/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines.vanilla;

import java.util.List;
import org.joda.primitives.list.impl.ArrayDoubleList;
import org.jquantlib.assets.DiscretizedAsset;
import org.jquantlib.math.Array;
import org.jquantlib.pricingengines.arguments.OneAssetOptionArguments;
import org.jquantlib.processes.StochasticProcess;
import org.jquantlib.time.TimeGrid;

public class DiscretizedVanillaOption
extends DiscretizedAsset {
    private final OneAssetOptionArguments arguments;
    private final List<Double> stoppingTimes;

    public DiscretizedVanillaOption(OneAssetOptionArguments args, StochasticProcess process, TimeGrid grid) {
        this.arguments = args;
        int size = args.exercise.size();
        this.stoppingTimes = new ArrayDoubleList();
        for (int i = 0; i < size; ++i) {
            this.stoppingTimes.add(i, process.getTime(args.exercise.date(i)));
            if (grid.empty()) continue;
            this.stoppingTimes.add(i, grid.closestTime(this.stoppingTimes.get(i)));
        }
    }

    @Override
    public void reset(int size) {
        this.values = new Array(size, 0.0);
        this.adjustValues();
    }

    @Override
    protected void postAdjustValuesImpl() {
        double now = this.time();
        switch (this.arguments.exercise.type()) {
            case AMERICAN: {
                if (!(now <= this.stoppingTimes.get(1)) || !(now >= this.stoppingTimes.get(0))) break;
                this.applySpecificCondition();
                break;
            }
            case EUROPEAN: {
                if (!this.isOnTime(this.stoppingTimes.get(0))) break;
                this.applySpecificCondition();
                break;
            }
            case BERMUDAN: {
                for (int i = 0; i < this.stoppingTimes.size(); ++i) {
                    if (!this.isOnTime(this.stoppingTimes.get(i))) continue;
                    this.applySpecificCondition();
                }
                break;
            }
            default: {
                throw new IllegalStateException("invalid option type");
            }
        }
    }

    void applySpecificCondition() {
        Array grid = this.method().grid(this.time());
        for (int j = 0; j < this.values.size(); ++j) {
            this.values.set(j, Math.max(this.values.at(j), this.arguments.payoff.valueOf(grid.at(j))));
        }
    }

    @Override
    public List<Double> mandatoryTimes() {
        return this.stoppingTimes;
    }
}

