/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ByteBufferProxy;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoFuture;
import org.apache.mina.common.IoFutureListener;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteFuture;
import org.apache.mina.common.support.DefaultWriteFuture;
import org.apache.mina.filter.support.SSLHandler;
import org.apache.mina.util.SessionLog;

public class SSLFilter
extends IoFilterAdapter {
    public static final String SSL_SESSION = SSLFilter.class.getName() + ".SSLSession";
    public static final String DISABLE_ENCRYPTION_ONCE = SSLFilter.class.getName() + ".DisableEncryptionOnce";
    public static final String USE_NOTIFICATION = SSLFilter.class.getName() + ".UseNotification";
    public static final SSLFilterMessage SESSION_SECURED = new SSLFilterMessage("SESSION_SECURED");
    public static final SSLFilterMessage SESSION_UNSECURED = new SSLFilterMessage("SESSION_UNSECURED");
    private static final String NEXT_FILTER = SSLFilter.class.getName() + ".NextFilter";
    private static final String SSL_HANDLER = SSLFilter.class.getName() + ".SSLHandler";
    private SSLContext sslContext;
    private boolean client;
    private boolean needClientAuth;
    private boolean wantClientAuth;
    private String[] enabledCipherSuites;
    private String[] enabledProtocols;

    public SSLFilter(SSLContext sslContext) {
        if (sslContext == null) {
            throw new NullPointerException("sslContext");
        }
        this.sslContext = sslContext;
    }

    public SSLSession getSSLSession(IoSession session) {
        return (SSLSession)session.getAttribute(SSL_SESSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startSSL(IoSession session) throws SSLException {
        SSLHandler handler;
        SSLHandler sSLHandler = handler = this.getSSLSessionHandler(session);
        synchronized (sSLHandler) {
            if (handler.isOutboundDone()) {
                IoFilter.NextFilter nextFilter = (IoFilter.NextFilter)session.getAttribute(NEXT_FILTER);
                handler.destroy();
                handler.init();
                handler.handshake(nextFilter);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSSLStarted(IoSession session) {
        SSLHandler handler;
        SSLHandler sSLHandler = handler = this.getSSLSessionHandler(session);
        synchronized (sSLHandler) {
            return !handler.isOutboundDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriteFuture stopSSL(IoSession session) throws SSLException {
        SSLHandler handler = this.getSSLSessionHandler(session);
        IoFilter.NextFilter nextFilter = (IoFilter.NextFilter)session.getAttribute(NEXT_FILTER);
        SSLHandler sSLHandler = handler;
        synchronized (sSLHandler) {
            return this.initiateClosure(nextFilter, session);
        }
    }

    public boolean isUseClientMode() {
        return this.client;
    }

    public void setUseClientMode(boolean clientMode) {
        this.client = clientMode;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public void setEnabledCipherSuites(String[] cipherSuites) {
        this.enabledCipherSuites = cipherSuites;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(String[] protocols) {
        this.enabledProtocols = protocols;
    }

    public void onPreAdd(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws SSLException {
        if (parent.contains(SSLFilter.class)) {
            throw new IllegalStateException("A filter chain cannot contain more than one SSLFilter.");
        }
    }

    public void onPostAdd(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws SSLException {
        IoSession session = parent.getSession();
        session.setAttribute(NEXT_FILTER, nextFilter);
        SSLHandler handler = new SSLHandler(this, this.sslContext, session);
        session.setAttribute(SSL_HANDLER, handler);
        handler.handshake(nextFilter);
    }

    public void onPreRemove(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws SSLException {
        IoSession session = parent.getSession();
        this.stopSSL(session);
        session.removeAttribute(NEXT_FILTER);
        session.removeAttribute(SSL_HANDLER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws SSLException {
        SSLHandler handler = this.getSSLSessionHandler(session);
        try {
            SSLHandler sSLHandler = handler;
            synchronized (sSLHandler) {
                if (this.isSSLStarted(session) && SessionLog.isDebugEnabled(session)) {
                    SessionLog.debug(session, " Closed: " + this.getSSLSessionHandler(session));
                }
                handler.destroy();
            }
        }
        finally {
            nextFilter.sessionClosed(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws SSLException {
        SSLHandler handler;
        SSLHandler sSLHandler = handler = this.getSSLSessionHandler(session);
        synchronized (sSLHandler) {
            if (!this.isSSLStarted(session) && handler.isInboundDone()) {
                nextFilter.messageReceived(session, message);
                return;
            }
            ByteBuffer buf = (ByteBuffer)message;
            if (SessionLog.isDebugEnabled(session)) {
                SessionLog.debug(session, " Data Read: " + handler + " (" + buf + ')');
            }
            try {
                handler.messageReceived(nextFilter, buf.buf());
                this.handleSSLData(nextFilter, handler);
                if (handler.isInboundDone()) {
                    if (handler.isOutboundDone()) {
                        if (SessionLog.isDebugEnabled(session)) {
                            SessionLog.debug(session, " SSL Session closed.");
                        }
                        handler.destroy();
                    } else {
                        this.initiateClosure(nextFilter, session);
                    }
                    if (buf.hasRemaining()) {
                        nextFilter.messageReceived(session, buf);
                    }
                }
            }
            catch (SSLException ssle2) {
                SSLHandshakeException ssle2;
                if (!handler.isInitialHandshakeComplete()) {
                    SSLHandshakeException newSSLE = new SSLHandshakeException("Initial SSL handshake failed.");
                    newSSLE.initCause(ssle2);
                    ssle2 = newSSLE;
                }
                throw ssle2;
            }
        }
    }

    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, Object message) {
        if (message instanceof EncryptedBuffer) {
            EncryptedBuffer buf = (EncryptedBuffer)message;
            buf.release();
            nextFilter.messageSent(session, buf.originalBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, IoFilter.WriteRequest writeRequest) throws SSLException {
        SSLHandler handler;
        SSLHandler sSLHandler = handler = this.getSSLSessionHandler(session);
        synchronized (sSLHandler) {
            if (!this.isSSLStarted(session)) {
                nextFilter.filterWrite(session, writeRequest);
                return;
            }
            if (session.containsAttribute(DISABLE_ENCRYPTION_ONCE)) {
                session.removeAttribute(DISABLE_ENCRYPTION_ONCE);
                nextFilter.filterWrite(session, writeRequest);
                return;
            }
            ByteBuffer buf = (ByteBuffer)writeRequest.getMessage();
            if (SessionLog.isDebugEnabled(session)) {
                SessionLog.debug(session, " Filtered Write: " + handler);
            }
            if (handler.isWritingEncryptedData()) {
                if (SessionLog.isDebugEnabled(session)) {
                    SessionLog.debug(session, "   already encrypted: " + buf);
                }
                nextFilter.filterWrite(session, writeRequest);
                return;
            }
            if (handler.isInitialHandshakeComplete()) {
                if (SessionLog.isDebugEnabled(session)) {
                    SessionLog.debug(session, " encrypt: " + buf);
                }
                int pos = buf.position();
                handler.encrypt(buf.buf());
                buf.position(pos);
                EncryptedBuffer encryptedBuffer = new EncryptedBuffer(SSLHandler.copy(handler.getOutNetBuffer()), buf);
                if (SessionLog.isDebugEnabled(session)) {
                    SessionLog.debug(session, " encrypted buf: " + encryptedBuffer);
                }
                nextFilter.filterWrite(session, new IoFilter.WriteRequest(encryptedBuffer, writeRequest.getFuture()));
                return;
            }
            if (!session.isConnected()) {
                if (SessionLog.isDebugEnabled(session)) {
                    SessionLog.debug(session, " Write request on closed session.");
                }
            } else {
                if (SessionLog.isDebugEnabled(session)) {
                    SessionLog.debug(session, " Handshaking is not complete yet. Buffering write request.");
                }
                handler.scheduleWrite(nextFilter, writeRequest);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterClose(IoFilter.NextFilter nextFilter, IoSession session) throws SSLException {
        SSLHandler handler = this.getSSLSessionHandler(session);
        WriteFuture future = null;
        SSLHandler sSLHandler = handler;
        synchronized (sSLHandler) {
            block8: {
                try {
                    if (this.isSSLStarted(session)) {
                        future = this.initiateClosure(nextFilter, session);
                    }
                    if (future != null) break block8;
                    nextFilter.filterClose(session);
                }
                catch (Throwable throwable) {
                    if (future == null) {
                        nextFilter.filterClose(session);
                    } else {
                        future.addListener(new IoFutureListener(nextFilter, session){
                            final /* synthetic */ IoFilter.NextFilter val$nextFilter;
                            final /* synthetic */ IoSession val$session;
                            {
                                this.val$nextFilter = nextFilter;
                                this.val$session = ioSession;
                            }

                            public void operationComplete(IoFuture future) {
                                this.val$nextFilter.filterClose(this.val$session);
                            }
                        });
                    }
                    throw throwable;
                }
            }
            future.addListener(new /* invalid duplicate definition of identical inner class */);
        }
    }

    private WriteFuture initiateClosure(IoFilter.NextFilter nextFilter, IoSession session) throws SSLException {
        SSLHandler handler = this.getSSLSessionHandler(session);
        if (!handler.closeOutbound()) {
            return DefaultWriteFuture.newNotWrittenFuture(session);
        }
        WriteFuture future = handler.writeNetBuffer(nextFilter);
        if (handler.isInboundDone()) {
            handler.destroy();
        }
        if (session.containsAttribute(USE_NOTIFICATION)) {
            nextFilter.messageReceived(session, SESSION_UNSECURED);
        }
        return future;
    }

    private void handleSSLData(IoFilter.NextFilter nextFilter, SSLHandler handler) throws SSLException {
        if (handler.isInitialHandshakeComplete()) {
            handler.flushScheduledWrites();
        }
        handler.writeNetBuffer(nextFilter);
        this.handleAppDataRead(nextFilter, handler);
    }

    private void handleAppDataRead(IoFilter.NextFilter nextFilter, SSLHandler handler) {
        IoSession session = handler.getSession();
        if (!handler.getAppBuffer().hasRemaining()) {
            return;
        }
        if (SessionLog.isDebugEnabled(session)) {
            SessionLog.debug(session, " appBuffer: " + handler.getAppBuffer());
        }
        ByteBuffer readBuffer = SSLHandler.copy(handler.getAppBuffer());
        if (SessionLog.isDebugEnabled(session)) {
            SessionLog.debug(session, " app data read: " + readBuffer + " (" + readBuffer.getHexDump() + ')');
        }
        nextFilter.messageReceived(session, readBuffer);
    }

    private SSLHandler getSSLSessionHandler(IoSession session) {
        SSLHandler handler = (SSLHandler)session.getAttribute(SSL_HANDLER);
        if (handler == null) {
            throw new IllegalStateException();
        }
        if (handler.getParent() != this) {
            throw new IllegalArgumentException("Not managed by this filter.");
        }
        return handler;
    }

    private static class EncryptedBuffer
    extends ByteBufferProxy {
        private final ByteBuffer originalBuffer;

        private EncryptedBuffer(ByteBuffer buf, ByteBuffer originalBuffer) {
            super(buf);
            this.originalBuffer = originalBuffer;
        }
    }

    public static class SSLFilterMessage {
        private final String name;

        private SSLFilterMessage(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

