/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.async.impl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.aries.async.impl.AsyncServiceFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.async.Async;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private final ExecutorService executor = Executors.newFixedThreadPool(10, new ThreadFactory(){
        private final AtomicInteger count = new AtomicInteger();

        @Override
        public Thread newThread(final Runnable r) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            r.run();
                            return null;
                        }
                    });
                }
            }, "Asynchronous Execution Service Thread " + this.count.incrementAndGet());
            return t;
        }
    });
    private volatile ServiceTracker<LogService, LogService> logServiceTracker;

    public void start(BundleContext context) throws Exception {
        this.logServiceTracker = new ServiceTracker(context, LogService.class, null);
        this.logServiceTracker.open();
        context.registerService(Async.class.getName(), (Object)new AsyncServiceFactory(this.executor, this.logServiceTracker), new Hashtable());
    }

    public void stop(BundleContext context) throws Exception {
        this.executor.shutdownNow();
        this.logServiceTracker.close();
    }
}

