/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import java.awt.MenuBar;
import netscape.application.AWTCompatibility;
import netscape.application.Application;
import netscape.application.Bitmap;
import netscape.application.Border;
import netscape.application.Color;
import netscape.application.EmptyBorder;
import netscape.application.FoundationCheckMenuItem;
import netscape.application.FoundationMenuItem;
import netscape.application.KeyEvent;
import netscape.application.MenuBorder;
import netscape.application.MenuItem;
import netscape.application.MenuView;
import netscape.application.Target;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.Vector;

public class Menu
implements Codable {
    java.awt.Menu awtMenu;
    MenuBar awtMenuBar;
    Application application;
    Vector items = new Vector();
    MenuItem superitem;
    MenuItem prototypeItem;
    Border border;
    Color backgroundColor = Color.lightGray;
    boolean transparent = false;
    MenuView menuView;
    static final String ITEMS_KEY = "items";
    static final String SUPERITEM_KEY = "superitem";
    static final String PROTOTYPEITEM_KEY = "prototypeItem";
    static final String BORDER_KEY = "border";
    static final String BACKGROUNDCOLOR_KEY = "backgroundColor";
    static final String TRANSPARENT_KEY = "transparent";

    public Menu() {
        this(true);
    }

    public Menu(boolean bl) {
        this.setBorder(new MenuBorder(this));
        if (bl) {
            this.awtMenuBar = new MenuBar();
        } else {
            this.awtMenu = new java.awt.Menu("");
        }
        MenuItem menuItem = new MenuItem();
        this.setPrototypeItem(menuItem);
    }

    boolean isTopLevel() {
        return this.superitem == null || this.superitem.supermenu() == null;
    }

    void setSuperitem(MenuItem menuItem) {
        this.superitem = menuItem;
    }

    MenuItem superitem() {
        return this.superitem;
    }

    public void setPrototypeItem(MenuItem menuItem) {
        this.prototypeItem = menuItem;
    }

    public MenuItem prototypeItem() {
        return this.prototypeItem;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public Color backgroundColor() {
        return this.backgroundColor;
    }

    public void setBorder(Border border) {
        if (border == null) {
            this.border = EmptyBorder.emptyBorder();
            return;
        }
        this.border = border;
    }

    public Border border() {
        return this.border;
    }

    public void setTransparent(boolean bl) {
        this.transparent = bl;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    MenuItem createItem(boolean bl) {
        MenuItem menuItem = (MenuItem)this.prototypeItem().clone();
        if (!bl) {
            menuItem.foundationMenuItem = new FoundationMenuItem("", menuItem);
        } else {
            menuItem.foundationMenuItem = new FoundationCheckMenuItem("", menuItem);
            menuItem.setCheckedImage(Bitmap.bitmapNamed("netscape/application/RadioButtonOn.gif"));
            menuItem.setUncheckedImage(Bitmap.bitmapNamed("netscape/application/RadioButtonOff.gif"));
            menuItem.setImage(menuItem.uncheckedImage());
            menuItem.setSelectedImage(menuItem.uncheckedImage());
        }
        menuItem.setFont(this.prototypeItem().font());
        return menuItem;
    }

    protected Menu createMenuAsSubmenu() {
        Menu menu = new Menu(false);
        menu.setPrototypeItem(this.createItem(false));
        menu.setBackgroundColor(this.backgroundColor());
        return menu;
    }

    public MenuItem addItemWithSubmenu(String string) {
        MenuItem menuItem = this.createItem(false);
        menuItem.setTitle(string);
        Menu menu = this.createMenuAsSubmenu();
        menuItem.setSubmenu(menu);
        this.addItemAt(menuItem, this.itemCount());
        return menuItem;
    }

    public MenuItem addItem(String string, String string2, Target target) {
        return this.addItem(string, '\u0000', string2, target);
    }

    public MenuItem addItem(String string, String string2, Target target, boolean bl) {
        return this.addItem(string, '\u0000', string2, target, bl);
    }

    public MenuItem addItem(String string, char c, String string2, Target target) {
        return this.addItem(string, c, string2, target, false);
    }

    public MenuItem addItem(String string, char c, String string2, Target target, boolean bl) {
        return this.addItemAt(string, c, string2, target, bl, this.itemCount());
    }

    public MenuItem addItemAt(String string, char c, String string2, Target target, boolean bl, int n) {
        MenuItem menuItem = this.createItem(bl);
        menuItem.setSubmenu(null);
        menuItem.setSupermenu(this);
        menuItem.setCommandKey(c);
        menuItem.setTitle(string);
        menuItem.setTarget(target);
        menuItem.setCommand(string2);
        this.addItemAt(menuItem, n);
        return menuItem;
    }

    public MenuItem addSeparator() {
        MenuItem menuItem = null;
        menuItem = this.createItem(false);
        menuItem.setSeparator(true);
        this.addItemAt(menuItem, this.itemCount());
        return menuItem;
    }

    public int indexOfItem(MenuItem menuItem) {
        return this.items.indexOf(menuItem);
    }

    public int itemCount() {
        return this.items.count();
    }

    public MenuItem itemAt(int n) {
        return (MenuItem)this.items.elementAt(n);
    }

    public void addItemAt(MenuItem menuItem, int n) {
        menuItem.setSupermenu(this);
        if (menuItem.hasSubmenu()) {
            java.awt.Menu menu = menuItem.submenu().awtMenu();
            menu.setLabel(menuItem.title());
            menu.setFont(AWTCompatibility.awtFontForFont(menuItem.font()));
            if (this.isTopLevel()) {
                if (this.awtMenuBar != null) {
                    this.awtMenuBar.add(menu);
                }
            } else if (this.awtMenu != null) {
                this.awtMenu.add(menu);
            }
        } else if (!this.isTopLevel() && this.awtMenu != null) {
            if (menuItem.isSeparator()) {
                this.awtMenu.addSeparator();
            } else {
                this.awtMenu.add(menuItem.foundationMenuItem());
            }
        }
        this.items.insertElementAt(menuItem, n);
        int n2 = 0;
        while (n2 < this.itemCount()) {
            this.itemAt(n2).setTitle(this.itemAt(n2).title());
            ++n2;
        }
    }

    public void removeItem(MenuItem menuItem) {
        this.items.removeElement(menuItem);
        if (this.isTopLevel()) {
            this.awtMenuBar.remove(menuItem.foundationMenuItem());
            return;
        }
        this.awtMenu.remove(menuItem.foundationMenuItem());
    }

    public void removeItemAt(int n) {
        this.items.removeElementAt(n);
        if (this.isTopLevel()) {
            this.awtMenuBar.remove(n);
            return;
        }
        this.awtMenu.remove(n);
    }

    public void replaceItemAt(int n, MenuItem menuItem) {
        this.items.replaceElementAt(n, menuItem);
    }

    public void replaceItem(MenuItem menuItem, MenuItem menuItem2) {
        int n = this.indexOfItem(menuItem);
        if (n != -1) {
            this.replaceItemAt(n, menuItem2);
        }
    }

    public void performCommand(String string, Object object) {
        if (object != null) {
            MenuItem menuItem;
            menuItem.setState(!(menuItem = (MenuItem)object).state());
            menuItem.sendCommand();
        }
    }

    int minItemWidth() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.itemCount()) {
            int n3 = this.itemAt(n2).minWidth();
            if (n3 > n) {
                n = n3;
            }
            ++n2;
        }
        return n;
    }

    public boolean handleCommandKeyEvent(KeyEvent keyEvent) {
        boolean bl = false;
        if (!keyEvent.isControlKeyDown()) {
            return false;
        }
        MenuItem menuItem = this.itemForKeyEvent(keyEvent);
        if (menuItem != null) {
            menuItem.sendCommand();
            bl = true;
        }
        return bl;
    }

    MenuItem itemForKeyEvent(KeyEvent keyEvent) {
        MenuItem menuItem = null;
        if (!keyEvent.isControlKeyDown()) {
            return null;
        }
        int n = 0;
        while (n < this.itemCount() && menuItem == null) {
            MenuItem menuItem2 = this.itemAt(n);
            if (menuItem2.isEnabled()) {
                if (menuItem2.hasSubmenu()) {
                    menuItem = menuItem2.submenu().itemForKeyEvent(keyEvent);
                } else if (menuItem2.commandKey() == keyEvent.key + 64) {
                    menuItem = menuItem2;
                }
            }
            ++n;
        }
        return menuItem;
    }

    java.awt.Menu awtMenu() {
        return this.awtMenu;
    }

    MenuBar awtMenuBar() {
        return this.awtMenuBar;
    }

    void setApplication(Application application) {
        this.application = application;
    }

    Application application() {
        return this.application;
    }

    public void describeClassInfo(ClassInfo classInfo) {
        classInfo.addClass("netscape.application.Menu", 1);
        classInfo.addField(ITEMS_KEY, (byte)18);
        classInfo.addField(SUPERITEM_KEY, (byte)18);
        classInfo.addField(PROTOTYPEITEM_KEY, (byte)18);
        classInfo.addField(BORDER_KEY, (byte)18);
        classInfo.addField(BACKGROUNDCOLOR_KEY, (byte)18);
        classInfo.addField(TRANSPARENT_KEY, (byte)0);
    }

    public void encode(Encoder encoder) throws CodingException {
        encoder.encodeObject(ITEMS_KEY, this.items);
        encoder.encodeObject(SUPERITEM_KEY, this.superitem);
        encoder.encodeObject(PROTOTYPEITEM_KEY, this.prototypeItem);
        encoder.encodeObject(BORDER_KEY, this.border);
        encoder.encodeObject(BACKGROUNDCOLOR_KEY, this.backgroundColor);
        encoder.encodeBoolean(TRANSPARENT_KEY, this.transparent);
    }

    public void decode(Decoder decoder) throws CodingException {
        this.items = (Vector)decoder.decodeObject(ITEMS_KEY);
        this.superitem = (MenuItem)decoder.decodeObject(SUPERITEM_KEY);
        this.prototypeItem = (MenuItem)decoder.decodeObject(PROTOTYPEITEM_KEY);
        this.border = (Border)decoder.decodeObject(BORDER_KEY);
        this.backgroundColor = (Color)decoder.decodeObject(BACKGROUNDCOLOR_KEY);
        this.transparent = decoder.decodeBoolean(TRANSPARENT_KEY);
    }

    public void finishDecoding() throws CodingException {
    }
}

