/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Application;
import netscape.application.Bitmap;
import netscape.application.DrawingSequence;
import netscape.application.DrawingSequenceOwner;
import netscape.application.Graphics;
import netscape.application.Image;
import netscape.application.Rect;
import netscape.application.Size;
import netscape.util.ClassInfo;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.Vector;

public class ImageSequence
extends DrawingSequence {
    Vector imageVector;
    Image imageStrip;
    int frameWidth;
    int frameHeight;
    static final String VECTOR_KEY = "imageVector";
    static final String IMAGESTRIP_KEY = "imageStrip";
    static final String FRAMEWIDTH_KEY = "frameWidth";
    static final String FRAMEHEIGHT_KEY = "frameHeight";

    public ImageSequence() {
    }

    public ImageSequence(DrawingSequenceOwner drawingSequenceOwner) {
        super(drawingSequenceOwner);
    }

    public Vector images() {
        return this.imageVector;
    }

    public void addImage(Image image) {
        if (this.imageVector == null) {
            this.imageVector = new Vector();
        }
        this.imageVector.addElement(image);
        this.frameCount = this.imageVector.count();
    }

    public void addImagesFromName(String string, int n) {
        if (string == null || n < 0) {
            return;
        }
        Application application = Application.application();
        int n2 = string.lastIndexOf(46);
        if (n2 == -1) {
            this.addImage(Bitmap.bitmapNamed(string));
            return;
        }
        String string2 = string.substring(n2);
        int n3 = n2 - 1;
        int n4 = 0;
        int n5 = 1;
        while (n3 > 0 && Character.isDigit(string.charAt(n3))) {
            n4 += n5 * Character.digit(string.charAt(n3), 10);
            n5 *= 10;
            --n3;
        }
        String string3 = string.substring(0, n3 + 1);
        if (this.imageVector == null) {
            this.imageVector = new Vector();
        }
        n += n4;
        int n6 = n4;
        while (n6 < n) {
            this.imageVector.addElement(Bitmap.bitmapNamed(string3 + n6 + string2));
            ++n6;
        }
        this.frameCount = this.imageVector.count();
    }

    public void removeImage(Image image) {
        if (this.imageVector != null) {
            this.imageVector.removeElement(image);
            this.frameCount = this.imageVector.count();
        }
    }

    public void removeAllImages() {
        if (this.imageVector != null) {
            this.imageVector.removeAllElements();
        }
        this.imageStrip = null;
        this.frameCount = 0;
        this.currentFrameNumber = 0;
    }

    public void setImageStrip(Image image) {
        this.imageStrip = image;
        this.frameCount = 0;
        this.currentFrameNumber = 0;
    }

    public Image imageStrip() {
        return this.imageStrip;
    }

    public void setFrameWidth(int n) {
        if (n < 0) {
            n = 0;
        }
        this.frameWidth = n;
        if (this.frameWidth > 0 && this.imageStrip != null) {
            this.frameCount = this.imageStrip.width() / this.frameWidth;
            return;
        }
        this.frameCount = 0;
        this.currentFrameNumber = 0;
    }

    public int frameWidth() {
        return this.frameWidth;
    }

    public void setFrameHeight(int n) {
        if (n < 0) {
            n = 0;
        }
        this.frameHeight = n;
        if (this.frameHeight > 0 && this.imageStrip != null) {
            this.frameCount = this.imageStrip.height() / this.frameHeight;
            return;
        }
        this.frameCount = 0;
        this.currentFrameNumber = 0;
    }

    public int frameHeight() {
        return this.frameHeight;
    }

    public int imageCount() {
        return this.frameCount();
    }

    public void setCurrentImageNumber(int n) {
        if (n < 0) {
            n = 0;
        } else if (n >= this.frameCount) {
            n = this.frameCount - 1;
        }
        this.currentFrameNumber = n;
    }

    public Image currentImage() {
        if (this.imageVector != null) {
            return (Image)this.imageVector.elementAt(this.currentFrameNumber);
        }
        return this.imageStrip;
    }

    public Size maxSize() {
        if (this.imageStrip != null) {
            if (this.frameWidth > 0) {
                return new Size(this.frameWidth, this.imageStrip.height());
            }
            if (this.frameHeight > 0) {
                return new Size(this.imageStrip.width(), this.frameHeight);
            }
        } else if (this.imageVector != null && !this.imageVector.isEmpty()) {
            int n = 0;
            int n2 = 0;
            int n3 = this.imageVector.count();
            while (n3-- > 0) {
                Image image = (Image)this.imageVector.elementAt(n3);
                if (image.width() > n2) {
                    n2 = image.width();
                }
                if (image.height() <= n) continue;
                n = image.height();
            }
            return new Size(n2, n);
        }
        return new Size(0, 0);
    }

    public int width() {
        int n = 0;
        if (this.imageStrip != null) {
            if (this.frameWidth > 0) {
                return this.frameWidth;
            }
            return this.imageStrip.width();
        }
        if (this.imageVector == null) {
            return 0;
        }
        int n2 = this.imageVector.count();
        while (n2-- > 0) {
            Image image = (Image)this.imageVector.elementAt(n2);
            if (image.width() <= n) continue;
            n = image.width();
        }
        return n;
    }

    public int height() {
        int n = 0;
        if (this.imageStrip != null) {
            if (this.frameHeight > 0) {
                return this.frameHeight;
            }
            return this.imageStrip.height();
        }
        if (this.imageVector == null) {
            return 0;
        }
        int n2 = this.imageVector.count();
        while (n2-- > 0) {
            Image image = (Image)this.imageVector.elementAt(n2);
            if (image.height() <= n) continue;
            n = image.height();
        }
        return n;
    }

    public void drawAt(Graphics graphics, int n, int n2) {
        if (this.imageVector != null) {
            Image image = (Image)this.imageVector.elementAt(this.currentFrameNumber);
            if (image != null) {
                image.drawAt(graphics, n, n2);
                return;
            }
        } else {
            if (this.frameWidth > 0) {
                Rect rect = Rect.newRect(n, n2, this.frameWidth, this.imageStrip.height());
                graphics.pushState();
                graphics.setClipRect(rect);
                this.imageStrip.drawAt(graphics, n - this.frameWidth * this.currentFrameNumber, n2);
                graphics.popState();
                Rect.returnRect(rect);
                return;
            }
            if (this.frameHeight > 0) {
                Rect rect = Rect.newRect(n, n2, this.imageStrip.width(), this.frameHeight);
                graphics.pushState();
                graphics.setClipRect(rect);
                this.imageStrip.drawAt(graphics, n, n2 - this.frameHeight * this.currentFrameNumber);
                graphics.popState();
                Rect.returnRect(rect);
            }
        }
    }

    public void drawScaled(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.imageVector != null) {
            Image image = (Image)this.imageVector.elementAt(this.currentFrameNumber);
            if (image != null) {
                image.drawCentered(graphics, n, n2, n3, n4);
                return;
            }
        } else {
            if (this.frameWidth > 0) {
                Rect rect = Rect.newRect(n += (n3 - this.frameWidth) / 2, n2 += (n4 - this.imageStrip.height()) / 2, this.frameWidth, this.imageStrip.height());
                graphics.pushState();
                graphics.setClipRect(rect);
                this.imageStrip.drawAt(graphics, n - this.frameWidth * this.currentFrameNumber, n2);
                graphics.popState();
                Rect.returnRect(rect);
                return;
            }
            if (this.frameHeight > 0) {
                Rect rect = Rect.newRect(n += (n3 - this.imageStrip.width()) / 2, n2 += (n4 - this.frameHeight) / 2, this.imageStrip.width(), this.frameHeight);
                graphics.pushState();
                graphics.setClipRect(rect);
                this.imageStrip.drawAt(graphics, n, n2 - this.frameHeight * this.currentFrameNumber);
                graphics.popState();
                Rect.returnRect(rect);
            }
        }
    }

    public void describeClassInfo(ClassInfo classInfo) {
        super.describeClassInfo(classInfo);
        classInfo.addClass("netscape.application.ImageSequence", 1);
        classInfo.addField(VECTOR_KEY, (byte)18);
        classInfo.addField(IMAGESTRIP_KEY, (byte)18);
        classInfo.addField(FRAMEWIDTH_KEY, (byte)8);
        classInfo.addField(FRAMEHEIGHT_KEY, (byte)8);
    }

    public void encode(Encoder encoder) throws CodingException {
        super.encode(encoder);
        encoder.encodeObject(VECTOR_KEY, this.imageVector);
        encoder.encodeObject(IMAGESTRIP_KEY, this.imageStrip);
        encoder.encodeInt(FRAMEWIDTH_KEY, this.frameWidth);
        encoder.encodeInt(FRAMEHEIGHT_KEY, this.frameHeight);
    }

    public void decode(Decoder decoder) throws CodingException {
        super.decode(decoder);
        this.imageVector = (Vector)decoder.decodeObject(VECTOR_KEY);
        this.imageStrip = (Image)decoder.decodeObject(IMAGESTRIP_KEY);
        this.frameWidth = decoder.decodeInt(FRAMEWIDTH_KEY);
        this.frameHeight = decoder.decodeInt(FRAMEHEIGHT_KEY);
    }
}

