/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.yieldcurves;

import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.Quote;
import org.jquantlib.quotes.SimpleQuote;
import org.jquantlib.termstructures.Compounding;
import org.jquantlib.termstructures.InterestRate;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Frequency;
import org.jquantlib.time.calendars.NullCalendar;
import org.jquantlib.util.Date;
import org.jquantlib.util.DateFactory;
import org.jquantlib.util.Observable;

public class FlatForward
extends YieldTermStructure {
    private Handle<? extends Quote> forward;
    private Compounding compounding;
    private Frequency frequency;
    private InterestRate rate;

    public FlatForward(Date referenceDate, Handle<? extends Quote> forward, DayCounter dayCounter, Compounding compounding, Frequency frequency) {
        super(referenceDate, (Calendar)new NullCalendar(), dayCounter);
        this.forward = forward;
        this.compounding = compounding;
        this.frequency = frequency;
        this.forward.addObserver(this);
        this.updateRate();
    }

    public FlatForward(Date referenceDate, Handle<? extends Quote> forward, DayCounter dayCounter, Compounding compounding) {
        this(referenceDate, forward, dayCounter, compounding, Frequency.ANNUAL);
    }

    public FlatForward(Date referenceDate, Handle<? extends Quote> forward, DayCounter dayCounter) {
        this(referenceDate, forward, dayCounter, Compounding.CONTINUOUS);
    }

    public FlatForward(Date referenceDate, double forward, DayCounter dayCounter, Compounding compounding, Frequency frequency) {
        super(referenceDate, (Calendar)new NullCalendar(), dayCounter);
        this.forward = new Handle<SimpleQuote>(new SimpleQuote(forward));
        this.compounding = compounding;
        this.frequency = frequency;
        this.updateRate();
    }

    public FlatForward(Date referenceDate, double forward, DayCounter dayCounter, Compounding compounding) {
        this(referenceDate, forward, dayCounter, compounding, Frequency.ANNUAL);
    }

    public FlatForward(Date referenceDate, double forward, DayCounter dayCounter) {
        this(referenceDate, forward, dayCounter, Compounding.CONTINUOUS);
    }

    public FlatForward(int settlementDays, Calendar calendar, Handle<? extends Quote> forward, DayCounter dayCounter, Compounding compounding, Frequency frequency) {
        super(settlementDays, calendar, dayCounter);
        this.forward = forward;
        this.compounding = compounding;
        this.frequency = frequency;
        this.forward.addObserver(this);
        this.updateRate();
    }

    public FlatForward(int settlementDays, Calendar calendar, Handle<? extends Quote> forward, DayCounter dayCounter) {
        this(settlementDays, calendar, forward, dayCounter, Compounding.CONTINUOUS);
    }

    public FlatForward(int settlementDays, Calendar calendar, Handle<? extends Quote> forward, DayCounter dayCounter, Compounding compounding) {
        this(settlementDays, calendar, forward, dayCounter, compounding, Frequency.ANNUAL);
    }

    public FlatForward(int settlementDays, Calendar calendar, double forward, DayCounter dayCounter, Compounding compounding, Frequency frequency) {
        super(settlementDays, calendar, dayCounter);
        this.forward = new Handle<SimpleQuote>(new SimpleQuote(forward));
        this.compounding = compounding;
        this.frequency = frequency;
        this.updateRate();
    }

    public FlatForward(int settlementDays, Calendar calendar, double forward, DayCounter dayCounter) {
        this(settlementDays, calendar, forward, dayCounter, Compounding.CONTINUOUS);
    }

    public FlatForward(int settlementDays, Calendar calendar, double forward, DayCounter dayCounter, Compounding compounding) {
        this(settlementDays, calendar, forward, dayCounter, compounding, Frequency.ANNUAL);
    }

    private void updateRate() {
        this.rate = new InterestRate(this.forward.getLink().evaluate(), this.dayCounter(), this.compounding, this.frequency);
    }

    public final Compounding compounding() {
        return this.compounding;
    }

    public final Frequency compoundingFrequency() {
        return this.frequency;
    }

    @Override
    protected final double discountImpl(double t) {
        return this.rate.discountFactor(t);
    }

    @Override
    public final Date maxDate() {
        return DateFactory.getFactory().getMaxDate();
    }

    @Override
    public void update(Observable o, Object arg) {
        this.updateRate();
        super.update(o, arg);
    }
}

