/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.model.volatility;

import org.jquantlib.model.volatility.VolatilityCompositor;
import org.jquantlib.util.Date;
import org.jquantlib.util.TimeSeriesDouble;

public class ConstantEstimator
implements VolatilityCompositor {
    private int size_;

    public ConstantEstimator(int size) {
        this.size_ = size;
    }

    @Override
    public void calibrate(TimeSeriesDouble timeSeries) {
    }

    @Override
    public TimeSeriesDouble calculate(TimeSeriesDouble volatilitySeries) {
        Date[] dates = volatilitySeries.dates();
        double[] values = volatilitySeries.values();
        TimeSeriesDouble retval = new TimeSeriesDouble();
        for (int i = this.size_; i < volatilitySeries.size(); ++i) {
            double sumu2 = 0.0;
            double sumu = 0.0;
            for (int j = i - this.size_; j < i; ++j) {
                double uj = values[j];
                sumu += uj;
                sumu2 += uj * uj;
            }
            double dsize = this.size_;
            double s = Math.sqrt(sumu2 / dsize - sumu * sumu / dsize / (dsize + 1.0));
            retval.add(dates[i], s);
        }
        return retval;
    }
}

