/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.util;

import java.util.Calendar;
import java.util.Formatter;
import java.util.Locale;
import org.jquantlib.time.Period;
import org.jquantlib.time.TimeUnit;
import org.jquantlib.time.Weekday;
import org.jquantlib.util.BaseDate;
import org.jquantlib.util.Date;
import org.jquantlib.util.DateFactory;
import org.jquantlib.util.DateParser;
import org.jquantlib.util.Month;
import org.jquantlib.util.Updatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDate
extends BaseDate {
    private static final Logger logger = LoggerFactory.getLogger(DefaultDate.class);
    private int value;
    private static final int MinimumSerialNumber = 367;
    private static final int MaximumSerialNumber = 73050;
    static final int[] monthLength = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] monthLeapLength = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] monthOffset = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
    private static final int[] monthLeapOffset = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, 366};
    private static final int[] yearOffset = new int[]{0, 366, 731, 1096, 1461, 1827, 2192, 2557, 2922, 3288, 3653, 4018, 4383, 4749, 5114, 5479, 5844, 6210, 6575, 6940, 7305, 7671, 8036, 8401, 8766, 9132, 9497, 9862, 10227, 10593, 10958, 11323, 11688, 12054, 12419, 12784, 13149, 13515, 13880, 14245, 14610, 14976, 15341, 15706, 16071, 16437, 16802, 17167, 17532, 17898, 18263, 18628, 18993, 19359, 19724, 20089, 20454, 20820, 21185, 21550, 21915, 22281, 22646, 23011, 23376, 23742, 24107, 24472, 24837, 25203, 25568, 25933, 26298, 26664, 27029, 27394, 27759, 28125, 28490, 28855, 29220, 29586, 29951, 30316, 30681, 31047, 31412, 31777, 32142, 32508, 32873, 33238, 33603, 33969, 34334, 34699, 35064, 35430, 35795, 36160, 36525, 36891, 37256, 37621, 37986, 38352, 38717, 39082, 39447, 39813, 40178, 40543, 40908, 41274, 41639, 42004, 42369, 42735, 43100, 43465, 43830, 44196, 44561, 44926, 45291, 45657, 46022, 46387, 46752, 47118, 47483, 47848, 48213, 48579, 48944, 49309, 49674, 50040, 50405, 50770, 51135, 51501, 51866, 52231, 52596, 52962, 53327, 53692, 54057, 54423, 54788, 55153, 55518, 55884, 56249, 56614, 56979, 57345, 57710, 58075, 58440, 58806, 59171, 59536, 59901, 60267, 60632, 60997, 61362, 61728, 62093, 62458, 62823, 63189, 63554, 63919, 64284, 64650, 65015, 65380, 65745, 66111, 66476, 66841, 67206, 67572, 67937, 68302, 68667, 69033, 69398, 69763, 70128, 70494, 70859, 71224, 71589, 71955, 72320, 72685, 73050};
    private static final boolean[] yearIsLeap = new boolean[]{true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, false};
    private UpdatableDate updatable = null;

    private DefaultDate(int value) {
        this.value = value;
    }

    public DefaultDate(int day, Month month, int year) {
        this(DefaultDate.fromDMY(day, month.toInteger(), year));
    }

    public DefaultDate(int day, int month, int year) {
        this(DefaultDate.fromDMY(day, month, year));
    }

    public DefaultDate(DefaultDate date) {
        this(date.value);
    }

    private static final int fromDMY(int d, int m, int y) {
        if (y <= 1900 || y >= 2100) {
            throw new IllegalArgumentException("year " + y + " out of bound. It must be in [1901,2099]");
        }
        if (m <= 0 || m >= 13) {
            throw new IllegalArgumentException("month " + m + " outside January-December range [1,12]");
        }
        boolean leap = DefaultDate.isLeap(y);
        int len = DefaultDate.getMonthLength(m, leap);
        int offset = DefaultDate.getMonthOffset(m, leap);
        if (d <= 0 || d > len) {
            throw new ArithmeticException("day outside month (" + m + ") day-range [1," + len + "]");
        }
        int result = d + offset + DefaultDate.getYearOffset(y);
        return result;
    }

    public final int hashCode() {
        return this.value;
    }

    public final boolean equals(Object anObject) {
        if (anObject == null) {
            return false;
        }
        if (!(anObject instanceof DefaultDate)) {
            return false;
        }
        return this.eq((Date)anObject);
    }

    @Override
    public final int getMonth() {
        int d = this.getDayOfYear();
        Integer m = d / 30 + 1;
        boolean leap = DefaultDate.isLeap(this.getYear());
        while (d <= DefaultDate.getMonthOffset(m, leap)) {
            m = m - 1;
        }
        while (d > DefaultDate.getMonthOffset(m + 1, leap)) {
            m = m + 1;
        }
        return m;
    }

    @Override
    public final Month getMonthEnum() {
        return Month.valueOf(this.getMonth());
    }

    @Override
    public final int getYear() {
        int y = this.value / 365 + 1900;
        if (this.value <= DefaultDate.getYearOffset(y)) {
            --y;
        }
        return y;
    }

    @Override
    public final Date increment() {
        ++this.value;
        this.checkSerialNumber();
        return this;
    }

    @Override
    public final Date decrement() {
        --this.value;
        this.checkSerialNumber();
        return this;
    }

    @Override
    public final Date increment(int days) {
        this.value += days;
        this.checkSerialNumber();
        return this;
    }

    @Override
    public final Date increment(Period p) {
        this.value = this.getAdvancedDateValue(this, p.length(), p.units());
        this.checkSerialNumber();
        return this;
    }

    @Override
    public final Date decrement(int days) {
        this.value -= days;
        this.checkSerialNumber();
        return this;
    }

    @Override
    public final Date decrement(Period p) {
        this.value = this.getAdvancedDateValue(this, -1 * p.length(), p.units());
        this.checkSerialNumber();
        return this;
    }

    @Override
    public Date plus(int days) {
        return new DefaultDate(this.value + days);
    }

    @Override
    public Date minus(int days) {
        return new DefaultDate(this.value - days);
    }

    @Override
    public Date plus(Period p) {
        return new DefaultDate(this.getAdvancedDateValue(this, p.length(), p.units()));
    }

    @Override
    public Date minus(Period p) {
        return new DefaultDate(this.getAdvancedDateValue(this, -1 * p.length(), p.units()));
    }

    @Override
    public final Date adjust(Period p) {
        this.value = this.getAdvancedDateValue(this, p.length(), p.units());
        this.checkSerialNumber();
        return this;
    }

    public static final Date getTodaysDate() {
        Calendar cal = Calendar.getInstance();
        int d = cal.get(5);
        int m = cal.get(2);
        int y = cal.get(1);
        return new DefaultDate(d, m + 1, y);
    }

    public static final Date getMinDate() {
        return new DefaultDate(367);
    }

    public static final Date getMaxDate() {
        return new DefaultDate(73050);
    }

    @Override
    public final boolean isLeap() {
        return DefaultDate.isLeap(this.getYear());
    }

    public static final boolean isLeap(int y) {
        return yearIsLeap[y - 1900];
    }

    @Override
    public final Date getNextWeekday(Weekday dayOfWeek) {
        int dow;
        int wd = this.getWeekday().toInteger();
        return new DefaultDate(this.value + (wd > (dow = dayOfWeek.toInteger()) ? 7 : 0) - wd + dow);
    }

    @Override
    public final Date getNthWeekday(int nth, Weekday dayOfWeek) {
        return DefaultDate.getNthWeekday(nth, dayOfWeek, this.getMonth(), this.getYear());
    }

    public static final Date getNthWeekday(int nth, Weekday dayOfWeek, Month month, int year) {
        return DefaultDate.getNthWeekday(nth, dayOfWeek, month.toInteger(), year);
    }

    public static final DefaultDate getNthWeekday(int nth, Weekday dayOfWeek, int month, int year) {
        int first;
        if (nth <= 0) {
            throw new IllegalArgumentException("zeroth day of week in a given (month, year) is undefined");
        }
        if (nth >= 6) {
            throw new IllegalArgumentException("no more than 5 weekday in a given (month, year)");
        }
        int m = month;
        int y = year;
        int dow = dayOfWeek.toInteger();
        int skip = nth - (dow >= (first = new DefaultDate(1, m, y).getWeekday().toInteger()) ? 1 : 0);
        return new DefaultDate(1 + dow - first + skip * 7, m, y);
    }

    private static final int getMonthLength(int m, boolean leapYear) {
        return leapYear ? monthLeapLength[m - 1] : monthLength[m - 1];
    }

    private static final int getMonthOffset(int m, boolean leapYear) {
        return leapYear ? monthLeapOffset[m - 1] : monthOffset[m - 1];
    }

    private static final int getYearOffset(int y) {
        return yearOffset[y - 1900];
    }

    @Override
    public final Weekday getWeekday() {
        int w = this.value % 7;
        return Weekday.valueOf(w == 0 ? 7 : w);
    }

    @Override
    public final int getDayOfMonth() {
        return this.getDayOfYear() - DefaultDate.getMonthOffset(this.getMonth(), DefaultDate.isLeap(this.getYear()));
    }

    @Override
    public final int getDayOfYear() {
        return this.value - DefaultDate.getYearOffset(this.getYear());
    }

    @Override
    public final DefaultDate getEndOfMonth() {
        int m = this.getMonth();
        int y = this.getYear();
        return new DefaultDate(DefaultDate.getMonthLength(m, DefaultDate.isLeap(y)), m, y);
    }

    @Override
    public final boolean isEndOfMonth() {
        return this.getDayOfMonth() == DefaultDate.getMonthLength(this.getMonth(), DefaultDate.isLeap(this.getYear()));
    }

    @Override
    public final boolean eq(Date date) {
        return this.value == ((DefaultDate)date).value;
    }

    @Override
    public final boolean lt(Date date) {
        return this.value < ((DefaultDate)date).value;
    }

    @Override
    public final boolean le(Date date) {
        return this.value <= ((DefaultDate)date).value;
    }

    @Override
    public final boolean gt(Date date) {
        return this.value > ((DefaultDate)date).value;
    }

    @Override
    public final boolean ge(Date date) {
        return this.value >= ((DefaultDate)date).value;
    }

    public final String toString() {
        return this.getLongFormat();
    }

    @Override
    public final String getLongFormat() {
        if (NULL_DATE.equals(this)) {
            return "null date";
        }
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb, Locale.US);
        formatter.format("%s %d, %d", new Object[]{this.getMonthEnum(), this.getDayOfMonth(), this.getYear()});
        return sb.toString();
    }

    @Override
    public final String getShortFormat() {
        if (NULL_DATE.equals(this)) {
            return "null date";
        }
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb, Locale.US);
        formatter.format("%s %d, %d", new Object[]{this.getMonthEnum(), this.getDayOfMonth(), this.getYear()});
        return sb.toString();
    }

    @Override
    public final String getISOFormat() {
        if (NULL_DATE.equals(this)) {
            return "null date";
        }
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb, Locale.US);
        formatter.format("%04d-%02d-%02d", this.getYear(), this.getMonth(), this.getDayOfMonth());
        return sb.toString();
    }

    private final void checkSerialNumber() {
        if (this.value < 367 || this.value > 73050) {
            throw new IllegalArgumentException("Date's serial number is outside allowed range");
        }
    }

    private final int getAdvancedDateValue(DefaultDate date, int n, TimeUnit units) {
        switch (units) {
            case DAYS: {
                return n + date.value;
            }
            case WEEKS: {
                return 7 * n + date.value;
            }
            case MONTHS: {
                int d = date.getDayOfMonth();
                int m = date.getMonth() + n;
                int y = date.getYear();
                while (m > 12) {
                    m -= 12;
                    ++y;
                }
                while (m < 1) {
                    m += 12;
                    --y;
                }
                if (y < 1900 || y > 2099) {
                    throw new IllegalArgumentException("year " + y + " out of bounds. It must be in [1901,2099]");
                }
                int length = DefaultDate.getMonthLength(m, DefaultDate.isLeap(y));
                if (d > length) {
                    d = length;
                }
                int result = DefaultDate.fromDMY(d, m, y);
                return result;
            }
            case YEARS: {
                int d = date.getDayOfMonth();
                int m = date.getMonth();
                int y = date.getYear() + n;
                if (y < 1900 || y > 2099) {
                    throw new IllegalArgumentException("year " + y + " out of bounds. It must be in [1901,2099]");
                }
                if (d == 29 && m == Month.FEBRUARY.toInteger() && !DefaultDate.isLeap(y)) {
                    d = 28;
                }
                int result = DefaultDate.fromDMY(d, m, y);
                return result;
            }
        }
        throw new IllegalArgumentException("undefined time units");
    }

    @Override
    public final int getDayCount(Date date) {
        return ((DefaultDate)date).value - this.value;
    }

    @Override
    public final Date getDateAfter(Period p) {
        int newDateValue = this.getAdvancedDateValue(this, p.length(), p.units());
        return new DefaultDate(newDateValue);
    }

    @Override
    public final Date getNextDay() {
        int newDateValue = this.value + 1;
        return new DefaultDate(newDateValue);
    }

    @Override
    public final Date getPreviousDay() {
        int newDateValue = this.value - 1;
        return new DefaultDate(newDateValue);
    }

    @Override
    public final boolean eq(int day, Month month, int year) {
        return this.value == DefaultDate.fromDMY(day, month.toInteger(), year);
    }

    @Override
    public final boolean ge(int day, Month month, int year) {
        return this.value >= DefaultDate.fromDMY(day, month.toInteger(), year);
    }

    @Override
    public final boolean gt(int day, Month month, int year) {
        return this.value > DefaultDate.fromDMY(day, month.toInteger(), year);
    }

    @Override
    public final boolean le(int day, Month month, int year) {
        return this.value <= DefaultDate.fromDMY(day, month.toInteger(), year);
    }

    @Override
    public final boolean lt(int day, Month month, int year) {
        return this.value < DefaultDate.fromDMY(day, month.toInteger(), year);
    }

    @Override
    public final Date getDateAfter(int n) {
        return new DefaultDate(this.value + n);
    }

    @Override
    public final Updatable<Date> getUpdatable() {
        if (this.updatable == null) {
            this.updatable = new UpdatableDate(this);
        }
        return this.updatable;
    }

    @Override
    public final int dateValue() {
        logger.debug("{}", (Object)this.value);
        return this.value;
    }

    public static final class JQLibDateUtil
    extends DateFactory {
        @Override
        public final Date getMaxDate() {
            return DefaultDate.getMaxDate();
        }

        @Override
        public final Date getMinDate() {
            return DefaultDate.getMinDate();
        }

        @Override
        public final Date getTodaysDate() {
            return DefaultDate.getTodaysDate();
        }

        @Override
        public final Date getDate(int day, Month month, int year) {
            return new DefaultDate(day, month, year);
        }

        @Override
        public final Date getDate(int day, int month, int year) {
            return new DefaultDate(day, month, year);
        }

        @Override
        public final Date getNthWeekday(int nth, Weekday dayOfWeek, Month month, int year) {
            return DefaultDate.getNthWeekday(nth, dayOfWeek, month, year);
        }

        @Override
        public final Date parseISO(String str) {
            return DateParser.parseISO(str);
        }

        @Override
        public final Date parse(String str, String fmt) {
            return DateParser.parse(str, fmt);
        }

        @Override
        public final boolean isLeap(int year) {
            return DefaultDate.isLeap(year);
        }
    }

    private static final class UpdatableDate
    implements Updatable<Date> {
        private final DefaultDate target;

        public UpdatableDate(DefaultDate date) {
            this.target = date;
        }

        @Override
        public final void update(Date source) {
            if (source == null) {
                throw new NullPointerException();
            }
            if (this.target.equals(Date.NULL_DATE)) {
                throw new IllegalStateException("not updatable");
            }
            this.target.value = ((DefaultDate)source).value;
            this.target.notifyObservers();
        }
    }
}

