/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.volatilities;

import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.math.interpolations.Interpolation;
import org.jquantlib.math.interpolations.Interpolator;
import org.jquantlib.math.interpolations.LinearInterpolation;
import org.jquantlib.termstructures.BlackVarianceTermStructure;
import org.jquantlib.termstructures.TermStructure;
import org.jquantlib.util.Date;
import org.jquantlib.util.TypedVisitor;
import org.jquantlib.util.Visitor;

public class BlackVarianceCurve
extends BlackVarianceTermStructure {
    private DayCounter dayCounter;
    private Date maxDate;
    private Date[] dates;
    private double[] times;
    private double[] variances;
    private Interpolation varianceCurve;
    private Interpolator factory;

    public BlackVarianceCurve(Date referenceDate, Date[] dates, double[] blackVolCurve, DayCounter dayCounter) {
        this(referenceDate, dates, blackVolCurve, dayCounter, true);
    }

    public BlackVarianceCurve(Date referenceDate, Date[] dates, double[] blackVolCurve, DayCounter dayCounter, boolean forceMonotoneVariance) {
        super(referenceDate);
        this.dayCounter = dayCounter;
        this.dates = (Date[])dates.clone();
        this.maxDate = dates[dates.length - 1];
        if (this.dates.length != blackVolCurve.length) {
            throw new IllegalArgumentException("mismatch between date vector and black vol vector");
        }
        if (this.dates[0].le(referenceDate)) {
            throw new IllegalArgumentException("cannot have dates[0] <= referenceDate");
        }
        this.variances = new double[this.dates.length + 1];
        this.times = new double[this.dates.length + 1];
        this.variances[0] = 0.0;
        this.times[0] = 0.0;
        for (int j = 1; j <= blackVolCurve.length; ++j) {
            this.times[j] = this.timeFromReference(this.dates[j - 1]);
            if (!(this.times[j] > this.times[j - 1])) {
                throw new IllegalArgumentException("dates must be sorted unique");
            }
            this.variances[j] = this.times[j] * blackVolCurve[j - 1] * blackVolCurve[j - 1];
            if (this.variances[j] >= this.variances[j - 1] || !forceMonotoneVariance) continue;
            throw new IllegalArgumentException("variance must be non-decreasing");
        }
        this.factory = LinearInterpolation.getInterpolator();
    }

    @Override
    public final DayCounter dayCounter() {
        return this.dayCounter;
    }

    @Override
    public final Date maxDate() {
        return this.maxDate;
    }

    @Override
    public final double minStrike() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public final double maxStrike() {
        return Double.POSITIVE_INFINITY;
    }

    public void setInterpolation() {
        this.setInterpolation(this.factory);
    }

    public final void setInterpolation(Interpolator factory) {
        this.varianceCurve = factory.interpolate(this.times, this.variances);
        this.varianceCurve.enableExtrapolation();
        this.varianceCurve.reload();
        this.notifyObservers();
    }

    @Override
    protected final double blackVarianceImpl(double t, double maturity) {
        if (t <= this.times[this.times.length]) {
            return this.varianceCurve.evaluate(t);
        }
        double lastTime = this.times[this.times.length];
        return this.varianceCurve.evaluate(lastTime) * t / lastTime;
    }

    @Override
    public void accept(TypedVisitor<TermStructure> v) {
        Visitor<TermStructure> v1;
        Visitor<TermStructure> visitor = v1 = v != null ? v.getVisitor(this.getClass()) : null;
        if (v1 != null) {
            v1.visit(this);
        } else {
            super.accept(v);
        }
    }
}

