/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.randomnumbers;

import org.joda.primitives.list.DoubleList;
import org.joda.primitives.list.impl.ArrayDoubleList;
import org.jquantlib.lang.reflect.TypeToken;
import org.jquantlib.math.randomnumbers.RandomNumberGenerator;
import org.jquantlib.math.randomnumbers.RandomSequenceGeneratorIntf;
import org.jquantlib.methods.montecarlo.Sample;

public class RandomSequenceGenerator<RNG extends RandomNumberGenerator>
implements RandomSequenceGeneratorIntf {
    private final int dimension;
    private final RNG rng;
    private final double[] sequence;
    private final long[] int32Sequence;

    public RandomSequenceGenerator(int dimensionality, RNG rng) {
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        if (dimensionality < 1) {
            throw new IllegalArgumentException("dimensionality must be greater than 0");
        }
        this.dimension = dimensionality;
        this.rng = rng;
        this.sequence = new double[this.dimension];
        this.int32Sequence = new long[this.dimension];
    }

    public RandomSequenceGenerator(int dimensionality) {
        this(dimensionality, 0L);
    }

    public RandomSequenceGenerator(int dimensionality, long seed) {
        if (dimensionality < 1) {
            throw new IllegalArgumentException("dimensionality must be greater than 0");
        }
        this.dimension = dimensionality;
        this.sequence = new double[this.dimension];
        this.int32Sequence = new long[this.dimension];
        try {
            this.rng = (RandomNumberGenerator)TypeToken.getClazz(this.getClass()).getConstructor(Long.TYPE).newInstance(seed);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final Sample<DoubleList> lastSequence() {
        return new Sample<ArrayDoubleList>(new ArrayDoubleList(this.sequence), 1.0);
    }

    @Override
    public final Sample<DoubleList> nextSequence() {
        double weight = 1.0;
        for (int i = 0; i < this.dimension; ++i) {
            Sample<Double> sample = this.rng.next();
            this.sequence[i] = sample.getValue();
            weight *= sample.getWeight();
        }
        return new Sample<ArrayDoubleList>(new ArrayDoubleList(this.sequence), weight);
    }

    @Override
    public long[] nextInt32Sequence() {
        for (int i = 0; i < this.dimension; ++i) {
            this.int32Sequence[i] = this.rng.nextInt32();
        }
        return this.int32Sequence;
    }

    @Override
    public int dimension() {
        return this.dimension;
    }
}

