/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.management;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoServiceListener;
import org.apache.mina.common.IoSession;
import org.apache.mina.management.IoSessionStat;

public class StatCollector {
    public static final String KEY = StatCollector.class.getName() + ".stat";
    private static volatile int nextId = 0;
    private final int id = nextId++;
    private final IoService service;
    private Worker worker;
    private int pollingInterval = 5000;
    private List polledSessions;
    private long totalProcessedSessions = 0L;
    private float msgWrittenThroughput = 0.0f;
    private float msgReadThroughput = 0.0f;
    private float bytesWrittenThroughput = 0.0f;
    private float bytesReadThroughput = 0.0f;
    private final IoServiceListener serviceListener = new IoServiceListener(){

        public void serviceActivated(IoService service, SocketAddress serviceAddress, IoHandler handler, IoServiceConfig config) {
        }

        public void serviceDeactivated(IoService service, SocketAddress serviceAddress, IoHandler handler, IoServiceConfig config) {
        }

        public void sessionCreated(IoSession session) {
            StatCollector.this.addSession(session);
        }

        public void sessionDestroyed(IoSession session) {
            StatCollector.this.removeSession(session);
        }
    };

    public StatCollector(IoService service) {
        this(service, 5000);
    }

    public StatCollector(IoService service, int pollingInterval) {
        this.service = service;
        this.pollingInterval = pollingInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        StatCollector statCollector = this;
        synchronized (statCollector) {
            if (this.worker != null && this.worker.isAlive()) {
                throw new RuntimeException("Stat collecting already started");
            }
            this.polledSessions = new ArrayList();
            for (SocketAddress element : this.service.getManagedServiceAddresses()) {
                Iterator<IoSession> iter2 = this.service.getManagedSessions(element).iterator();
                while (iter2.hasNext()) {
                    this.addSession(iter2.next());
                }
            }
            this.service.addListener(this.serviceListener);
            this.worker = new Worker();
            this.worker.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        StatCollector statCollector = this;
        synchronized (statCollector) {
            this.service.removeListener(this.serviceListener);
            this.worker.stop = true;
            this.worker.interrupt();
            while (this.worker.isAlive()) {
                try {
                    this.worker.join();
                }
                catch (InterruptedException e) {}
            }
            for (IoSession session : this.polledSessions) {
                session.removeAttribute(KEY);
            }
            this.polledSessions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        StatCollector statCollector = this;
        synchronized (statCollector) {
            return this.worker != null && !this.worker.stop;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSession(IoSession session) {
        StatCollector statCollector = this;
        synchronized (statCollector) {
            ++this.totalProcessedSessions;
            this.polledSessions.add(session);
            session.setAttribute(KEY, new IoSessionStat());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSession(IoSession session) {
        StatCollector statCollector = this;
        synchronized (statCollector) {
            this.polledSessions.remove(session);
            IoSessionStat sessStat = (IoSessionStat)session.getAttribute(KEY);
            this.bytesReadThroughput += (float)(session.getReadBytes() - sessStat.lastByteRead) / ((float)(System.currentTimeMillis() - sessStat.lastPollingTime) / 1000.0f);
            this.bytesWrittenThroughput += (float)(session.getWrittenBytes() - sessStat.lastByteWrite) / ((float)(System.currentTimeMillis() - sessStat.lastPollingTime) / 1000.0f);
            this.msgReadThroughput += (float)(session.getReadMessages() - sessStat.lastMessageRead) / ((float)(System.currentTimeMillis() - sessStat.lastPollingTime) / 1000.0f);
            this.msgWrittenThroughput += (float)(session.getWrittenMessages() - sessStat.lastMessageWrite) / ((float)(System.currentTimeMillis() - sessStat.lastPollingTime) / 1000.0f);
            session.removeAttribute(KEY);
        }
    }

    public long getTotalProcessedSessions() {
        return this.totalProcessedSessions;
    }

    public float getBytesReadThroughput() {
        return this.bytesReadThroughput;
    }

    public float getBytesWrittenThroughput() {
        return this.bytesWrittenThroughput;
    }

    public float getMsgReadThroughput() {
        return this.msgReadThroughput;
    }

    public float getMsgWrittenThroughput() {
        return this.msgWrittenThroughput;
    }

    public long getSessionCount() {
        return this.polledSessions.size();
    }

    private class Worker
    extends Thread {
        boolean stop;

        private Worker() {
            super("StatCollectorWorker-" + StatCollector.this.id);
            this.stop = false;
        }

        public void run() {
            while (!this.stop) {
                IoSessionStat sessStat;
                for (IoSession session : StatCollector.this.polledSessions) {
                    sessStat = (IoSessionStat)session.getAttribute(KEY);
                    sessStat.lastByteRead = session.getReadBytes();
                    sessStat.lastByteWrite = session.getWrittenBytes();
                    sessStat.lastMessageRead = session.getReadMessages();
                    sessStat.lastMessageWrite = session.getWrittenMessages();
                }
                try {
                    Thread.sleep(StatCollector.this.pollingInterval);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                StatCollector.this.msgWrittenThroughput = 0.0f;
                StatCollector.this.msgReadThroughput = 0.0f;
                StatCollector.this.bytesWrittenThroughput = 0.0f;
                StatCollector.this.bytesReadThroughput = 0.0f;
                for (IoSession session : StatCollector.this.polledSessions) {
                    sessStat = (IoSessionStat)session.getAttribute(KEY);
                    sessStat.byteReadThroughput = (float)(session.getReadBytes() - sessStat.lastByteRead) / ((float)StatCollector.this.pollingInterval / 1000.0f);
                    StatCollector.this.bytesReadThroughput += sessStat.byteReadThroughput;
                    sessStat.byteWrittenThroughput = (float)(session.getWrittenBytes() - sessStat.lastByteWrite) / ((float)StatCollector.this.pollingInterval / 1000.0f);
                    StatCollector.this.bytesWrittenThroughput += sessStat.byteWrittenThroughput;
                    sessStat.messageReadThroughput = (float)(session.getReadMessages() - sessStat.lastMessageRead) / ((float)StatCollector.this.pollingInterval / 1000.0f);
                    StatCollector.this.msgReadThroughput += sessStat.messageReadThroughput;
                    sessStat.messageWrittenThroughput = (float)(session.getWrittenMessages() - sessStat.lastMessageWrite) / ((float)StatCollector.this.pollingInterval / 1000.0f);
                    StatCollector.this.msgWrittenThroughput += sessStat.messageWrittenThroughput;
                    sessStat.lastPollingTime = System.currentTimeMillis();
                }
            }
        }
    }
}

