/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo;

import java.util.Dictionary;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.Factory;
import org.apache.felix.ipojo.HandlerManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.architecture.ComponentTypeDescription;
import org.apache.felix.ipojo.architecture.HandlerDescription;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.util.Logger;

public abstract class Handler {
    public static final String HANDLER_NAMESPACE_PROPERTY = "handler.namespace";
    public static final String HANDLER_NAME_PROPERTY = "handler.name";
    public static final String HANDLER_TYPE_PROPERTY = "handler.type";
    public static final String HANDLER_LEVEL_PROPERTY = "handler.level";
    protected boolean m_isValid = true;
    protected HandlerManager m_instance;

    public abstract void setFactory(Factory var1);

    public abstract Logger getLogger();

    public final void warn(String message) {
        this.getLogger().log(2, message);
    }

    public final void error(String message) {
        this.getLogger().log(1, message);
    }

    public final void info(String message) {
        this.getLogger().log(3, message);
    }

    public final void warn(String message, Throwable exception) {
        this.getLogger().log(2, message, exception);
    }

    public final void error(String message, Throwable exception) {
        this.getLogger().log(1, message, exception);
    }

    public abstract Handler getHandler(String var1);

    protected abstract void attach(ComponentInstance var1);

    public final boolean isValid() {
        return ((Pojo)((Object)this)).getComponentInstance().getState() == 2;
    }

    public final void setValidity(boolean isValid) {
        if (this.m_isValid != isValid) {
            this.m_isValid = isValid;
            HandlerManager instance = this.getHandlerManager();
            if (isValid) {
                instance.stateChanged(instance, 2);
            } else {
                instance.stateChanged(instance, 1);
            }
        }
    }

    public final boolean getValidity() {
        return this.m_isValid;
    }

    public final HandlerManager getHandlerManager() {
        if (this.m_instance != null) {
            return this.m_instance;
        }
        this.m_instance = (HandlerManager)((Pojo)((Object)this)).getComponentInstance();
        return this.m_instance;
    }

    public void initializeComponentFactory(ComponentTypeDescription typeDesc, Element metadata) throws ConfigurationException {
    }

    public abstract void configure(Element var1, Dictionary var2) throws ConfigurationException;

    public abstract void stop();

    public abstract void start();

    public void stateChanged(int state) {
    }

    public HandlerDescription getDescription() {
        return new HandlerDescription(this);
    }

    public void reconfigure(Dictionary configuration) {
    }
}

