/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.methods.lattices;

import org.jquantlib.lang.annotation.NonNegative;
import org.jquantlib.lang.annotation.Price;
import org.jquantlib.lang.annotation.Time;
import org.jquantlib.methods.lattices.BinomialTree;
import org.jquantlib.processes.StochasticProcess1D;

public class Joshi4
extends BinomialTree {
    protected double up;
    protected double down;
    protected double pu;
    protected double pd;

    public Joshi4(StochasticProcess1D process, @Time double end, @NonNegative int steps, @Price double strike) {
        super(process, end, steps % 2 > 0 ? steps : steps + 1);
        if (strike <= 0.0) {
            throw new IllegalStateException("strike must be positive");
        }
        int oddSteps = steps % 2 > 0 ? steps : steps + 1;
        double variance = process.variance(0.0, this.x0, end);
        double ermqdt = Math.exp(this.driftPerStep + 0.5 * variance / (double)oddSteps);
        double d2 = (Math.log(this.x0 / strike) + this.driftPerStep * (double)oddSteps) / Math.sqrt(variance);
        this.pu = this.computeUpProb(((double)oddSteps - 1.0) / 2.0, d2);
        this.pd = 1.0 - this.pu;
        double pdash = this.computeUpProb(((double)oddSteps - 1.0) / 2.0, d2 + Math.sqrt(variance));
        this.up = ermqdt * pdash / this.pu;
        this.down = (ermqdt - this.pu * this.up) / (1.0 - this.pu);
    }

    @Override
    public double underlying(int i, int index) {
        long j = (long)i - (long)index;
        double d = j;
        return this.x0 * Math.pow(this.down, d) * Math.pow(this.up, index);
    }

    @Override
    public double probability(int i, int j, int branch) {
        return branch == 1 ? this.pu : this.pd;
    }

    protected double computeUpProb(double k, double dj) {
        double alpha = dj / Math.sqrt(8.0);
        double alpha2 = alpha * alpha;
        double alpha3 = alpha * alpha2;
        double alpha5 = alpha3 * alpha2;
        double alpha7 = alpha5 * alpha2;
        double beta = -0.375 * alpha - alpha3;
        double gamma = 0.8333333333333334 * alpha5 + 1.0833333333333333 * alpha3 + 0.1953125 * alpha;
        double delta = -0.1025 * alpha - 0.9285 * alpha3 - 1.43 * alpha5 - 0.5 * alpha7;
        double p = 0.5;
        double rootk = Math.sqrt(k);
        p += alpha / rootk;
        p += beta / (k * rootk);
        p += gamma / (k * k * rootk);
        return p += delta / (k * k * k * rootk);
    }
}

