/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures;

import java.util.List;
import org.jquantlib.Configuration;
import org.jquantlib.Settings;
import org.jquantlib.daycounters.Actual365Fixed;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.math.interpolations.DefaultExtrapolator;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.TimeUnit;
import org.jquantlib.util.Date;
import org.jquantlib.util.DefaultObservable;
import org.jquantlib.util.Observable;
import org.jquantlib.util.Observer;

public abstract class TermStructure
implements Observer,
Observable {
    private static final String THIS_METHOD_MUST_BE_OVERRIDDEN = "This method must be overridden";
    protected final Settings settings;
    private Date referenceDate;
    private final Calendar calendar;
    private final DayCounter dayCounter;
    private boolean updated;
    private final int settlementDays;
    private final boolean moving;
    private final Date today;
    private DefaultExtrapolator delegatedExtrapolator = new DefaultExtrapolator();
    private Observable delegatedObservable = new DefaultObservable(this);

    public TermStructure() {
        this(Actual365Fixed.getDayCounter());
    }

    public TermStructure(DayCounter dc) {
        if (dc == null) {
            throw new NullPointerException();
        }
        this.calendar = null;
        this.settlementDays = 0;
        this.dayCounter = dc;
        this.settings = Configuration.getSystemConfiguration(null).getGlobalSettings();
        this.moving = false;
        this.updated = true;
        this.today = null;
        this.referenceDate = null;
    }

    public TermStructure(Date referenceDate, Calendar calendar) {
        this(referenceDate, calendar, (DayCounter)Actual365Fixed.getDayCounter());
    }

    public TermStructure(Date referenceDate, Calendar calendar, DayCounter dc) {
        if (referenceDate == null) {
            throw new NullPointerException();
        }
        if (calendar == null) {
            throw new NullPointerException();
        }
        if (dc == null) {
            throw new NullPointerException();
        }
        this.settlementDays = 0;
        this.calendar = calendar;
        this.dayCounter = dc;
        this.settings = Configuration.getSystemConfiguration(null).getGlobalSettings();
        this.moving = false;
        this.updated = true;
        this.today = null;
        this.referenceDate = referenceDate;
        this.referenceDate.addObserver(this);
    }

    public TermStructure(int settlementDays, Calendar calendar) {
        this(settlementDays, calendar, (DayCounter)Actual365Fixed.getDayCounter());
    }

    public TermStructure(int settlementDays, Calendar calendar, DayCounter dc) {
        this.settlementDays = settlementDays;
        this.calendar = calendar;
        this.dayCounter = dc;
        this.settings = Configuration.getSystemConfiguration(null).getGlobalSettings();
        this.moving = true;
        this.updated = false;
        this.today = this.settings.getEvaluationDate();
        this.today.addObserver(this);
        this.referenceDate = null;
    }

    public abstract Date maxDate();

    public Calendar calendar() {
        if (this.calendar == null) {
            throw new IllegalStateException(THIS_METHOD_MUST_BE_OVERRIDDEN);
        }
        return this.calendar;
    }

    public final double timeFromReference(Date date) {
        return this.dayCounter().yearFraction(this.referenceDate(), date);
    }

    protected final void checkRange(Date date, boolean extrapolate) {
        this.checkRange(this.timeFromReference(date), extrapolate);
    }

    protected final void checkRange(double time, boolean extrapolate) {
        double t = time;
        if (t < 0.0) {
            throw new IllegalArgumentException("negative double given");
        }
        if (!(extrapolate || this.allowsExtrapolation() || t <= this.maxTime())) {
            throw new IllegalArgumentException("double (" + time + ") is past max curve double (" + this.maxTime() + ")");
        }
    }

    public DayCounter dayCounter() {
        if (this.dayCounter == null) {
            throw new IllegalStateException(THIS_METHOD_MUST_BE_OVERRIDDEN);
        }
        return this.dayCounter;
    }

    public double maxTime() {
        return this.timeFromReference(this.maxDate());
    }

    public Date referenceDate() {
        if (this.moving && !this.updated) {
            this.referenceDate = this.calendar().advance(this.today, this.settlementDays, TimeUnit.DAYS);
            this.updated = true;
        }
        if (this.referenceDate == null) {
            throw new IllegalStateException(THIS_METHOD_MUST_BE_OVERRIDDEN);
        }
        return this.referenceDate;
    }

    public final boolean allowsExtrapolation() {
        return this.delegatedExtrapolator.allowsExtrapolation();
    }

    public void disableExtrapolation() {
        this.delegatedExtrapolator.disableExtrapolation();
    }

    public void enableExtrapolation() {
        this.delegatedExtrapolator.enableExtrapolation();
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.moving) {
            this.updated = false;
        }
        this.notifyObservers();
    }

    @Override
    public void addObserver(Observer observer) {
        this.delegatedObservable.addObserver(observer);
    }

    @Override
    public int countObservers() {
        return this.delegatedObservable.countObservers();
    }

    @Override
    public void deleteObserver(Observer observer) {
        this.delegatedObservable.deleteObserver(observer);
    }

    @Override
    public void notifyObservers() {
        this.delegatedObservable.notifyObservers();
    }

    @Override
    public void notifyObservers(Object arg) {
        this.delegatedObservable.notifyObservers(arg);
    }

    @Override
    public void deleteObservers() {
        this.delegatedObservable.deleteObservers();
    }

    @Override
    public List<Observer> getObservers() {
        return this.delegatedObservable.getObservers();
    }
}

