"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _createSuper2 = _interopRequireDefault(require("@babel/runtime/helpers/createSuper"));

var _PortalWrapper = _interopRequireDefault(require("rc-util/lib/PortalWrapper"));

var React = _interopRequireWildcard(require("react"));

var _DrawerChild = _interopRequireDefault(require("./DrawerChild"));

var _excluded = ["defaultOpen", "getContainer", "wrapperClassName", "forceRender", "handler"],
    _excluded2 = ["visible", "afterClose"];

var DrawerWrapper = /*#__PURE__*/function (_React$Component) {
  (0, _inherits2.default)(DrawerWrapper, _React$Component);

  var _super = (0, _createSuper2.default)(DrawerWrapper);

  function DrawerWrapper(props) {
    var _this;

    (0, _classCallCheck2.default)(this, DrawerWrapper);
    _this = _super.call(this, props);
    _this.dom = void 0;

    _this.onHandleClick = function (e) {
      var _this$props = _this.props,
          onHandleClick = _this$props.onHandleClick,
          $open = _this$props.open;

      if (onHandleClick) {
        onHandleClick(e);
      }

      if (typeof $open === 'undefined') {
        var open = _this.state.open;

        _this.setState({
          open: !open
        });
      }
    };

    _this.onClose = function (e) {
      var _this$props2 = _this.props,
          onClose = _this$props2.onClose,
          open = _this$props2.open;

      if (onClose) {
        onClose(e);
      }

      if (typeof open === 'undefined') {
        _this.setState({
          open: false
        });
      }
    };

    var _open = typeof props.open !== 'undefined' ? props.open : !!props.defaultOpen;

    _this.state = {
      open: _open
    };

    if ('onMaskClick' in props) {
      console.warn('`onMaskClick` are removed, please use `onClose` instead.');
    }

    return _this;
  }

  (0, _createClass2.default)(DrawerWrapper, [{
    key: "render",
    value: // tslint:disable-next-line:member-ordering
    function render() {
      var _this2 = this;

      var _this$props3 = this.props,
          defaultOpen = _this$props3.defaultOpen,
          getContainer = _this$props3.getContainer,
          wrapperClassName = _this$props3.wrapperClassName,
          forceRender = _this$props3.forceRender,
          handler = _this$props3.handler,
          props = (0, _objectWithoutProperties2.default)(_this$props3, _excluded);
      var open = this.state.open; // 渲染在当前 dom 里；

      if (!getContainer) {
        return /*#__PURE__*/React.createElement("div", {
          className: wrapperClassName,
          ref: function ref(c) {
            _this2.dom = c;
          }
        }, /*#__PURE__*/React.createElement(_DrawerChild.default, (0, _extends2.default)({}, props, {
          open: open,
          handler: handler,
          getContainer: function getContainer() {
            return _this2.dom;
          },
          onClose: this.onClose,
          onHandleClick: this.onHandleClick
        })));
      } // 如果有 handler 为内置强制渲染；


      var $forceRender = !!handler || forceRender;
      return /*#__PURE__*/React.createElement(_PortalWrapper.default, {
        visible: open,
        forceRender: $forceRender,
        getContainer: getContainer,
        wrapperClassName: wrapperClassName
      }, function (_ref) {
        var visible = _ref.visible,
            afterClose = _ref.afterClose,
            rest = (0, _objectWithoutProperties2.default)(_ref, _excluded2);
        return (
          /*#__PURE__*/
          // react 15，componentWillUnmount 时 Portal 返回 afterClose, visible.
          React.createElement(_DrawerChild.default, (0, _extends2.default)({}, props, rest, {
            open: visible !== undefined ? visible : open,
            afterVisibleChange: afterClose !== undefined ? afterClose : props.afterVisibleChange,
            handler: handler,
            onClose: _this2.onClose,
            onHandleClick: _this2.onHandleClick
          }))
        );
      });
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(props, _ref2) {
      var prevProps = _ref2.prevProps;
      var newState = {
        prevProps: props
      };

      if (typeof prevProps !== 'undefined' && props.open !== prevProps.open) {
        newState.open = props.open;
      }

      return newState;
    }
  }]);
  return DrawerWrapper;
}(React.Component);

DrawerWrapper.defaultProps = {
  prefixCls: 'drawer',
  placement: 'left',
  getContainer: 'body',
  defaultOpen: false,
  level: 'all',
  duration: '.3s',
  ease: 'cubic-bezier(0.78, 0.14, 0.15, 0.86)',
  onChange: function onChange() {},
  afterVisibleChange: function afterVisibleChange() {},
  handler: /*#__PURE__*/React.createElement("div", {
    className: "drawer-handle"
  }, /*#__PURE__*/React.createElement("i", {
    className: "drawer-handle-icon"
  })),
  showMask: true,
  maskClosable: true,
  maskStyle: {},
  wrapperClassName: '',
  className: '',
  keyboard: true,
  forceRender: false,
  autoFocus: true
};
var _default = DrawerWrapper;
exports.default = _default;