"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

exports.default = function () {
  return {
    visitor: {
      Program: function Program(path, state) {
        // On program start, do an explicit traversal up front for this plugin.
        var properties = state.opts.properties || [];

        if (state.opts.property) {
          /* eslint-disable no-console */
          console.warn("\n            babel-plugin-react-remove-properties:\n            The property option is deprecated, instead use the properties one.\n          ");
          /* eslint-enable no-console */
          properties.push(state.opts.property);
        }

        if (properties.length === 0) {
          properties.push(/^data-test/);
        }

        path.traverse({
          JSXIdentifier: function JSXIdentifier(path2) {
            properties.forEach(function (property) {
              var regularExpressionMatch = property instanceof RegExp && property.test(path2.node.name);
              var stringMatch = property === path2.node.name;
              if (regularExpressionMatch || stringMatch) path2.parentPath.remove();
            });
          }
        });
      }
    }
  };
};