import React from 'react';
import { TimeZone, LogsDedupStrategy, LogRowModel, Field, LinkModel, LogsSortOrder } from '@grafana/data';
import { Themeable2 } from '../../types/theme';
import { RowContextOptions } from './LogRowContextProvider';
export declare const PREVIEW_LIMIT = 100;
export interface Props extends Themeable2 {
    logRows?: LogRowModel[];
    deduplicatedRows?: LogRowModel[];
    dedupStrategy: LogsDedupStrategy;
    showLabels: boolean;
    showTime: boolean;
    wrapLogMessage: boolean;
    prettifyLogMessage: boolean;
    timeZone: TimeZone;
    enableLogDetails: boolean;
    logsSortOrder?: LogsSortOrder | null;
    previewLimit?: number;
    forceEscape?: boolean;
    showDetectedFields?: string[];
    showContextToggle?: (row?: LogRowModel) => boolean;
    onClickFilterLabel?: (key: string, value: string) => void;
    onClickFilterOutLabel?: (key: string, value: string) => void;
    getRowContext?: (row: LogRowModel, options?: RowContextOptions) => Promise<any>;
    getFieldLinks?: (field: Field, rowIndex: number) => Array<LinkModel<Field>>;
    onClickShowDetectedField?: (key: string) => void;
    onClickHideDetectedField?: (key: string) => void;
    onLogRowHover?: (row?: LogRowModel) => void;
}
export declare const LogRows: React.FunctionComponent<{
    timeZone: TimeZone;
    wrapLogMessage: boolean;
    onClickFilterLabel?: ((key: string, value: string) => void) | undefined;
    onClickFilterOutLabel?: ((key: string, value: string) => void) | undefined;
    showDetectedFields?: string[] | undefined;
    onClickShowDetectedField?: ((key: string) => void) | undefined;
    onClickHideDetectedField?: ((key: string) => void) | undefined;
    getRowContext?: ((row: LogRowModel, options?: RowContextOptions) => Promise<any>) | undefined;
    logsSortOrder?: LogsSortOrder | null | undefined;
    prettifyLogMessage: boolean;
    showContextToggle?: ((row?: LogRowModel) => boolean) | undefined;
    getFieldLinks?: ((field: Field, rowIndex: number) => Array<LinkModel<Field>>) | undefined;
    showLabels: boolean;
    showTime: boolean;
    enableLogDetails: boolean;
    forceEscape?: boolean | undefined;
    onLogRowHover?: ((row?: LogRowModel) => void) | undefined;
    logRows?: LogRowModel[] | undefined;
    deduplicatedRows?: LogRowModel[] | undefined;
    dedupStrategy: LogsDedupStrategy;
    previewLimit?: number | undefined;
}>;
