import { defaultGlobalObjectKey, } from '@grafana/agent-core';
import { ConsoleInstrumentation, ErrorsInstrumentation, parseStacktrace, WebVitalsInstrumentation, } from './instrumentations';
import { browserMeta, pageMeta } from './metas';
import { FetchTransport } from './transports';
export const defaultMetas = [browserMeta, pageMeta];
export const getWebInstrumentations = (options = {}) => {
    const instrumentations = [new ErrorsInstrumentation(), new WebVitalsInstrumentation()];
    if (options.captureConsole !== false) {
        instrumentations.push(new ConsoleInstrumentation());
    }
    return instrumentations;
};
export function makeCoreConfig(browserConfig) {
    var _a, _b, _c;
    const transports = [];
    if (browserConfig.transports) {
        if (browserConfig.url || browserConfig.apiKey) {
            throw new Error('if "transports" is defined, "url" and "apiKey" should not be defined');
        }
        transports.push(...browserConfig.transports);
    }
    else if (browserConfig.url) {
        transports.push(new FetchTransport({
            url: browserConfig.url,
            apiKey: browserConfig.apiKey,
        }));
    }
    else {
        throw new Error('either "url" or "transports" must be defined');
    }
    const config = {
        globalObjectKey: browserConfig.globalObjectKey || defaultGlobalObjectKey,
        preventGlobalExposure: browserConfig.preventGlobalExposure || false,
        transports,
        metas: (_a = browserConfig.metas) !== null && _a !== void 0 ? _a : defaultMetas,
        instrumentations: (_b = browserConfig.instrumentations) !== null && _b !== void 0 ? _b : getWebInstrumentations(),
        app: browserConfig.app,
        session: browserConfig.session,
        user: browserConfig.user,
        ignoreErrors: browserConfig.ignoreErrors,
        parseStacktrace,
        paused: (_c = browserConfig.paused) !== null && _c !== void 0 ? _c : false,
        beforeSend: browserConfig.beforeSend,
    };
    return config;
}
//# sourceMappingURL=config.js.map