import { defaultGlobalObjectKey } from '@grafana/agent-core';
import { ConsoleInstrumentation, ErrorsInstrumentation, WebVitalsInstrumentation } from './instrumentations';
import { browserMeta, pageMeta } from './metas';
import { FetchTransport } from './transports';
export var defaultMetas = [browserMeta, pageMeta];
export var getWebInstrumentations = function (options) {
  if (options === void 0) {
    options = {};
  }
  var instrumentations = [new ErrorsInstrumentation(), new WebVitalsInstrumentation()];
  if (options.captureConsole !== false) {
    instrumentations.push(new ConsoleInstrumentation());
  }
  return instrumentations;
};
export function makeCoreConfig(browserConfig) {
  var _a, _b;
  var transports = [];
  if (browserConfig.transports) {
    if (browserConfig.url || browserConfig.apiKey) {
      throw new Error('if "transports" is defined, "url" and "apiKey" should not be defined');
    }
    transports.push.apply(transports, browserConfig.transports);
  } else if (browserConfig.url) {
    transports.push(
      new FetchTransport({
        url: browserConfig.url,
        apiKey: browserConfig.apiKey,
      })
    );
  } else {
    throw new Error('either "url" or "transports" must be defined');
  }
  var config = {
    globalObjectKey: browserConfig.globalObjectKey || defaultGlobalObjectKey,
    preventGlobalExposure: browserConfig.preventGlobalExposure || false,
    transports: transports,
    metas: (_a = browserConfig.metas) !== null && _a !== void 0 ? _a : defaultMetas,
    instrumentations: (_b = browserConfig.instrumentations) !== null && _b !== void 0 ? _b : getWebInstrumentations(),
    app: browserConfig.app,
    session: browserConfig.session,
    user: browserConfig.user,
    ignoreErrors: browserConfig.ignoreErrors,
  };
  return config;
}
//# sourceMappingURL=config.js.map
