"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.makeCoreConfig = exports.getWebInstrumentations = exports.defaultMetas = void 0;
var agent_core_1 = require("@grafana/agent-core");
var instrumentations_1 = require("./instrumentations");
var metas_1 = require("./metas");
var transports_1 = require("./transports");
exports.defaultMetas = [metas_1.browserMeta, metas_1.pageMeta];
var getWebInstrumentations = function (options) {
    if (options === void 0) { options = {}; }
    var instrumentations = [new instrumentations_1.ErrorsInstrumentation(), new instrumentations_1.WebVitalsInstrumentation()];
    if (options.captureConsole !== false) {
        instrumentations.push(new instrumentations_1.ConsoleInstrumentation());
    }
    return instrumentations;
};
exports.getWebInstrumentations = getWebInstrumentations;
function makeCoreConfig(browserConfig) {
    var _a, _b, _c;
    var transports = [];
    if (browserConfig.transports) {
        if (browserConfig.url || browserConfig.apiKey) {
            throw new Error('if "transports" is defined, "url" and "apiKey" should not be defined');
        }
        transports.push.apply(transports, browserConfig.transports);
    }
    else if (browserConfig.url) {
        transports.push(new transports_1.FetchTransport({
            url: browserConfig.url,
            apiKey: browserConfig.apiKey,
        }));
    }
    else {
        throw new Error('either "url" or "transports" must be defined');
    }
    var config = {
        globalObjectKey: browserConfig.globalObjectKey || agent_core_1.defaultGlobalObjectKey,
        preventGlobalExposure: browserConfig.preventGlobalExposure || false,
        transports: transports,
        metas: (_a = browserConfig.metas) !== null && _a !== void 0 ? _a : exports.defaultMetas,
        instrumentations: (_b = browserConfig.instrumentations) !== null && _b !== void 0 ? _b : (0, exports.getWebInstrumentations)(),
        app: browserConfig.app,
        session: browserConfig.session,
        user: browserConfig.user,
        ignoreErrors: browserConfig.ignoreErrors,
        parseStacktrace: instrumentations_1.parseStacktrace,
        paused: (_c = browserConfig.paused) !== null && _c !== void 0 ? _c : false,
        beforeSend: browserConfig.beforeSend,
    };
    return config;
}
exports.makeCoreConfig = makeCoreConfig;
//# sourceMappingURL=config.js.map