var __extends =
  (this && this.__extends) ||
  (function () {
    var extendStatics = function (d, b) {
      extendStatics =
        Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array &&
          function (d, b) {
            d.__proto__ = b;
          }) ||
        function (d, b) {
          for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p];
        };
      return extendStatics(d, b);
    };
    return function (d, b) {
      if (typeof b !== 'function' && b !== null)
        throw new TypeError('Class extends value ' + String(b) + ' is not a constructor or null');
      extendStatics(d, b);
      function __() {
        this.constructor = d;
      }
      d.prototype = b === null ? Object.create(b) : ((__.prototype = b.prototype), new __());
    };
  })();
var __spreadArray =
  (this && this.__spreadArray) ||
  function (to, from, pack) {
    if (pack || arguments.length === 2)
      for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
          if (!ar) ar = Array.prototype.slice.call(from, 0, i);
          ar[i] = from[i];
        }
      }
    return to.concat(ar || Array.prototype.slice.call(from));
  };
import { allLogLevels, LogLevel, VERSION, BaseInstrumentation } from '@grafana/agent-core';
var ConsoleInstrumentation = /** @class */ (function (_super) {
  __extends(ConsoleInstrumentation, _super);
  function ConsoleInstrumentation(options) {
    if (options === void 0) {
      options = {};
    }
    var _this = _super.call(this) || this;
    _this.options = options;
    _this.version = VERSION;
    _this.name = '@grafana/agent-web:instrumentation-console';
    return _this;
  }
  ConsoleInstrumentation.prototype.initialize = function () {
    var _this = this;
    allLogLevels
      .filter(function (level) {
        var _a;
        return !(
          (_a = _this.options.disabledLevels) !== null && _a !== void 0
            ? _a
            : ConsoleInstrumentation.defaultDisabledLevels
        ).includes(level);
      })
      .forEach(function (level) {
        /* eslint-disable-next-line no-console */
        console[level] = function () {
          var _a;
          var args = [];
          for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
          }
          try {
            _this.agent.api.pushLog(args, { level: level });
          } catch (err) {
          } finally {
            (_a = _this.agent.api).callOriginalConsoleMethod.apply(_a, __spreadArray([level], args, false));
          }
        };
      });
  };
  ConsoleInstrumentation.defaultDisabledLevels = [LogLevel.DEBUG, LogLevel.TRACE, LogLevel.LOG];
  return ConsoleInstrumentation;
})(BaseInstrumentation);
export { ConsoleInstrumentation };
//# sourceMappingURL=index.js.map
