﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/inspector2/model/CodeVulnerabilityDetails.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace Inspector2
{
namespace Model
{

CodeVulnerabilityDetails::CodeVulnerabilityDetails() : 
    m_cwesHasBeenSet(false),
    m_detectorIdHasBeenSet(false),
    m_detectorNameHasBeenSet(false),
    m_detectorTagsHasBeenSet(false),
    m_filePathHasBeenSet(false),
    m_referenceUrlsHasBeenSet(false),
    m_ruleIdHasBeenSet(false),
    m_sourceLambdaLayerArnHasBeenSet(false)
{
}

CodeVulnerabilityDetails::CodeVulnerabilityDetails(JsonView jsonValue) : 
    m_cwesHasBeenSet(false),
    m_detectorIdHasBeenSet(false),
    m_detectorNameHasBeenSet(false),
    m_detectorTagsHasBeenSet(false),
    m_filePathHasBeenSet(false),
    m_referenceUrlsHasBeenSet(false),
    m_ruleIdHasBeenSet(false),
    m_sourceLambdaLayerArnHasBeenSet(false)
{
  *this = jsonValue;
}

CodeVulnerabilityDetails& CodeVulnerabilityDetails::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("cwes"))
  {
    Aws::Utils::Array<JsonView> cwesJsonList = jsonValue.GetArray("cwes");
    for(unsigned cwesIndex = 0; cwesIndex < cwesJsonList.GetLength(); ++cwesIndex)
    {
      m_cwes.push_back(cwesJsonList[cwesIndex].AsString());
    }
    m_cwesHasBeenSet = true;
  }

  if(jsonValue.ValueExists("detectorId"))
  {
    m_detectorId = jsonValue.GetString("detectorId");

    m_detectorIdHasBeenSet = true;
  }

  if(jsonValue.ValueExists("detectorName"))
  {
    m_detectorName = jsonValue.GetString("detectorName");

    m_detectorNameHasBeenSet = true;
  }

  if(jsonValue.ValueExists("detectorTags"))
  {
    Aws::Utils::Array<JsonView> detectorTagsJsonList = jsonValue.GetArray("detectorTags");
    for(unsigned detectorTagsIndex = 0; detectorTagsIndex < detectorTagsJsonList.GetLength(); ++detectorTagsIndex)
    {
      m_detectorTags.push_back(detectorTagsJsonList[detectorTagsIndex].AsString());
    }
    m_detectorTagsHasBeenSet = true;
  }

  if(jsonValue.ValueExists("filePath"))
  {
    m_filePath = jsonValue.GetObject("filePath");

    m_filePathHasBeenSet = true;
  }

  if(jsonValue.ValueExists("referenceUrls"))
  {
    Aws::Utils::Array<JsonView> referenceUrlsJsonList = jsonValue.GetArray("referenceUrls");
    for(unsigned referenceUrlsIndex = 0; referenceUrlsIndex < referenceUrlsJsonList.GetLength(); ++referenceUrlsIndex)
    {
      m_referenceUrls.push_back(referenceUrlsJsonList[referenceUrlsIndex].AsString());
    }
    m_referenceUrlsHasBeenSet = true;
  }

  if(jsonValue.ValueExists("ruleId"))
  {
    m_ruleId = jsonValue.GetString("ruleId");

    m_ruleIdHasBeenSet = true;
  }

  if(jsonValue.ValueExists("sourceLambdaLayerArn"))
  {
    m_sourceLambdaLayerArn = jsonValue.GetString("sourceLambdaLayerArn");

    m_sourceLambdaLayerArnHasBeenSet = true;
  }

  return *this;
}

JsonValue CodeVulnerabilityDetails::Jsonize() const
{
  JsonValue payload;

  if(m_cwesHasBeenSet)
  {
   Aws::Utils::Array<JsonValue> cwesJsonList(m_cwes.size());
   for(unsigned cwesIndex = 0; cwesIndex < cwesJsonList.GetLength(); ++cwesIndex)
   {
     cwesJsonList[cwesIndex].AsString(m_cwes[cwesIndex]);
   }
   payload.WithArray("cwes", std::move(cwesJsonList));

  }

  if(m_detectorIdHasBeenSet)
  {
   payload.WithString("detectorId", m_detectorId);

  }

  if(m_detectorNameHasBeenSet)
  {
   payload.WithString("detectorName", m_detectorName);

  }

  if(m_detectorTagsHasBeenSet)
  {
   Aws::Utils::Array<JsonValue> detectorTagsJsonList(m_detectorTags.size());
   for(unsigned detectorTagsIndex = 0; detectorTagsIndex < detectorTagsJsonList.GetLength(); ++detectorTagsIndex)
   {
     detectorTagsJsonList[detectorTagsIndex].AsString(m_detectorTags[detectorTagsIndex]);
   }
   payload.WithArray("detectorTags", std::move(detectorTagsJsonList));

  }

  if(m_filePathHasBeenSet)
  {
   payload.WithObject("filePath", m_filePath.Jsonize());

  }

  if(m_referenceUrlsHasBeenSet)
  {
   Aws::Utils::Array<JsonValue> referenceUrlsJsonList(m_referenceUrls.size());
   for(unsigned referenceUrlsIndex = 0; referenceUrlsIndex < referenceUrlsJsonList.GetLength(); ++referenceUrlsIndex)
   {
     referenceUrlsJsonList[referenceUrlsIndex].AsString(m_referenceUrls[referenceUrlsIndex]);
   }
   payload.WithArray("referenceUrls", std::move(referenceUrlsJsonList));

  }

  if(m_ruleIdHasBeenSet)
  {
   payload.WithString("ruleId", m_ruleId);

  }

  if(m_sourceLambdaLayerArnHasBeenSet)
  {
   payload.WithString("sourceLambdaLayerArn", m_sourceLambdaLayerArn);

  }

  return payload;
}

} // namespace Model
} // namespace Inspector2
} // namespace Aws
