﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/codestar/CodeStar_EXPORTS.h>
#include <aws/core/client/GenericClientConfiguration.h>
#include <aws/core/endpoint/DefaultEndpointProvider.h>
#include <aws/core/endpoint/EndpointParameter.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <aws/codestar/CodeStarEndpointRules.h>


namespace Aws
{
namespace CodeStar
{
namespace Endpoint
{
using EndpointParameters = Aws::Endpoint::EndpointParameters;
using Aws::Endpoint::EndpointProviderBase;
using Aws::Endpoint::DefaultEndpointProvider;

using CodeStarClientContextParameters = Aws::Endpoint::ClientContextParameters;

using CodeStarClientConfiguration = Aws::Client::GenericClientConfiguration<false>;
using CodeStarBuiltInParameters = Aws::Endpoint::BuiltInParameters;

/**
 * The type for the CodeStar Client Endpoint Provider.
 * Inherit from this Base class / "Interface" should you want to provide a custom endpoint provider.
 * The SDK must use service-specific type for each service per specification.
 */
using CodeStarEndpointProviderBase =
    EndpointProviderBase<CodeStarClientConfiguration, CodeStarBuiltInParameters, CodeStarClientContextParameters>;

using CodeStarDefaultEpProviderBase =
    DefaultEndpointProvider<CodeStarClientConfiguration, CodeStarBuiltInParameters, CodeStarClientContextParameters>;

/**
 * Default endpoint provider used for this service
 */
class AWS_CODESTAR_API CodeStarEndpointProvider : public CodeStarDefaultEpProviderBase
{
public:
    using CodeStarResolveEndpointOutcome = Aws::Endpoint::ResolveEndpointOutcome;

    CodeStarEndpointProvider()
      : CodeStarDefaultEpProviderBase(Aws::CodeStar::CodeStarEndpointRules::GetRulesBlob(), Aws::CodeStar::CodeStarEndpointRules::RulesBlobSize)
    {}

    ~CodeStarEndpointProvider()
    {
    }
};
} // namespace Endpoint
} // namespace CodeStar
} // namespace Aws
