; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse4.1 | FileCheck %s --check-prefixes=CHECK,SSE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefixes=CHECK,AVX

declare {i32, i1} @llvm.ssub.with.overflow.i32(i32, i32) nounwind readnone
declare {i32, i1} @llvm.usub.with.overflow.i32(i32, i32) nounwind readnone
declare { i8, i1 } @llvm.ssub.with.overflow.i8(i8, i8) nounwind readnone
declare { i8, i1 } @llvm.usub.with.overflow.i8(i8, i8) nounwind readnone


declare {<4 x i32>, <4 x i1>} @llvm.ssub.with.overflow.v4i32(<4 x i32>, <4 x i32>) nounwind readnone
declare {<4 x i32>, <4 x i1>} @llvm.usub.with.overflow.v4i32(<4 x i32>, <4 x i32>) nounwind readnone
declare { <4 x i8>, <4 x i1> } @llvm.ssub.with.overflow.v4i8(<4 x i8>, <4 x i8>) nounwind readnone
declare { <4 x i8>, <4 x i1> } @llvm.usub.with.overflow.v4i8(<4 x i8> , <4 x i8>) nounwind readnone

; fold (ssub x, 0) -> x
define i32 @combine_ssub_zero(i32 %a0, i32 %a1) {
; CHECK-LABEL: combine_ssub_zero:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movl %edi, %eax
; CHECK-NEXT:    retq
  %1 = call {i32, i1} @llvm.ssub.with.overflow.i32(i32 %a0, i32 zeroinitializer)
  %2 = extractvalue {i32, i1} %1, 0
  %3 = extractvalue {i32, i1} %1, 1
  %4 = select i1 %3, i32 %a1, i32 %2
  ret i32 %4
}

define <4 x i32> @combine_vec_ssub_zero(<4 x i32> %a0, <4 x i32> %a1) {
; CHECK-LABEL: combine_vec_ssub_zero:
; CHECK:       # %bb.0:
; CHECK-NEXT:    retq
  %1 = call {<4 x i32>, <4 x i1>} @llvm.ssub.with.overflow.v4i32(<4 x i32> %a0, <4 x i32> zeroinitializer)
  %2 = extractvalue {<4 x i32>, <4 x i1>} %1, 0
  %3 = extractvalue {<4 x i32>, <4 x i1>} %1, 1
  %4 = select <4 x i1> %3, <4 x i32> %a1, <4 x i32> %2
  ret <4 x i32> %4
}

; fold (usub x, 0) -> x
define i32 @combine_usub_zero(i32 %a0, i32 %a1) {
; CHECK-LABEL: combine_usub_zero:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movl %edi, %eax
; CHECK-NEXT:    retq
  %1 = call {i32, i1} @llvm.usub.with.overflow.i32(i32 %a0, i32 zeroinitializer)
  %2 = extractvalue {i32, i1} %1, 0
  %3 = extractvalue {i32, i1} %1, 1
  %4 = select i1 %3, i32 %a1, i32 %2
  ret i32 %4
}

define <4 x i32> @combine_vec_usub_zero(<4 x i32> %a0, <4 x i32> %a1) {
; CHECK-LABEL: combine_vec_usub_zero:
; CHECK:       # %bb.0:
; CHECK-NEXT:    retq
  %1 = call {<4 x i32>, <4 x i1>} @llvm.usub.with.overflow.v4i32(<4 x i32> %a0, <4 x i32> zeroinitializer)
  %2 = extractvalue {<4 x i32>, <4 x i1>} %1, 0
  %3 = extractvalue {<4 x i32>, <4 x i1>} %1, 1
  %4 = select <4 x i1> %3, <4 x i32> %a1, <4 x i32> %2
  ret <4 x i32> %4
}

; fold (ssub x, x) -> 0
define i32 @combine_ssub_self(i32 %a0, i32 %a1) {
; CHECK-LABEL: combine_ssub_self:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    retq
  %1 = call {i32, i1} @llvm.ssub.with.overflow.i32(i32 %a0, i32 %a0)
  %2 = extractvalue {i32, i1} %1, 0
  %3 = extractvalue {i32, i1} %1, 1
  %4 = select i1 %3, i32 %a1, i32 %2
  ret i32 %4
}

define <4 x i32> @combine_vec_ssub_self(<4 x i32> %a0, <4 x i32> %a1) {
; SSE-LABEL: combine_vec_ssub_self:
; SSE:       # %bb.0:
; SSE-NEXT:    xorps %xmm0, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_vec_ssub_self:
; AVX:       # %bb.0:
; AVX-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = call {<4 x i32>, <4 x i1>} @llvm.ssub.with.overflow.v4i32(<4 x i32> %a0, <4 x i32> %a0)
  %2 = extractvalue {<4 x i32>, <4 x i1>} %1, 0
  %3 = extractvalue {<4 x i32>, <4 x i1>} %1, 1
  %4 = select <4 x i1> %3, <4 x i32> %a1, <4 x i32> %2
  ret <4 x i32> %4
}

; fold (usub x, x) -> x
define i32 @combine_usub_self(i32 %a0, i32 %a1) {
; CHECK-LABEL: combine_usub_self:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    retq
  %1 = call {i32, i1} @llvm.usub.with.overflow.i32(i32 %a0, i32 %a0)
  %2 = extractvalue {i32, i1} %1, 0
  %3 = extractvalue {i32, i1} %1, 1
  %4 = select i1 %3, i32 %a1, i32 %2
  ret i32 %4
}

define <4 x i32> @combine_vec_usub_self(<4 x i32> %a0, <4 x i32> %a1) {
; SSE-LABEL: combine_vec_usub_self:
; SSE:       # %bb.0:
; SSE-NEXT:    xorps %xmm0, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_vec_usub_self:
; AVX:       # %bb.0:
; AVX-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = call {<4 x i32>, <4 x i1>} @llvm.usub.with.overflow.v4i32(<4 x i32> %a0, <4 x i32> %a0)
  %2 = extractvalue {<4 x i32>, <4 x i1>} %1, 0
  %3 = extractvalue {<4 x i32>, <4 x i1>} %1, 1
  %4 = select <4 x i1> %3, <4 x i32> %a1, <4 x i32> %2
  ret <4 x i32> %4
}

; fold (usub -1, x) -> (xor x, -1) + no borrow
define i32 @combine_usub_negone(i32 %a0, i32 %a1) {
; CHECK-LABEL: combine_usub_negone:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movl %edi, %eax
; CHECK-NEXT:    notl %eax
; CHECK-NEXT:    retq
  %1 = call {i32, i1} @llvm.usub.with.overflow.i32(i32 -1, i32 %a0)
  %2 = extractvalue {i32, i1} %1, 0
  %3 = extractvalue {i32, i1} %1, 1
  %4 = select i1 %3, i32 %a1, i32 %2
  ret i32 %4
}

define <4 x i32> @combine_vec_usub_negone(<4 x i32> %a0, <4 x i32> %a1) {
; SSE-LABEL: combine_vec_usub_negone:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE-NEXT:    pxor %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_vec_usub_negone:
; AVX:       # %bb.0:
; AVX-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = call {<4 x i32>, <4 x i1>} @llvm.usub.with.overflow.v4i32(<4 x i32> <i32 -1, i32 -1, i32 -1, i32 -1>, <4 x i32> %a0)
  %2 = extractvalue {<4 x i32>, <4 x i1>} %1, 0
  %3 = extractvalue {<4 x i32>, <4 x i1>} %1, 1
  %4 = select <4 x i1> %3, <4 x i32> %a1, <4 x i32> %2
  ret <4 x i32> %4
}

define { i32, i1 } @combine_usub_nuw(i32 %a, i32 %b) {
; CHECK-LABEL: combine_usub_nuw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movl %edi, %eax
; CHECK-NEXT:    orl $-2147483648, %eax # imm = 0x80000000
; CHECK-NEXT:    andl $2147483647, %esi # imm = 0x7FFFFFFF
; CHECK-NEXT:    subl %esi, %eax
; CHECK-NEXT:    xorl %edx, %edx
; CHECK-NEXT:    retq
  %aa = or i32 %a, 2147483648
  %bb = and i32 %b, 2147483647
  %x = call { i32, i1 } @llvm.usub.with.overflow.i32(i32 %aa, i32 %bb)
  ret { i32, i1 } %x
}

define { i8, i1 } @usub_always_overflow(i8 %x) nounwind {
; CHECK-LABEL: usub_always_overflow:
; CHECK:       # %bb.0:
; CHECK-NEXT:    orb $64, %dil
; CHECK-NEXT:    movb $63, %al
; CHECK-NEXT:    subb %dil, %al
; CHECK-NEXT:    setb %dl
; CHECK-NEXT:    retq
  %y = or i8 %x, 64
  %a = call { i8, i1 } @llvm.usub.with.overflow.i8(i8 63, i8 %y)
  ret { i8, i1 } %a
}

define { i8, i1 } @ssub_always_overflow(i8 %x) nounwind {
; CHECK-LABEL: ssub_always_overflow:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpb $30, %dil
; CHECK-NEXT:    movl $29, %ecx
; CHECK-NEXT:    cmovgel %edi, %ecx
; CHECK-NEXT:    movb $-100, %al
; CHECK-NEXT:    subb %cl, %al
; CHECK-NEXT:    seto %dl
; CHECK-NEXT:    retq
  %c = icmp sgt i8 %x, 29
  %y = select i1 %c, i8 %x, i8 29
  %a = call { i8, i1 } @llvm.ssub.with.overflow.i8(i8 -100, i8 %y)
  ret { i8, i1 } %a
}

define { <4 x i8>, <4 x i1> } @always_usub_const_vector() nounwind {
; SSE-LABEL: always_usub_const_vector:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm0, %xmm0
; SSE-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: always_usub_const_vector:
; AVX:       # %bb.0:
; AVX-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; AVX-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX-NEXT:    retq
  %x = call { <4 x i8>, <4 x i1> } @llvm.usub.with.overflow.v4i8(<4 x i8> <i8 0, i8 0, i8 0, i8 0>, <4 x i8> <i8 1, i8 1, i8 1, i8 1>)
  ret { <4 x i8>, <4 x i1> } %x
}

define { <4 x i8>, <4 x i1> } @never_usub_const_vector() nounwind {
; SSE-LABEL: never_usub_const_vector:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps {{.*#+}} xmm0 = [127,255,0,254,u,u,u,u,u,u,u,u,u,u,u,u]
; SSE-NEXT:    xorps %xmm1, %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: never_usub_const_vector:
; AVX:       # %bb.0:
; AVX-NEXT:    vbroadcastss {{.*#+}} xmm0 = [127,255,0,254,127,255,0,254,127,255,0,254,127,255,0,254]
; AVX-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX-NEXT:    retq
  %x = call { <4 x i8>, <4 x i1> } @llvm.usub.with.overflow.v4i8(<4 x i8> <i8 255, i8 255, i8 255, i8 255>, <4 x i8> <i8 128, i8 0, i8 255, i8 1>)
  ret { <4 x i8>, <4 x i1> } %x
}
