; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+d,+zfh,+zvfh,+v,+m -target-abi=ilp32d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV32
; RUN: llc -mtriple=riscv64 -mattr=+d,+zfh,+zvfh,+v,+m -target-abi=lp64d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV64
; RUN: llc -mtriple=riscv32 -mattr=+v,+zvbb,+m -target-abi=ilp32d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK-ZVBB
; RUN: llc -mtriple=riscv64 -mattr=+v,+zvbb,+m -target-abi=lp64d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK-ZVBB

declare <vscale x 1 x i8> @llvm.vp.ctlz.nxv1i8(<vscale x 1 x i8>, i1 immarg, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @vp_ctlz_nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    vzext.vf2 v9, v8, v0.t
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v9, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vsrl.vi v8, v8, 23, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0, v0.t
; CHECK-NEXT:    li a0, 134
; CHECK-NEXT:    vrsub.vx v8, v8, a0, v0.t
; CHECK-NEXT:    li a0, 8
; CHECK-NEXT:    vminu.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv1i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 1 x i8> @llvm.vp.ctlz.nxv1i8(<vscale x 1 x i8> %va, i1 false, <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i8> %v
}

define <vscale x 1 x i8> @vp_ctlz_nxv1i8_unmasked(<vscale x 1 x i8> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv1i8_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    vzext.vf2 v9, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-NEXT:    vnsrl.wi v8, v8, 23
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    li a0, 134
; CHECK-NEXT:    vrsub.vx v8, v8, a0
; CHECK-NEXT:    li a0, 8
; CHECK-NEXT:    vminu.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv1i8_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 1 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 1 x i1> %head, <vscale x 1 x i1> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i8> @llvm.vp.ctlz.nxv1i8(<vscale x 1 x i8> %va, i1 false, <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i8> %v
}

declare <vscale x 2 x i8> @llvm.vp.ctlz.nxv2i8(<vscale x 2 x i8>, i1 immarg, <vscale x 2 x i1>, i32)

define <vscale x 2 x i8> @vp_ctlz_nxv2i8(<vscale x 2 x i8> %va, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    vzext.vf2 v9, v8, v0.t
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v9, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vsrl.vi v8, v8, 23, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0, v0.t
; CHECK-NEXT:    li a0, 134
; CHECK-NEXT:    vrsub.vx v8, v8, a0, v0.t
; CHECK-NEXT:    li a0, 8
; CHECK-NEXT:    vminu.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv2i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 2 x i8> @llvm.vp.ctlz.nxv2i8(<vscale x 2 x i8> %va, i1 false, <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x i8> %v
}

define <vscale x 2 x i8> @vp_ctlz_nxv2i8_unmasked(<vscale x 2 x i8> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv2i8_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    vzext.vf2 v9, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-NEXT:    vnsrl.wi v8, v8, 23
; CHECK-NEXT:    vsetvli zero, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    li a0, 134
; CHECK-NEXT:    vrsub.vx v8, v8, a0
; CHECK-NEXT:    li a0, 8
; CHECK-NEXT:    vminu.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv2i8_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 2 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 2 x i1> %head, <vscale x 2 x i1> poison, <vscale x 2 x i32> zeroinitializer
  %v = call <vscale x 2 x i8> @llvm.vp.ctlz.nxv2i8(<vscale x 2 x i8> %va, i1 false, <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x i8> %v
}

declare <vscale x 4 x i8> @llvm.vp.ctlz.nxv4i8(<vscale x 4 x i8>, i1 immarg, <vscale x 4 x i1>, i32)

define <vscale x 4 x i8> @vp_ctlz_nxv4i8(<vscale x 4 x i8> %va, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vzext.vf2 v9, v8, v0.t
; CHECK-NEXT:    vfwcvt.f.xu.v v10, v9, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vsrl.vi v8, v10, 23, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vnsrl.wi v10, v8, 0, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v10, 0, v0.t
; CHECK-NEXT:    li a0, 134
; CHECK-NEXT:    vrsub.vx v8, v8, a0, v0.t
; CHECK-NEXT:    li a0, 8
; CHECK-NEXT:    vminu.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv4i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 4 x i8> @llvm.vp.ctlz.nxv4i8(<vscale x 4 x i8> %va, i1 false, <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x i8> %v
}

define <vscale x 4 x i8> @vp_ctlz_nxv4i8_unmasked(<vscale x 4 x i8> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv4i8_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vzext.vf2 v9, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v10, v9
; CHECK-NEXT:    vnsrl.wi v8, v10, 23
; CHECK-NEXT:    vsetvli zero, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    li a0, 134
; CHECK-NEXT:    vrsub.vx v8, v8, a0
; CHECK-NEXT:    li a0, 8
; CHECK-NEXT:    vminu.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv4i8_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 4 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 4 x i1> %head, <vscale x 4 x i1> poison, <vscale x 4 x i32> zeroinitializer
  %v = call <vscale x 4 x i8> @llvm.vp.ctlz.nxv4i8(<vscale x 4 x i8> %va, i1 false, <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x i8> %v
}

declare <vscale x 8 x i8> @llvm.vp.ctlz.nxv8i8(<vscale x 8 x i8>, i1 immarg, <vscale x 8 x i1>, i32)

define <vscale x 8 x i8> @vp_ctlz_nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8, v0.t
; CHECK-NEXT:    vfwcvt.f.xu.v v12, v10, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vsrl.vi v8, v12, 23, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vnsrl.wi v12, v8, 0, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e8, m1, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v12, 0, v0.t
; CHECK-NEXT:    li a0, 134
; CHECK-NEXT:    vrsub.vx v8, v8, a0, v0.t
; CHECK-NEXT:    li a0, 8
; CHECK-NEXT:    vminu.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv8i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 8 x i8> @llvm.vp.ctlz.nxv8i8(<vscale x 8 x i8> %va, i1 false, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i8> %v
}

define <vscale x 8 x i8> @vp_ctlz_nxv8i8_unmasked(<vscale x 8 x i8> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv8i8_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v12, v10
; CHECK-NEXT:    vnsrl.wi v8, v12, 23
; CHECK-NEXT:    vsetvli zero, zero, e8, m1, ta, ma
; CHECK-NEXT:    vnsrl.wi v10, v8, 0
; CHECK-NEXT:    li a0, 134
; CHECK-NEXT:    vrsub.vx v8, v10, a0
; CHECK-NEXT:    li a0, 8
; CHECK-NEXT:    vminu.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv8i8_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 8 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 8 x i1> %head, <vscale x 8 x i1> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i8> @llvm.vp.ctlz.nxv8i8(<vscale x 8 x i8> %va, i1 false, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i8> %v
}

declare <vscale x 16 x i8> @llvm.vp.ctlz.nxv16i8(<vscale x 16 x i8>, i1 immarg, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @vp_ctlz_nxv16i8(<vscale x 16 x i8> %va, <vscale x 16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    vzext.vf2 v12, v8, v0.t
; CHECK-NEXT:    vfwcvt.f.xu.v v16, v12, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; CHECK-NEXT:    vsrl.vi v8, v16, 23, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e16, m4, ta, ma
; CHECK-NEXT:    vnsrl.wi v16, v8, 0, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e8, m2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v16, 0, v0.t
; CHECK-NEXT:    li a0, 134
; CHECK-NEXT:    vrsub.vx v8, v8, a0, v0.t
; CHECK-NEXT:    li a0, 8
; CHECK-NEXT:    vminu.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv16i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 16 x i8> @llvm.vp.ctlz.nxv16i8(<vscale x 16 x i8> %va, i1 false, <vscale x 16 x i1> %m, i32 %evl)
  ret <vscale x 16 x i8> %v
}

define <vscale x 16 x i8> @vp_ctlz_nxv16i8_unmasked(<vscale x 16 x i8> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv16i8_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    vzext.vf2 v12, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v16, v12
; CHECK-NEXT:    vnsrl.wi v8, v16, 23
; CHECK-NEXT:    vsetvli zero, zero, e8, m2, ta, ma
; CHECK-NEXT:    vnsrl.wi v12, v8, 0
; CHECK-NEXT:    li a0, 134
; CHECK-NEXT:    vrsub.vx v8, v12, a0
; CHECK-NEXT:    li a0, 8
; CHECK-NEXT:    vminu.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv16i8_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 16 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 16 x i1> %head, <vscale x 16 x i1> poison, <vscale x 16 x i32> zeroinitializer
  %v = call <vscale x 16 x i8> @llvm.vp.ctlz.nxv16i8(<vscale x 16 x i8> %va, i1 false, <vscale x 16 x i1> %m, i32 %evl)
  ret <vscale x 16 x i8> %v
}

declare <vscale x 32 x i8> @llvm.vp.ctlz.nxv32i8(<vscale x 32 x i8>, i1 immarg, <vscale x 32 x i1>, i32)

define <vscale x 32 x i8> @vp_ctlz_nxv32i8(<vscale x 32 x i8> %va, <vscale x 32 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-NEXT:    vsrl.vi v12, v8, 1, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v12, v0.t
; CHECK-NEXT:    vsrl.vi v12, v8, 2, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v12, v0.t
; CHECK-NEXT:    vsrl.vi v12, v8, 4, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v12, v0.t
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vsrl.vi v12, v8, 1, v0.t
; CHECK-NEXT:    li a0, 85
; CHECK-NEXT:    vand.vx v12, v12, a0, v0.t
; CHECK-NEXT:    vsub.vv v8, v8, v12, v0.t
; CHECK-NEXT:    li a0, 51
; CHECK-NEXT:    vand.vx v12, v8, a0, v0.t
; CHECK-NEXT:    vsrl.vi v8, v8, 2, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    vadd.vv v8, v12, v8, v0.t
; CHECK-NEXT:    vsrl.vi v12, v8, 4, v0.t
; CHECK-NEXT:    vadd.vv v8, v8, v12, v0.t
; CHECK-NEXT:    vand.vi v8, v8, 15, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv32i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 32 x i8> @llvm.vp.ctlz.nxv32i8(<vscale x 32 x i8> %va, i1 false, <vscale x 32 x i1> %m, i32 %evl)
  ret <vscale x 32 x i8> %v
}

define <vscale x 32 x i8> @vp_ctlz_nxv32i8_unmasked(<vscale x 32 x i8> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv32i8_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-NEXT:    vsrl.vi v12, v8, 1
; CHECK-NEXT:    vor.vv v8, v8, v12
; CHECK-NEXT:    vsrl.vi v12, v8, 2
; CHECK-NEXT:    vor.vv v8, v8, v12
; CHECK-NEXT:    vsrl.vi v12, v8, 4
; CHECK-NEXT:    vor.vv v8, v8, v12
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vsrl.vi v12, v8, 1
; CHECK-NEXT:    li a0, 85
; CHECK-NEXT:    vand.vx v12, v12, a0
; CHECK-NEXT:    vsub.vv v8, v8, v12
; CHECK-NEXT:    li a0, 51
; CHECK-NEXT:    vand.vx v12, v8, a0
; CHECK-NEXT:    vsrl.vi v8, v8, 2
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vadd.vv v8, v12, v8
; CHECK-NEXT:    vsrl.vi v12, v8, 4
; CHECK-NEXT:    vadd.vv v8, v8, v12
; CHECK-NEXT:    vand.vi v8, v8, 15
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv32i8_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 32 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 32 x i1> %head, <vscale x 32 x i1> poison, <vscale x 32 x i32> zeroinitializer
  %v = call <vscale x 32 x i8> @llvm.vp.ctlz.nxv32i8(<vscale x 32 x i8> %va, i1 false, <vscale x 32 x i1> %m, i32 %evl)
  ret <vscale x 32 x i8> %v
}

declare <vscale x 64 x i8> @llvm.vp.ctlz.nxv64i8(<vscale x 64 x i8>, i1 immarg, <vscale x 64 x i1>, i32)

define <vscale x 64 x i8> @vp_ctlz_nxv64i8(<vscale x 64 x i8> %va, <vscale x 64 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv64i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m8, ta, ma
; CHECK-NEXT:    vsrl.vi v16, v8, 1, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v16, v0.t
; CHECK-NEXT:    vsrl.vi v16, v8, 2, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v16, v0.t
; CHECK-NEXT:    vsrl.vi v16, v8, 4, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v16, v0.t
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vsrl.vi v16, v8, 1, v0.t
; CHECK-NEXT:    li a0, 85
; CHECK-NEXT:    vand.vx v16, v16, a0, v0.t
; CHECK-NEXT:    vsub.vv v8, v8, v16, v0.t
; CHECK-NEXT:    li a0, 51
; CHECK-NEXT:    vand.vx v16, v8, a0, v0.t
; CHECK-NEXT:    vsrl.vi v8, v8, 2, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    vadd.vv v8, v16, v8, v0.t
; CHECK-NEXT:    vsrl.vi v16, v8, 4, v0.t
; CHECK-NEXT:    vadd.vv v8, v8, v16, v0.t
; CHECK-NEXT:    vand.vi v8, v8, 15, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv64i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e8, m8, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 64 x i8> @llvm.vp.ctlz.nxv64i8(<vscale x 64 x i8> %va, i1 false, <vscale x 64 x i1> %m, i32 %evl)
  ret <vscale x 64 x i8> %v
}

define <vscale x 64 x i8> @vp_ctlz_nxv64i8_unmasked(<vscale x 64 x i8> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv64i8_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m8, ta, ma
; CHECK-NEXT:    vsrl.vi v16, v8, 1
; CHECK-NEXT:    vor.vv v8, v8, v16
; CHECK-NEXT:    vsrl.vi v16, v8, 2
; CHECK-NEXT:    vor.vv v8, v8, v16
; CHECK-NEXT:    vsrl.vi v16, v8, 4
; CHECK-NEXT:    vor.vv v8, v8, v16
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vsrl.vi v16, v8, 1
; CHECK-NEXT:    li a0, 85
; CHECK-NEXT:    vand.vx v16, v16, a0
; CHECK-NEXT:    vsub.vv v8, v8, v16
; CHECK-NEXT:    li a0, 51
; CHECK-NEXT:    vand.vx v16, v8, a0
; CHECK-NEXT:    vsrl.vi v8, v8, 2
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vadd.vv v8, v16, v8
; CHECK-NEXT:    vsrl.vi v16, v8, 4
; CHECK-NEXT:    vadd.vv v8, v8, v16
; CHECK-NEXT:    vand.vi v8, v8, 15
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv64i8_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e8, m8, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 64 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 64 x i1> %head, <vscale x 64 x i1> poison, <vscale x 64 x i32> zeroinitializer
  %v = call <vscale x 64 x i8> @llvm.vp.ctlz.nxv64i8(<vscale x 64 x i8> %va, i1 false, <vscale x 64 x i1> %m, i32 %evl)
  ret <vscale x 64 x i8> %v
}

declare <vscale x 1 x i16> @llvm.vp.ctlz.nxv1i16(<vscale x 1 x i16>, i1 immarg, <vscale x 1 x i1>, i32)

define <vscale x 1 x i16> @vp_ctlz_nxv1i16(<vscale x 1 x i16> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v9, v8, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vsrl.vi v8, v9, 23, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0, v0.t
; CHECK-NEXT:    li a0, 142
; CHECK-NEXT:    vrsub.vx v8, v8, a0, v0.t
; CHECK-NEXT:    li a0, 16
; CHECK-NEXT:    vminu.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv1i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 1 x i16> @llvm.vp.ctlz.nxv1i16(<vscale x 1 x i16> %va, i1 false, <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i16> %v
}

define <vscale x 1 x i16> @vp_ctlz_nxv1i16_unmasked(<vscale x 1 x i16> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv1i16_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-NEXT:    vnsrl.wi v8, v9, 23
; CHECK-NEXT:    li a0, 142
; CHECK-NEXT:    vrsub.vx v8, v8, a0
; CHECK-NEXT:    li a0, 16
; CHECK-NEXT:    vminu.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv1i16_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 1 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 1 x i1> %head, <vscale x 1 x i1> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i16> @llvm.vp.ctlz.nxv1i16(<vscale x 1 x i16> %va, i1 false, <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i16> %v
}

declare <vscale x 2 x i16> @llvm.vp.ctlz.nxv2i16(<vscale x 2 x i16>, i1 immarg, <vscale x 2 x i1>, i32)

define <vscale x 2 x i16> @vp_ctlz_nxv2i16(<vscale x 2 x i16> %va, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v9, v8, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vsrl.vi v8, v9, 23, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0, v0.t
; CHECK-NEXT:    li a0, 142
; CHECK-NEXT:    vrsub.vx v8, v8, a0, v0.t
; CHECK-NEXT:    li a0, 16
; CHECK-NEXT:    vminu.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv2i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 2 x i16> @llvm.vp.ctlz.nxv2i16(<vscale x 2 x i16> %va, i1 false, <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x i16> %v
}

define <vscale x 2 x i16> @vp_ctlz_nxv2i16_unmasked(<vscale x 2 x i16> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv2i16_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-NEXT:    vnsrl.wi v8, v9, 23
; CHECK-NEXT:    li a0, 142
; CHECK-NEXT:    vrsub.vx v8, v8, a0
; CHECK-NEXT:    li a0, 16
; CHECK-NEXT:    vminu.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv2i16_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 2 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 2 x i1> %head, <vscale x 2 x i1> poison, <vscale x 2 x i32> zeroinitializer
  %v = call <vscale x 2 x i16> @llvm.vp.ctlz.nxv2i16(<vscale x 2 x i16> %va, i1 false, <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x i16> %v
}

declare <vscale x 4 x i16> @llvm.vp.ctlz.nxv4i16(<vscale x 4 x i16>, i1 immarg, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @vp_ctlz_nxv4i16(<vscale x 4 x i16> %va, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v10, v8, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vsrl.vi v8, v10, 23, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vnsrl.wi v10, v8, 0, v0.t
; CHECK-NEXT:    li a0, 142
; CHECK-NEXT:    vrsub.vx v8, v10, a0, v0.t
; CHECK-NEXT:    li a0, 16
; CHECK-NEXT:    vminu.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv4i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 4 x i16> @llvm.vp.ctlz.nxv4i16(<vscale x 4 x i16> %va, i1 false, <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x i16> %v
}

define <vscale x 4 x i16> @vp_ctlz_nxv4i16_unmasked(<vscale x 4 x i16> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv4i16_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v10, v8
; CHECK-NEXT:    vnsrl.wi v8, v10, 23
; CHECK-NEXT:    li a0, 142
; CHECK-NEXT:    vrsub.vx v8, v8, a0
; CHECK-NEXT:    li a0, 16
; CHECK-NEXT:    vminu.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv4i16_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 4 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 4 x i1> %head, <vscale x 4 x i1> poison, <vscale x 4 x i32> zeroinitializer
  %v = call <vscale x 4 x i16> @llvm.vp.ctlz.nxv4i16(<vscale x 4 x i16> %va, i1 false, <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x i16> %v
}

declare <vscale x 8 x i16> @llvm.vp.ctlz.nxv8i16(<vscale x 8 x i16>, i1 immarg, <vscale x 8 x i1>, i32)

define <vscale x 8 x i16> @vp_ctlz_nxv8i16(<vscale x 8 x i16> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v12, v8, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vsrl.vi v8, v12, 23, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vnsrl.wi v12, v8, 0, v0.t
; CHECK-NEXT:    li a0, 142
; CHECK-NEXT:    vrsub.vx v8, v12, a0, v0.t
; CHECK-NEXT:    li a0, 16
; CHECK-NEXT:    vminu.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv8i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 8 x i16> @llvm.vp.ctlz.nxv8i16(<vscale x 8 x i16> %va, i1 false, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i16> %v
}

define <vscale x 8 x i16> @vp_ctlz_nxv8i16_unmasked(<vscale x 8 x i16> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv8i16_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v12, v8
; CHECK-NEXT:    vnsrl.wi v8, v12, 23
; CHECK-NEXT:    li a0, 142
; CHECK-NEXT:    vrsub.vx v8, v8, a0
; CHECK-NEXT:    li a0, 16
; CHECK-NEXT:    vminu.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv8i16_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 8 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 8 x i1> %head, <vscale x 8 x i1> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i16> @llvm.vp.ctlz.nxv8i16(<vscale x 8 x i16> %va, i1 false, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i16> %v
}

declare <vscale x 16 x i16> @llvm.vp.ctlz.nxv16i16(<vscale x 16 x i16>, i1 immarg, <vscale x 16 x i1>, i32)

define <vscale x 16 x i16> @vp_ctlz_nxv16i16(<vscale x 16 x i16> %va, <vscale x 16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v16, v8, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; CHECK-NEXT:    vsrl.vi v8, v16, 23, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e16, m4, ta, ma
; CHECK-NEXT:    vnsrl.wi v16, v8, 0, v0.t
; CHECK-NEXT:    li a0, 142
; CHECK-NEXT:    vrsub.vx v8, v16, a0, v0.t
; CHECK-NEXT:    li a0, 16
; CHECK-NEXT:    vminu.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv16i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 16 x i16> @llvm.vp.ctlz.nxv16i16(<vscale x 16 x i16> %va, i1 false, <vscale x 16 x i1> %m, i32 %evl)
  ret <vscale x 16 x i16> %v
}

define <vscale x 16 x i16> @vp_ctlz_nxv16i16_unmasked(<vscale x 16 x i16> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv16i16_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v16, v8
; CHECK-NEXT:    vnsrl.wi v8, v16, 23
; CHECK-NEXT:    li a0, 142
; CHECK-NEXT:    vrsub.vx v8, v8, a0
; CHECK-NEXT:    li a0, 16
; CHECK-NEXT:    vminu.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv16i16_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 16 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 16 x i1> %head, <vscale x 16 x i1> poison, <vscale x 16 x i32> zeroinitializer
  %v = call <vscale x 16 x i16> @llvm.vp.ctlz.nxv16i16(<vscale x 16 x i16> %va, i1 false, <vscale x 16 x i1> %m, i32 %evl)
  ret <vscale x 16 x i16> %v
}

declare <vscale x 32 x i16> @llvm.vp.ctlz.nxv32i16(<vscale x 32 x i16>, i1 immarg, <vscale x 32 x i1>, i32)

define <vscale x 32 x i16> @vp_ctlz_nxv32i16(<vscale x 32 x i16> %va, <vscale x 32 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv32i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m8, ta, ma
; CHECK-NEXT:    vsrl.vi v16, v8, 1, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v16, v0.t
; CHECK-NEXT:    vsrl.vi v16, v8, 2, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v16, v0.t
; CHECK-NEXT:    vsrl.vi v16, v8, 4, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v16, v0.t
; CHECK-NEXT:    vsrl.vi v16, v8, 8, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v16, v0.t
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vsrl.vi v16, v8, 1, v0.t
; CHECK-NEXT:    lui a0, 5
; CHECK-NEXT:    addi a0, a0, 1365
; CHECK-NEXT:    vand.vx v16, v16, a0, v0.t
; CHECK-NEXT:    vsub.vv v8, v8, v16, v0.t
; CHECK-NEXT:    lui a0, 3
; CHECK-NEXT:    addi a0, a0, 819
; CHECK-NEXT:    vand.vx v16, v8, a0, v0.t
; CHECK-NEXT:    vsrl.vi v8, v8, 2, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    vadd.vv v8, v16, v8, v0.t
; CHECK-NEXT:    vsrl.vi v16, v8, 4, v0.t
; CHECK-NEXT:    vadd.vv v8, v8, v16, v0.t
; CHECK-NEXT:    lui a0, 1
; CHECK-NEXT:    addi a0, a0, -241
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    li a0, 257
; CHECK-NEXT:    vmul.vx v8, v8, a0, v0.t
; CHECK-NEXT:    vsrl.vi v8, v8, 8, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv32i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e16, m8, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 32 x i16> @llvm.vp.ctlz.nxv32i16(<vscale x 32 x i16> %va, i1 false, <vscale x 32 x i1> %m, i32 %evl)
  ret <vscale x 32 x i16> %v
}

define <vscale x 32 x i16> @vp_ctlz_nxv32i16_unmasked(<vscale x 32 x i16> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv32i16_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m8, ta, ma
; CHECK-NEXT:    vsrl.vi v16, v8, 1
; CHECK-NEXT:    vor.vv v8, v8, v16
; CHECK-NEXT:    vsrl.vi v16, v8, 2
; CHECK-NEXT:    vor.vv v8, v8, v16
; CHECK-NEXT:    vsrl.vi v16, v8, 4
; CHECK-NEXT:    vor.vv v8, v8, v16
; CHECK-NEXT:    vsrl.vi v16, v8, 8
; CHECK-NEXT:    vor.vv v8, v8, v16
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vsrl.vi v16, v8, 1
; CHECK-NEXT:    lui a0, 5
; CHECK-NEXT:    addi a0, a0, 1365
; CHECK-NEXT:    vand.vx v16, v16, a0
; CHECK-NEXT:    vsub.vv v8, v8, v16
; CHECK-NEXT:    lui a0, 3
; CHECK-NEXT:    addi a0, a0, 819
; CHECK-NEXT:    vand.vx v16, v8, a0
; CHECK-NEXT:    vsrl.vi v8, v8, 2
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vadd.vv v8, v16, v8
; CHECK-NEXT:    vsrl.vi v16, v8, 4
; CHECK-NEXT:    vadd.vv v8, v8, v16
; CHECK-NEXT:    lui a0, 1
; CHECK-NEXT:    addi a0, a0, -241
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    li a0, 257
; CHECK-NEXT:    vmul.vx v8, v8, a0
; CHECK-NEXT:    vsrl.vi v8, v8, 8
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv32i16_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e16, m8, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 32 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 32 x i1> %head, <vscale x 32 x i1> poison, <vscale x 32 x i32> zeroinitializer
  %v = call <vscale x 32 x i16> @llvm.vp.ctlz.nxv32i16(<vscale x 32 x i16> %va, i1 false, <vscale x 32 x i1> %m, i32 %evl)
  ret <vscale x 32 x i16> %v
}

declare <vscale x 1 x i32> @llvm.vp.ctlz.nxv1i32(<vscale x 1 x i32>, i1 immarg, <vscale x 1 x i1>, i32)

define <vscale x 1 x i32> @vp_ctlz_nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v9, v8, v0.t
; CHECK-NEXT:    li a0, 52
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, ma
; CHECK-NEXT:    vsrl.vx v8, v9, a0, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0, v0.t
; CHECK-NEXT:    li a0, 1054
; CHECK-NEXT:    vrsub.vx v8, v8, a0, v0.t
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vminu.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv1i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 1 x i32> @llvm.vp.ctlz.nxv1i32(<vscale x 1 x i32> %va, i1 false, <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i32> %v
}

define <vscale x 1 x i32> @vp_ctlz_nxv1i32_unmasked(<vscale x 1 x i32> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv1i32_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-NEXT:    li a0, 52
; CHECK-NEXT:    vnsrl.wx v8, v9, a0
; CHECK-NEXT:    li a0, 1054
; CHECK-NEXT:    vrsub.vx v8, v8, a0
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vminu.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv1i32_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 1 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 1 x i1> %head, <vscale x 1 x i1> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i32> @llvm.vp.ctlz.nxv1i32(<vscale x 1 x i32> %va, i1 false, <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i32> %v
}

declare <vscale x 2 x i32> @llvm.vp.ctlz.nxv2i32(<vscale x 2 x i32>, i1 immarg, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @vp_ctlz_nxv2i32(<vscale x 2 x i32> %va, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v10, v8, v0.t
; CHECK-NEXT:    li a0, 52
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-NEXT:    vsrl.vx v8, v10, a0, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vnsrl.wi v10, v8, 0, v0.t
; CHECK-NEXT:    li a0, 1054
; CHECK-NEXT:    vrsub.vx v8, v10, a0, v0.t
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vminu.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv2i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 2 x i32> @llvm.vp.ctlz.nxv2i32(<vscale x 2 x i32> %va, i1 false, <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x i32> %v
}

define <vscale x 2 x i32> @vp_ctlz_nxv2i32_unmasked(<vscale x 2 x i32> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv2i32_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v10, v8
; CHECK-NEXT:    li a0, 52
; CHECK-NEXT:    vnsrl.wx v8, v10, a0
; CHECK-NEXT:    li a0, 1054
; CHECK-NEXT:    vrsub.vx v8, v8, a0
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vminu.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv2i32_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 2 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 2 x i1> %head, <vscale x 2 x i1> poison, <vscale x 2 x i32> zeroinitializer
  %v = call <vscale x 2 x i32> @llvm.vp.ctlz.nxv2i32(<vscale x 2 x i32> %va, i1 false, <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x i32> %v
}

declare <vscale x 4 x i32> @llvm.vp.ctlz.nxv4i32(<vscale x 4 x i32>, i1 immarg, <vscale x 4 x i1>, i32)

define <vscale x 4 x i32> @vp_ctlz_nxv4i32(<vscale x 4 x i32> %va, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v12, v8, v0.t
; CHECK-NEXT:    li a0, 52
; CHECK-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; CHECK-NEXT:    vsrl.vx v8, v12, a0, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vnsrl.wi v12, v8, 0, v0.t
; CHECK-NEXT:    li a0, 1054
; CHECK-NEXT:    vrsub.vx v8, v12, a0, v0.t
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vminu.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv4i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 4 x i32> @llvm.vp.ctlz.nxv4i32(<vscale x 4 x i32> %va, i1 false, <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x i32> %v
}

define <vscale x 4 x i32> @vp_ctlz_nxv4i32_unmasked(<vscale x 4 x i32> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv4i32_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v12, v8
; CHECK-NEXT:    li a0, 52
; CHECK-NEXT:    vnsrl.wx v8, v12, a0
; CHECK-NEXT:    li a0, 1054
; CHECK-NEXT:    vrsub.vx v8, v8, a0
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vminu.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv4i32_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 4 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 4 x i1> %head, <vscale x 4 x i1> poison, <vscale x 4 x i32> zeroinitializer
  %v = call <vscale x 4 x i32> @llvm.vp.ctlz.nxv4i32(<vscale x 4 x i32> %va, i1 false, <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x i32> %v
}

declare <vscale x 8 x i32> @llvm.vp.ctlz.nxv8i32(<vscale x 8 x i32>, i1 immarg, <vscale x 8 x i1>, i32)

define <vscale x 8 x i32> @vp_ctlz_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v16, v8, v0.t
; CHECK-NEXT:    li a0, 52
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, ma
; CHECK-NEXT:    vsrl.vx v8, v16, a0, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vnsrl.wi v16, v8, 0, v0.t
; CHECK-NEXT:    li a0, 1054
; CHECK-NEXT:    vrsub.vx v8, v16, a0, v0.t
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vminu.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv8i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 8 x i32> @llvm.vp.ctlz.nxv8i32(<vscale x 8 x i32> %va, i1 false, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i32> %v
}

define <vscale x 8 x i32> @vp_ctlz_nxv8i32_unmasked(<vscale x 8 x i32> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv8i32_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v16, v8
; CHECK-NEXT:    li a0, 52
; CHECK-NEXT:    vnsrl.wx v8, v16, a0
; CHECK-NEXT:    li a0, 1054
; CHECK-NEXT:    vrsub.vx v8, v8, a0
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vminu.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv8i32_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 8 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 8 x i1> %head, <vscale x 8 x i1> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i32> @llvm.vp.ctlz.nxv8i32(<vscale x 8 x i32> %va, i1 false, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i32> %v
}

declare <vscale x 16 x i32> @llvm.vp.ctlz.nxv16i32(<vscale x 16 x i32>, i1 immarg, <vscale x 16 x i1>, i32)

define <vscale x 16 x i32> @vp_ctlz_nxv16i32(<vscale x 16 x i32> %va, <vscale x 16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m8, ta, ma
; CHECK-NEXT:    fsrmi a0, 1
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8, v0.t
; CHECK-NEXT:    vsrl.vi v8, v8, 23, v0.t
; CHECK-NEXT:    li a1, 158
; CHECK-NEXT:    vrsub.vx v8, v8, a1, v0.t
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vminu.vx v8, v8, a1, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv16i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e32, m8, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 16 x i32> @llvm.vp.ctlz.nxv16i32(<vscale x 16 x i32> %va, i1 false, <vscale x 16 x i1> %m, i32 %evl)
  ret <vscale x 16 x i32> %v
}

define <vscale x 16 x i32> @vp_ctlz_nxv16i32_unmasked(<vscale x 16 x i32> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv16i32_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m8, ta, ma
; CHECK-NEXT:    fsrmi a0, 1
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    vsrl.vi v8, v8, 23
; CHECK-NEXT:    li a1, 158
; CHECK-NEXT:    vrsub.vx v8, v8, a1
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vminu.vx v8, v8, a1
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv16i32_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e32, m8, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 16 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 16 x i1> %head, <vscale x 16 x i1> poison, <vscale x 16 x i32> zeroinitializer
  %v = call <vscale x 16 x i32> @llvm.vp.ctlz.nxv16i32(<vscale x 16 x i32> %va, i1 false, <vscale x 16 x i1> %m, i32 %evl)
  ret <vscale x 16 x i32> %v
}

declare <vscale x 1 x i64> @llvm.vp.ctlz.nxv1i64(<vscale x 1 x i64>, i1 immarg, <vscale x 1 x i1>, i32)

define <vscale x 1 x i64> @vp_ctlz_nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    fsrmi a0, 1
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8, v0.t
; CHECK-NEXT:    li a1, 52
; CHECK-NEXT:    vsrl.vx v8, v8, a1, v0.t
; CHECK-NEXT:    li a1, 1086
; CHECK-NEXT:    vrsub.vx v8, v8, a1, v0.t
; CHECK-NEXT:    li a1, 64
; CHECK-NEXT:    vminu.vx v8, v8, a1, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv1i64:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 1 x i64> @llvm.vp.ctlz.nxv1i64(<vscale x 1 x i64> %va, i1 false, <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i64> %v
}

define <vscale x 1 x i64> @vp_ctlz_nxv1i64_unmasked(<vscale x 1 x i64> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv1i64_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    fsrmi a0, 1
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    li a1, 52
; CHECK-NEXT:    vsrl.vx v8, v8, a1
; CHECK-NEXT:    li a1, 1086
; CHECK-NEXT:    vrsub.vx v8, v8, a1
; CHECK-NEXT:    li a1, 64
; CHECK-NEXT:    vminu.vx v8, v8, a1
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv1i64_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 1 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 1 x i1> %head, <vscale x 1 x i1> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i64> @llvm.vp.ctlz.nxv1i64(<vscale x 1 x i64> %va, i1 false, <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i64> %v
}

declare <vscale x 2 x i64> @llvm.vp.ctlz.nxv2i64(<vscale x 2 x i64>, i1 immarg, <vscale x 2 x i1>, i32)

define <vscale x 2 x i64> @vp_ctlz_nxv2i64(<vscale x 2 x i64> %va, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-NEXT:    fsrmi a0, 1
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8, v0.t
; CHECK-NEXT:    li a1, 52
; CHECK-NEXT:    vsrl.vx v8, v8, a1, v0.t
; CHECK-NEXT:    li a1, 1086
; CHECK-NEXT:    vrsub.vx v8, v8, a1, v0.t
; CHECK-NEXT:    li a1, 64
; CHECK-NEXT:    vminu.vx v8, v8, a1, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv2i64:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 2 x i64> @llvm.vp.ctlz.nxv2i64(<vscale x 2 x i64> %va, i1 false, <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x i64> %v
}

define <vscale x 2 x i64> @vp_ctlz_nxv2i64_unmasked(<vscale x 2 x i64> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv2i64_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-NEXT:    fsrmi a0, 1
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    li a1, 52
; CHECK-NEXT:    vsrl.vx v8, v8, a1
; CHECK-NEXT:    li a1, 1086
; CHECK-NEXT:    vrsub.vx v8, v8, a1
; CHECK-NEXT:    li a1, 64
; CHECK-NEXT:    vminu.vx v8, v8, a1
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv2i64_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 2 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 2 x i1> %head, <vscale x 2 x i1> poison, <vscale x 2 x i32> zeroinitializer
  %v = call <vscale x 2 x i64> @llvm.vp.ctlz.nxv2i64(<vscale x 2 x i64> %va, i1 false, <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x i64> %v
}

declare <vscale x 4 x i64> @llvm.vp.ctlz.nxv4i64(<vscale x 4 x i64>, i1 immarg, <vscale x 4 x i1>, i32)

define <vscale x 4 x i64> @vp_ctlz_nxv4i64(<vscale x 4 x i64> %va, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    fsrmi a0, 1
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8, v0.t
; CHECK-NEXT:    li a1, 52
; CHECK-NEXT:    vsrl.vx v8, v8, a1, v0.t
; CHECK-NEXT:    li a1, 1086
; CHECK-NEXT:    vrsub.vx v8, v8, a1, v0.t
; CHECK-NEXT:    li a1, 64
; CHECK-NEXT:    vminu.vx v8, v8, a1, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv4i64:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 4 x i64> @llvm.vp.ctlz.nxv4i64(<vscale x 4 x i64> %va, i1 false, <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x i64> %v
}

define <vscale x 4 x i64> @vp_ctlz_nxv4i64_unmasked(<vscale x 4 x i64> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv4i64_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    fsrmi a0, 1
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    li a1, 52
; CHECK-NEXT:    vsrl.vx v8, v8, a1
; CHECK-NEXT:    li a1, 1086
; CHECK-NEXT:    vrsub.vx v8, v8, a1
; CHECK-NEXT:    li a1, 64
; CHECK-NEXT:    vminu.vx v8, v8, a1
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv4i64_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 4 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 4 x i1> %head, <vscale x 4 x i1> poison, <vscale x 4 x i32> zeroinitializer
  %v = call <vscale x 4 x i64> @llvm.vp.ctlz.nxv4i64(<vscale x 4 x i64> %va, i1 false, <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x i64> %v
}

declare <vscale x 7 x i64> @llvm.vp.ctlz.nxv7i64(<vscale x 7 x i64>, i1 immarg, <vscale x 7 x i1>, i32)

define <vscale x 7 x i64> @vp_ctlz_nxv7i64(<vscale x 7 x i64> %va, <vscale x 7 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv7i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    fsrmi a0, 1
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8, v0.t
; CHECK-NEXT:    li a1, 52
; CHECK-NEXT:    vsrl.vx v8, v8, a1, v0.t
; CHECK-NEXT:    li a1, 1086
; CHECK-NEXT:    vrsub.vx v8, v8, a1, v0.t
; CHECK-NEXT:    li a1, 64
; CHECK-NEXT:    vminu.vx v8, v8, a1, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv7i64:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 7 x i64> @llvm.vp.ctlz.nxv7i64(<vscale x 7 x i64> %va, i1 false, <vscale x 7 x i1> %m, i32 %evl)
  ret <vscale x 7 x i64> %v
}

define <vscale x 7 x i64> @vp_ctlz_nxv7i64_unmasked(<vscale x 7 x i64> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv7i64_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    fsrmi a0, 1
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    li a1, 52
; CHECK-NEXT:    vsrl.vx v8, v8, a1
; CHECK-NEXT:    li a1, 1086
; CHECK-NEXT:    vrsub.vx v8, v8, a1
; CHECK-NEXT:    li a1, 64
; CHECK-NEXT:    vminu.vx v8, v8, a1
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv7i64_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 7 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 7 x i1> %head, <vscale x 7 x i1> poison, <vscale x 7 x i32> zeroinitializer
  %v = call <vscale x 7 x i64> @llvm.vp.ctlz.nxv7i64(<vscale x 7 x i64> %va, i1 false, <vscale x 7 x i1> %m, i32 %evl)
  ret <vscale x 7 x i64> %v
}

declare <vscale x 8 x i64> @llvm.vp.ctlz.nxv8i64(<vscale x 8 x i64>, i1 immarg, <vscale x 8 x i1>, i32)

define <vscale x 8 x i64> @vp_ctlz_nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    fsrmi a0, 1
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8, v0.t
; CHECK-NEXT:    li a1, 52
; CHECK-NEXT:    vsrl.vx v8, v8, a1, v0.t
; CHECK-NEXT:    li a1, 1086
; CHECK-NEXT:    vrsub.vx v8, v8, a1, v0.t
; CHECK-NEXT:    li a1, 64
; CHECK-NEXT:    vminu.vx v8, v8, a1, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv8i64:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 8 x i64> @llvm.vp.ctlz.nxv8i64(<vscale x 8 x i64> %va, i1 false, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i64> %v
}

define <vscale x 8 x i64> @vp_ctlz_nxv8i64_unmasked(<vscale x 8 x i64> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv8i64_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    fsrmi a0, 1
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    li a1, 52
; CHECK-NEXT:    vsrl.vx v8, v8, a1
; CHECK-NEXT:    li a1, 1086
; CHECK-NEXT:    vrsub.vx v8, v8, a1
; CHECK-NEXT:    li a1, 64
; CHECK-NEXT:    vminu.vx v8, v8, a1
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv8i64_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 8 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 8 x i1> %head, <vscale x 8 x i1> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i64> @llvm.vp.ctlz.nxv8i64(<vscale x 8 x i64> %va, i1 false, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i64> %v
}

declare <vscale x 16 x i64> @llvm.vp.ctlz.nxv16i64(<vscale x 16 x i64>, i1 immarg, <vscale x 16 x i1>, i32)

define <vscale x 16 x i64> @vp_ctlz_nxv16i64(<vscale x 16 x i64> %va, <vscale x 16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv16i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmv1r.v v24, v0
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    srli a2, a1, 3
; CHECK-NEXT:    vsetvli a3, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vslidedown.vx v0, v0, a2
; CHECK-NEXT:    sub a2, a0, a1
; CHECK-NEXT:    sltu a3, a0, a2
; CHECK-NEXT:    addi a3, a3, -1
; CHECK-NEXT:    and a2, a3, a2
; CHECK-NEXT:    vsetvli zero, a2, e64, m8, ta, ma
; CHECK-NEXT:    fsrmi a2, 1
; CHECK-NEXT:    vfcvt.f.xu.v v16, v16, v0.t
; CHECK-NEXT:    fsrm a2
; CHECK-NEXT:    li a2, 52
; CHECK-NEXT:    vsrl.vx v16, v16, a2, v0.t
; CHECK-NEXT:    li a3, 1086
; CHECK-NEXT:    vrsub.vx v16, v16, a3, v0.t
; CHECK-NEXT:    li a4, 64
; CHECK-NEXT:    vminu.vx v16, v16, a4, v0.t
; CHECK-NEXT:    bltu a0, a1, .LBB46_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:  .LBB46_2:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    fsrmi a0, 1
; CHECK-NEXT:    vmv1r.v v0, v24
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8, v0.t
; CHECK-NEXT:    vsrl.vx v8, v8, a2, v0.t
; CHECK-NEXT:    vrsub.vx v8, v8, a3, v0.t
; CHECK-NEXT:    vminu.vx v8, v8, a4, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv16i64:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vmv1r.v v24, v0
; CHECK-ZVBB-NEXT:    csrr a1, vlenb
; CHECK-ZVBB-NEXT:    srli a2, a1, 3
; CHECK-ZVBB-NEXT:    vsetvli a3, zero, e8, mf4, ta, ma
; CHECK-ZVBB-NEXT:    vslidedown.vx v0, v0, a2
; CHECK-ZVBB-NEXT:    sub a2, a0, a1
; CHECK-ZVBB-NEXT:    sltu a3, a0, a2
; CHECK-ZVBB-NEXT:    addi a3, a3, -1
; CHECK-ZVBB-NEXT:    and a2, a3, a2
; CHECK-ZVBB-NEXT:    vsetvli zero, a2, e64, m8, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v16, v16, v0.t
; CHECK-ZVBB-NEXT:    bltu a0, a1, .LBB46_2
; CHECK-ZVBB-NEXT:  # %bb.1:
; CHECK-ZVBB-NEXT:    mv a0, a1
; CHECK-ZVBB-NEXT:  .LBB46_2:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-ZVBB-NEXT:    vmv1r.v v0, v24
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 16 x i64> @llvm.vp.ctlz.nxv16i64(<vscale x 16 x i64> %va, i1 false, <vscale x 16 x i1> %m, i32 %evl)
  ret <vscale x 16 x i64> %v
}

define <vscale x 16 x i64> @vp_ctlz_nxv16i64_unmasked(<vscale x 16 x i64> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv16i64_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    sub a2, a0, a1
; CHECK-NEXT:    sltu a3, a0, a2
; CHECK-NEXT:    addi a3, a3, -1
; CHECK-NEXT:    and a2, a3, a2
; CHECK-NEXT:    vsetvli zero, a2, e64, m8, ta, ma
; CHECK-NEXT:    fsrmi a2, 1
; CHECK-NEXT:    vfcvt.f.xu.v v16, v16
; CHECK-NEXT:    fsrm a2
; CHECK-NEXT:    li a2, 52
; CHECK-NEXT:    vsrl.vx v16, v16, a2
; CHECK-NEXT:    li a3, 1086
; CHECK-NEXT:    vrsub.vx v16, v16, a3
; CHECK-NEXT:    li a4, 64
; CHECK-NEXT:    vminu.vx v16, v16, a4
; CHECK-NEXT:    bltu a0, a1, .LBB47_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:  .LBB47_2:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    fsrmi a0, 1
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    vsrl.vx v8, v8, a2
; CHECK-NEXT:    vrsub.vx v8, v8, a3
; CHECK-NEXT:    vminu.vx v8, v8, a4
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv16i64_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    csrr a1, vlenb
; CHECK-ZVBB-NEXT:    sub a2, a0, a1
; CHECK-ZVBB-NEXT:    sltu a3, a0, a2
; CHECK-ZVBB-NEXT:    addi a3, a3, -1
; CHECK-ZVBB-NEXT:    and a2, a3, a2
; CHECK-ZVBB-NEXT:    vsetvli zero, a2, e64, m8, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v16, v16
; CHECK-ZVBB-NEXT:    bltu a0, a1, .LBB47_2
; CHECK-ZVBB-NEXT:  # %bb.1:
; CHECK-ZVBB-NEXT:    mv a0, a1
; CHECK-ZVBB-NEXT:  .LBB47_2:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 16 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 16 x i1> %head, <vscale x 16 x i1> poison, <vscale x 16 x i32> zeroinitializer
  %v = call <vscale x 16 x i64> @llvm.vp.ctlz.nxv16i64(<vscale x 16 x i64> %va, i1 false, <vscale x 16 x i1> %m, i32 %evl)
  ret <vscale x 16 x i64> %v
}

define <vscale x 1 x i8> @vp_ctlz_zero_undef_nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    vzext.vf2 v9, v8, v0.t
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v9, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vsrl.vi v8, v8, 23, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0, v0.t
; CHECK-NEXT:    li a0, 134
; CHECK-NEXT:    vrsub.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv1i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 1 x i8> @llvm.vp.ctlz.nxv1i8(<vscale x 1 x i8> %va, i1 true, <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i8> %v
}

define <vscale x 1 x i8> @vp_ctlz_zero_undef_nxv1i8_unmasked(<vscale x 1 x i8> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv1i8_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    vzext.vf2 v9, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-NEXT:    vnsrl.wi v8, v8, 23
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    li a0, 134
; CHECK-NEXT:    vrsub.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv1i8_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 1 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 1 x i1> %head, <vscale x 1 x i1> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i8> @llvm.vp.ctlz.nxv1i8(<vscale x 1 x i8> %va, i1 true, <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i8> %v
}


define <vscale x 2 x i8> @vp_ctlz_zero_undef_nxv2i8(<vscale x 2 x i8> %va, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    vzext.vf2 v9, v8, v0.t
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v9, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vsrl.vi v8, v8, 23, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0, v0.t
; CHECK-NEXT:    li a0, 134
; CHECK-NEXT:    vrsub.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv2i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 2 x i8> @llvm.vp.ctlz.nxv2i8(<vscale x 2 x i8> %va, i1 true, <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x i8> %v
}

define <vscale x 2 x i8> @vp_ctlz_zero_undef_nxv2i8_unmasked(<vscale x 2 x i8> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv2i8_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    vzext.vf2 v9, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-NEXT:    vnsrl.wi v8, v8, 23
; CHECK-NEXT:    vsetvli zero, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    li a0, 134
; CHECK-NEXT:    vrsub.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv2i8_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 2 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 2 x i1> %head, <vscale x 2 x i1> poison, <vscale x 2 x i32> zeroinitializer
  %v = call <vscale x 2 x i8> @llvm.vp.ctlz.nxv2i8(<vscale x 2 x i8> %va, i1 true, <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x i8> %v
}


define <vscale x 4 x i8> @vp_ctlz_zero_undef_nxv4i8(<vscale x 4 x i8> %va, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vzext.vf2 v9, v8, v0.t
; CHECK-NEXT:    vfwcvt.f.xu.v v10, v9, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vsrl.vi v8, v10, 23, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vnsrl.wi v10, v8, 0, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v10, 0, v0.t
; CHECK-NEXT:    li a0, 134
; CHECK-NEXT:    vrsub.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv4i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 4 x i8> @llvm.vp.ctlz.nxv4i8(<vscale x 4 x i8> %va, i1 true, <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x i8> %v
}

define <vscale x 4 x i8> @vp_ctlz_zero_undef_nxv4i8_unmasked(<vscale x 4 x i8> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv4i8_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vzext.vf2 v9, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v10, v9
; CHECK-NEXT:    vnsrl.wi v8, v10, 23
; CHECK-NEXT:    vsetvli zero, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    li a0, 134
; CHECK-NEXT:    vrsub.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv4i8_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 4 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 4 x i1> %head, <vscale x 4 x i1> poison, <vscale x 4 x i32> zeroinitializer
  %v = call <vscale x 4 x i8> @llvm.vp.ctlz.nxv4i8(<vscale x 4 x i8> %va, i1 true, <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x i8> %v
}


define <vscale x 8 x i8> @vp_ctlz_zero_undef_nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8, v0.t
; CHECK-NEXT:    vfwcvt.f.xu.v v12, v10, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vsrl.vi v8, v12, 23, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vnsrl.wi v12, v8, 0, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e8, m1, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v12, 0, v0.t
; CHECK-NEXT:    li a0, 134
; CHECK-NEXT:    vrsub.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv8i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 8 x i8> @llvm.vp.ctlz.nxv8i8(<vscale x 8 x i8> %va, i1 true, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i8> %v
}

define <vscale x 8 x i8> @vp_ctlz_zero_undef_nxv8i8_unmasked(<vscale x 8 x i8> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv8i8_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v12, v10
; CHECK-NEXT:    vnsrl.wi v8, v12, 23
; CHECK-NEXT:    vsetvli zero, zero, e8, m1, ta, ma
; CHECK-NEXT:    vnsrl.wi v10, v8, 0
; CHECK-NEXT:    li a0, 134
; CHECK-NEXT:    vrsub.vx v8, v10, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv8i8_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 8 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 8 x i1> %head, <vscale x 8 x i1> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i8> @llvm.vp.ctlz.nxv8i8(<vscale x 8 x i8> %va, i1 true, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i8> %v
}


define <vscale x 16 x i8> @vp_ctlz_zero_undef_nxv16i8(<vscale x 16 x i8> %va, <vscale x 16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    vzext.vf2 v12, v8, v0.t
; CHECK-NEXT:    vfwcvt.f.xu.v v16, v12, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; CHECK-NEXT:    vsrl.vi v8, v16, 23, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e16, m4, ta, ma
; CHECK-NEXT:    vnsrl.wi v16, v8, 0, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e8, m2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v16, 0, v0.t
; CHECK-NEXT:    li a0, 134
; CHECK-NEXT:    vrsub.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv16i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 16 x i8> @llvm.vp.ctlz.nxv16i8(<vscale x 16 x i8> %va, i1 true, <vscale x 16 x i1> %m, i32 %evl)
  ret <vscale x 16 x i8> %v
}

define <vscale x 16 x i8> @vp_ctlz_zero_undef_nxv16i8_unmasked(<vscale x 16 x i8> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv16i8_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    vzext.vf2 v12, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v16, v12
; CHECK-NEXT:    vnsrl.wi v8, v16, 23
; CHECK-NEXT:    vsetvli zero, zero, e8, m2, ta, ma
; CHECK-NEXT:    vnsrl.wi v12, v8, 0
; CHECK-NEXT:    li a0, 134
; CHECK-NEXT:    vrsub.vx v8, v12, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv16i8_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 16 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 16 x i1> %head, <vscale x 16 x i1> poison, <vscale x 16 x i32> zeroinitializer
  %v = call <vscale x 16 x i8> @llvm.vp.ctlz.nxv16i8(<vscale x 16 x i8> %va, i1 true, <vscale x 16 x i1> %m, i32 %evl)
  ret <vscale x 16 x i8> %v
}


define <vscale x 32 x i8> @vp_ctlz_zero_undef_nxv32i8(<vscale x 32 x i8> %va, <vscale x 32 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-NEXT:    vsrl.vi v12, v8, 1, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v12, v0.t
; CHECK-NEXT:    vsrl.vi v12, v8, 2, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v12, v0.t
; CHECK-NEXT:    vsrl.vi v12, v8, 4, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v12, v0.t
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vsrl.vi v12, v8, 1, v0.t
; CHECK-NEXT:    li a0, 85
; CHECK-NEXT:    vand.vx v12, v12, a0, v0.t
; CHECK-NEXT:    vsub.vv v8, v8, v12, v0.t
; CHECK-NEXT:    li a0, 51
; CHECK-NEXT:    vand.vx v12, v8, a0, v0.t
; CHECK-NEXT:    vsrl.vi v8, v8, 2, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    vadd.vv v8, v12, v8, v0.t
; CHECK-NEXT:    vsrl.vi v12, v8, 4, v0.t
; CHECK-NEXT:    vadd.vv v8, v8, v12, v0.t
; CHECK-NEXT:    vand.vi v8, v8, 15, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv32i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 32 x i8> @llvm.vp.ctlz.nxv32i8(<vscale x 32 x i8> %va, i1 true, <vscale x 32 x i1> %m, i32 %evl)
  ret <vscale x 32 x i8> %v
}

define <vscale x 32 x i8> @vp_ctlz_zero_undef_nxv32i8_unmasked(<vscale x 32 x i8> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv32i8_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-NEXT:    vsrl.vi v12, v8, 1
; CHECK-NEXT:    vor.vv v8, v8, v12
; CHECK-NEXT:    vsrl.vi v12, v8, 2
; CHECK-NEXT:    vor.vv v8, v8, v12
; CHECK-NEXT:    vsrl.vi v12, v8, 4
; CHECK-NEXT:    vor.vv v8, v8, v12
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vsrl.vi v12, v8, 1
; CHECK-NEXT:    li a0, 85
; CHECK-NEXT:    vand.vx v12, v12, a0
; CHECK-NEXT:    vsub.vv v8, v8, v12
; CHECK-NEXT:    li a0, 51
; CHECK-NEXT:    vand.vx v12, v8, a0
; CHECK-NEXT:    vsrl.vi v8, v8, 2
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vadd.vv v8, v12, v8
; CHECK-NEXT:    vsrl.vi v12, v8, 4
; CHECK-NEXT:    vadd.vv v8, v8, v12
; CHECK-NEXT:    vand.vi v8, v8, 15
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv32i8_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 32 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 32 x i1> %head, <vscale x 32 x i1> poison, <vscale x 32 x i32> zeroinitializer
  %v = call <vscale x 32 x i8> @llvm.vp.ctlz.nxv32i8(<vscale x 32 x i8> %va, i1 true, <vscale x 32 x i1> %m, i32 %evl)
  ret <vscale x 32 x i8> %v
}


define <vscale x 64 x i8> @vp_ctlz_zero_undef_nxv64i8(<vscale x 64 x i8> %va, <vscale x 64 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv64i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m8, ta, ma
; CHECK-NEXT:    vsrl.vi v16, v8, 1, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v16, v0.t
; CHECK-NEXT:    vsrl.vi v16, v8, 2, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v16, v0.t
; CHECK-NEXT:    vsrl.vi v16, v8, 4, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v16, v0.t
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vsrl.vi v16, v8, 1, v0.t
; CHECK-NEXT:    li a0, 85
; CHECK-NEXT:    vand.vx v16, v16, a0, v0.t
; CHECK-NEXT:    vsub.vv v8, v8, v16, v0.t
; CHECK-NEXT:    li a0, 51
; CHECK-NEXT:    vand.vx v16, v8, a0, v0.t
; CHECK-NEXT:    vsrl.vi v8, v8, 2, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    vadd.vv v8, v16, v8, v0.t
; CHECK-NEXT:    vsrl.vi v16, v8, 4, v0.t
; CHECK-NEXT:    vadd.vv v8, v8, v16, v0.t
; CHECK-NEXT:    vand.vi v8, v8, 15, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv64i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e8, m8, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 64 x i8> @llvm.vp.ctlz.nxv64i8(<vscale x 64 x i8> %va, i1 true, <vscale x 64 x i1> %m, i32 %evl)
  ret <vscale x 64 x i8> %v
}

define <vscale x 64 x i8> @vp_ctlz_zero_undef_nxv64i8_unmasked(<vscale x 64 x i8> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv64i8_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m8, ta, ma
; CHECK-NEXT:    vsrl.vi v16, v8, 1
; CHECK-NEXT:    vor.vv v8, v8, v16
; CHECK-NEXT:    vsrl.vi v16, v8, 2
; CHECK-NEXT:    vor.vv v8, v8, v16
; CHECK-NEXT:    vsrl.vi v16, v8, 4
; CHECK-NEXT:    vor.vv v8, v8, v16
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vsrl.vi v16, v8, 1
; CHECK-NEXT:    li a0, 85
; CHECK-NEXT:    vand.vx v16, v16, a0
; CHECK-NEXT:    vsub.vv v8, v8, v16
; CHECK-NEXT:    li a0, 51
; CHECK-NEXT:    vand.vx v16, v8, a0
; CHECK-NEXT:    vsrl.vi v8, v8, 2
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vadd.vv v8, v16, v8
; CHECK-NEXT:    vsrl.vi v16, v8, 4
; CHECK-NEXT:    vadd.vv v8, v8, v16
; CHECK-NEXT:    vand.vi v8, v8, 15
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv64i8_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e8, m8, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 64 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 64 x i1> %head, <vscale x 64 x i1> poison, <vscale x 64 x i32> zeroinitializer
  %v = call <vscale x 64 x i8> @llvm.vp.ctlz.nxv64i8(<vscale x 64 x i8> %va, i1 true, <vscale x 64 x i1> %m, i32 %evl)
  ret <vscale x 64 x i8> %v
}


define <vscale x 1 x i16> @vp_ctlz_zero_undef_nxv1i16(<vscale x 1 x i16> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v9, v8, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vsrl.vi v8, v9, 23, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0, v0.t
; CHECK-NEXT:    li a0, 142
; CHECK-NEXT:    vrsub.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv1i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 1 x i16> @llvm.vp.ctlz.nxv1i16(<vscale x 1 x i16> %va, i1 true, <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i16> %v
}

define <vscale x 1 x i16> @vp_ctlz_zero_undef_nxv1i16_unmasked(<vscale x 1 x i16> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv1i16_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-NEXT:    vnsrl.wi v8, v9, 23
; CHECK-NEXT:    li a0, 142
; CHECK-NEXT:    vrsub.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv1i16_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 1 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 1 x i1> %head, <vscale x 1 x i1> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i16> @llvm.vp.ctlz.nxv1i16(<vscale x 1 x i16> %va, i1 true, <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i16> %v
}


define <vscale x 2 x i16> @vp_ctlz_zero_undef_nxv2i16(<vscale x 2 x i16> %va, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v9, v8, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vsrl.vi v8, v9, 23, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0, v0.t
; CHECK-NEXT:    li a0, 142
; CHECK-NEXT:    vrsub.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv2i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 2 x i16> @llvm.vp.ctlz.nxv2i16(<vscale x 2 x i16> %va, i1 true, <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x i16> %v
}

define <vscale x 2 x i16> @vp_ctlz_zero_undef_nxv2i16_unmasked(<vscale x 2 x i16> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv2i16_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-NEXT:    vnsrl.wi v8, v9, 23
; CHECK-NEXT:    li a0, 142
; CHECK-NEXT:    vrsub.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv2i16_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 2 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 2 x i1> %head, <vscale x 2 x i1> poison, <vscale x 2 x i32> zeroinitializer
  %v = call <vscale x 2 x i16> @llvm.vp.ctlz.nxv2i16(<vscale x 2 x i16> %va, i1 true, <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x i16> %v
}


define <vscale x 4 x i16> @vp_ctlz_zero_undef_nxv4i16(<vscale x 4 x i16> %va, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v10, v8, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vsrl.vi v8, v10, 23, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vnsrl.wi v10, v8, 0, v0.t
; CHECK-NEXT:    li a0, 142
; CHECK-NEXT:    vrsub.vx v8, v10, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv4i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 4 x i16> @llvm.vp.ctlz.nxv4i16(<vscale x 4 x i16> %va, i1 true, <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x i16> %v
}

define <vscale x 4 x i16> @vp_ctlz_zero_undef_nxv4i16_unmasked(<vscale x 4 x i16> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv4i16_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v10, v8
; CHECK-NEXT:    vnsrl.wi v8, v10, 23
; CHECK-NEXT:    li a0, 142
; CHECK-NEXT:    vrsub.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv4i16_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 4 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 4 x i1> %head, <vscale x 4 x i1> poison, <vscale x 4 x i32> zeroinitializer
  %v = call <vscale x 4 x i16> @llvm.vp.ctlz.nxv4i16(<vscale x 4 x i16> %va, i1 true, <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x i16> %v
}


define <vscale x 8 x i16> @vp_ctlz_zero_undef_nxv8i16(<vscale x 8 x i16> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v12, v8, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vsrl.vi v8, v12, 23, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vnsrl.wi v12, v8, 0, v0.t
; CHECK-NEXT:    li a0, 142
; CHECK-NEXT:    vrsub.vx v8, v12, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv8i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 8 x i16> @llvm.vp.ctlz.nxv8i16(<vscale x 8 x i16> %va, i1 true, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i16> %v
}

define <vscale x 8 x i16> @vp_ctlz_zero_undef_nxv8i16_unmasked(<vscale x 8 x i16> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv8i16_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v12, v8
; CHECK-NEXT:    vnsrl.wi v8, v12, 23
; CHECK-NEXT:    li a0, 142
; CHECK-NEXT:    vrsub.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv8i16_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 8 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 8 x i1> %head, <vscale x 8 x i1> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i16> @llvm.vp.ctlz.nxv8i16(<vscale x 8 x i16> %va, i1 true, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i16> %v
}


define <vscale x 16 x i16> @vp_ctlz_zero_undef_nxv16i16(<vscale x 16 x i16> %va, <vscale x 16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v16, v8, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; CHECK-NEXT:    vsrl.vi v8, v16, 23, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e16, m4, ta, ma
; CHECK-NEXT:    vnsrl.wi v16, v8, 0, v0.t
; CHECK-NEXT:    li a0, 142
; CHECK-NEXT:    vrsub.vx v8, v16, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv16i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 16 x i16> @llvm.vp.ctlz.nxv16i16(<vscale x 16 x i16> %va, i1 true, <vscale x 16 x i1> %m, i32 %evl)
  ret <vscale x 16 x i16> %v
}

define <vscale x 16 x i16> @vp_ctlz_zero_undef_nxv16i16_unmasked(<vscale x 16 x i16> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv16i16_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v16, v8
; CHECK-NEXT:    vnsrl.wi v8, v16, 23
; CHECK-NEXT:    li a0, 142
; CHECK-NEXT:    vrsub.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv16i16_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 16 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 16 x i1> %head, <vscale x 16 x i1> poison, <vscale x 16 x i32> zeroinitializer
  %v = call <vscale x 16 x i16> @llvm.vp.ctlz.nxv16i16(<vscale x 16 x i16> %va, i1 true, <vscale x 16 x i1> %m, i32 %evl)
  ret <vscale x 16 x i16> %v
}


define <vscale x 32 x i16> @vp_ctlz_zero_undef_nxv32i16(<vscale x 32 x i16> %va, <vscale x 32 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv32i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m8, ta, ma
; CHECK-NEXT:    vsrl.vi v16, v8, 1, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v16, v0.t
; CHECK-NEXT:    vsrl.vi v16, v8, 2, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v16, v0.t
; CHECK-NEXT:    vsrl.vi v16, v8, 4, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v16, v0.t
; CHECK-NEXT:    vsrl.vi v16, v8, 8, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v16, v0.t
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vsrl.vi v16, v8, 1, v0.t
; CHECK-NEXT:    lui a0, 5
; CHECK-NEXT:    addi a0, a0, 1365
; CHECK-NEXT:    vand.vx v16, v16, a0, v0.t
; CHECK-NEXT:    vsub.vv v8, v8, v16, v0.t
; CHECK-NEXT:    lui a0, 3
; CHECK-NEXT:    addi a0, a0, 819
; CHECK-NEXT:    vand.vx v16, v8, a0, v0.t
; CHECK-NEXT:    vsrl.vi v8, v8, 2, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    vadd.vv v8, v16, v8, v0.t
; CHECK-NEXT:    vsrl.vi v16, v8, 4, v0.t
; CHECK-NEXT:    vadd.vv v8, v8, v16, v0.t
; CHECK-NEXT:    lui a0, 1
; CHECK-NEXT:    addi a0, a0, -241
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    li a0, 257
; CHECK-NEXT:    vmul.vx v8, v8, a0, v0.t
; CHECK-NEXT:    vsrl.vi v8, v8, 8, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv32i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e16, m8, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 32 x i16> @llvm.vp.ctlz.nxv32i16(<vscale x 32 x i16> %va, i1 true, <vscale x 32 x i1> %m, i32 %evl)
  ret <vscale x 32 x i16> %v
}

define <vscale x 32 x i16> @vp_ctlz_zero_undef_nxv32i16_unmasked(<vscale x 32 x i16> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv32i16_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m8, ta, ma
; CHECK-NEXT:    vsrl.vi v16, v8, 1
; CHECK-NEXT:    vor.vv v8, v8, v16
; CHECK-NEXT:    vsrl.vi v16, v8, 2
; CHECK-NEXT:    vor.vv v8, v8, v16
; CHECK-NEXT:    vsrl.vi v16, v8, 4
; CHECK-NEXT:    vor.vv v8, v8, v16
; CHECK-NEXT:    vsrl.vi v16, v8, 8
; CHECK-NEXT:    vor.vv v8, v8, v16
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vsrl.vi v16, v8, 1
; CHECK-NEXT:    lui a0, 5
; CHECK-NEXT:    addi a0, a0, 1365
; CHECK-NEXT:    vand.vx v16, v16, a0
; CHECK-NEXT:    vsub.vv v8, v8, v16
; CHECK-NEXT:    lui a0, 3
; CHECK-NEXT:    addi a0, a0, 819
; CHECK-NEXT:    vand.vx v16, v8, a0
; CHECK-NEXT:    vsrl.vi v8, v8, 2
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vadd.vv v8, v16, v8
; CHECK-NEXT:    vsrl.vi v16, v8, 4
; CHECK-NEXT:    vadd.vv v8, v8, v16
; CHECK-NEXT:    lui a0, 1
; CHECK-NEXT:    addi a0, a0, -241
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    li a0, 257
; CHECK-NEXT:    vmul.vx v8, v8, a0
; CHECK-NEXT:    vsrl.vi v8, v8, 8
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv32i16_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e16, m8, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 32 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 32 x i1> %head, <vscale x 32 x i1> poison, <vscale x 32 x i32> zeroinitializer
  %v = call <vscale x 32 x i16> @llvm.vp.ctlz.nxv32i16(<vscale x 32 x i16> %va, i1 true, <vscale x 32 x i1> %m, i32 %evl)
  ret <vscale x 32 x i16> %v
}


define <vscale x 1 x i32> @vp_ctlz_zero_undef_nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v9, v8, v0.t
; CHECK-NEXT:    li a0, 52
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, ma
; CHECK-NEXT:    vsrl.vx v8, v9, a0, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0, v0.t
; CHECK-NEXT:    li a0, 1054
; CHECK-NEXT:    vrsub.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv1i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 1 x i32> @llvm.vp.ctlz.nxv1i32(<vscale x 1 x i32> %va, i1 true, <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i32> %v
}

define <vscale x 1 x i32> @vp_ctlz_zero_undef_nxv1i32_unmasked(<vscale x 1 x i32> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv1i32_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-NEXT:    li a0, 52
; CHECK-NEXT:    vnsrl.wx v8, v9, a0
; CHECK-NEXT:    li a0, 1054
; CHECK-NEXT:    vrsub.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv1i32_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 1 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 1 x i1> %head, <vscale x 1 x i1> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i32> @llvm.vp.ctlz.nxv1i32(<vscale x 1 x i32> %va, i1 true, <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i32> %v
}


define <vscale x 2 x i32> @vp_ctlz_zero_undef_nxv2i32(<vscale x 2 x i32> %va, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v10, v8, v0.t
; CHECK-NEXT:    li a0, 52
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-NEXT:    vsrl.vx v8, v10, a0, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vnsrl.wi v10, v8, 0, v0.t
; CHECK-NEXT:    li a0, 1054
; CHECK-NEXT:    vrsub.vx v8, v10, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv2i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 2 x i32> @llvm.vp.ctlz.nxv2i32(<vscale x 2 x i32> %va, i1 true, <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x i32> %v
}

define <vscale x 2 x i32> @vp_ctlz_zero_undef_nxv2i32_unmasked(<vscale x 2 x i32> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv2i32_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v10, v8
; CHECK-NEXT:    li a0, 52
; CHECK-NEXT:    vnsrl.wx v8, v10, a0
; CHECK-NEXT:    li a0, 1054
; CHECK-NEXT:    vrsub.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv2i32_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 2 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 2 x i1> %head, <vscale x 2 x i1> poison, <vscale x 2 x i32> zeroinitializer
  %v = call <vscale x 2 x i32> @llvm.vp.ctlz.nxv2i32(<vscale x 2 x i32> %va, i1 true, <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x i32> %v
}


define <vscale x 4 x i32> @vp_ctlz_zero_undef_nxv4i32(<vscale x 4 x i32> %va, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v12, v8, v0.t
; CHECK-NEXT:    li a0, 52
; CHECK-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; CHECK-NEXT:    vsrl.vx v8, v12, a0, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vnsrl.wi v12, v8, 0, v0.t
; CHECK-NEXT:    li a0, 1054
; CHECK-NEXT:    vrsub.vx v8, v12, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv4i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 4 x i32> @llvm.vp.ctlz.nxv4i32(<vscale x 4 x i32> %va, i1 true, <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x i32> %v
}

define <vscale x 4 x i32> @vp_ctlz_zero_undef_nxv4i32_unmasked(<vscale x 4 x i32> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv4i32_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v12, v8
; CHECK-NEXT:    li a0, 52
; CHECK-NEXT:    vnsrl.wx v8, v12, a0
; CHECK-NEXT:    li a0, 1054
; CHECK-NEXT:    vrsub.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv4i32_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 4 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 4 x i1> %head, <vscale x 4 x i1> poison, <vscale x 4 x i32> zeroinitializer
  %v = call <vscale x 4 x i32> @llvm.vp.ctlz.nxv4i32(<vscale x 4 x i32> %va, i1 true, <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x i32> %v
}


define <vscale x 8 x i32> @vp_ctlz_zero_undef_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v16, v8, v0.t
; CHECK-NEXT:    li a0, 52
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, ma
; CHECK-NEXT:    vsrl.vx v8, v16, a0, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vnsrl.wi v16, v8, 0, v0.t
; CHECK-NEXT:    li a0, 1054
; CHECK-NEXT:    vrsub.vx v8, v16, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv8i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 8 x i32> @llvm.vp.ctlz.nxv8i32(<vscale x 8 x i32> %va, i1 true, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i32> %v
}

define <vscale x 8 x i32> @vp_ctlz_zero_undef_nxv8i32_unmasked(<vscale x 8 x i32> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv8i32_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v16, v8
; CHECK-NEXT:    li a0, 52
; CHECK-NEXT:    vnsrl.wx v8, v16, a0
; CHECK-NEXT:    li a0, 1054
; CHECK-NEXT:    vrsub.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv8i32_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 8 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 8 x i1> %head, <vscale x 8 x i1> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i32> @llvm.vp.ctlz.nxv8i32(<vscale x 8 x i32> %va, i1 true, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i32> %v
}


define <vscale x 16 x i32> @vp_ctlz_zero_undef_nxv16i32(<vscale x 16 x i32> %va, <vscale x 16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m8, ta, ma
; CHECK-NEXT:    fsrmi a0, 1
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8, v0.t
; CHECK-NEXT:    vsrl.vi v8, v8, 23, v0.t
; CHECK-NEXT:    li a1, 158
; CHECK-NEXT:    vrsub.vx v8, v8, a1, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv16i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e32, m8, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 16 x i32> @llvm.vp.ctlz.nxv16i32(<vscale x 16 x i32> %va, i1 true, <vscale x 16 x i1> %m, i32 %evl)
  ret <vscale x 16 x i32> %v
}

define <vscale x 16 x i32> @vp_ctlz_zero_undef_nxv16i32_unmasked(<vscale x 16 x i32> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv16i32_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m8, ta, ma
; CHECK-NEXT:    fsrmi a0, 1
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    vsrl.vi v8, v8, 23
; CHECK-NEXT:    li a1, 158
; CHECK-NEXT:    vrsub.vx v8, v8, a1
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv16i32_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e32, m8, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 16 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 16 x i1> %head, <vscale x 16 x i1> poison, <vscale x 16 x i32> zeroinitializer
  %v = call <vscale x 16 x i32> @llvm.vp.ctlz.nxv16i32(<vscale x 16 x i32> %va, i1 true, <vscale x 16 x i1> %m, i32 %evl)
  ret <vscale x 16 x i32> %v
}


define <vscale x 1 x i64> @vp_ctlz_zero_undef_nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    fsrmi a0, 1
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8, v0.t
; CHECK-NEXT:    li a1, 52
; CHECK-NEXT:    vsrl.vx v8, v8, a1, v0.t
; CHECK-NEXT:    li a1, 1086
; CHECK-NEXT:    vrsub.vx v8, v8, a1, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv1i64:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 1 x i64> @llvm.vp.ctlz.nxv1i64(<vscale x 1 x i64> %va, i1 true, <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i64> %v
}

define <vscale x 1 x i64> @vp_ctlz_zero_undef_nxv1i64_unmasked(<vscale x 1 x i64> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv1i64_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    fsrmi a0, 1
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    li a1, 52
; CHECK-NEXT:    vsrl.vx v8, v8, a1
; CHECK-NEXT:    li a1, 1086
; CHECK-NEXT:    vrsub.vx v8, v8, a1
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv1i64_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 1 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 1 x i1> %head, <vscale x 1 x i1> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i64> @llvm.vp.ctlz.nxv1i64(<vscale x 1 x i64> %va, i1 true, <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i64> %v
}


define <vscale x 2 x i64> @vp_ctlz_zero_undef_nxv2i64(<vscale x 2 x i64> %va, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-NEXT:    fsrmi a0, 1
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8, v0.t
; CHECK-NEXT:    li a1, 52
; CHECK-NEXT:    vsrl.vx v8, v8, a1, v0.t
; CHECK-NEXT:    li a1, 1086
; CHECK-NEXT:    vrsub.vx v8, v8, a1, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv2i64:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 2 x i64> @llvm.vp.ctlz.nxv2i64(<vscale x 2 x i64> %va, i1 true, <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x i64> %v
}

define <vscale x 2 x i64> @vp_ctlz_zero_undef_nxv2i64_unmasked(<vscale x 2 x i64> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv2i64_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-NEXT:    fsrmi a0, 1
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    li a1, 52
; CHECK-NEXT:    vsrl.vx v8, v8, a1
; CHECK-NEXT:    li a1, 1086
; CHECK-NEXT:    vrsub.vx v8, v8, a1
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv2i64_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 2 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 2 x i1> %head, <vscale x 2 x i1> poison, <vscale x 2 x i32> zeroinitializer
  %v = call <vscale x 2 x i64> @llvm.vp.ctlz.nxv2i64(<vscale x 2 x i64> %va, i1 true, <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x i64> %v
}


define <vscale x 4 x i64> @vp_ctlz_zero_undef_nxv4i64(<vscale x 4 x i64> %va, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    fsrmi a0, 1
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8, v0.t
; CHECK-NEXT:    li a1, 52
; CHECK-NEXT:    vsrl.vx v8, v8, a1, v0.t
; CHECK-NEXT:    li a1, 1086
; CHECK-NEXT:    vrsub.vx v8, v8, a1, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv4i64:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 4 x i64> @llvm.vp.ctlz.nxv4i64(<vscale x 4 x i64> %va, i1 true, <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x i64> %v
}

define <vscale x 4 x i64> @vp_ctlz_zero_undef_nxv4i64_unmasked(<vscale x 4 x i64> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv4i64_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    fsrmi a0, 1
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    li a1, 52
; CHECK-NEXT:    vsrl.vx v8, v8, a1
; CHECK-NEXT:    li a1, 1086
; CHECK-NEXT:    vrsub.vx v8, v8, a1
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv4i64_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 4 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 4 x i1> %head, <vscale x 4 x i1> poison, <vscale x 4 x i32> zeroinitializer
  %v = call <vscale x 4 x i64> @llvm.vp.ctlz.nxv4i64(<vscale x 4 x i64> %va, i1 true, <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x i64> %v
}


define <vscale x 7 x i64> @vp_ctlz_zero_undef_nxv7i64(<vscale x 7 x i64> %va, <vscale x 7 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv7i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    fsrmi a0, 1
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8, v0.t
; CHECK-NEXT:    li a1, 52
; CHECK-NEXT:    vsrl.vx v8, v8, a1, v0.t
; CHECK-NEXT:    li a1, 1086
; CHECK-NEXT:    vrsub.vx v8, v8, a1, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv7i64:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 7 x i64> @llvm.vp.ctlz.nxv7i64(<vscale x 7 x i64> %va, i1 true, <vscale x 7 x i1> %m, i32 %evl)
  ret <vscale x 7 x i64> %v
}

define <vscale x 7 x i64> @vp_ctlz_zero_undef_nxv7i64_unmasked(<vscale x 7 x i64> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv7i64_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    fsrmi a0, 1
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    li a1, 52
; CHECK-NEXT:    vsrl.vx v8, v8, a1
; CHECK-NEXT:    li a1, 1086
; CHECK-NEXT:    vrsub.vx v8, v8, a1
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv7i64_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 7 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 7 x i1> %head, <vscale x 7 x i1> poison, <vscale x 7 x i32> zeroinitializer
  %v = call <vscale x 7 x i64> @llvm.vp.ctlz.nxv7i64(<vscale x 7 x i64> %va, i1 true, <vscale x 7 x i1> %m, i32 %evl)
  ret <vscale x 7 x i64> %v
}


define <vscale x 8 x i64> @vp_ctlz_zero_undef_nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    fsrmi a0, 1
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8, v0.t
; CHECK-NEXT:    li a1, 52
; CHECK-NEXT:    vsrl.vx v8, v8, a1, v0.t
; CHECK-NEXT:    li a1, 1086
; CHECK-NEXT:    vrsub.vx v8, v8, a1, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv8i64:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 8 x i64> @llvm.vp.ctlz.nxv8i64(<vscale x 8 x i64> %va, i1 true, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i64> %v
}

define <vscale x 8 x i64> @vp_ctlz_zero_undef_nxv8i64_unmasked(<vscale x 8 x i64> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv8i64_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    fsrmi a0, 1
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    li a1, 52
; CHECK-NEXT:    vsrl.vx v8, v8, a1
; CHECK-NEXT:    li a1, 1086
; CHECK-NEXT:    vrsub.vx v8, v8, a1
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv8i64_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 8 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 8 x i1> %head, <vscale x 8 x i1> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i64> @llvm.vp.ctlz.nxv8i64(<vscale x 8 x i64> %va, i1 true, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i64> %v
}

define <vscale x 16 x i64> @vp_ctlz_zero_undef_nxv16i64(<vscale x 16 x i64> %va, <vscale x 16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv16i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmv1r.v v24, v0
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    srli a2, a1, 3
; CHECK-NEXT:    vsetvli a3, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vslidedown.vx v0, v0, a2
; CHECK-NEXT:    sub a2, a0, a1
; CHECK-NEXT:    sltu a3, a0, a2
; CHECK-NEXT:    addi a3, a3, -1
; CHECK-NEXT:    and a2, a3, a2
; CHECK-NEXT:    vsetvli zero, a2, e64, m8, ta, ma
; CHECK-NEXT:    fsrmi a2, 1
; CHECK-NEXT:    vfcvt.f.xu.v v16, v16, v0.t
; CHECK-NEXT:    fsrm a2
; CHECK-NEXT:    li a2, 52
; CHECK-NEXT:    vsrl.vx v16, v16, a2, v0.t
; CHECK-NEXT:    li a3, 1086
; CHECK-NEXT:    vrsub.vx v16, v16, a3, v0.t
; CHECK-NEXT:    bltu a0, a1, .LBB94_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:  .LBB94_2:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    fsrmi a0, 1
; CHECK-NEXT:    vmv1r.v v0, v24
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8, v0.t
; CHECK-NEXT:    vsrl.vx v8, v8, a2, v0.t
; CHECK-NEXT:    vrsub.vx v8, v8, a3, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv16i64:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vmv1r.v v24, v0
; CHECK-ZVBB-NEXT:    csrr a1, vlenb
; CHECK-ZVBB-NEXT:    srli a2, a1, 3
; CHECK-ZVBB-NEXT:    vsetvli a3, zero, e8, mf4, ta, ma
; CHECK-ZVBB-NEXT:    vslidedown.vx v0, v0, a2
; CHECK-ZVBB-NEXT:    sub a2, a0, a1
; CHECK-ZVBB-NEXT:    sltu a3, a0, a2
; CHECK-ZVBB-NEXT:    addi a3, a3, -1
; CHECK-ZVBB-NEXT:    and a2, a3, a2
; CHECK-ZVBB-NEXT:    vsetvli zero, a2, e64, m8, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v16, v16, v0.t
; CHECK-ZVBB-NEXT:    bltu a0, a1, .LBB94_2
; CHECK-ZVBB-NEXT:  # %bb.1:
; CHECK-ZVBB-NEXT:    mv a0, a1
; CHECK-ZVBB-NEXT:  .LBB94_2:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-ZVBB-NEXT:    vmv1r.v v0, v24
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 16 x i64> @llvm.vp.ctlz.nxv16i64(<vscale x 16 x i64> %va, i1 true, <vscale x 16 x i1> %m, i32 %evl)
  ret <vscale x 16 x i64> %v
}

define <vscale x 16 x i64> @vp_ctlz_zero_undef_nxv16i64_unmasked(<vscale x 16 x i64> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv16i64_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    sub a2, a0, a1
; CHECK-NEXT:    sltu a3, a0, a2
; CHECK-NEXT:    addi a3, a3, -1
; CHECK-NEXT:    and a2, a3, a2
; CHECK-NEXT:    vsetvli zero, a2, e64, m8, ta, ma
; CHECK-NEXT:    fsrmi a2, 1
; CHECK-NEXT:    vfcvt.f.xu.v v16, v16
; CHECK-NEXT:    fsrm a2
; CHECK-NEXT:    li a2, 52
; CHECK-NEXT:    vsrl.vx v16, v16, a2
; CHECK-NEXT:    li a3, 1086
; CHECK-NEXT:    vrsub.vx v16, v16, a3
; CHECK-NEXT:    bltu a0, a1, .LBB95_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:  .LBB95_2:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    fsrmi a0, 1
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    vsrl.vx v8, v8, a2
; CHECK-NEXT:    vrsub.vx v8, v8, a3
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv16i64_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    csrr a1, vlenb
; CHECK-ZVBB-NEXT:    sub a2, a0, a1
; CHECK-ZVBB-NEXT:    sltu a3, a0, a2
; CHECK-ZVBB-NEXT:    addi a3, a3, -1
; CHECK-ZVBB-NEXT:    and a2, a3, a2
; CHECK-ZVBB-NEXT:    vsetvli zero, a2, e64, m8, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v16, v16
; CHECK-ZVBB-NEXT:    bltu a0, a1, .LBB95_2
; CHECK-ZVBB-NEXT:  # %bb.1:
; CHECK-ZVBB-NEXT:    mv a0, a1
; CHECK-ZVBB-NEXT:  .LBB95_2:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 16 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 16 x i1> %head, <vscale x 16 x i1> poison, <vscale x 16 x i32> zeroinitializer
  %v = call <vscale x 16 x i64> @llvm.vp.ctlz.nxv16i64(<vscale x 16 x i64> %va, i1 true, <vscale x 16 x i1> %m, i32 %evl)
  ret <vscale x 16 x i64> %v
}

; Test promotion.
declare <vscale x 1 x i9> @llvm.vp.ctlz.nxv1i9(<vscale x 1 x i9>, i1 immarg, <vscale x 1 x i1>, i32)
define <vscale x 1 x i9> @vp_ctlz_nxv1i9(<vscale x 1 x i9> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_nxv1i9:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 511
; CHECK-NEXT:    vsetvli a2, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a1
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v9, v8, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vsrl.vi v8, v9, 23, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0, v0.t
; CHECK-NEXT:    li a0, 142
; CHECK-NEXT:    vrsub.vx v8, v8, a0, v0.t
; CHECK-NEXT:    li a0, 16
; CHECK-NEXT:    vminu.vx v8, v8, a0, v0.t
; CHECK-NEXT:    li a0, 7
; CHECK-NEXT:    vsub.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_nxv1i9:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    li a1, 511
; CHECK-ZVBB-NEXT:    vsetvli a2, zero, e16, mf4, ta, ma
; CHECK-ZVBB-NEXT:    vand.vx v8, v8, a1
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    li a0, 7
; CHECK-ZVBB-NEXT:    vsub.vx v8, v8, a0, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 1 x i9> @llvm.vp.ctlz.nxv1i9(<vscale x 1 x i9> %va, i1 false, <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i9> %v
}
define <vscale x 1 x i9> @vp_ctlz_zero_undef_nxv1i9(<vscale x 1 x i9> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_ctlz_zero_undef_nxv1i9:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 511
; CHECK-NEXT:    vsetvli a2, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a1
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v9, v8, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vsrl.vi v8, v9, 23, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0, v0.t
; CHECK-NEXT:    li a0, 142
; CHECK-NEXT:    vrsub.vx v8, v8, a0, v0.t
; CHECK-NEXT:    li a0, 7
; CHECK-NEXT:    vsub.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_ctlz_zero_undef_nxv1i9:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    li a1, 511
; CHECK-ZVBB-NEXT:    vsetvli a2, zero, e16, mf4, ta, ma
; CHECK-ZVBB-NEXT:    vand.vx v8, v8, a1
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    li a0, 7
; CHECK-ZVBB-NEXT:    vsub.vx v8, v8, a0, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 1 x i9> @llvm.vp.ctlz.nxv1i9(<vscale x 1 x i9> %va, i1 true, <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i9> %v
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; RV32: {{.*}}
; RV64: {{.*}}
