; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mcpu=pwr8 \
; RUN:   -mtriple=powerpc64-unknown-aix < %s | FileCheck %s --check-prefix=P8-BE
; RUN: llc -verify-machineinstrs -mcpu=pwr9 \
; RUN:   -mtriple=powerpc64-unknown-aix < %s | FileCheck %s --check-prefix=P9-BE
; RUN: llc -verify-machineinstrs -mcpu=pwr10 \
; RUN:   -mtriple=powerpc64-unknown-aix < %s | FileCheck %s --check-prefix=P10-BE
; RUN: llc -verify-machineinstrs -mcpu=pwr8 \
; RUN:   -mtriple=powerpc64le-unknown-unknown < %s | FileCheck %s --check-prefix=P8-LE
; RUN: llc -verify-machineinstrs -mcpu=pwr9 \
; RUN:   -mtriple=powerpc64le-unknown-unknown < %s | FileCheck %s --check-prefix=P9-LE
; RUN: llc -verify-machineinstrs -mcpu=pwr10 \
; RUN:   -mtriple=powerpc64le-unknown-unknown < %s | FileCheck %s --check-prefix=P10-LE

define dso_local void @memsetTailV1B15(ptr nocapture noundef writeonly %p) local_unnamed_addr {
; P8-BE-LABEL: memsetTailV1B15:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    vspltisb 2, 15
; P8-BE-NEXT:    li 4, 15
; P8-BE-NEXT:    stxvw4x 34, 3, 4
; P8-BE-NEXT:    stxvw4x 34, 0, 3
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: memsetTailV1B15:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    xxspltib 0, 15
; P9-BE-NEXT:    li 4, 15
; P9-BE-NEXT:    stxvx 0, 3, 4
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: memsetTailV1B15:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    xxspltib 0, 15
; P10-BE-NEXT:    pstxv 0, 15(3), 0
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: memsetTailV1B15:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    vspltisb 2, 15
; P8-LE-NEXT:    li 4, 15
; P8-LE-NEXT:    stxvd2x 34, 3, 4
; P8-LE-NEXT:    stxvd2x 34, 0, 3
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: memsetTailV1B15:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    xxspltib 0, 15
; P9-LE-NEXT:    li 4, 15
; P9-LE-NEXT:    stxvx 0, 3, 4
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: memsetTailV1B15:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    xxspltib 0, 15
; P10-LE-NEXT:    pstxv 0, 15(3), 0
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  tail call void @llvm.memset.p0.i64(ptr %p, i8 15, i64 31, i1 false)
  ret void
}

define dso_local void @memsetTailV1B12(ptr nocapture noundef writeonly %p) local_unnamed_addr {
; P8-BE-LABEL: memsetTailV1B12:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    vspltisb 2, 15
; P8-BE-NEXT:    li 4, 12
; P8-BE-NEXT:    stxvw4x 34, 3, 4
; P8-BE-NEXT:    stxvw4x 34, 0, 3
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: memsetTailV1B12:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    xxspltib 0, 15
; P9-BE-NEXT:    li 4, 12
; P9-BE-NEXT:    stxvx 0, 3, 4
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: memsetTailV1B12:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    xxspltib 0, 15
; P10-BE-NEXT:    pstxv 0, 12(3), 0
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: memsetTailV1B12:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    vspltisb 2, 15
; P8-LE-NEXT:    li 4, 12
; P8-LE-NEXT:    stxvd2x 34, 3, 4
; P8-LE-NEXT:    stxvd2x 34, 0, 3
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: memsetTailV1B12:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    xxspltib 0, 15
; P9-LE-NEXT:    li 4, 12
; P9-LE-NEXT:    stxvx 0, 3, 4
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: memsetTailV1B12:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    xxspltib 0, 15
; P10-LE-NEXT:    pstxv 0, 12(3), 0
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  tail call void @llvm.memset.p0.i64(ptr %p, i8 15, i64 28, i1 false)
  ret void
}

define dso_local void @memsetTailV1B9(ptr nocapture noundef writeonly %p) local_unnamed_addr {
; P8-BE-LABEL: memsetTailV1B9:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    vspltisb 2, 15
; P8-BE-NEXT:    li 4, 9
; P8-BE-NEXT:    stxvw4x 34, 3, 4
; P8-BE-NEXT:    stxvw4x 34, 0, 3
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: memsetTailV1B9:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    xxspltib 0, 15
; P9-BE-NEXT:    li 4, 9
; P9-BE-NEXT:    stxvx 0, 3, 4
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: memsetTailV1B9:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    xxspltib 0, 15
; P10-BE-NEXT:    pstxv 0, 9(3), 0
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: memsetTailV1B9:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    vspltisb 2, 15
; P8-LE-NEXT:    li 4, 9
; P8-LE-NEXT:    stxvd2x 34, 3, 4
; P8-LE-NEXT:    stxvd2x 34, 0, 3
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: memsetTailV1B9:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    xxspltib 0, 15
; P9-LE-NEXT:    li 4, 9
; P9-LE-NEXT:    stxvx 0, 3, 4
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: memsetTailV1B9:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    xxspltib 0, 15
; P10-LE-NEXT:    pstxv 0, 9(3), 0
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  tail call void @llvm.memset.p0.i64(ptr %p, i8 15, i64 25, i1 false)
  ret void
}

define dso_local void @memsetTailV1B8(ptr nocapture noundef writeonly %p) local_unnamed_addr {
; P8-BE-LABEL: memsetTailV1B8:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    vspltisb 2, 15
; P8-BE-NEXT:    li 4, 16
; P8-BE-NEXT:    stxsdx 34, 3, 4
; P8-BE-NEXT:    stxvw4x 34, 0, 3
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: memsetTailV1B8:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    xxspltib 0, 15
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    stfd 0, 16(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: memsetTailV1B8:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    xxspltib 0, 15
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    stfd 0, 16(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: memsetTailV1B8:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    vspltisb 2, 15
; P8-LE-NEXT:    li 4, 16
; P8-LE-NEXT:    stxsdx 34, 3, 4
; P8-LE-NEXT:    stxvd2x 34, 0, 3
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: memsetTailV1B8:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    xxspltib 0, 15
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    stfd 0, 16(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: memsetTailV1B8:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    xxspltib 0, 15
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    stfd 0, 16(3)
; P10-LE-NEXT:    blr
entry:
  tail call void @llvm.memset.p0.i64(ptr %p, i8 15, i64 24, i1 false)
  ret void
}

define dso_local void @memsetTailV1B7(ptr nocapture noundef writeonly %p) local_unnamed_addr {
; P8-BE-LABEL: memsetTailV1B7:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    vspltisb 2, 15
; P8-BE-NEXT:    li 4, 15
; P8-BE-NEXT:    stxsdx 34, 3, 4
; P8-BE-NEXT:    stxvw4x 34, 0, 3
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: memsetTailV1B7:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    xxspltib 0, 15
; P9-BE-NEXT:    stfd 0, 15(3)
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: memsetTailV1B7:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    xxspltib 0, 15
; P10-BE-NEXT:    stfd 0, 15(3)
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: memsetTailV1B7:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    vspltisb 2, 15
; P8-LE-NEXT:    li 4, 15
; P8-LE-NEXT:    stxsdx 34, 3, 4
; P8-LE-NEXT:    stxvd2x 34, 0, 3
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: memsetTailV1B7:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    xxspltib 0, 15
; P9-LE-NEXT:    stfd 0, 15(3)
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: memsetTailV1B7:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    xxspltib 0, 15
; P10-LE-NEXT:    stfd 0, 15(3)
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  tail call void @llvm.memset.p0.i64(ptr %p, i8 15, i64 23, i1 false)
  ret void
}

define dso_local void @memsetTailV1B4(ptr nocapture noundef writeonly %p) local_unnamed_addr {
; P8-BE-LABEL: memsetTailV1B4:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    vspltisb 2, 15
; P8-BE-NEXT:    li 4, 16
; P8-BE-NEXT:    stxsiwx 34, 3, 4
; P8-BE-NEXT:    stxvw4x 34, 0, 3
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: memsetTailV1B4:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    xxspltib 0, 15
; P9-BE-NEXT:    li 4, 16
; P9-BE-NEXT:    stfiwx 0, 3, 4
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: memsetTailV1B4:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    xxspltib 0, 15
; P10-BE-NEXT:    li 4, 16
; P10-BE-NEXT:    stfiwx 0, 3, 4
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: memsetTailV1B4:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    vspltisb 2, 15
; P8-LE-NEXT:    li 4, 16
; P8-LE-NEXT:    stxsiwx 34, 3, 4
; P8-LE-NEXT:    stxvd2x 34, 0, 3
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: memsetTailV1B4:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    xxspltib 0, 15
; P9-LE-NEXT:    li 4, 16
; P9-LE-NEXT:    stfiwx 0, 3, 4
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: memsetTailV1B4:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    xxspltib 0, 15
; P10-LE-NEXT:    li 4, 16
; P10-LE-NEXT:    stfiwx 0, 3, 4
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  tail call void @llvm.memset.p0.i32(ptr %p, i8 15, i32 20, i1 false)
  ret void
}

define dso_local void @memsetTailV1B3(ptr nocapture noundef writeonly %p) local_unnamed_addr {
; P8-BE-LABEL: memsetTailV1B3:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    vspltisb 2, 15
; P8-BE-NEXT:    li 4, 15
; P8-BE-NEXT:    stxsiwx 34, 3, 4
; P8-BE-NEXT:    stxvw4x 34, 0, 3
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: memsetTailV1B3:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    xxspltib 0, 15
; P9-BE-NEXT:    li 4, 15
; P9-BE-NEXT:    stfiwx 0, 3, 4
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: memsetTailV1B3:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    xxspltib 0, 15
; P10-BE-NEXT:    li 4, 15
; P10-BE-NEXT:    stfiwx 0, 3, 4
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: memsetTailV1B3:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    vspltisb 2, 15
; P8-LE-NEXT:    li 4, 15
; P8-LE-NEXT:    stxsiwx 34, 3, 4
; P8-LE-NEXT:    stxvd2x 34, 0, 3
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: memsetTailV1B3:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    xxspltib 0, 15
; P9-LE-NEXT:    li 4, 15
; P9-LE-NEXT:    stfiwx 0, 3, 4
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: memsetTailV1B3:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    xxspltib 0, 15
; P10-LE-NEXT:    li 4, 15
; P10-LE-NEXT:    stfiwx 0, 3, 4
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  tail call void @llvm.memset.p0.i64(ptr %p, i8 15, i64 19, i1 false)
  ret void
}

define dso_local void @memsetTailV1B2(ptr nocapture noundef writeonly %p) local_unnamed_addr {
; P8-BE-LABEL: memsetTailV1B2:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    vspltisb 2, 15
; P8-BE-NEXT:    li 4, 3855
; P8-BE-NEXT:    sth 4, 16(3)
; P8-BE-NEXT:    stxvw4x 34, 0, 3
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: memsetTailV1B2:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    li 4, 3855
; P9-BE-NEXT:    sth 4, 16(3)
; P9-BE-NEXT:    xxspltib 0, 15
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: memsetTailV1B2:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    li 4, 3855
; P10-BE-NEXT:    sth 4, 16(3)
; P10-BE-NEXT:    xxspltib 0, 15
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: memsetTailV1B2:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    vspltisb 2, 15
; P8-LE-NEXT:    li 4, 3855
; P8-LE-NEXT:    sth 4, 16(3)
; P8-LE-NEXT:    stxvd2x 34, 0, 3
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: memsetTailV1B2:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    li 4, 3855
; P9-LE-NEXT:    sth 4, 16(3)
; P9-LE-NEXT:    xxspltib 0, 15
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: memsetTailV1B2:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    li 4, 3855
; P10-LE-NEXT:    sth 4, 16(3)
; P10-LE-NEXT:    xxspltib 0, 15
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  tail call void @llvm.memset.p0.i64(ptr %p, i8 15, i64 18, i1 false)
  ret void
}

define dso_local void @memsetTailV1B1(ptr nocapture noundef writeonly %p) local_unnamed_addr {
; P8-BE-LABEL: memsetTailV1B1:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    vspltisb 2, 15
; P8-BE-NEXT:    li 4, 15
; P8-BE-NEXT:    stb 4, 16(3)
; P8-BE-NEXT:    stxvw4x 34, 0, 3
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: memsetTailV1B1:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    li 4, 15
; P9-BE-NEXT:    stb 4, 16(3)
; P9-BE-NEXT:    xxspltib 0, 15
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: memsetTailV1B1:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    li 4, 15
; P10-BE-NEXT:    stb 4, 16(3)
; P10-BE-NEXT:    xxspltib 0, 15
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: memsetTailV1B1:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    vspltisb 2, 15
; P8-LE-NEXT:    li 4, 15
; P8-LE-NEXT:    stb 4, 16(3)
; P8-LE-NEXT:    stxvd2x 34, 0, 3
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: memsetTailV1B1:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    li 4, 15
; P9-LE-NEXT:    stb 4, 16(3)
; P9-LE-NEXT:    xxspltib 0, 15
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: memsetTailV1B1:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    li 4, 15
; P10-LE-NEXT:    stb 4, 16(3)
; P10-LE-NEXT:    xxspltib 0, 15
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  tail call void @llvm.memset.p0.i64(ptr %p, i8 15, i64 17, i1 false)
  ret void
}

define dso_local void @memset2TailV1B15(ptr nocapture noundef writeonly %p) local_unnamed_addr {
; P8-BE-LABEL: memset2TailV1B15:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    ld 4, L..C0(2) # %const.0
; P8-BE-NEXT:    lxvw4x 0, 0, 4
; P8-BE-NEXT:    li 4, 15
; P8-BE-NEXT:    stxvw4x 0, 3, 4
; P8-BE-NEXT:    stxvw4x 0, 0, 3
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: memset2TailV1B15:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    xxspltib 0, 165
; P9-BE-NEXT:    li 4, 15
; P9-BE-NEXT:    stxvx 0, 3, 4
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: memset2TailV1B15:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    xxspltib 0, 165
; P10-BE-NEXT:    pstxv 0, 15(3), 0
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: memset2TailV1B15:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    addis 4, 2, .LCPI9_0@toc@ha
; P8-LE-NEXT:    addi 4, 4, .LCPI9_0@toc@l
; P8-LE-NEXT:    lxvd2x 0, 0, 4
; P8-LE-NEXT:    li 4, 15
; P8-LE-NEXT:    stxvd2x 0, 3, 4
; P8-LE-NEXT:    stxvd2x 0, 0, 3
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: memset2TailV1B15:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    xxspltib 0, 165
; P9-LE-NEXT:    li 4, 15
; P9-LE-NEXT:    stxvx 0, 3, 4
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: memset2TailV1B15:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    xxspltib 0, 165
; P10-LE-NEXT:    pstxv 0, 15(3), 0
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  tail call void @llvm.memset.p0.i64(ptr %p, i8 165, i64 31, i1 false)
  ret void
}

define dso_local void @memset2TailV1B12(ptr nocapture noundef writeonly %p) local_unnamed_addr {
; P8-BE-LABEL: memset2TailV1B12:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    ld 4, L..C1(2) # %const.0
; P8-BE-NEXT:    lxvw4x 0, 0, 4
; P8-BE-NEXT:    li 4, 12
; P8-BE-NEXT:    stxvw4x 0, 3, 4
; P8-BE-NEXT:    stxvw4x 0, 0, 3
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: memset2TailV1B12:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    xxspltib 0, 165
; P9-BE-NEXT:    li 4, 12
; P9-BE-NEXT:    stxvx 0, 3, 4
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: memset2TailV1B12:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    xxspltib 0, 165
; P10-BE-NEXT:    pstxv 0, 12(3), 0
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: memset2TailV1B12:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    addis 4, 2, .LCPI10_0@toc@ha
; P8-LE-NEXT:    addi 4, 4, .LCPI10_0@toc@l
; P8-LE-NEXT:    lxvd2x 0, 0, 4
; P8-LE-NEXT:    li 4, 12
; P8-LE-NEXT:    stxvd2x 0, 3, 4
; P8-LE-NEXT:    stxvd2x 0, 0, 3
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: memset2TailV1B12:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    xxspltib 0, 165
; P9-LE-NEXT:    li 4, 12
; P9-LE-NEXT:    stxvx 0, 3, 4
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: memset2TailV1B12:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    xxspltib 0, 165
; P10-LE-NEXT:    pstxv 0, 12(3), 0
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  tail call void @llvm.memset.p0.i64(ptr %p, i8 165, i64 28, i1 false)
  ret void
}

define dso_local void @memset2TailV1B9(ptr nocapture noundef writeonly %p) local_unnamed_addr {
; P8-BE-LABEL: memset2TailV1B9:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    ld 4, L..C2(2) # %const.0
; P8-BE-NEXT:    lxvw4x 0, 0, 4
; P8-BE-NEXT:    li 4, 9
; P8-BE-NEXT:    stxvw4x 0, 3, 4
; P8-BE-NEXT:    stxvw4x 0, 0, 3
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: memset2TailV1B9:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    xxspltib 0, 165
; P9-BE-NEXT:    li 4, 9
; P9-BE-NEXT:    stxvx 0, 3, 4
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: memset2TailV1B9:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    xxspltib 0, 165
; P10-BE-NEXT:    pstxv 0, 9(3), 0
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: memset2TailV1B9:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    addis 4, 2, .LCPI11_0@toc@ha
; P8-LE-NEXT:    addi 4, 4, .LCPI11_0@toc@l
; P8-LE-NEXT:    lxvd2x 0, 0, 4
; P8-LE-NEXT:    li 4, 9
; P8-LE-NEXT:    stxvd2x 0, 3, 4
; P8-LE-NEXT:    stxvd2x 0, 0, 3
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: memset2TailV1B9:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    xxspltib 0, 165
; P9-LE-NEXT:    li 4, 9
; P9-LE-NEXT:    stxvx 0, 3, 4
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: memset2TailV1B9:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    xxspltib 0, 165
; P10-LE-NEXT:    pstxv 0, 9(3), 0
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  tail call void @llvm.memset.p0.i64(ptr %p, i8 165, i64 25, i1 false)
  ret void
}

define dso_local void @memset2TailV1B8(ptr nocapture noundef writeonly %p) local_unnamed_addr {
; P8-BE-LABEL: memset2TailV1B8:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    ld 4, L..C3(2) # %const.0
; P8-BE-NEXT:    lxvw4x 0, 0, 4
; P8-BE-NEXT:    stfd 0, 16(3)
; P8-BE-NEXT:    stxvw4x 0, 0, 3
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: memset2TailV1B8:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    xxspltib 0, 165
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    stfd 0, 16(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: memset2TailV1B8:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    xxspltib 0, 165
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    stfd 0, 16(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: memset2TailV1B8:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    addis 4, 2, .LCPI12_0@toc@ha
; P8-LE-NEXT:    addi 4, 4, .LCPI12_0@toc@l
; P8-LE-NEXT:    lxvd2x 0, 0, 4
; P8-LE-NEXT:    stfd 0, 16(3)
; P8-LE-NEXT:    stxvd2x 0, 0, 3
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: memset2TailV1B8:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    xxspltib 0, 165
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    stfd 0, 16(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: memset2TailV1B8:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    xxspltib 0, 165
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    stfd 0, 16(3)
; P10-LE-NEXT:    blr
entry:
  tail call void @llvm.memset.p0.i64(ptr %p, i8 165, i64 24, i1 false)
  ret void
}

define dso_local void @memset2TailV1B7(ptr nocapture noundef writeonly %p) local_unnamed_addr {
; P8-BE-LABEL: memset2TailV1B7:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    ld 4, L..C4(2) # %const.0
; P8-BE-NEXT:    lxvw4x 0, 0, 4
; P8-BE-NEXT:    stfd 0, 15(3)
; P8-BE-NEXT:    stxvw4x 0, 0, 3
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: memset2TailV1B7:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    xxspltib 0, 165
; P9-BE-NEXT:    stfd 0, 15(3)
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: memset2TailV1B7:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    xxspltib 0, 165
; P10-BE-NEXT:    stfd 0, 15(3)
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: memset2TailV1B7:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    addis 4, 2, .LCPI13_0@toc@ha
; P8-LE-NEXT:    addi 4, 4, .LCPI13_0@toc@l
; P8-LE-NEXT:    lxvd2x 0, 0, 4
; P8-LE-NEXT:    stfd 0, 15(3)
; P8-LE-NEXT:    stxvd2x 0, 0, 3
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: memset2TailV1B7:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    xxspltib 0, 165
; P9-LE-NEXT:    stfd 0, 15(3)
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: memset2TailV1B7:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    xxspltib 0, 165
; P10-LE-NEXT:    stfd 0, 15(3)
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  tail call void @llvm.memset.p0.i64(ptr %p, i8 165, i64 23, i1 false)
  ret void
}

define dso_local void @memset2TailV1B4(ptr nocapture noundef writeonly %p) local_unnamed_addr {
; P8-BE-LABEL: memset2TailV1B4:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    ld 4, L..C5(2) # %const.0
; P8-BE-NEXT:    lxvw4x 0, 0, 4
; P8-BE-NEXT:    li 4, 16
; P8-BE-NEXT:    stfiwx 0, 3, 4
; P8-BE-NEXT:    stxvw4x 0, 0, 3
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: memset2TailV1B4:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    xxspltib 0, 165
; P9-BE-NEXT:    li 4, 16
; P9-BE-NEXT:    stfiwx 0, 3, 4
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: memset2TailV1B4:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    xxspltib 0, 165
; P10-BE-NEXT:    li 4, 16
; P10-BE-NEXT:    stfiwx 0, 3, 4
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: memset2TailV1B4:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    addis 4, 2, .LCPI14_0@toc@ha
; P8-LE-NEXT:    addi 4, 4, .LCPI14_0@toc@l
; P8-LE-NEXT:    lxvd2x 0, 0, 4
; P8-LE-NEXT:    li 4, 16
; P8-LE-NEXT:    stfiwx 0, 3, 4
; P8-LE-NEXT:    stxvd2x 0, 0, 3
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: memset2TailV1B4:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    xxspltib 0, 165
; P9-LE-NEXT:    li 4, 16
; P9-LE-NEXT:    stfiwx 0, 3, 4
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: memset2TailV1B4:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    xxspltib 0, 165
; P10-LE-NEXT:    li 4, 16
; P10-LE-NEXT:    stfiwx 0, 3, 4
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  tail call void @llvm.memset.p0.i32(ptr %p, i8 165, i32 20, i1 false)
  ret void
}

define dso_local void @memset2TailV1B3(ptr nocapture noundef writeonly %p) local_unnamed_addr {
; P8-BE-LABEL: memset2TailV1B3:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    ld 4, L..C6(2) # %const.0
; P8-BE-NEXT:    lxvw4x 0, 0, 4
; P8-BE-NEXT:    li 4, 15
; P8-BE-NEXT:    stfiwx 0, 3, 4
; P8-BE-NEXT:    stxvw4x 0, 0, 3
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: memset2TailV1B3:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    xxspltib 0, 165
; P9-BE-NEXT:    li 4, 15
; P9-BE-NEXT:    stfiwx 0, 3, 4
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: memset2TailV1B3:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    xxspltib 0, 165
; P10-BE-NEXT:    li 4, 15
; P10-BE-NEXT:    stfiwx 0, 3, 4
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: memset2TailV1B3:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    addis 4, 2, .LCPI15_0@toc@ha
; P8-LE-NEXT:    addi 4, 4, .LCPI15_0@toc@l
; P8-LE-NEXT:    lxvd2x 0, 0, 4
; P8-LE-NEXT:    li 4, 15
; P8-LE-NEXT:    stfiwx 0, 3, 4
; P8-LE-NEXT:    stxvd2x 0, 0, 3
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: memset2TailV1B3:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    xxspltib 0, 165
; P9-LE-NEXT:    li 4, 15
; P9-LE-NEXT:    stfiwx 0, 3, 4
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: memset2TailV1B3:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    xxspltib 0, 165
; P10-LE-NEXT:    li 4, 15
; P10-LE-NEXT:    stfiwx 0, 3, 4
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  tail call void @llvm.memset.p0.i64(ptr %p, i8 165, i64 19, i1 false)
  ret void
}

define dso_local void @memset2TailV1B2(ptr nocapture noundef writeonly %p) local_unnamed_addr {
; P8-BE-LABEL: memset2TailV1B2:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    li 4, -23131
; P8-BE-NEXT:    sth 4, 16(3)
; P8-BE-NEXT:    ld 4, L..C7(2) # %const.0
; P8-BE-NEXT:    lxvw4x 0, 0, 4
; P8-BE-NEXT:    stxvw4x 0, 0, 3
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: memset2TailV1B2:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    li 4, -23131
; P9-BE-NEXT:    sth 4, 16(3)
; P9-BE-NEXT:    xxspltib 0, 165
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: memset2TailV1B2:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    li 4, -23131
; P10-BE-NEXT:    sth 4, 16(3)
; P10-BE-NEXT:    xxspltib 0, 165
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: memset2TailV1B2:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    li 4, -23131
; P8-LE-NEXT:    sth 4, 16(3)
; P8-LE-NEXT:    addis 4, 2, .LCPI16_0@toc@ha
; P8-LE-NEXT:    addi 4, 4, .LCPI16_0@toc@l
; P8-LE-NEXT:    lxvd2x 0, 0, 4
; P8-LE-NEXT:    stxvd2x 0, 0, 3
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: memset2TailV1B2:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    li 4, -23131
; P9-LE-NEXT:    sth 4, 16(3)
; P9-LE-NEXT:    xxspltib 0, 165
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: memset2TailV1B2:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    li 4, -23131
; P10-LE-NEXT:    sth 4, 16(3)
; P10-LE-NEXT:    xxspltib 0, 165
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  tail call void @llvm.memset.p0.i64(ptr %p, i8 165, i64 18, i1 false)
  ret void
}

define dso_local void @memset2TailV1B1(ptr nocapture noundef writeonly %p) local_unnamed_addr {
; P8-BE-LABEL: memset2TailV1B1:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    li 4, -91
; P8-BE-NEXT:    stb 4, 16(3)
; P8-BE-NEXT:    ld 4, L..C8(2) # %const.0
; P8-BE-NEXT:    lxvw4x 0, 0, 4
; P8-BE-NEXT:    stxvw4x 0, 0, 3
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: memset2TailV1B1:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    li 4, -91
; P9-BE-NEXT:    stb 4, 16(3)
; P9-BE-NEXT:    xxspltib 0, 165
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: memset2TailV1B1:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    li 4, -91
; P10-BE-NEXT:    stb 4, 16(3)
; P10-BE-NEXT:    xxspltib 0, 165
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: memset2TailV1B1:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    li 4, -91
; P8-LE-NEXT:    stb 4, 16(3)
; P8-LE-NEXT:    addis 4, 2, .LCPI17_0@toc@ha
; P8-LE-NEXT:    addi 4, 4, .LCPI17_0@toc@l
; P8-LE-NEXT:    lxvd2x 0, 0, 4
; P8-LE-NEXT:    stxvd2x 0, 0, 3
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: memset2TailV1B1:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    li 4, -91
; P9-LE-NEXT:    stb 4, 16(3)
; P9-LE-NEXT:    xxspltib 0, 165
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: memset2TailV1B1:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    li 4, -91
; P10-LE-NEXT:    stb 4, 16(3)
; P10-LE-NEXT:    xxspltib 0, 165
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  tail call void @llvm.memset.p0.i64(ptr %p, i8 165, i64 17, i1 false)
  ret void
}

define dso_local void @memsetTailV0B15(ptr nocapture noundef writeonly %p) local_unnamed_addr {
; P8-BE-LABEL: memsetTailV0B15:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    lis 4, 3855
; P8-BE-NEXT:    li 5, 7
; P8-BE-NEXT:    ori 4, 4, 3855
; P8-BE-NEXT:    rldimi 4, 4, 32, 0
; P8-BE-NEXT:    stdx 4, 3, 5
; P8-BE-NEXT:    std 4, 0(3)
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: memsetTailV0B15:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    lis 4, 3855
; P9-BE-NEXT:    li 5, 7
; P9-BE-NEXT:    ori 4, 4, 3855
; P9-BE-NEXT:    rldimi 4, 4, 32, 0
; P9-BE-NEXT:    stdx 4, 3, 5
; P9-BE-NEXT:    std 4, 0(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: memsetTailV0B15:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    pli 4, 252645135
; P10-BE-NEXT:    rldimi 4, 4, 32, 0
; P10-BE-NEXT:    pstd 4, 7(3), 0
; P10-BE-NEXT:    std 4, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: memsetTailV0B15:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    lis 4, 3855
; P8-LE-NEXT:    li 5, 7
; P8-LE-NEXT:    ori 4, 4, 3855
; P8-LE-NEXT:    rldimi 4, 4, 32, 0
; P8-LE-NEXT:    stdx 4, 3, 5
; P8-LE-NEXT:    std 4, 0(3)
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: memsetTailV0B15:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    lis 4, 3855
; P9-LE-NEXT:    li 5, 7
; P9-LE-NEXT:    ori 4, 4, 3855
; P9-LE-NEXT:    rldimi 4, 4, 32, 0
; P9-LE-NEXT:    stdx 4, 3, 5
; P9-LE-NEXT:    std 4, 0(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: memsetTailV0B15:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    pli 4, 252645135
; P10-LE-NEXT:    rldimi 4, 4, 32, 0
; P10-LE-NEXT:    pstd 4, 7(3), 0
; P10-LE-NEXT:    std 4, 0(3)
; P10-LE-NEXT:    blr
entry:
  tail call void @llvm.memset.p0.i64(ptr %p, i8 15, i64 15, i1 false)
  ret void
}

define dso_local void @memsetTailV0B12(ptr nocapture noundef writeonly %p) local_unnamed_addr {
; P8-BE-LABEL: memsetTailV0B12:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    lis 4, 3855
; P8-BE-NEXT:    ori 4, 4, 3855
; P8-BE-NEXT:    rldimi 4, 4, 32, 0
; P8-BE-NEXT:    stw 4, 8(3)
; P8-BE-NEXT:    std 4, 0(3)
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: memsetTailV0B12:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    lis 4, 3855
; P9-BE-NEXT:    ori 4, 4, 3855
; P9-BE-NEXT:    rldimi 4, 4, 32, 0
; P9-BE-NEXT:    stw 4, 8(3)
; P9-BE-NEXT:    std 4, 0(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: memsetTailV0B12:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    pli 4, 252645135
; P10-BE-NEXT:    rldimi 4, 4, 32, 0
; P10-BE-NEXT:    stw 4, 8(3)
; P10-BE-NEXT:    std 4, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: memsetTailV0B12:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    lis 4, 3855
; P8-LE-NEXT:    ori 4, 4, 3855
; P8-LE-NEXT:    rldimi 4, 4, 32, 0
; P8-LE-NEXT:    stw 4, 8(3)
; P8-LE-NEXT:    std 4, 0(3)
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: memsetTailV0B12:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    lis 4, 3855
; P9-LE-NEXT:    ori 4, 4, 3855
; P9-LE-NEXT:    rldimi 4, 4, 32, 0
; P9-LE-NEXT:    stw 4, 8(3)
; P9-LE-NEXT:    std 4, 0(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: memsetTailV0B12:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    pli 4, 252645135
; P10-LE-NEXT:    rldimi 4, 4, 32, 0
; P10-LE-NEXT:    stw 4, 8(3)
; P10-LE-NEXT:    std 4, 0(3)
; P10-LE-NEXT:    blr
entry:
  tail call void @llvm.memset.p0.i64(ptr %p, i8 15, i64 12, i1 false)
  ret void
}

define dso_local void @memsetTailV0B9(ptr nocapture noundef writeonly %p) local_unnamed_addr {
; P8-BE-LABEL: memsetTailV0B9:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    li 4, 15
; P8-BE-NEXT:    stb 4, 8(3)
; P8-BE-NEXT:    lis 4, 3855
; P8-BE-NEXT:    ori 4, 4, 3855
; P8-BE-NEXT:    rldimi 4, 4, 32, 0
; P8-BE-NEXT:    std 4, 0(3)
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: memsetTailV0B9:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    li 4, 15
; P9-BE-NEXT:    stb 4, 8(3)
; P9-BE-NEXT:    lis 4, 3855
; P9-BE-NEXT:    ori 4, 4, 3855
; P9-BE-NEXT:    rldimi 4, 4, 32, 0
; P9-BE-NEXT:    std 4, 0(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: memsetTailV0B9:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    li 4, 15
; P10-BE-NEXT:    stb 4, 8(3)
; P10-BE-NEXT:    pli 4, 252645135
; P10-BE-NEXT:    rldimi 4, 4, 32, 0
; P10-BE-NEXT:    std 4, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: memsetTailV0B9:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    li 4, 15
; P8-LE-NEXT:    stb 4, 8(3)
; P8-LE-NEXT:    lis 4, 3855
; P8-LE-NEXT:    ori 4, 4, 3855
; P8-LE-NEXT:    rldimi 4, 4, 32, 0
; P8-LE-NEXT:    std 4, 0(3)
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: memsetTailV0B9:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    li 4, 15
; P9-LE-NEXT:    stb 4, 8(3)
; P9-LE-NEXT:    lis 4, 3855
; P9-LE-NEXT:    ori 4, 4, 3855
; P9-LE-NEXT:    rldimi 4, 4, 32, 0
; P9-LE-NEXT:    std 4, 0(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: memsetTailV0B9:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    li 4, 15
; P10-LE-NEXT:    stb 4, 8(3)
; P10-LE-NEXT:    pli 4, 252645135
; P10-LE-NEXT:    rldimi 4, 4, 32, 0
; P10-LE-NEXT:    std 4, 0(3)
; P10-LE-NEXT:    blr
entry:
  tail call void @llvm.memset.p0.i64(ptr %p, i8 15, i64 9, i1 false)
  ret void
}

define dso_local void @memsetTailV0B8(ptr nocapture noundef writeonly %p) local_unnamed_addr {
; P8-BE-LABEL: memsetTailV0B8:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    lis 4, 3855
; P8-BE-NEXT:    ori 4, 4, 3855
; P8-BE-NEXT:    rldimi 4, 4, 32, 0
; P8-BE-NEXT:    std 4, 0(3)
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: memsetTailV0B8:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    lis 4, 3855
; P9-BE-NEXT:    ori 4, 4, 3855
; P9-BE-NEXT:    rldimi 4, 4, 32, 0
; P9-BE-NEXT:    std 4, 0(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: memsetTailV0B8:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    pli 4, 252645135
; P10-BE-NEXT:    rldimi 4, 4, 32, 0
; P10-BE-NEXT:    std 4, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: memsetTailV0B8:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    lis 4, 3855
; P8-LE-NEXT:    ori 4, 4, 3855
; P8-LE-NEXT:    rldimi 4, 4, 32, 0
; P8-LE-NEXT:    std 4, 0(3)
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: memsetTailV0B8:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    lis 4, 3855
; P9-LE-NEXT:    ori 4, 4, 3855
; P9-LE-NEXT:    rldimi 4, 4, 32, 0
; P9-LE-NEXT:    std 4, 0(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: memsetTailV0B8:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    pli 4, 252645135
; P10-LE-NEXT:    rldimi 4, 4, 32, 0
; P10-LE-NEXT:    std 4, 0(3)
; P10-LE-NEXT:    blr
entry:
  tail call void @llvm.memset.p0.i64(ptr %p, i8 15, i64 8, i1 false)
  ret void
}

define dso_local void @memsetTailV0B7(ptr nocapture noundef writeonly %p) local_unnamed_addr {
; P8-BE-LABEL: memsetTailV0B7:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    lis 4, 3855
; P8-BE-NEXT:    ori 4, 4, 3855
; P8-BE-NEXT:    stw 4, 3(3)
; P8-BE-NEXT:    stw 4, 0(3)
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: memsetTailV0B7:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    lis 4, 3855
; P9-BE-NEXT:    ori 4, 4, 3855
; P9-BE-NEXT:    stw 4, 3(3)
; P9-BE-NEXT:    stw 4, 0(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: memsetTailV0B7:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    pli 4, 252645135
; P10-BE-NEXT:    stw 4, 3(3)
; P10-BE-NEXT:    stw 4, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: memsetTailV0B7:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    lis 4, 3855
; P8-LE-NEXT:    ori 4, 4, 3855
; P8-LE-NEXT:    stw 4, 3(3)
; P8-LE-NEXT:    stw 4, 0(3)
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: memsetTailV0B7:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    lis 4, 3855
; P9-LE-NEXT:    ori 4, 4, 3855
; P9-LE-NEXT:    stw 4, 3(3)
; P9-LE-NEXT:    stw 4, 0(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: memsetTailV0B7:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    pli 4, 252645135
; P10-LE-NEXT:    stw 4, 3(3)
; P10-LE-NEXT:    stw 4, 0(3)
; P10-LE-NEXT:    blr
entry:
  tail call void @llvm.memset.p0.i64(ptr %p, i8 15, i64 7, i1 false)
  ret void
}

define dso_local void @memsetTailV0B5(ptr nocapture noundef writeonly %p) local_unnamed_addr {
; P8-BE-LABEL: memsetTailV0B5:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    li 4, 15
; P8-BE-NEXT:    stb 4, 4(3)
; P8-BE-NEXT:    lis 4, 3855
; P8-BE-NEXT:    ori 4, 4, 3855
; P8-BE-NEXT:    stw 4, 0(3)
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: memsetTailV0B5:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    li 4, 15
; P9-BE-NEXT:    stb 4, 4(3)
; P9-BE-NEXT:    lis 4, 3855
; P9-BE-NEXT:    ori 4, 4, 3855
; P9-BE-NEXT:    stw 4, 0(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: memsetTailV0B5:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    li 4, 15
; P10-BE-NEXT:    stb 4, 4(3)
; P10-BE-NEXT:    pli 4, 252645135
; P10-BE-NEXT:    stw 4, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: memsetTailV0B5:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    li 4, 15
; P8-LE-NEXT:    stb 4, 4(3)
; P8-LE-NEXT:    lis 4, 3855
; P8-LE-NEXT:    ori 4, 4, 3855
; P8-LE-NEXT:    stw 4, 0(3)
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: memsetTailV0B5:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    li 4, 15
; P9-LE-NEXT:    stb 4, 4(3)
; P9-LE-NEXT:    lis 4, 3855
; P9-LE-NEXT:    ori 4, 4, 3855
; P9-LE-NEXT:    stw 4, 0(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: memsetTailV0B5:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    li 4, 15
; P10-LE-NEXT:    stb 4, 4(3)
; P10-LE-NEXT:    pli 4, 252645135
; P10-LE-NEXT:    stw 4, 0(3)
; P10-LE-NEXT:    blr
entry:
  tail call void @llvm.memset.p0.i32(ptr %p, i8 15, i32 5, i1 false)
  ret void
}

define dso_local void @memsetTailV0B4(ptr nocapture noundef writeonly %p) local_unnamed_addr {
; P8-BE-LABEL: memsetTailV0B4:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    lis 4, 3855
; P8-BE-NEXT:    ori 4, 4, 3855
; P8-BE-NEXT:    stw 4, 0(3)
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: memsetTailV0B4:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    lis 4, 3855
; P9-BE-NEXT:    ori 4, 4, 3855
; P9-BE-NEXT:    stw 4, 0(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: memsetTailV0B4:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    pli 4, 252645135
; P10-BE-NEXT:    stw 4, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: memsetTailV0B4:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    lis 4, 3855
; P8-LE-NEXT:    ori 4, 4, 3855
; P8-LE-NEXT:    stw 4, 0(3)
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: memsetTailV0B4:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    lis 4, 3855
; P9-LE-NEXT:    ori 4, 4, 3855
; P9-LE-NEXT:    stw 4, 0(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: memsetTailV0B4:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    pli 4, 252645135
; P10-LE-NEXT:    stw 4, 0(3)
; P10-LE-NEXT:    blr
entry:
  tail call void @llvm.memset.p0.i32(ptr %p, i8 15, i32 4, i1 false)
  ret void
}

define dso_local void @memsetTailV0B1(ptr nocapture noundef writeonly %p) local_unnamed_addr {
; P8-BE-LABEL: memsetTailV0B1:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    li 4, -91
; P8-BE-NEXT:    stb 4, 0(3)
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: memsetTailV0B1:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    li 4, -91
; P9-BE-NEXT:    stb 4, 0(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: memsetTailV0B1:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    li 4, -91
; P10-BE-NEXT:    stb 4, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: memsetTailV0B1:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    li 4, -91
; P8-LE-NEXT:    stb 4, 0(3)
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: memsetTailV0B1:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    li 4, -91
; P9-LE-NEXT:    stb 4, 0(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: memsetTailV0B1:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    li 4, -91
; P10-LE-NEXT:    stb 4, 0(3)
; P10-LE-NEXT:    blr
entry:
  tail call void @llvm.memset.p0.i64(ptr %p, i8 165, i64 1, i1 false)
  ret void
}

declare void @llvm.memset.p0.i32(ptr nocapture writeonly, i8, i32, i1 immarg)
declare void @llvm.memset.p0.i64(ptr nocapture writeonly, i8, i64, i1 immarg)
