; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -amdgpu-enable-delay-alu=0 -global-isel=1 -verify-machineinstrs < %s | FileCheck  -check-prefixes=GFX11 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -amdgpu-enable-delay-alu=0 -global-isel=0 -verify-machineinstrs < %s | FileCheck  -check-prefixes=GFX11 %s

declare i64 @llvm.amdgcn.s.bitreplicate(i32)

define i64 @test_s_bitreplicate_constant() {
; GFX11-LABEL: test_s_bitreplicate_constant:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v0, 0xfccc30c
; GFX11-NEXT:    v_mov_b32_e32 v1, 0xc033fffc
; GFX11-NEXT:    s_setpc_b64 s[30:31]
entry:
  %br = call i64 @llvm.amdgcn.s.bitreplicate(i32 u0x85FE3A92)
  ret i64 %br
}

define i64 @test_s_bitreplicate_constant_zero() {
; GFX11-LABEL: test_s_bitreplicate_constant_zero:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
entry:
  %br = call i64 @llvm.amdgcn.s.bitreplicate(i32 0)
  ret i64 %br
}

define i64 @test_s_bitreplicate_constant_neg_one() {
; GFX11-LABEL: test_s_bitreplicate_constant_neg_one:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v0, -1 :: v_dual_mov_b32 v1, -1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
entry:
  %br = call i64 @llvm.amdgcn.s.bitreplicate(i32 -1)
  ret i64 %br
}

define i64 @test_s_bitreplicate_constant_undef() {
; GFX11-LABEL: test_s_bitreplicate_constant_undef:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_bitreplicate_b64_b32 s[0:1], s0
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
entry:
  %br = call i64 @llvm.amdgcn.s.bitreplicate(i32 undef)
  ret i64 %br
}

define i64 @test_s_bitreplicate_constant_poison() {
; GFX11-LABEL: test_s_bitreplicate_constant_poison:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_bitreplicate_b64_b32 s[0:1], s0
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
entry:
  %br = call i64 @llvm.amdgcn.s.bitreplicate(i32 poison)
  ret i64 %br
}

define amdgpu_cs void @test_s_bitreplicate_sgpr(i32 inreg %mask, ptr addrspace(1) %out) {
; GFX11-LABEL: test_s_bitreplicate_sgpr:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_bitreplicate_b64_b32 s[0:1], s0
; GFX11-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX11-NEXT:    global_store_b64 v[0:1], v[2:3], off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
entry:
  %br = call i64 @llvm.amdgcn.s.bitreplicate(i32 %mask)
  store i64 %br, ptr addrspace(1) %out
  ret void
}

define i64 @test_s_bitreplicate_vgpr(i32 %mask) {
; GFX11-LABEL: test_s_bitreplicate_vgpr:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_readfirstlane_b32 s0, v0
; GFX11-NEXT:    s_bitreplicate_b64_b32 s[0:1], s0
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
entry:
  %br = call i64 @llvm.amdgcn.s.bitreplicate(i32 %mask)
  ret i64 %br
}
