; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --force-update
; RUN: llc -march=amdgcn -amdgpu-atomic-optimizations=true -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX7LESS %s
; RUN: llc -march=amdgcn -mcpu=tonga -mattr=-flat-for-global -amdgpu-atomic-optimizations=true -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX8 %s
; RUN: llc -march=amdgcn -mcpu=gfx900 -mattr=-flat-for-global -amdgpu-atomic-optimizations=true -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX9 %s
; RUN: llc -march=amdgcn -mcpu=gfx1010 -mattr=-wavefrontsize32,+wavefrontsize64 -mattr=-flat-for-global -amdgpu-atomic-optimizations=true -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX10,GFX1064 %s
; RUN: llc -march=amdgcn -mcpu=gfx1010 -mattr=+wavefrontsize32,-wavefrontsize64 -mattr=-flat-for-global -amdgpu-atomic-optimizations=true -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX10,GFX1032 %s
; RUN: llc -march=amdgcn -mcpu=gfx1100 -mattr=-wavefrontsize32,+wavefrontsize64 -mattr=-flat-for-global -amdgpu-atomic-optimizations=true -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX11,GFX1164 %s
; RUN: llc -march=amdgcn -mcpu=gfx1100 -mattr=+wavefrontsize32,-wavefrontsize64 -mattr=-flat-for-global -amdgpu-atomic-optimizations=true -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX11,GFX1132 %s

declare i32 @llvm.amdgcn.workitem.id.x()

@local_var32 = addrspace(3) global i32 undef, align 4
@local_var64 = addrspace(3) global i64 undef, align 8

; Show what the atomic optimization pass will do for local pointers.

define amdgpu_kernel void @add_i32_constant(i32 addrspace(1)* %out) {
;
;
; GFX7LESS-LABEL: add_i32_constant:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_mov_b64 s[2:3], exec
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s2, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s3, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    ; implicit-def: $vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB0_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX7LESS-NEXT:    s_mul_i32 s2, s2, 5
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, s2
; GFX7LESS-NEXT:    s_mov_b32 m0, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    ds_add_rtn_u32 v1, v1, v2
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:  .LBB0_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    v_readfirstlane_b32 s2, v1
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    v_mad_u32_u24 v0, v0, 5, s2
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: add_i32_constant:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX8-NEXT:    s_mov_b64 s[2:3], exec
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8-NEXT:    ; implicit-def: $vgpr1
; GFX8-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB0_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX8-NEXT:    s_mul_i32 s2, s2, 5
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    ds_add_rtn_u32 v1, v1, v2
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:  .LBB0_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_readfirstlane_b32 s2, v1
; GFX8-NEXT:    v_mad_u32_u24 v0, v0, 5, s2
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: add_i32_constant:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    s_mov_b64 s[2:3], exec
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    ; implicit-def: $vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB0_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX9-NEXT:    s_mul_i32 s2, s2, 5
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    ds_add_rtn_u32 v1, v1, v2
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:  .LBB0_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_readfirstlane_b32 s2, v1
; GFX9-NEXT:    v_mad_u32_u24 v0, v0, 5, s2
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: add_i32_constant:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX1064-NEXT:    s_mov_b64 s[2:3], exec
; GFX1064-NEXT:    ; implicit-def: $vgpr1
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB0_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-NEXT:    s_mul_i32 s2, s2, 5
; GFX1064-NEXT:    v_mov_b32_e32 v2, s2
; GFX1064-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1064-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1064-NEXT:    ds_add_rtn_u32 v1, v1, v2
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:  .LBB0_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    v_mad_u32_u24 v0, v0, 5, s2
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: add_i32_constant:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX1032-NEXT:    s_mov_b32 s3, exec_lo
; GFX1032-NEXT:    ; implicit-def: $vgpr1
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, s3, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s2, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB0_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s3, s3
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-NEXT:    s_mul_i32 s3, s3, 5
; GFX1032-NEXT:    v_mov_b32_e32 v2, s3
; GFX1032-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1032-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1032-NEXT:    ds_add_rtn_u32 v1, v1, v2
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:  .LBB0_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s2
; GFX1032-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    v_mad_u32_u24 v0, v0, 5, s2
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: add_i32_constant:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX1164-NEXT:    s_mov_b64 s[2:3], exec
; GFX1164-NEXT:    s_mov_b64 s[4:5], exec
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX1164-NEXT:    ; implicit-def: $vgpr1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_cbranch_execz .LBB0_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-NEXT:    s_mul_i32 s2, s2, 5
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    v_mov_b32_e32 v2, s2
; GFX1164-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1164-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1164-NEXT:    ds_add_rtn_u32 v1, v1, v2
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:  .LBB0_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1164-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_mad_u32_u24 v0, v0, 5, s2
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1164-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: add_i32_constant:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX1132-NEXT:    s_mov_b32 s3, exec_lo
; GFX1132-NEXT:    s_mov_b32 s2, exec_lo
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, s3, 0
; GFX1132-NEXT:    ; implicit-def: $vgpr1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_cbranch_execz .LBB0_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_bcnt1_i32_b32 s3, s3
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1132-NEXT:    s_mul_i32 s3, s3, 5
; GFX1132-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v2, s3
; GFX1132-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1132-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1132-NEXT:    ds_add_rtn_u32 v1, v1, v2
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:  .LBB0_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s2
; GFX1132-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_mad_u32_u24 v0, v0, 5, s2
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1132-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1132-NEXT:    s_endpgm
entry:
  %old = atomicrmw add i32 addrspace(3)* @local_var32, i32 5 acq_rel
  store i32 %old, i32 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @add_i32_uniform(i32 addrspace(1)* %out, i32 %additive) {
;
;
; GFX7LESS-LABEL: add_i32_uniform:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_mov_b64 s[2:3], exec
; GFX7LESS-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; GFX7LESS-NEXT:    s_load_dword s6, s[0:1], 0xb
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s2, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s3, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    ; implicit-def: $vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB1_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mul_i32 s2, s6, s2
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, s2
; GFX7LESS-NEXT:    s_mov_b32 m0, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    ds_add_rtn_u32 v1, v1, v2
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:  .LBB1_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    v_readfirstlane_b32 s0, v1
; GFX7LESS-NEXT:    v_mul_lo_u32 v0, s6, v0
; GFX7LESS-NEXT:    s_mov_b32 s7, 0xf000
; GFX7LESS-NEXT:    v_add_i32_e32 v0, vcc, s0, v0
; GFX7LESS-NEXT:    s_mov_b32 s6, -1
; GFX7LESS-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: add_i32_uniform:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; GFX8-NEXT:    s_load_dword s6, s[0:1], 0x2c
; GFX8-NEXT:    s_mov_b64 s[2:3], exec
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8-NEXT:    ; implicit-def: $vgpr1
; GFX8-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB1_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mul_i32 s2, s6, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    ds_add_rtn_u32 v1, v1, v2
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:  .LBB1_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mul_lo_u32 v0, s6, v0
; GFX8-NEXT:    v_readfirstlane_b32 s0, v1
; GFX8-NEXT:    s_mov_b32 s7, 0xf000
; GFX8-NEXT:    s_mov_b32 s6, -1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; GFX8-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: add_i32_uniform:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; GFX9-NEXT:    s_load_dword s6, s[0:1], 0x2c
; GFX9-NEXT:    s_mov_b64 s[2:3], exec
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    ; implicit-def: $vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB1_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mul_i32 s2, s6, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    ds_add_rtn_u32 v1, v1, v2
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:  .LBB1_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mul_lo_u32 v0, s6, v0
; GFX9-NEXT:    v_readfirstlane_b32 s0, v1
; GFX9-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-NEXT:    s_mov_b32 s6, -1
; GFX9-NEXT:    v_add_u32_e32 v0, s0, v0
; GFX9-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: add_i32_uniform:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_clause 0x1
; GFX1064-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; GFX1064-NEXT:    s_load_dword s6, s[0:1], 0x2c
; GFX1064-NEXT:    s_mov_b64 s[2:3], exec
; GFX1064-NEXT:    ; implicit-def: $vgpr1
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB1_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_mul_i32 s2, s6, s2
; GFX1064-NEXT:    v_mov_b32_e32 v2, s2
; GFX1064-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1064-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1064-NEXT:    ds_add_rtn_u32 v1, v1, v2
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:  .LBB1_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1064-NEXT:    v_readfirstlane_b32 s0, v1
; GFX1064-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_mad_u64_u32 v[0:1], s[0:1], s6, v0, s[0:1]
; GFX1064-NEXT:    s_mov_b32 s6, -1
; GFX1064-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: add_i32_uniform:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_clause 0x1
; GFX1032-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; GFX1032-NEXT:    s_load_dword s2, s[0:1], 0x2c
; GFX1032-NEXT:    s_mov_b32 s3, exec_lo
; GFX1032-NEXT:    ; implicit-def: $vgpr1
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, s3, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB1_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s1, s3
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_mul_i32 s1, s2, s1
; GFX1032-NEXT:    v_mov_b32_e32 v2, s1
; GFX1032-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1032-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1032-NEXT:    ds_add_rtn_u32 v1, v1, v2
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:  .LBB1_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX1032-NEXT:    v_readfirstlane_b32 s0, v1
; GFX1032-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1032-NEXT:    s_mov_b32 s6, -1
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_mad_u64_u32 v[0:1], s0, s2, v0, s[0:1]
; GFX1032-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: add_i32_uniform:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    s_clause 0x1
; GFX1164-NEXT:    s_load_b64 s[4:5], s[0:1], 0x24
; GFX1164-NEXT:    s_load_b32 s6, s[0:1], 0x2c
; GFX1164-NEXT:    s_mov_b64 s[2:3], exec
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX1164-NEXT:    ; implicit-def: $vgpr1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_cbranch_execz .LBB1_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_mul_i32 s2, s6, s2
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    v_mov_b32_e32 v2, s2
; GFX1164-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1164-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1164-NEXT:    ds_add_rtn_u32 v1, v1, v2
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:  .LBB1_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1164-NEXT:    v_readfirstlane_b32 s0, v1
; GFX1164-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_mad_u64_u32 v[1:2], null, s6, v0, s[0:1]
; GFX1164-NEXT:    s_mov_b32 s6, -1
; GFX1164-NEXT:    buffer_store_b32 v1, off, s[4:7], 0
; GFX1164-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: add_i32_uniform:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    s_clause 0x1
; GFX1132-NEXT:    s_load_b64 s[4:5], s[0:1], 0x24
; GFX1132-NEXT:    s_load_b32 s0, s[0:1], 0x2c
; GFX1132-NEXT:    s_mov_b32 s2, exec_lo
; GFX1132-NEXT:    s_mov_b32 s1, exec_lo
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX1132-NEXT:    ; implicit-def: $vgpr1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_cbranch_execz .LBB1_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_bcnt1_i32_b32 s2, s2
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_mul_i32 s2, s0, s2
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v2, s2
; GFX1132-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1132-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1132-NEXT:    ds_add_rtn_u32 v1, v1, v2
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:  .LBB1_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1132-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1132-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1132-NEXT:    s_mov_b32 s6, -1
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_mad_u64_u32 v[1:2], null, s0, v0, s[2:3]
; GFX1132-NEXT:    buffer_store_b32 v1, off, s[4:7], 0
; GFX1132-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1132-NEXT:    s_endpgm
entry:
  %old = atomicrmw add i32 addrspace(3)* @local_var32, i32 %additive acq_rel
  store i32 %old, i32 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @add_i32_varying(i32 addrspace(1)* %out) {
;
;
; GFX7LESS-LABEL: add_i32_varying:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    s_mov_b32 m0, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    ds_add_rtn_u32 v0, v1, v0
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: add_i32_varying:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX8-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    s_mov_b64 exec, s[2:3]
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v3, exec_hi, v3
; GFX8-NEXT:    v_mov_b32_e32 v2, v0
; GFX8-NEXT:    s_not_b64 exec, exec
; GFX8-NEXT:    v_mov_b32_e32 v2, 0
; GFX8-NEXT:    s_not_b64 exec, exec
; GFX8-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX8-NEXT:    v_add_u32_dpp v2, vcc, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_add_u32_dpp v2, vcc, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_add_u32_dpp v2, vcc, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_add_u32_dpp v2, vcc, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_add_u32_dpp v2, vcc, v2, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_add_u32_dpp v2, vcc, v2, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8-NEXT:    v_readlane_b32 s4, v2, 63
; GFX8-NEXT:    s_nop 0
; GFX8-NEXT:    v_mov_b32_dpp v1, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8-NEXT:    s_mov_b64 exec, s[2:3]
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX8-NEXT:    ; implicit-def: $vgpr0
; GFX8-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB2_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s4
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    ds_add_rtn_u32 v0, v0, v3
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:  .LBB2_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_readfirstlane_b32 s2, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, v1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    s_nop 0
; GFX8-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: add_i32_varying:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_mov_b64 exec, s[2:3]
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v3, exec_hi, v3
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    s_not_b64 exec, exec
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_not_b64 exec, exec
; GFX9-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX9-NEXT:    v_add_u32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_add_u32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_add_u32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_add_u32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_add_u32_dpp v2, v2, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_add_u32_dpp v2, v2, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-NEXT:    v_readlane_b32 s4, v2, 63
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    v_mov_b32_dpp v1, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9-NEXT:    s_mov_b64 exec, s[2:3]
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX9-NEXT:    ; implicit-def: $vgpr0
; GFX9-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB2_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v3, s4
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    ds_add_rtn_u32 v0, v0, v3
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:  .LBB2_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_readfirstlane_b32 s2, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, v1
; GFX9-NEXT:    v_add_u32_e32 v0, s2, v0
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: add_i32_varying:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    v_mov_b32_e32 v1, v0
; GFX1064-NEXT:    s_not_b64 exec, exec
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-NEXT:    s_not_b64 exec, exec
; GFX1064-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1064-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064-NEXT:    v_mov_b32_e32 v2, v1
; GFX1064-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1064-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064-NEXT:    v_readlane_b32 s4, v1, 31
; GFX1064-NEXT:    v_mov_b32_e32 v2, s4
; GFX1064-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064-NEXT:    v_readlane_b32 s4, v1, 15
; GFX1064-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX1064-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1064-NEXT:    v_readlane_b32 s5, v1, 31
; GFX1064-NEXT:    v_writelane_b32 v3, s4, 16
; GFX1064-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1064-NEXT:    v_readlane_b32 s7, v1, 63
; GFX1064-NEXT:    v_readlane_b32 s6, v1, 47
; GFX1064-NEXT:    v_writelane_b32 v3, s5, 32
; GFX1064-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX1064-NEXT:    v_writelane_b32 v3, s6, 48
; GFX1064-NEXT:    s_mov_b64 exec, s[4:5]
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    ; implicit-def: $vgpr0
; GFX1064-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB2_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064-NEXT:    v_mov_b32_e32 v4, s7
; GFX1064-NEXT:    s_mov_b32 s3, s7
; GFX1064-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1064-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1064-NEXT:    ds_add_rtn_u32 v0, v0, v4
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:  .LBB2_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1064-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1064-NEXT:    v_mov_b32_e32 v0, v3
; GFX1064-NEXT:    v_add_nc_u32_e32 v0, s3, v0
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: add_i32_varying:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    v_mov_b32_e32 v1, v0
; GFX1032-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1032-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032-NEXT:    v_mov_b32_e32 v2, v1
; GFX1032-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1032-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX1032-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032-NEXT:    v_readlane_b32 s3, v1, 15
; GFX1032-NEXT:    v_readlane_b32 s4, v1, 31
; GFX1032-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032-NEXT:    v_writelane_b32 v3, s3, 16
; GFX1032-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    ; implicit-def: $vgpr0
; GFX1032-NEXT:    s_and_saveexec_b32 s3, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB2_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032-NEXT:    v_mov_b32_e32 v4, s4
; GFX1032-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1032-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1032-NEXT:    ds_add_rtn_u32 v0, v0, v4
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:  .LBB2_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GFX1032-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1032-NEXT:    v_mov_b32_e32 v0, v3
; GFX1032-NEXT:    v_add_nc_u32_e32 v0, s3, v0
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: add_i32_varying:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    v_mov_b32_e32 v1, v0
; GFX1164-NEXT:    s_not_b64 exec, exec
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-NEXT:    s_not_b64 exec, exec
; GFX1164-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1164-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mov_b32_e32 v2, v1
; GFX1164-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1164-NEXT:    v_readlane_b32 s4, v1, 31
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mov_b32_e32 v2, s4
; GFX1164-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_readlane_b32 s4, v1, 15
; GFX1164-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1164-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX1164-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1164-NEXT:    v_readlane_b32 s5, v1, 31
; GFX1164-NEXT:    v_writelane_b32 v3, s4, 16
; GFX1164-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1164-NEXT:    v_readlane_b32 s7, v1, 63
; GFX1164-NEXT:    v_readlane_b32 s6, v1, 47
; GFX1164-NEXT:    v_writelane_b32 v3, s5, 32
; GFX1164-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX1164-NEXT:    v_writelane_b32 v3, s6, 48
; GFX1164-NEXT:    s_mov_b64 exec, s[4:5]
; GFX1164-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    ; implicit-def: $vgpr0
; GFX1164-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1164-NEXT:    s_cbranch_execz .LBB2_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164-NEXT:    v_mov_b32_e32 v4, s7
; GFX1164-NEXT:    s_mov_b32 s3, s7
; GFX1164-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1164-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1164-NEXT:    ds_add_rtn_u32 v0, v0, v4
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:  .LBB2_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1164-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1164-NEXT:    v_mov_b32_e32 v0, v3
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_add_nc_u32_e32 v0, s3, v0
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1164-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: add_i32_varying:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    v_mov_b32_e32 v1, v0
; GFX1132-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1132-NEXT:    v_mov_b32_e32 v1, 0
; GFX1132-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1132-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_mov_b32_e32 v2, v1
; GFX1132-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1132-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX1132-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1132-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1132-NEXT:    v_mov_b32_e32 v3, 0
; GFX1132-NEXT:    v_readlane_b32 s3, v1, 15
; GFX1132-NEXT:    v_readlane_b32 s4, v1, 31
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1132-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132-NEXT:    v_writelane_b32 v3, s3, 16
; GFX1132-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1132-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    ; implicit-def: $vgpr0
; GFX1132-NEXT:    s_and_saveexec_b32 s3, vcc_lo
; GFX1132-NEXT:    s_cbranch_execz .LBB2_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    v_mov_b32_e32 v0, 0
; GFX1132-NEXT:    v_mov_b32_e32 v4, s4
; GFX1132-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1132-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1132-NEXT:    ds_add_rtn_u32 v0, v0, v4
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:  .LBB2_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GFX1132-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1132-NEXT:    v_mov_b32_e32 v0, v3
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_add_nc_u32_e32 v0, s3, v0
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1132-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1132-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %old = atomicrmw add i32 addrspace(3)* @local_var32, i32 %lane acq_rel
  store i32 %old, i32 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @add_i32_varying_nouse() {
; GFX7LESS-LABEL: add_i32_varying_nouse:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    s_mov_b32 m0, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    ds_add_u32 v1, v0
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: add_i32_varying_nouse:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v2, exec_hi, v2
; GFX8-NEXT:    v_mov_b32_e32 v1, v0
; GFX8-NEXT:    s_not_b64 exec, exec
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    s_not_b64 exec, exec
; GFX8-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX8-NEXT:    v_add_u32_dpp v1, vcc, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_add_u32_dpp v1, vcc, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_add_u32_dpp v1, vcc, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_add_u32_dpp v1, vcc, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_add_u32_dpp v1, vcc, v1, v1 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_add_u32_dpp v1, vcc, v1, v1 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8-NEXT:    v_readlane_b32 s2, v1, 63
; GFX8-NEXT:    s_mov_b64 exec, s[0:1]
; GFX8-NEXT:    s_mov_b32 s0, s2
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX8-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB3_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    ds_add_u32 v0, v2
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:  .LBB3_2:
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: add_i32_varying_nouse:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v2, exec_hi, v2
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_not_b64 exec, exec
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_not_b64 exec, exec
; GFX9-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9-NEXT:    v_add_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_add_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_add_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_add_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_add_u32_dpp v1, v1, v1 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_add_u32_dpp v1, v1, v1 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-NEXT:    v_readlane_b32 s2, v1, 63
; GFX9-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9-NEXT:    s_mov_b32 s0, s2
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB3_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v2, s0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    ds_add_u32 v0, v2
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:  .LBB3_2:
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: add_i32_varying_nouse:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    v_mov_b32_e32 v1, v0
; GFX1064-NEXT:    s_not_b64 exec, exec
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-NEXT:    s_not_b64 exec, exec
; GFX1064-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064-NEXT:    v_mov_b32_e32 v2, v1
; GFX1064-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1064-NEXT:    v_add_nc_u32_e32 v1, v1, v2
; GFX1064-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064-NEXT:    v_readlane_b32 s2, v1, 0
; GFX1064-NEXT:    v_readlane_b32 s3, v1, 32
; GFX1064-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    s_add_i32 s0, s2, s3
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB3_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064-NEXT:    v_mov_b32_e32 v3, s0
; GFX1064-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1064-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1064-NEXT:    ds_add_u32 v0, v3
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:  .LBB3_2:
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: add_i32_varying_nouse:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    v_mov_b32_e32 v1, v0
; GFX1032-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1032-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1032-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032-NEXT:    v_mov_b32_e32 v2, v1
; GFX1032-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1032-NEXT:    v_add_nc_u32_e32 v1, v1, v2
; GFX1032-NEXT:    s_mov_b32 exec_lo, s0
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX1032-NEXT:    v_mov_b32_e32 v0, v1
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v3
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB3_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1032-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1032-NEXT:    ds_add_u32 v3, v0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:  .LBB3_2:
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: add_i32_varying_nouse:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    v_mov_b32_e32 v1, v0
; GFX1164-NEXT:    s_not_b64 exec, exec
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-NEXT:    s_not_b64 exec, exec
; GFX1164-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mov_b32_e32 v2, v1
; GFX1164-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_add_nc_u32_e32 v1, v1, v2
; GFX1164-NEXT:    v_permlane64_b32 v2, v1
; GFX1164-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164-NEXT:    v_add_nc_u32_e32 v1, v1, v2
; GFX1164-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instid1(SALU_CYCLE_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v3, exec_hi, v0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1164-NEXT:    v_mov_b32_e32 v0, v1
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v3
; GFX1164-NEXT:    s_cbranch_execz .LBB3_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1164-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1164-NEXT:    ds_add_u32 v3, v0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:  .LBB3_2:
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: add_i32_varying_nouse:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    v_mov_b32_e32 v1, v0
; GFX1132-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1132-NEXT:    v_mov_b32_e32 v1, 0
; GFX1132-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1132-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_mov_b32_e32 v2, v1
; GFX1132-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1132-NEXT:    v_add_nc_u32_e32 v1, v1, v2
; GFX1132-NEXT:    s_mov_b32 exec_lo, s0
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1132-NEXT:    v_mov_b32_e32 v0, v1
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v3
; GFX1132-NEXT:    s_cbranch_execz .LBB3_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    v_mov_b32_e32 v3, 0
; GFX1132-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1132-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1132-NEXT:    ds_add_u32 v3, v0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:  .LBB3_2:
; GFX1132-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %old = atomicrmw add i32 addrspace(3)* @local_var32, i32 %lane acq_rel
  ret void
}

define amdgpu_kernel void @add_i64_constant(i64 addrspace(1)* %out) {
;
;
; GFX7LESS-LABEL: add_i64_constant:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], exec
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s4, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v2, s5, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX7LESS-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB4_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s4, s[4:5]
; GFX7LESS-NEXT:    s_mul_i32 s4, s4, 5
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, s4
; GFX7LESS-NEXT:    s_mov_b32 m0, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    ds_add_rtn_u64 v[0:1], v1, v[0:1]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:  .LBB4_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    v_readfirstlane_b32 s2, v0
; GFX7LESS-NEXT:    v_readfirstlane_b32 s4, v1
; GFX7LESS-NEXT:    v_mul_hi_u32_u24_e32 v1, 5, v2
; GFX7LESS-NEXT:    v_mul_u32_u24_e32 v0, 5, v2
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, s4
; GFX7LESS-NEXT:    v_add_i32_e32 v0, vcc, s2, v0
; GFX7LESS-NEXT:    v_addc_u32_e32 v1, vcc, v2, v1, vcc
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: add_i64_constant:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX8-NEXT:    s_mov_b64 s[4:5], exec
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, s4, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v2, s5, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX8-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX8-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB4_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_bcnt1_i32_b64 s4, s[4:5]
; GFX8-NEXT:    s_mul_i32 s4, s4, 5
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    ds_add_rtn_u64 v[0:1], v1, v[0:1]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:  .LBB4_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_readfirstlane_b32 s2, v0
; GFX8-NEXT:    v_readfirstlane_b32 s3, v1
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_mad_u64_u32 v[0:1], s[2:3], v2, 5, v[0:1]
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    s_nop 2
; GFX8-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: add_i64_constant:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    s_mov_b64 s[4:5], exec
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s4, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v2, s5, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB4_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_bcnt1_i32_b64 s4, s[4:5]
; GFX9-NEXT:    s_mul_i32 s4, s4, 5
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    ds_add_rtn_u64 v[0:1], v1, v[0:1]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:  .LBB4_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_readfirstlane_b32 s2, v0
; GFX9-NEXT:    v_readfirstlane_b32 s3, v1
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    v_mad_u64_u32 v[0:1], s[2:3], v2, 5, v[0:1]
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    s_nop 2
; GFX9-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: add_i64_constant:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX1064-NEXT:    s_mov_b64 s[4:5], exec
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s4, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v2, s5, v0
; GFX1064-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX1064-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB4_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s4, s[4:5]
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-NEXT:    s_mul_i32 s4, s4, 5
; GFX1064-NEXT:    v_mov_b32_e32 v0, s4
; GFX1064-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1064-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1064-NEXT:    ds_add_rtn_u64 v[0:1], v1, v[0:1]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:  .LBB4_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1064-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1064-NEXT:    v_mad_u64_u32 v[0:1], s[2:3], v2, 5, s[2:3]
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: add_i64_constant:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX1032-NEXT:    s_mov_b32 s3, exec_lo
; GFX1032-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v2, s3, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v2
; GFX1032-NEXT:    s_and_saveexec_b32 s2, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB4_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s3, s3
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-NEXT:    s_mul_i32 s3, s3, 5
; GFX1032-NEXT:    v_mov_b32_e32 v0, s3
; GFX1032-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1032-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1032-NEXT:    ds_add_rtn_u64 v[0:1], v1, v[0:1]
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:  .LBB4_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s2
; GFX1032-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1032-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1032-NEXT:    v_mad_u64_u32 v[0:1], s2, v2, 5, s[2:3]
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: add_i64_constant:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX1164-NEXT:    s_mov_b64 s[4:5], exec
; GFX1164-NEXT:    s_mov_b64 s[2:3], exec
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, s4, 0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v2, s5, v0
; GFX1164-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1164-NEXT:    s_cbranch_execz .LBB4_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_bcnt1_i32_b64 s4, s[4:5]
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-NEXT:    s_mul_i32 s4, s4, 5
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    v_mov_b32_e32 v0, s4
; GFX1164-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1164-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1164-NEXT:    ds_add_rtn_u64 v[0:1], v1, v[0:1]
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:  .LBB4_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1164-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1164-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_mad_u64_u32 v[0:1], null, v2, 5, s[2:3]
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1164-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: add_i64_constant:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX1132-NEXT:    s_mov_b32 s3, exec_lo
; GFX1132-NEXT:    s_mov_b32 s2, exec_lo
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v2, s3, 0
; GFX1132-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1132-NEXT:    s_cbranch_execz .LBB4_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_bcnt1_i32_b32 s3, s3
; GFX1132-NEXT:    v_mov_b32_e32 v1, 0
; GFX1132-NEXT:    s_mul_i32 s3, s3, 5
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-NEXT:    v_mov_b32_e32 v0, s3
; GFX1132-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1132-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1132-NEXT:    ds_add_rtn_u64 v[0:1], v1, v[0:1]
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:  .LBB4_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s2
; GFX1132-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1132-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_mad_u64_u32 v[0:1], null, v2, 5, s[2:3]
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1132-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1132-NEXT:    s_endpgm
entry:
  %old = atomicrmw add i64 addrspace(3)* @local_var64, i64 5 acq_rel
  store i64 %old, i64 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @add_i64_uniform(i64 addrspace(1)* %out, i64 %additive) {
;
;
; GFX7LESS-LABEL: add_i64_uniform:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_mov_b64 s[6:7], exec
; GFX7LESS-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s6, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v2, s7, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX7LESS-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB5_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, 0
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mul_i32 s7, s3, s6
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, s6
; GFX7LESS-NEXT:    v_mul_hi_u32 v0, s2, v0
; GFX7LESS-NEXT:    s_mul_i32 s6, s2, s6
; GFX7LESS-NEXT:    v_add_i32_e32 v1, vcc, s7, v0
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, s6
; GFX7LESS-NEXT:    s_mov_b32 m0, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    ds_add_rtn_u64 v[0:1], v3, v[0:1]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:  .LBB5_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_mov_b32 s7, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s6, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s4, s0
; GFX7LESS-NEXT:    s_mov_b32 s5, s1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s0, v0
; GFX7LESS-NEXT:    v_readfirstlane_b32 s1, v1
; GFX7LESS-NEXT:    v_mul_lo_u32 v0, s3, v2
; GFX7LESS-NEXT:    v_mul_hi_u32 v1, s2, v2
; GFX7LESS-NEXT:    v_mul_lo_u32 v2, s2, v2
; GFX7LESS-NEXT:    v_add_i32_e32 v1, vcc, v1, v0
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, s1
; GFX7LESS-NEXT:    v_add_i32_e32 v0, vcc, s0, v2
; GFX7LESS-NEXT:    v_addc_u32_e32 v1, vcc, v3, v1, vcc
; GFX7LESS-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: add_i64_uniform:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_mov_b64 s[6:7], exec
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v2, s7, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX8-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX8-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB5_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_bcnt1_i32_b64 s8, s[6:7]
; GFX8-NEXT:    v_mov_b32_e32 v0, s8
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_u64_u32 v[0:1], s[6:7], s2, v0, 0
; GFX8-NEXT:    s_mul_i32 s6, s3, s8
; GFX8-NEXT:    v_mov_b32_e32 v3, 0
; GFX8-NEXT:    v_add_u32_e32 v1, vcc, s6, v1
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    ds_add_rtn_u64 v[0:1], v3, v[0:1]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:  .LBB5_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_readfirstlane_b32 s4, v0
; GFX8-NEXT:    v_readfirstlane_b32 s5, v1
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_mul_lo_u32 v3, s3, v2
; GFX8-NEXT:    v_mad_u64_u32 v[0:1], s[2:3], s2, v2, v[0:1]
; GFX8-NEXT:    s_mov_b32 s7, 0xf000
; GFX8-NEXT:    s_mov_b32 s6, -1
; GFX8-NEXT:    s_mov_b32 s4, s0
; GFX8-NEXT:    s_mov_b32 s5, s1
; GFX8-NEXT:    v_add_u32_e32 v1, vcc, v3, v1
; GFX8-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: add_i64_uniform:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX9-NEXT:    s_mov_b64 s[6:7], exec
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v2, s7, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB5_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mul_i32 s7, s3, s6
; GFX9-NEXT:    s_mul_hi_u32 s8, s2, s6
; GFX9-NEXT:    s_add_i32 s8, s8, s7
; GFX9-NEXT:    s_mul_i32 s6, s2, s6
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s8
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    ds_add_rtn_u64 v[0:1], v3, v[0:1]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:  .LBB5_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_readfirstlane_b32 s4, v0
; GFX9-NEXT:    v_readfirstlane_b32 s5, v1
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], s2, v2, v[0:1]
; GFX9-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-NEXT:    s_mov_b32 s6, -1
; GFX9-NEXT:    v_mad_u64_u32 v[1:2], s[2:3], s3, v2, v[1:2]
; GFX9-NEXT:    s_mov_b32 s4, s0
; GFX9-NEXT:    s_mov_b32 s5, s1
; GFX9-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: add_i64_uniform:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX1064-NEXT:    s_mov_b64 s[6:7], exec
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v2, s7, v0
; GFX1064-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX1064-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB5_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1064-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_mul_i32 s7, s3, s6
; GFX1064-NEXT:    s_mul_hi_u32 s8, s2, s6
; GFX1064-NEXT:    s_mul_i32 s6, s2, s6
; GFX1064-NEXT:    s_add_i32 s8, s8, s7
; GFX1064-NEXT:    v_mov_b32_e32 v0, s6
; GFX1064-NEXT:    v_mov_b32_e32 v1, s8
; GFX1064-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1064-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1064-NEXT:    ds_add_rtn_u64 v[0:1], v3, v[0:1]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:  .LBB5_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1064-NEXT:    v_readfirstlane_b32 s4, v0
; GFX1064-NEXT:    v_readfirstlane_b32 s5, v1
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], s2, v2, s[4:5]
; GFX1064-NEXT:    v_mad_u64_u32 v[1:2], s[2:3], s3, v2, v[1:2]
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: add_i64_uniform:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX1032-NEXT:    s_mov_b32 s5, exec_lo
; GFX1032-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v2, s5, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v2
; GFX1032-NEXT:    s_and_saveexec_b32 s4, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB5_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s5, s5
; GFX1032-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_mul_i32 s6, s3, s5
; GFX1032-NEXT:    s_mul_hi_u32 s7, s2, s5
; GFX1032-NEXT:    s_mul_i32 s5, s2, s5
; GFX1032-NEXT:    s_add_i32 s7, s7, s6
; GFX1032-NEXT:    v_mov_b32_e32 v0, s5
; GFX1032-NEXT:    v_mov_b32_e32 v1, s7
; GFX1032-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1032-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1032-NEXT:    ds_add_rtn_u64 v[0:1], v3, v[0:1]
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:  .LBB5_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1032-NEXT:    v_readfirstlane_b32 s4, v0
; GFX1032-NEXT:    v_readfirstlane_b32 s5, v1
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_mad_u64_u32 v[0:1], s2, s2, v2, s[4:5]
; GFX1032-NEXT:    v_mad_u64_u32 v[1:2], s2, s3, v2, v[1:2]
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: add_i64_uniform:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX1164-NEXT:    s_mov_b64 s[6:7], exec
; GFX1164-NEXT:    s_mov_b64 s[4:5], exec
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v2, s7, v0
; GFX1164-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1164-NEXT:    s_cbranch_execz .LBB5_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1164-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_mul_i32 s7, s3, s6
; GFX1164-NEXT:    s_mul_hi_u32 s8, s2, s6
; GFX1164-NEXT:    s_mul_i32 s6, s2, s6
; GFX1164-NEXT:    s_add_i32 s8, s8, s7
; GFX1164-NEXT:    v_mov_b32_e32 v0, s6
; GFX1164-NEXT:    v_mov_b32_e32 v1, s8
; GFX1164-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1164-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1164-NEXT:    ds_add_rtn_u64 v[0:1], v3, v[0:1]
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:  .LBB5_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1164-NEXT:    v_readfirstlane_b32 s4, v0
; GFX1164-NEXT:    v_readfirstlane_b32 s5, v1
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mad_u64_u32 v[0:1], null, s2, v2, s[4:5]
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    v_mad_u64_u32 v[3:4], null, s3, v2, v[1:2]
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_mov_b32_e32 v1, v3
; GFX1164-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1164-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: add_i64_uniform:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX1132-NEXT:    s_mov_b32 s5, exec_lo
; GFX1132-NEXT:    s_mov_b32 s4, exec_lo
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v2, s5, 0
; GFX1132-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1132-NEXT:    s_cbranch_execz .LBB5_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_bcnt1_i32_b32 s5, s5
; GFX1132-NEXT:    v_mov_b32_e32 v3, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_mul_i32 s6, s3, s5
; GFX1132-NEXT:    s_mul_hi_u32 s7, s2, s5
; GFX1132-NEXT:    s_mul_i32 s5, s2, s5
; GFX1132-NEXT:    s_add_i32 s7, s7, s6
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-NEXT:    v_dual_mov_b32 v0, s5 :: v_dual_mov_b32 v1, s7
; GFX1132-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1132-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1132-NEXT:    ds_add_rtn_u64 v[0:1], v3, v[0:1]
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:  .LBB5_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1132-NEXT:    v_readfirstlane_b32 s4, v0
; GFX1132-NEXT:    v_readfirstlane_b32 s5, v1
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_mad_u64_u32 v[0:1], null, s2, v2, s[4:5]
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    v_mad_u64_u32 v[3:4], null, s3, v2, v[1:2]
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_mov_b32_e32 v1, v3
; GFX1132-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1132-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1132-NEXT:    s_endpgm
entry:
  %old = atomicrmw add i64 addrspace(3)* @local_var64, i64 %additive acq_rel
  store i64 %old, i64 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @add_i64_varying(i64 addrspace(1)* %out) {
;
;
; GFX7LESS-LABEL: add_i64_varying:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    s_mov_b32 m0, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    ds_add_rtn_u64 v[0:1], v1, v[0:1]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: add_i64_varying:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    ds_add_rtn_u64 v[0:1], v1, v[0:1]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: add_i64_varying:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    ds_add_rtn_u64 v[0:1], v1, v[0:1]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: add_i64_varying:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    s_mov_b32 s3, 0x31016000
; GFX10-NEXT:    s_mov_b32 s2, -1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ds_add_rtn_u64 v[0:1], v1, v[0:1]
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: add_i64_varying:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    s_mov_b32 s3, 0x31016000
; GFX11-NEXT:    s_mov_b32 s2, -1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ds_add_rtn_u64 v[0:1], v1, v[0:1]
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %zext = zext i32 %lane to i64
  %old = atomicrmw add i64 addrspace(3)* @local_var64, i64 %zext acq_rel
  store i64 %old, i64 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @sub_i32_constant(i32 addrspace(1)* %out) {
;
;
; GFX7LESS-LABEL: sub_i32_constant:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_mov_b64 s[2:3], exec
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s2, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s3, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    ; implicit-def: $vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB7_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX7LESS-NEXT:    s_mul_i32 s2, s2, 5
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, s2
; GFX7LESS-NEXT:    s_mov_b32 m0, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    ds_sub_rtn_u32 v1, v1, v2
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:  .LBB7_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    v_readfirstlane_b32 s2, v1
; GFX7LESS-NEXT:    v_mul_u32_u24_e32 v0, 5, v0
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    v_sub_i32_e32 v0, vcc, s2, v0
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: sub_i32_constant:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX8-NEXT:    s_mov_b64 s[2:3], exec
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8-NEXT:    ; implicit-def: $vgpr1
; GFX8-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB7_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX8-NEXT:    s_mul_i32 s2, s2, 5
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    ds_sub_rtn_u32 v1, v1, v2
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:  .LBB7_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_readfirstlane_b32 s2, v1
; GFX8-NEXT:    v_mul_u32_u24_e32 v0, 5, v0
; GFX8-NEXT:    v_sub_u32_e32 v0, vcc, s2, v0
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    s_nop 0
; GFX8-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: sub_i32_constant:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    s_mov_b64 s[2:3], exec
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    ; implicit-def: $vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB7_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX9-NEXT:    s_mul_i32 s2, s2, 5
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    ds_sub_rtn_u32 v1, v1, v2
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:  .LBB7_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_readfirstlane_b32 s2, v1
; GFX9-NEXT:    v_mul_u32_u24_e32 v0, 5, v0
; GFX9-NEXT:    v_sub_u32_e32 v0, s2, v0
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: sub_i32_constant:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX1064-NEXT:    s_mov_b64 s[2:3], exec
; GFX1064-NEXT:    ; implicit-def: $vgpr1
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB7_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-NEXT:    s_mul_i32 s2, s2, 5
; GFX1064-NEXT:    v_mov_b32_e32 v2, s2
; GFX1064-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1064-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1064-NEXT:    ds_sub_rtn_u32 v1, v1, v2
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:  .LBB7_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1064-NEXT:    v_mul_u32_u24_e32 v0, 5, v0
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: sub_i32_constant:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX1032-NEXT:    s_mov_b32 s3, exec_lo
; GFX1032-NEXT:    ; implicit-def: $vgpr1
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, s3, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s2, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB7_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s3, s3
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-NEXT:    s_mul_i32 s3, s3, 5
; GFX1032-NEXT:    v_mov_b32_e32 v2, s3
; GFX1032-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1032-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1032-NEXT:    ds_sub_rtn_u32 v1, v1, v2
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:  .LBB7_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s2
; GFX1032-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1032-NEXT:    v_mul_u32_u24_e32 v0, 5, v0
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: sub_i32_constant:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX1164-NEXT:    s_mov_b64 s[2:3], exec
; GFX1164-NEXT:    s_mov_b64 s[4:5], exec
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX1164-NEXT:    ; implicit-def: $vgpr1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_cbranch_execz .LBB7_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-NEXT:    s_mul_i32 s2, s2, 5
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    v_mov_b32_e32 v2, s2
; GFX1164-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1164-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1164-NEXT:    ds_sub_rtn_u32 v1, v1, v2
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:  .LBB7_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1164-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1164-NEXT:    v_mul_u32_u24_e32 v0, 5, v0
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1164-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: sub_i32_constant:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX1132-NEXT:    s_mov_b32 s3, exec_lo
; GFX1132-NEXT:    s_mov_b32 s2, exec_lo
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, s3, 0
; GFX1132-NEXT:    ; implicit-def: $vgpr1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_cbranch_execz .LBB7_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_bcnt1_i32_b32 s3, s3
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1132-NEXT:    s_mul_i32 s3, s3, 5
; GFX1132-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v2, s3
; GFX1132-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1132-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1132-NEXT:    ds_sub_rtn_u32 v1, v1, v2
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:  .LBB7_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s2
; GFX1132-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1132-NEXT:    v_mul_u32_u24_e32 v0, 5, v0
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1132-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1132-NEXT:    s_endpgm
entry:
  %old = atomicrmw sub i32 addrspace(3)* @local_var32, i32 5 acq_rel
  store i32 %old, i32 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @sub_i32_uniform(i32 addrspace(1)* %out, i32 %subitive) {
;
;
; GFX7LESS-LABEL: sub_i32_uniform:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_mov_b64 s[2:3], exec
; GFX7LESS-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; GFX7LESS-NEXT:    s_load_dword s6, s[0:1], 0xb
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s2, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s3, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    ; implicit-def: $vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB8_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mul_i32 s2, s6, s2
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, s2
; GFX7LESS-NEXT:    s_mov_b32 m0, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    ds_sub_rtn_u32 v1, v1, v2
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:  .LBB8_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    v_readfirstlane_b32 s0, v1
; GFX7LESS-NEXT:    v_mul_lo_u32 v0, s6, v0
; GFX7LESS-NEXT:    s_mov_b32 s7, 0xf000
; GFX7LESS-NEXT:    v_sub_i32_e32 v0, vcc, s0, v0
; GFX7LESS-NEXT:    s_mov_b32 s6, -1
; GFX7LESS-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: sub_i32_uniform:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; GFX8-NEXT:    s_load_dword s6, s[0:1], 0x2c
; GFX8-NEXT:    s_mov_b64 s[2:3], exec
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8-NEXT:    ; implicit-def: $vgpr1
; GFX8-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB8_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mul_i32 s2, s6, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    ds_sub_rtn_u32 v1, v1, v2
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:  .LBB8_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mul_lo_u32 v0, s6, v0
; GFX8-NEXT:    v_readfirstlane_b32 s0, v1
; GFX8-NEXT:    s_mov_b32 s7, 0xf000
; GFX8-NEXT:    s_mov_b32 s6, -1
; GFX8-NEXT:    v_sub_u32_e32 v0, vcc, s0, v0
; GFX8-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: sub_i32_uniform:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; GFX9-NEXT:    s_load_dword s6, s[0:1], 0x2c
; GFX9-NEXT:    s_mov_b64 s[2:3], exec
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    ; implicit-def: $vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB8_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mul_i32 s2, s6, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    ds_sub_rtn_u32 v1, v1, v2
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:  .LBB8_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mul_lo_u32 v0, s6, v0
; GFX9-NEXT:    v_readfirstlane_b32 s0, v1
; GFX9-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-NEXT:    s_mov_b32 s6, -1
; GFX9-NEXT:    v_sub_u32_e32 v0, s0, v0
; GFX9-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: sub_i32_uniform:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_clause 0x1
; GFX1064-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; GFX1064-NEXT:    s_load_dword s6, s[0:1], 0x2c
; GFX1064-NEXT:    s_mov_b64 s[2:3], exec
; GFX1064-NEXT:    ; implicit-def: $vgpr1
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB8_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_mul_i32 s2, s6, s2
; GFX1064-NEXT:    v_mov_b32_e32 v2, s2
; GFX1064-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1064-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1064-NEXT:    ds_sub_rtn_u32 v1, v1, v2
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:  .LBB8_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_mul_lo_u32 v0, s6, v0
; GFX1064-NEXT:    v_readfirstlane_b32 s0, v1
; GFX1064-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1064-NEXT:    s_mov_b32 s6, -1
; GFX1064-NEXT:    v_sub_nc_u32_e32 v0, s0, v0
; GFX1064-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: sub_i32_uniform:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_clause 0x1
; GFX1032-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; GFX1032-NEXT:    s_load_dword s2, s[0:1], 0x2c
; GFX1032-NEXT:    s_mov_b32 s3, exec_lo
; GFX1032-NEXT:    ; implicit-def: $vgpr1
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, s3, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB8_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s1, s3
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_mul_i32 s1, s2, s1
; GFX1032-NEXT:    v_mov_b32_e32 v2, s1
; GFX1032-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1032-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1032-NEXT:    ds_sub_rtn_u32 v1, v1, v2
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:  .LBB8_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_mul_lo_u32 v0, s2, v0
; GFX1032-NEXT:    v_readfirstlane_b32 s0, v1
; GFX1032-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1032-NEXT:    s_mov_b32 s6, -1
; GFX1032-NEXT:    v_sub_nc_u32_e32 v0, s0, v0
; GFX1032-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: sub_i32_uniform:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    s_clause 0x1
; GFX1164-NEXT:    s_load_b64 s[4:5], s[0:1], 0x24
; GFX1164-NEXT:    s_load_b32 s6, s[0:1], 0x2c
; GFX1164-NEXT:    s_mov_b64 s[2:3], exec
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX1164-NEXT:    ; implicit-def: $vgpr1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_cbranch_execz .LBB8_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_mul_i32 s2, s6, s2
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    v_mov_b32_e32 v2, s2
; GFX1164-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1164-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1164-NEXT:    ds_sub_rtn_u32 v1, v1, v2
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:  .LBB8_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    v_mul_lo_u32 v0, s6, v0
; GFX1164-NEXT:    v_readfirstlane_b32 s0, v1
; GFX1164-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1164-NEXT:    s_mov_b32 s6, -1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_sub_nc_u32_e32 v0, s0, v0
; GFX1164-NEXT:    buffer_store_b32 v0, off, s[4:7], 0
; GFX1164-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: sub_i32_uniform:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    s_clause 0x1
; GFX1132-NEXT:    s_load_b64 s[4:5], s[0:1], 0x24
; GFX1132-NEXT:    s_load_b32 s0, s[0:1], 0x2c
; GFX1132-NEXT:    s_mov_b32 s2, exec_lo
; GFX1132-NEXT:    s_mov_b32 s1, exec_lo
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX1132-NEXT:    ; implicit-def: $vgpr1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_cbranch_execz .LBB8_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_bcnt1_i32_b32 s2, s2
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_mul_i32 s2, s0, s2
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v2, s2
; GFX1132-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1132-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1132-NEXT:    ds_sub_rtn_u32 v1, v1, v2
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:  .LBB8_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    v_mul_lo_u32 v0, s0, v0
; GFX1132-NEXT:    v_readfirstlane_b32 s0, v1
; GFX1132-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1132-NEXT:    s_mov_b32 s6, -1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_sub_nc_u32_e32 v0, s0, v0
; GFX1132-NEXT:    buffer_store_b32 v0, off, s[4:7], 0
; GFX1132-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1132-NEXT:    s_endpgm
entry:
  %old = atomicrmw sub i32 addrspace(3)* @local_var32, i32 %subitive acq_rel
  store i32 %old, i32 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @sub_i32_varying(i32 addrspace(1)* %out) {
;
;
; GFX7LESS-LABEL: sub_i32_varying:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    s_mov_b32 m0, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    ds_sub_rtn_u32 v0, v1, v0
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: sub_i32_varying:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX8-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    s_mov_b64 exec, s[2:3]
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v3, exec_hi, v3
; GFX8-NEXT:    v_mov_b32_e32 v2, v0
; GFX8-NEXT:    s_not_b64 exec, exec
; GFX8-NEXT:    v_mov_b32_e32 v2, 0
; GFX8-NEXT:    s_not_b64 exec, exec
; GFX8-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX8-NEXT:    v_add_u32_dpp v2, vcc, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_add_u32_dpp v2, vcc, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_add_u32_dpp v2, vcc, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_add_u32_dpp v2, vcc, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_add_u32_dpp v2, vcc, v2, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_add_u32_dpp v2, vcc, v2, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8-NEXT:    v_readlane_b32 s4, v2, 63
; GFX8-NEXT:    s_nop 0
; GFX8-NEXT:    v_mov_b32_dpp v1, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8-NEXT:    s_mov_b64 exec, s[2:3]
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX8-NEXT:    ; implicit-def: $vgpr0
; GFX8-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB9_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s4
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    ds_sub_rtn_u32 v0, v0, v3
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:  .LBB9_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_readfirstlane_b32 s2, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, v1
; GFX8-NEXT:    v_sub_u32_e32 v0, vcc, s2, v0
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    s_nop 0
; GFX8-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: sub_i32_varying:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_mov_b64 exec, s[2:3]
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v3, exec_hi, v3
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    s_not_b64 exec, exec
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_not_b64 exec, exec
; GFX9-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX9-NEXT:    v_add_u32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_add_u32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_add_u32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_add_u32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_add_u32_dpp v2, v2, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_add_u32_dpp v2, v2, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-NEXT:    v_readlane_b32 s4, v2, 63
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    v_mov_b32_dpp v1, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9-NEXT:    s_mov_b64 exec, s[2:3]
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX9-NEXT:    ; implicit-def: $vgpr0
; GFX9-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB9_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v3, s4
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    ds_sub_rtn_u32 v0, v0, v3
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:  .LBB9_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_readfirstlane_b32 s2, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, v1
; GFX9-NEXT:    v_sub_u32_e32 v0, s2, v0
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: sub_i32_varying:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    v_mov_b32_e32 v1, v0
; GFX1064-NEXT:    s_not_b64 exec, exec
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-NEXT:    s_not_b64 exec, exec
; GFX1064-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1064-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064-NEXT:    v_mov_b32_e32 v2, v1
; GFX1064-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1064-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064-NEXT:    v_readlane_b32 s4, v1, 31
; GFX1064-NEXT:    v_mov_b32_e32 v2, s4
; GFX1064-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064-NEXT:    v_readlane_b32 s4, v1, 15
; GFX1064-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX1064-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1064-NEXT:    v_readlane_b32 s5, v1, 31
; GFX1064-NEXT:    v_writelane_b32 v3, s4, 16
; GFX1064-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1064-NEXT:    v_readlane_b32 s7, v1, 63
; GFX1064-NEXT:    v_readlane_b32 s6, v1, 47
; GFX1064-NEXT:    v_writelane_b32 v3, s5, 32
; GFX1064-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX1064-NEXT:    v_writelane_b32 v3, s6, 48
; GFX1064-NEXT:    s_mov_b64 exec, s[4:5]
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    ; implicit-def: $vgpr0
; GFX1064-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB9_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064-NEXT:    v_mov_b32_e32 v4, s7
; GFX1064-NEXT:    s_mov_b32 s3, s7
; GFX1064-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1064-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1064-NEXT:    ds_sub_rtn_u32 v0, v0, v4
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:  .LBB9_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1064-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1064-NEXT:    v_mov_b32_e32 v0, v3
; GFX1064-NEXT:    v_sub_nc_u32_e32 v0, s3, v0
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: sub_i32_varying:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    v_mov_b32_e32 v1, v0
; GFX1032-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1032-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032-NEXT:    v_mov_b32_e32 v2, v1
; GFX1032-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1032-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX1032-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032-NEXT:    v_readlane_b32 s3, v1, 15
; GFX1032-NEXT:    v_readlane_b32 s4, v1, 31
; GFX1032-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032-NEXT:    v_writelane_b32 v3, s3, 16
; GFX1032-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    ; implicit-def: $vgpr0
; GFX1032-NEXT:    s_and_saveexec_b32 s3, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB9_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032-NEXT:    v_mov_b32_e32 v4, s4
; GFX1032-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1032-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1032-NEXT:    ds_sub_rtn_u32 v0, v0, v4
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:  .LBB9_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GFX1032-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1032-NEXT:    v_mov_b32_e32 v0, v3
; GFX1032-NEXT:    v_sub_nc_u32_e32 v0, s3, v0
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: sub_i32_varying:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    v_mov_b32_e32 v1, v0
; GFX1164-NEXT:    s_not_b64 exec, exec
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-NEXT:    s_not_b64 exec, exec
; GFX1164-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1164-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mov_b32_e32 v2, v1
; GFX1164-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1164-NEXT:    v_readlane_b32 s4, v1, 31
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mov_b32_e32 v2, s4
; GFX1164-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_readlane_b32 s4, v1, 15
; GFX1164-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1164-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX1164-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1164-NEXT:    v_readlane_b32 s5, v1, 31
; GFX1164-NEXT:    v_writelane_b32 v3, s4, 16
; GFX1164-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1164-NEXT:    v_readlane_b32 s7, v1, 63
; GFX1164-NEXT:    v_readlane_b32 s6, v1, 47
; GFX1164-NEXT:    v_writelane_b32 v3, s5, 32
; GFX1164-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX1164-NEXT:    v_writelane_b32 v3, s6, 48
; GFX1164-NEXT:    s_mov_b64 exec, s[4:5]
; GFX1164-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    ; implicit-def: $vgpr0
; GFX1164-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1164-NEXT:    s_cbranch_execz .LBB9_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164-NEXT:    v_mov_b32_e32 v4, s7
; GFX1164-NEXT:    s_mov_b32 s3, s7
; GFX1164-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1164-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1164-NEXT:    ds_sub_rtn_u32 v0, v0, v4
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:  .LBB9_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1164-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1164-NEXT:    v_mov_b32_e32 v0, v3
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_sub_nc_u32_e32 v0, s3, v0
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1164-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: sub_i32_varying:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    v_mov_b32_e32 v1, v0
; GFX1132-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1132-NEXT:    v_mov_b32_e32 v1, 0
; GFX1132-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1132-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_mov_b32_e32 v2, v1
; GFX1132-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1132-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX1132-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1132-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1132-NEXT:    v_mov_b32_e32 v3, 0
; GFX1132-NEXT:    v_readlane_b32 s3, v1, 15
; GFX1132-NEXT:    v_readlane_b32 s4, v1, 31
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1132-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132-NEXT:    v_writelane_b32 v3, s3, 16
; GFX1132-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1132-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    ; implicit-def: $vgpr0
; GFX1132-NEXT:    s_and_saveexec_b32 s3, vcc_lo
; GFX1132-NEXT:    s_cbranch_execz .LBB9_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    v_mov_b32_e32 v0, 0
; GFX1132-NEXT:    v_mov_b32_e32 v4, s4
; GFX1132-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1132-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1132-NEXT:    ds_sub_rtn_u32 v0, v0, v4
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:  .LBB9_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GFX1132-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1132-NEXT:    v_mov_b32_e32 v0, v3
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_sub_nc_u32_e32 v0, s3, v0
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1132-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1132-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %old = atomicrmw sub i32 addrspace(3)* @local_var32, i32 %lane acq_rel
  store i32 %old, i32 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @sub_i32_varying_nouse() {
; GFX7LESS-LABEL: sub_i32_varying_nouse:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    s_mov_b32 m0, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    ds_sub_u32 v1, v0
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: sub_i32_varying_nouse:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v2, exec_hi, v2
; GFX8-NEXT:    v_mov_b32_e32 v1, v0
; GFX8-NEXT:    s_not_b64 exec, exec
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    s_not_b64 exec, exec
; GFX8-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX8-NEXT:    v_add_u32_dpp v1, vcc, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_add_u32_dpp v1, vcc, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_add_u32_dpp v1, vcc, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_add_u32_dpp v1, vcc, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_add_u32_dpp v1, vcc, v1, v1 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_add_u32_dpp v1, vcc, v1, v1 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8-NEXT:    v_readlane_b32 s2, v1, 63
; GFX8-NEXT:    s_mov_b64 exec, s[0:1]
; GFX8-NEXT:    s_mov_b32 s0, s2
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX8-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB10_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    ds_sub_u32 v0, v2
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:  .LBB10_2:
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: sub_i32_varying_nouse:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v2, exec_hi, v2
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_not_b64 exec, exec
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_not_b64 exec, exec
; GFX9-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9-NEXT:    v_add_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_add_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_add_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_add_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_add_u32_dpp v1, v1, v1 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_add_u32_dpp v1, v1, v1 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-NEXT:    v_readlane_b32 s2, v1, 63
; GFX9-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9-NEXT:    s_mov_b32 s0, s2
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB10_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v2, s0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    ds_sub_u32 v0, v2
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:  .LBB10_2:
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: sub_i32_varying_nouse:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    v_mov_b32_e32 v1, v0
; GFX1064-NEXT:    s_not_b64 exec, exec
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-NEXT:    s_not_b64 exec, exec
; GFX1064-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064-NEXT:    v_mov_b32_e32 v2, v1
; GFX1064-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1064-NEXT:    v_add_nc_u32_e32 v1, v1, v2
; GFX1064-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064-NEXT:    v_readlane_b32 s2, v1, 0
; GFX1064-NEXT:    v_readlane_b32 s3, v1, 32
; GFX1064-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    s_add_i32 s0, s2, s3
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB10_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064-NEXT:    v_mov_b32_e32 v3, s0
; GFX1064-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1064-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1064-NEXT:    ds_sub_u32 v0, v3
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:  .LBB10_2:
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: sub_i32_varying_nouse:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    v_mov_b32_e32 v1, v0
; GFX1032-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1032-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1032-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032-NEXT:    v_mov_b32_e32 v2, v1
; GFX1032-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1032-NEXT:    v_add_nc_u32_e32 v1, v1, v2
; GFX1032-NEXT:    s_mov_b32 exec_lo, s0
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX1032-NEXT:    v_mov_b32_e32 v0, v1
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v3
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB10_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1032-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1032-NEXT:    ds_sub_u32 v3, v0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:  .LBB10_2:
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: sub_i32_varying_nouse:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    v_mov_b32_e32 v1, v0
; GFX1164-NEXT:    s_not_b64 exec, exec
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-NEXT:    s_not_b64 exec, exec
; GFX1164-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mov_b32_e32 v2, v1
; GFX1164-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_add_nc_u32_e32 v1, v1, v2
; GFX1164-NEXT:    v_permlane64_b32 v2, v1
; GFX1164-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164-NEXT:    v_add_nc_u32_e32 v1, v1, v2
; GFX1164-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instid1(SALU_CYCLE_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v3, exec_hi, v0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1164-NEXT:    v_mov_b32_e32 v0, v1
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v3
; GFX1164-NEXT:    s_cbranch_execz .LBB10_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1164-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1164-NEXT:    ds_sub_u32 v3, v0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:  .LBB10_2:
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: sub_i32_varying_nouse:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    v_mov_b32_e32 v1, v0
; GFX1132-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1132-NEXT:    v_mov_b32_e32 v1, 0
; GFX1132-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1132-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_mov_b32_e32 v2, v1
; GFX1132-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1132-NEXT:    v_add_nc_u32_e32 v1, v1, v2
; GFX1132-NEXT:    s_mov_b32 exec_lo, s0
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1132-NEXT:    v_mov_b32_e32 v0, v1
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v3
; GFX1132-NEXT:    s_cbranch_execz .LBB10_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    v_mov_b32_e32 v3, 0
; GFX1132-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1132-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1132-NEXT:    ds_sub_u32 v3, v0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:  .LBB10_2:
; GFX1132-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %old = atomicrmw sub i32 addrspace(3)* @local_var32, i32 %lane acq_rel
  ret void
}

define amdgpu_kernel void @sub_i64_constant(i64 addrspace(1)* %out) {
;
;
; GFX7LESS-LABEL: sub_i64_constant:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], exec
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s4, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v2, s5, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX7LESS-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB11_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s4, s[4:5]
; GFX7LESS-NEXT:    s_mul_i32 s4, s4, 5
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, s4
; GFX7LESS-NEXT:    s_mov_b32 m0, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    ds_sub_rtn_u64 v[0:1], v1, v[0:1]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:  .LBB11_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    v_readfirstlane_b32 s2, v0
; GFX7LESS-NEXT:    v_readfirstlane_b32 s4, v1
; GFX7LESS-NEXT:    v_mul_hi_u32_u24_e32 v1, 5, v2
; GFX7LESS-NEXT:    v_mul_u32_u24_e32 v0, 5, v2
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, s4
; GFX7LESS-NEXT:    v_sub_i32_e32 v0, vcc, s2, v0
; GFX7LESS-NEXT:    v_subb_u32_e32 v1, vcc, v2, v1, vcc
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: sub_i64_constant:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX8-NEXT:    s_mov_b64 s[4:5], exec
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, s4, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v2, s5, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX8-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX8-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB11_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_bcnt1_i32_b64 s4, s[4:5]
; GFX8-NEXT:    s_mul_i32 s4, s4, 5
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    ds_sub_rtn_u64 v[0:1], v1, v[0:1]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:  .LBB11_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_readfirstlane_b32 s2, v0
; GFX8-NEXT:    v_readfirstlane_b32 s3, v1
; GFX8-NEXT:    v_mul_u32_u24_e32 v0, 5, v2
; GFX8-NEXT:    v_mul_hi_u32_u24_e32 v1, 5, v2
; GFX8-NEXT:    v_mov_b32_e32 v2, s3
; GFX8-NEXT:    v_sub_u32_e32 v0, vcc, s2, v0
; GFX8-NEXT:    v_subb_u32_e32 v1, vcc, v2, v1, vcc
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: sub_i64_constant:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    s_mov_b64 s[4:5], exec
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s4, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v2, s5, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB11_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_bcnt1_i32_b64 s4, s[4:5]
; GFX9-NEXT:    s_mul_i32 s4, s4, 5
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    ds_sub_rtn_u64 v[0:1], v1, v[0:1]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:  .LBB11_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_readfirstlane_b32 s2, v0
; GFX9-NEXT:    v_readfirstlane_b32 s3, v1
; GFX9-NEXT:    v_mul_u32_u24_e32 v0, 5, v2
; GFX9-NEXT:    v_mul_hi_u32_u24_e32 v1, 5, v2
; GFX9-NEXT:    v_mov_b32_e32 v2, s3
; GFX9-NEXT:    v_sub_co_u32_e32 v0, vcc, s2, v0
; GFX9-NEXT:    v_subb_co_u32_e32 v1, vcc, v2, v1, vcc
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: sub_i64_constant:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX1064-NEXT:    s_mov_b64 s[4:5], exec
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s4, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v2, s5, v0
; GFX1064-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX1064-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB11_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s4, s[4:5]
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-NEXT:    s_mul_i32 s4, s4, 5
; GFX1064-NEXT:    v_mov_b32_e32 v0, s4
; GFX1064-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1064-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1064-NEXT:    ds_sub_rtn_u64 v[0:1], v1, v[0:1]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:  .LBB11_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1064-NEXT:    v_mul_u32_u24_e32 v0, 5, v2
; GFX1064-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1064-NEXT:    v_mul_hi_u32_u24_e32 v1, 5, v2
; GFX1064-NEXT:    v_sub_co_u32 v0, vcc, s2, v0
; GFX1064-NEXT:    v_sub_co_ci_u32_e32 v1, vcc, s3, v1, vcc
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: sub_i64_constant:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX1032-NEXT:    s_mov_b32 s3, exec_lo
; GFX1032-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v2, s3, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v2
; GFX1032-NEXT:    s_and_saveexec_b32 s2, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB11_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s3, s3
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-NEXT:    s_mul_i32 s3, s3, 5
; GFX1032-NEXT:    v_mov_b32_e32 v0, s3
; GFX1032-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1032-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1032-NEXT:    ds_sub_rtn_u64 v[0:1], v1, v[0:1]
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:  .LBB11_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s2
; GFX1032-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1032-NEXT:    v_mul_u32_u24_e32 v0, 5, v2
; GFX1032-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1032-NEXT:    v_mul_hi_u32_u24_e32 v1, 5, v2
; GFX1032-NEXT:    v_sub_co_u32 v0, vcc_lo, s2, v0
; GFX1032-NEXT:    v_sub_co_ci_u32_e32 v1, vcc_lo, s3, v1, vcc_lo
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: sub_i64_constant:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX1164-NEXT:    s_mov_b64 s[4:5], exec
; GFX1164-NEXT:    s_mov_b64 s[2:3], exec
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, s4, 0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v2, s5, v0
; GFX1164-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1164-NEXT:    s_cbranch_execz .LBB11_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_bcnt1_i32_b64 s4, s[4:5]
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-NEXT:    s_mul_i32 s4, s4, 5
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    v_mov_b32_e32 v0, s4
; GFX1164-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1164-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1164-NEXT:    ds_sub_rtn_u64 v[0:1], v1, v[0:1]
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:  .LBB11_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1164-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1164-NEXT:    v_mul_u32_u24_e32 v0, 5, v2
; GFX1164-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1164-NEXT:    v_mul_hi_u32_u24_e32 v1, 5, v2
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-NEXT:    v_sub_co_u32 v0, vcc, s2, v0
; GFX1164-NEXT:    v_sub_co_ci_u32_e32 v1, vcc, s3, v1, vcc
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1164-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: sub_i64_constant:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX1132-NEXT:    s_mov_b32 s3, exec_lo
; GFX1132-NEXT:    s_mov_b32 s2, exec_lo
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v2, s3, 0
; GFX1132-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1132-NEXT:    s_cbranch_execz .LBB11_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_bcnt1_i32_b32 s3, s3
; GFX1132-NEXT:    v_mov_b32_e32 v1, 0
; GFX1132-NEXT:    s_mul_i32 s3, s3, 5
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-NEXT:    v_mov_b32_e32 v0, s3
; GFX1132-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1132-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1132-NEXT:    ds_sub_rtn_u64 v[0:1], v1, v[0:1]
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:  .LBB11_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s2
; GFX1132-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1132-NEXT:    v_mul_u32_u24_e32 v0, 5, v2
; GFX1132-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1132-NEXT:    v_mul_hi_u32_u24_e32 v1, 5, v2
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132-NEXT:    v_sub_co_u32 v0, vcc_lo, s2, v0
; GFX1132-NEXT:    v_sub_co_ci_u32_e32 v1, vcc_lo, s3, v1, vcc_lo
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1132-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1132-NEXT:    s_endpgm
entry:
  %old = atomicrmw sub i64 addrspace(3)* @local_var64, i64 5 acq_rel
  store i64 %old, i64 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @sub_i64_uniform(i64 addrspace(1)* %out, i64 %subitive) {
;
;
; GFX7LESS-LABEL: sub_i64_uniform:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_mov_b64 s[6:7], exec
; GFX7LESS-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s6, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v2, s7, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX7LESS-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB12_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, 0
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mul_i32 s7, s3, s6
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, s6
; GFX7LESS-NEXT:    v_mul_hi_u32 v0, s2, v0
; GFX7LESS-NEXT:    s_mul_i32 s6, s2, s6
; GFX7LESS-NEXT:    v_add_i32_e32 v1, vcc, s7, v0
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, s6
; GFX7LESS-NEXT:    s_mov_b32 m0, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    ds_sub_rtn_u64 v[0:1], v3, v[0:1]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:  .LBB12_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_mov_b32 s7, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s6, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s4, s0
; GFX7LESS-NEXT:    s_mov_b32 s5, s1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s0, v0
; GFX7LESS-NEXT:    v_readfirstlane_b32 s1, v1
; GFX7LESS-NEXT:    v_mul_lo_u32 v0, s3, v2
; GFX7LESS-NEXT:    v_mul_hi_u32 v1, s2, v2
; GFX7LESS-NEXT:    v_mul_lo_u32 v2, s2, v2
; GFX7LESS-NEXT:    v_add_i32_e32 v1, vcc, v1, v0
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, s1
; GFX7LESS-NEXT:    v_sub_i32_e32 v0, vcc, s0, v2
; GFX7LESS-NEXT:    v_subb_u32_e32 v1, vcc, v3, v1, vcc
; GFX7LESS-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: sub_i64_uniform:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_mov_b64 s[6:7], exec
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v2, s7, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX8-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX8-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB12_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_bcnt1_i32_b64 s8, s[6:7]
; GFX8-NEXT:    v_mov_b32_e32 v0, s8
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_u64_u32 v[0:1], s[6:7], s2, v0, 0
; GFX8-NEXT:    s_mul_i32 s6, s3, s8
; GFX8-NEXT:    v_mov_b32_e32 v3, 0
; GFX8-NEXT:    v_add_u32_e32 v1, vcc, s6, v1
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    ds_sub_rtn_u64 v[0:1], v3, v[0:1]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:  .LBB12_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s4, s0
; GFX8-NEXT:    s_mov_b32 s5, s1
; GFX8-NEXT:    v_mul_lo_u32 v4, s3, v2
; GFX8-NEXT:    v_mad_u64_u32 v[2:3], s[0:1], s2, v2, 0
; GFX8-NEXT:    v_readfirstlane_b32 s0, v0
; GFX8-NEXT:    v_readfirstlane_b32 s1, v1
; GFX8-NEXT:    v_add_u32_e32 v1, vcc, v3, v4
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_sub_u32_e32 v0, vcc, s0, v2
; GFX8-NEXT:    s_mov_b32 s7, 0xf000
; GFX8-NEXT:    s_mov_b32 s6, -1
; GFX8-NEXT:    v_subb_u32_e32 v1, vcc, v3, v1, vcc
; GFX8-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: sub_i64_uniform:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX9-NEXT:    s_mov_b64 s[6:7], exec
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v2, s7, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB12_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mul_i32 s7, s3, s6
; GFX9-NEXT:    s_mul_hi_u32 s8, s2, s6
; GFX9-NEXT:    s_add_i32 s8, s8, s7
; GFX9-NEXT:    s_mul_i32 s6, s2, s6
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s8
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    ds_sub_rtn_u64 v[0:1], v3, v[0:1]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:  .LBB12_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mad_u64_u32 v[3:4], s[4:5], s2, v2, 0
; GFX9-NEXT:    s_mov_b32 s4, s0
; GFX9-NEXT:    s_mov_b32 s5, s1
; GFX9-NEXT:    v_mad_u64_u32 v[4:5], s[2:3], s3, v2, v[4:5]
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    v_readfirstlane_b32 s1, v1
; GFX9-NEXT:    v_mov_b32_e32 v1, v4
; GFX9-NEXT:    v_mov_b32_e32 v2, s1
; GFX9-NEXT:    v_sub_co_u32_e32 v0, vcc, s0, v3
; GFX9-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-NEXT:    s_mov_b32 s6, -1
; GFX9-NEXT:    v_subb_co_u32_e32 v1, vcc, v2, v1, vcc
; GFX9-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: sub_i64_uniform:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX1064-NEXT:    s_mov_b64 s[6:7], exec
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v2, s7, v0
; GFX1064-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX1064-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB12_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1064-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_mul_i32 s7, s3, s6
; GFX1064-NEXT:    s_mul_hi_u32 s8, s2, s6
; GFX1064-NEXT:    s_mul_i32 s6, s2, s6
; GFX1064-NEXT:    s_add_i32 s8, s8, s7
; GFX1064-NEXT:    v_mov_b32_e32 v0, s6
; GFX1064-NEXT:    v_mov_b32_e32 v1, s8
; GFX1064-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1064-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1064-NEXT:    ds_sub_rtn_u64 v[0:1], v3, v[0:1]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:  .LBB12_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_mad_u64_u32 v[3:4], s[4:5], s2, v2, 0
; GFX1064-NEXT:    v_readfirstlane_b32 s4, v1
; GFX1064-NEXT:    v_mad_u64_u32 v[4:5], s[2:3], s3, v2, v[4:5]
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    v_sub_co_u32 v0, vcc, s2, v3
; GFX1064-NEXT:    v_mov_b32_e32 v1, v4
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    v_sub_co_ci_u32_e32 v1, vcc, s4, v1, vcc
; GFX1064-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: sub_i64_uniform:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX1032-NEXT:    s_mov_b32 s5, exec_lo
; GFX1032-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v2, s5, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v2
; GFX1032-NEXT:    s_and_saveexec_b32 s4, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB12_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s5, s5
; GFX1032-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_mul_i32 s6, s3, s5
; GFX1032-NEXT:    s_mul_hi_u32 s7, s2, s5
; GFX1032-NEXT:    s_mul_i32 s5, s2, s5
; GFX1032-NEXT:    s_add_i32 s7, s7, s6
; GFX1032-NEXT:    v_mov_b32_e32 v0, s5
; GFX1032-NEXT:    v_mov_b32_e32 v1, s7
; GFX1032-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1032-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1032-NEXT:    ds_sub_rtn_u64 v[0:1], v3, v[0:1]
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:  .LBB12_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_mad_u64_u32 v[3:4], s2, s2, v2, 0
; GFX1032-NEXT:    v_readfirstlane_b32 s4, v1
; GFX1032-NEXT:    v_mad_u64_u32 v[4:5], s2, s3, v2, v[4:5]
; GFX1032-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    v_sub_co_u32 v0, vcc_lo, s2, v3
; GFX1032-NEXT:    v_mov_b32_e32 v1, v4
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    v_sub_co_ci_u32_e32 v1, vcc_lo, s4, v1, vcc_lo
; GFX1032-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: sub_i64_uniform:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX1164-NEXT:    s_mov_b64 s[6:7], exec
; GFX1164-NEXT:    s_mov_b64 s[4:5], exec
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v2, s7, v0
; GFX1164-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1164-NEXT:    s_cbranch_execz .LBB12_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1164-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_mul_i32 s7, s3, s6
; GFX1164-NEXT:    s_mul_hi_u32 s8, s2, s6
; GFX1164-NEXT:    s_mul_i32 s6, s2, s6
; GFX1164-NEXT:    s_add_i32 s8, s8, s7
; GFX1164-NEXT:    v_mov_b32_e32 v0, s6
; GFX1164-NEXT:    v_mov_b32_e32 v1, s8
; GFX1164-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1164-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1164-NEXT:    ds_sub_rtn_u64 v[0:1], v3, v[0:1]
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:  .LBB12_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    v_mad_u64_u32 v[3:4], null, s2, v2, 0
; GFX1164-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1164-NEXT:    v_readfirstlane_b32 s4, v1
; GFX1164-NEXT:    s_waitcnt_depctr 0xfff
; GFX1164-NEXT:    v_mad_u64_u32 v[5:6], null, s3, v2, v[4:5]
; GFX1164-NEXT:    v_sub_co_u32 v0, vcc, s2, v3
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mov_b32_e32 v1, v5
; GFX1164-NEXT:    v_sub_co_ci_u32_e32 v1, vcc, s4, v1, vcc
; GFX1164-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1164-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: sub_i64_uniform:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX1132-NEXT:    s_mov_b32 s5, exec_lo
; GFX1132-NEXT:    s_mov_b32 s4, exec_lo
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v2, s5, 0
; GFX1132-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1132-NEXT:    s_cbranch_execz .LBB12_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_bcnt1_i32_b32 s5, s5
; GFX1132-NEXT:    v_mov_b32_e32 v3, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_mul_i32 s6, s3, s5
; GFX1132-NEXT:    s_mul_hi_u32 s7, s2, s5
; GFX1132-NEXT:    s_mul_i32 s5, s2, s5
; GFX1132-NEXT:    s_add_i32 s7, s7, s6
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-NEXT:    v_dual_mov_b32 v0, s5 :: v_dual_mov_b32 v1, s7
; GFX1132-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1132-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1132-NEXT:    ds_sub_rtn_u64 v[0:1], v3, v[0:1]
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:  .LBB12_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    v_mad_u64_u32 v[3:4], null, s2, v2, 0
; GFX1132-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1132-NEXT:    v_readfirstlane_b32 s4, v1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX1132-NEXT:    v_mad_u64_u32 v[5:6], null, s3, v2, v[4:5]
; GFX1132-NEXT:    v_sub_co_u32 v0, vcc_lo, s2, v3
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_mov_b32_e32 v1, v5
; GFX1132-NEXT:    v_sub_co_ci_u32_e32 v1, vcc_lo, s4, v1, vcc_lo
; GFX1132-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1132-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1132-NEXT:    s_endpgm
entry:
  %old = atomicrmw sub i64 addrspace(3)* @local_var64, i64 %subitive acq_rel
  store i64 %old, i64 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @sub_i64_varying(i64 addrspace(1)* %out) {
;
;
; GFX7LESS-LABEL: sub_i64_varying:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    s_mov_b32 m0, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    ds_sub_rtn_u64 v[0:1], v1, v[0:1]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: sub_i64_varying:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    ds_sub_rtn_u64 v[0:1], v1, v[0:1]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: sub_i64_varying:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    ds_sub_rtn_u64 v[0:1], v1, v[0:1]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: sub_i64_varying:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    s_mov_b32 s3, 0x31016000
; GFX10-NEXT:    s_mov_b32 s2, -1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ds_sub_rtn_u64 v[0:1], v1, v[0:1]
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: sub_i64_varying:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    s_mov_b32 s3, 0x31016000
; GFX11-NEXT:    s_mov_b32 s2, -1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ds_sub_rtn_u64 v[0:1], v1, v[0:1]
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %zext = zext i32 %lane to i64
  %old = atomicrmw sub i64 addrspace(3)* @local_var64, i64 %zext acq_rel
  store i64 %old, i64 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @and_i32_varying(i32 addrspace(1)* %out) {
;
;
; GFX7LESS-LABEL: and_i32_varying:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    s_mov_b32 m0, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    ds_and_rtn_b32 v0, v1, v0
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: and_i32_varying:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v3, exec_hi, v3
; GFX8-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX8-NEXT:    v_mov_b32_e32 v1, -1
; GFX8-NEXT:    s_mov_b64 exec, s[2:3]
; GFX8-NEXT:    v_mov_b32_e32 v2, v0
; GFX8-NEXT:    s_not_b64 exec, exec
; GFX8-NEXT:    v_mov_b32_e32 v2, -1
; GFX8-NEXT:    s_not_b64 exec, exec
; GFX8-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX8-NEXT:    v_and_b32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_and_b32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_and_b32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_and_b32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_and_b32_dpp v2, v2, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_and_b32_dpp v2, v2, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8-NEXT:    v_readlane_b32 s4, v2, 63
; GFX8-NEXT:    s_nop 0
; GFX8-NEXT:    v_mov_b32_dpp v1, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8-NEXT:    s_mov_b64 exec, s[2:3]
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX8-NEXT:    ; implicit-def: $vgpr0
; GFX8-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB14_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s4
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    ds_and_rtn_b32 v0, v0, v3
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:  .LBB14_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_readfirstlane_b32 s2, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, v1
; GFX8-NEXT:    v_and_b32_e32 v0, s2, v0
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    s_nop 0
; GFX8-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: and_i32_varying:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v3, exec_hi, v3
; GFX9-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX9-NEXT:    v_mov_b32_e32 v1, -1
; GFX9-NEXT:    s_mov_b64 exec, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    s_not_b64 exec, exec
; GFX9-NEXT:    v_mov_b32_e32 v2, -1
; GFX9-NEXT:    s_not_b64 exec, exec
; GFX9-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX9-NEXT:    v_and_b32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_and_b32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_and_b32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_and_b32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_and_b32_dpp v2, v2, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_and_b32_dpp v2, v2, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-NEXT:    v_readlane_b32 s4, v2, 63
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    v_mov_b32_dpp v1, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9-NEXT:    s_mov_b64 exec, s[2:3]
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX9-NEXT:    ; implicit-def: $vgpr0
; GFX9-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB14_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v3, s4
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    ds_and_rtn_b32 v0, v0, v3
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:  .LBB14_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_readfirstlane_b32 s2, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, v1
; GFX9-NEXT:    v_and_b32_e32 v0, s2, v0
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: and_i32_varying:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    v_mov_b32_e32 v1, v0
; GFX1064-NEXT:    s_not_b64 exec, exec
; GFX1064-NEXT:    v_mov_b32_e32 v1, -1
; GFX1064-NEXT:    s_not_b64 exec, exec
; GFX1064-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1064-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064-NEXT:    v_mov_b32_e32 v3, -1
; GFX1064-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1064-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1064-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1064-NEXT:    v_mov_b32_e32 v2, v1
; GFX1064-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1064-NEXT:    v_and_b32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064-NEXT:    v_readlane_b32 s4, v1, 31
; GFX1064-NEXT:    v_mov_b32_e32 v2, s4
; GFX1064-NEXT:    v_and_b32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064-NEXT:    v_readlane_b32 s4, v1, 15
; GFX1064-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX1064-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1064-NEXT:    v_readlane_b32 s5, v1, 31
; GFX1064-NEXT:    v_writelane_b32 v3, s4, 16
; GFX1064-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1064-NEXT:    v_readlane_b32 s7, v1, 63
; GFX1064-NEXT:    v_readlane_b32 s6, v1, 47
; GFX1064-NEXT:    v_writelane_b32 v3, s5, 32
; GFX1064-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX1064-NEXT:    v_writelane_b32 v3, s6, 48
; GFX1064-NEXT:    s_mov_b64 exec, s[4:5]
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    ; implicit-def: $vgpr0
; GFX1064-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB14_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064-NEXT:    v_mov_b32_e32 v4, s7
; GFX1064-NEXT:    s_mov_b32 s3, s7
; GFX1064-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1064-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1064-NEXT:    ds_and_rtn_b32 v0, v0, v4
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:  .LBB14_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1064-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1064-NEXT:    v_mov_b32_e32 v0, v3
; GFX1064-NEXT:    v_and_b32_e32 v0, s3, v0
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: and_i32_varying:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    v_mov_b32_e32 v1, v0
; GFX1032-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1032-NEXT:    v_mov_b32_e32 v1, -1
; GFX1032-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1032-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1032-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1032-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1032-NEXT:    v_mov_b32_e32 v2, v1
; GFX1032-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1032-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX1032-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032-NEXT:    v_and_b32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032-NEXT:    v_mov_b32_e32 v3, -1
; GFX1032-NEXT:    v_readlane_b32 s3, v1, 15
; GFX1032-NEXT:    v_readlane_b32 s4, v1, 31
; GFX1032-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032-NEXT:    v_writelane_b32 v3, s3, 16
; GFX1032-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    ; implicit-def: $vgpr0
; GFX1032-NEXT:    s_and_saveexec_b32 s3, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB14_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032-NEXT:    v_mov_b32_e32 v4, s4
; GFX1032-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1032-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1032-NEXT:    ds_and_rtn_b32 v0, v0, v4
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:  .LBB14_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GFX1032-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1032-NEXT:    v_mov_b32_e32 v0, v3
; GFX1032-NEXT:    v_and_b32_e32 v0, s3, v0
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: and_i32_varying:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    v_mov_b32_e32 v1, v0
; GFX1164-NEXT:    s_not_b64 exec, exec
; GFX1164-NEXT:    v_mov_b32_e32 v1, -1
; GFX1164-NEXT:    s_not_b64 exec, exec
; GFX1164-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1164-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164-NEXT:    v_mov_b32_e32 v3, -1
; GFX1164-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1164-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mov_b32_e32 v2, v1
; GFX1164-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_and_b32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1164-NEXT:    v_readlane_b32 s4, v1, 31
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mov_b32_e32 v2, s4
; GFX1164-NEXT:    v_and_b32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_readlane_b32 s4, v1, 15
; GFX1164-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1164-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX1164-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1164-NEXT:    v_readlane_b32 s5, v1, 31
; GFX1164-NEXT:    v_writelane_b32 v3, s4, 16
; GFX1164-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1164-NEXT:    v_readlane_b32 s7, v1, 63
; GFX1164-NEXT:    v_readlane_b32 s6, v1, 47
; GFX1164-NEXT:    v_writelane_b32 v3, s5, 32
; GFX1164-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX1164-NEXT:    v_writelane_b32 v3, s6, 48
; GFX1164-NEXT:    s_mov_b64 exec, s[4:5]
; GFX1164-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    ; implicit-def: $vgpr0
; GFX1164-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1164-NEXT:    s_cbranch_execz .LBB14_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164-NEXT:    v_mov_b32_e32 v4, s7
; GFX1164-NEXT:    s_mov_b32 s3, s7
; GFX1164-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1164-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1164-NEXT:    ds_and_rtn_b32 v0, v0, v4
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:  .LBB14_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1164-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1164-NEXT:    v_mov_b32_e32 v0, v3
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_and_b32_e32 v0, s3, v0
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1164-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: and_i32_varying:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    v_mov_b32_e32 v1, v0
; GFX1132-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1132-NEXT:    v_mov_b32_e32 v1, -1
; GFX1132-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1132-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1132-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_mov_b32_e32 v2, v1
; GFX1132-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1132-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX1132-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1132-NEXT:    v_and_b32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1132-NEXT:    v_mov_b32_e32 v3, -1
; GFX1132-NEXT:    v_readlane_b32 s3, v1, 15
; GFX1132-NEXT:    v_readlane_b32 s4, v1, 31
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1132-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132-NEXT:    v_writelane_b32 v3, s3, 16
; GFX1132-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1132-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    ; implicit-def: $vgpr0
; GFX1132-NEXT:    s_and_saveexec_b32 s3, vcc_lo
; GFX1132-NEXT:    s_cbranch_execz .LBB14_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    v_mov_b32_e32 v0, 0
; GFX1132-NEXT:    v_mov_b32_e32 v4, s4
; GFX1132-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1132-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1132-NEXT:    ds_and_rtn_b32 v0, v0, v4
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:  .LBB14_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GFX1132-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1132-NEXT:    v_mov_b32_e32 v0, v3
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_and_b32_e32 v0, s3, v0
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1132-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1132-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %old = atomicrmw and i32 addrspace(3)* @local_var32, i32 %lane acq_rel
  store i32 %old, i32 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @or_i32_varying(i32 addrspace(1)* %out) {
;
;
; GFX7LESS-LABEL: or_i32_varying:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    s_mov_b32 m0, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    ds_or_rtn_b32 v0, v1, v0
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: or_i32_varying:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX8-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    s_mov_b64 exec, s[2:3]
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v3, exec_hi, v3
; GFX8-NEXT:    v_mov_b32_e32 v2, v0
; GFX8-NEXT:    s_not_b64 exec, exec
; GFX8-NEXT:    v_mov_b32_e32 v2, 0
; GFX8-NEXT:    s_not_b64 exec, exec
; GFX8-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX8-NEXT:    v_or_b32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_or_b32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_or_b32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_or_b32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_or_b32_dpp v2, v2, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_or_b32_dpp v2, v2, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8-NEXT:    v_readlane_b32 s4, v2, 63
; GFX8-NEXT:    s_nop 0
; GFX8-NEXT:    v_mov_b32_dpp v1, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8-NEXT:    s_mov_b64 exec, s[2:3]
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX8-NEXT:    ; implicit-def: $vgpr0
; GFX8-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB15_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s4
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    ds_or_rtn_b32 v0, v0, v3
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:  .LBB15_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_readfirstlane_b32 s2, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, v1
; GFX8-NEXT:    v_or_b32_e32 v0, s2, v0
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    s_nop 0
; GFX8-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: or_i32_varying:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_mov_b64 exec, s[2:3]
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v3, exec_hi, v3
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    s_not_b64 exec, exec
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_not_b64 exec, exec
; GFX9-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX9-NEXT:    v_or_b32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_or_b32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_or_b32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_or_b32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_or_b32_dpp v2, v2, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_or_b32_dpp v2, v2, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-NEXT:    v_readlane_b32 s4, v2, 63
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    v_mov_b32_dpp v1, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9-NEXT:    s_mov_b64 exec, s[2:3]
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX9-NEXT:    ; implicit-def: $vgpr0
; GFX9-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB15_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v3, s4
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    ds_or_rtn_b32 v0, v0, v3
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:  .LBB15_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_readfirstlane_b32 s2, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, v1
; GFX9-NEXT:    v_or_b32_e32 v0, s2, v0
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: or_i32_varying:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    v_mov_b32_e32 v1, v0
; GFX1064-NEXT:    s_not_b64 exec, exec
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-NEXT:    s_not_b64 exec, exec
; GFX1064-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1064-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064-NEXT:    v_mov_b32_e32 v2, v1
; GFX1064-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1064-NEXT:    v_or_b32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064-NEXT:    v_readlane_b32 s4, v1, 31
; GFX1064-NEXT:    v_mov_b32_e32 v2, s4
; GFX1064-NEXT:    v_or_b32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064-NEXT:    v_readlane_b32 s4, v1, 15
; GFX1064-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX1064-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1064-NEXT:    v_readlane_b32 s5, v1, 31
; GFX1064-NEXT:    v_writelane_b32 v3, s4, 16
; GFX1064-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1064-NEXT:    v_readlane_b32 s7, v1, 63
; GFX1064-NEXT:    v_readlane_b32 s6, v1, 47
; GFX1064-NEXT:    v_writelane_b32 v3, s5, 32
; GFX1064-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX1064-NEXT:    v_writelane_b32 v3, s6, 48
; GFX1064-NEXT:    s_mov_b64 exec, s[4:5]
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    ; implicit-def: $vgpr0
; GFX1064-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB15_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064-NEXT:    v_mov_b32_e32 v4, s7
; GFX1064-NEXT:    s_mov_b32 s3, s7
; GFX1064-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1064-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1064-NEXT:    ds_or_rtn_b32 v0, v0, v4
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:  .LBB15_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1064-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1064-NEXT:    v_mov_b32_e32 v0, v3
; GFX1064-NEXT:    v_or_b32_e32 v0, s3, v0
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: or_i32_varying:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    v_mov_b32_e32 v1, v0
; GFX1032-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1032-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032-NEXT:    v_mov_b32_e32 v2, v1
; GFX1032-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1032-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX1032-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032-NEXT:    v_or_b32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032-NEXT:    v_readlane_b32 s3, v1, 15
; GFX1032-NEXT:    v_readlane_b32 s4, v1, 31
; GFX1032-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032-NEXT:    v_writelane_b32 v3, s3, 16
; GFX1032-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    ; implicit-def: $vgpr0
; GFX1032-NEXT:    s_and_saveexec_b32 s3, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB15_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032-NEXT:    v_mov_b32_e32 v4, s4
; GFX1032-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1032-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1032-NEXT:    ds_or_rtn_b32 v0, v0, v4
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:  .LBB15_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GFX1032-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1032-NEXT:    v_mov_b32_e32 v0, v3
; GFX1032-NEXT:    v_or_b32_e32 v0, s3, v0
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: or_i32_varying:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    v_mov_b32_e32 v1, v0
; GFX1164-NEXT:    s_not_b64 exec, exec
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-NEXT:    s_not_b64 exec, exec
; GFX1164-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1164-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mov_b32_e32 v2, v1
; GFX1164-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_or_b32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1164-NEXT:    v_readlane_b32 s4, v1, 31
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mov_b32_e32 v2, s4
; GFX1164-NEXT:    v_or_b32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_readlane_b32 s4, v1, 15
; GFX1164-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1164-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX1164-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1164-NEXT:    v_readlane_b32 s5, v1, 31
; GFX1164-NEXT:    v_writelane_b32 v3, s4, 16
; GFX1164-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1164-NEXT:    v_readlane_b32 s7, v1, 63
; GFX1164-NEXT:    v_readlane_b32 s6, v1, 47
; GFX1164-NEXT:    v_writelane_b32 v3, s5, 32
; GFX1164-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX1164-NEXT:    v_writelane_b32 v3, s6, 48
; GFX1164-NEXT:    s_mov_b64 exec, s[4:5]
; GFX1164-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    ; implicit-def: $vgpr0
; GFX1164-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1164-NEXT:    s_cbranch_execz .LBB15_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164-NEXT:    v_mov_b32_e32 v4, s7
; GFX1164-NEXT:    s_mov_b32 s3, s7
; GFX1164-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1164-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1164-NEXT:    ds_or_rtn_b32 v0, v0, v4
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:  .LBB15_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1164-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1164-NEXT:    v_mov_b32_e32 v0, v3
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_or_b32_e32 v0, s3, v0
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1164-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: or_i32_varying:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    v_mov_b32_e32 v1, v0
; GFX1132-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1132-NEXT:    v_mov_b32_e32 v1, 0
; GFX1132-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1132-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_mov_b32_e32 v2, v1
; GFX1132-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1132-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX1132-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1132-NEXT:    v_or_b32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1132-NEXT:    v_mov_b32_e32 v3, 0
; GFX1132-NEXT:    v_readlane_b32 s3, v1, 15
; GFX1132-NEXT:    v_readlane_b32 s4, v1, 31
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1132-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132-NEXT:    v_writelane_b32 v3, s3, 16
; GFX1132-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1132-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    ; implicit-def: $vgpr0
; GFX1132-NEXT:    s_and_saveexec_b32 s3, vcc_lo
; GFX1132-NEXT:    s_cbranch_execz .LBB15_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    v_mov_b32_e32 v0, 0
; GFX1132-NEXT:    v_mov_b32_e32 v4, s4
; GFX1132-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1132-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1132-NEXT:    ds_or_rtn_b32 v0, v0, v4
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:  .LBB15_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GFX1132-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1132-NEXT:    v_mov_b32_e32 v0, v3
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_or_b32_e32 v0, s3, v0
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1132-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1132-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %old = atomicrmw or i32 addrspace(3)* @local_var32, i32 %lane acq_rel
  store i32 %old, i32 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @xor_i32_varying(i32 addrspace(1)* %out) {
;
;
; GFX7LESS-LABEL: xor_i32_varying:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    s_mov_b32 m0, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    ds_xor_rtn_b32 v0, v1, v0
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: xor_i32_varying:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX8-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    s_mov_b64 exec, s[2:3]
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v3, exec_hi, v3
; GFX8-NEXT:    v_mov_b32_e32 v2, v0
; GFX8-NEXT:    s_not_b64 exec, exec
; GFX8-NEXT:    v_mov_b32_e32 v2, 0
; GFX8-NEXT:    s_not_b64 exec, exec
; GFX8-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX8-NEXT:    v_xor_b32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_xor_b32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_xor_b32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_xor_b32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_xor_b32_dpp v2, v2, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_xor_b32_dpp v2, v2, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8-NEXT:    v_readlane_b32 s4, v2, 63
; GFX8-NEXT:    s_nop 0
; GFX8-NEXT:    v_mov_b32_dpp v1, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8-NEXT:    s_mov_b64 exec, s[2:3]
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX8-NEXT:    ; implicit-def: $vgpr0
; GFX8-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB16_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s4
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    ds_xor_rtn_b32 v0, v0, v3
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:  .LBB16_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_readfirstlane_b32 s2, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, v1
; GFX8-NEXT:    v_xor_b32_e32 v0, s2, v0
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    s_nop 0
; GFX8-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: xor_i32_varying:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_mov_b64 exec, s[2:3]
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v3, exec_hi, v3
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    s_not_b64 exec, exec
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_not_b64 exec, exec
; GFX9-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX9-NEXT:    v_xor_b32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_xor_b32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_xor_b32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_xor_b32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_xor_b32_dpp v2, v2, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_xor_b32_dpp v2, v2, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-NEXT:    v_readlane_b32 s4, v2, 63
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    v_mov_b32_dpp v1, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9-NEXT:    s_mov_b64 exec, s[2:3]
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX9-NEXT:    ; implicit-def: $vgpr0
; GFX9-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB16_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v3, s4
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    ds_xor_rtn_b32 v0, v0, v3
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:  .LBB16_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_readfirstlane_b32 s2, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, v1
; GFX9-NEXT:    v_xor_b32_e32 v0, s2, v0
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: xor_i32_varying:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    v_mov_b32_e32 v1, v0
; GFX1064-NEXT:    s_not_b64 exec, exec
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-NEXT:    s_not_b64 exec, exec
; GFX1064-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1064-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064-NEXT:    v_mov_b32_e32 v2, v1
; GFX1064-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1064-NEXT:    v_xor_b32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064-NEXT:    v_readlane_b32 s4, v1, 31
; GFX1064-NEXT:    v_mov_b32_e32 v2, s4
; GFX1064-NEXT:    v_xor_b32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064-NEXT:    v_readlane_b32 s4, v1, 15
; GFX1064-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX1064-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1064-NEXT:    v_readlane_b32 s5, v1, 31
; GFX1064-NEXT:    v_writelane_b32 v3, s4, 16
; GFX1064-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1064-NEXT:    v_readlane_b32 s7, v1, 63
; GFX1064-NEXT:    v_readlane_b32 s6, v1, 47
; GFX1064-NEXT:    v_writelane_b32 v3, s5, 32
; GFX1064-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX1064-NEXT:    v_writelane_b32 v3, s6, 48
; GFX1064-NEXT:    s_mov_b64 exec, s[4:5]
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    ; implicit-def: $vgpr0
; GFX1064-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB16_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064-NEXT:    v_mov_b32_e32 v4, s7
; GFX1064-NEXT:    s_mov_b32 s3, s7
; GFX1064-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1064-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1064-NEXT:    ds_xor_rtn_b32 v0, v0, v4
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:  .LBB16_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1064-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1064-NEXT:    v_mov_b32_e32 v0, v3
; GFX1064-NEXT:    v_xor_b32_e32 v0, s3, v0
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: xor_i32_varying:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    v_mov_b32_e32 v1, v0
; GFX1032-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1032-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032-NEXT:    v_mov_b32_e32 v2, v1
; GFX1032-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1032-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX1032-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032-NEXT:    v_xor_b32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032-NEXT:    v_readlane_b32 s3, v1, 15
; GFX1032-NEXT:    v_readlane_b32 s4, v1, 31
; GFX1032-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032-NEXT:    v_writelane_b32 v3, s3, 16
; GFX1032-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    ; implicit-def: $vgpr0
; GFX1032-NEXT:    s_and_saveexec_b32 s3, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB16_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032-NEXT:    v_mov_b32_e32 v4, s4
; GFX1032-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1032-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1032-NEXT:    ds_xor_rtn_b32 v0, v0, v4
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:  .LBB16_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GFX1032-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1032-NEXT:    v_mov_b32_e32 v0, v3
; GFX1032-NEXT:    v_xor_b32_e32 v0, s3, v0
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: xor_i32_varying:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    v_mov_b32_e32 v1, v0
; GFX1164-NEXT:    s_not_b64 exec, exec
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-NEXT:    s_not_b64 exec, exec
; GFX1164-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1164-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mov_b32_e32 v2, v1
; GFX1164-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_xor_b32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1164-NEXT:    v_readlane_b32 s4, v1, 31
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mov_b32_e32 v2, s4
; GFX1164-NEXT:    v_xor_b32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_readlane_b32 s4, v1, 15
; GFX1164-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1164-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX1164-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1164-NEXT:    v_readlane_b32 s5, v1, 31
; GFX1164-NEXT:    v_writelane_b32 v3, s4, 16
; GFX1164-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1164-NEXT:    v_readlane_b32 s7, v1, 63
; GFX1164-NEXT:    v_readlane_b32 s6, v1, 47
; GFX1164-NEXT:    v_writelane_b32 v3, s5, 32
; GFX1164-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX1164-NEXT:    v_writelane_b32 v3, s6, 48
; GFX1164-NEXT:    s_mov_b64 exec, s[4:5]
; GFX1164-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    ; implicit-def: $vgpr0
; GFX1164-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1164-NEXT:    s_cbranch_execz .LBB16_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164-NEXT:    v_mov_b32_e32 v4, s7
; GFX1164-NEXT:    s_mov_b32 s3, s7
; GFX1164-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1164-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1164-NEXT:    ds_xor_rtn_b32 v0, v0, v4
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:  .LBB16_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1164-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1164-NEXT:    v_mov_b32_e32 v0, v3
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_xor_b32_e32 v0, s3, v0
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1164-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: xor_i32_varying:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    v_mov_b32_e32 v1, v0
; GFX1132-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1132-NEXT:    v_mov_b32_e32 v1, 0
; GFX1132-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1132-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_mov_b32_e32 v2, v1
; GFX1132-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1132-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX1132-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1132-NEXT:    v_xor_b32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1132-NEXT:    v_mov_b32_e32 v3, 0
; GFX1132-NEXT:    v_readlane_b32 s3, v1, 15
; GFX1132-NEXT:    v_readlane_b32 s4, v1, 31
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1132-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132-NEXT:    v_writelane_b32 v3, s3, 16
; GFX1132-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1132-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    ; implicit-def: $vgpr0
; GFX1132-NEXT:    s_and_saveexec_b32 s3, vcc_lo
; GFX1132-NEXT:    s_cbranch_execz .LBB16_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    v_mov_b32_e32 v0, 0
; GFX1132-NEXT:    v_mov_b32_e32 v4, s4
; GFX1132-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1132-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1132-NEXT:    ds_xor_rtn_b32 v0, v0, v4
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:  .LBB16_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GFX1132-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1132-NEXT:    v_mov_b32_e32 v0, v3
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_xor_b32_e32 v0, s3, v0
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1132-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1132-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %old = atomicrmw xor i32 addrspace(3)* @local_var32, i32 %lane acq_rel
  store i32 %old, i32 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @max_i32_varying(i32 addrspace(1)* %out) {
;
;
; GFX7LESS-LABEL: max_i32_varying:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    s_mov_b32 m0, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    ds_max_rtn_i32 v0, v1, v0
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: max_i32_varying:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v3, exec_hi, v3
; GFX8-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX8-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX8-NEXT:    s_mov_b64 exec, s[2:3]
; GFX8-NEXT:    v_mov_b32_e32 v2, v0
; GFX8-NEXT:    s_not_b64 exec, exec
; GFX8-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX8-NEXT:    s_not_b64 exec, exec
; GFX8-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX8-NEXT:    v_max_i32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_max_i32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_max_i32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_max_i32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_max_i32_dpp v2, v2, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_max_i32_dpp v2, v2, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8-NEXT:    v_readlane_b32 s4, v2, 63
; GFX8-NEXT:    s_nop 0
; GFX8-NEXT:    v_mov_b32_dpp v1, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8-NEXT:    s_mov_b64 exec, s[2:3]
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX8-NEXT:    ; implicit-def: $vgpr0
; GFX8-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB17_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s4
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    ds_max_rtn_i32 v0, v0, v3
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:  .LBB17_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_readfirstlane_b32 s2, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, v1
; GFX8-NEXT:    v_max_i32_e32 v0, s2, v0
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    s_nop 0
; GFX8-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: max_i32_varying:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v3, exec_hi, v3
; GFX9-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX9-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX9-NEXT:    s_mov_b64 exec, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    s_not_b64 exec, exec
; GFX9-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX9-NEXT:    s_not_b64 exec, exec
; GFX9-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX9-NEXT:    v_max_i32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_max_i32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_max_i32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_max_i32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_max_i32_dpp v2, v2, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_max_i32_dpp v2, v2, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-NEXT:    v_readlane_b32 s4, v2, 63
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    v_mov_b32_dpp v1, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9-NEXT:    s_mov_b64 exec, s[2:3]
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX9-NEXT:    ; implicit-def: $vgpr0
; GFX9-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB17_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v3, s4
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    ds_max_rtn_i32 v0, v0, v3
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:  .LBB17_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_readfirstlane_b32 s2, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, v1
; GFX9-NEXT:    v_max_i32_e32 v0, s2, v0
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: max_i32_varying:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    v_mov_b32_e32 v1, v0
; GFX1064-NEXT:    s_not_b64 exec, exec
; GFX1064-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX1064-NEXT:    s_not_b64 exec, exec
; GFX1064-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1064-NEXT:    v_max_i32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1064-NEXT:    v_max_i32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1064-NEXT:    v_max_i32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1064-NEXT:    v_max_i32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1064-NEXT:    v_mov_b32_e32 v2, v1
; GFX1064-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1064-NEXT:    v_max_i32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064-NEXT:    v_readlane_b32 s4, v1, 31
; GFX1064-NEXT:    v_mov_b32_e32 v2, s4
; GFX1064-NEXT:    v_max_i32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064-NEXT:    v_readlane_b32 s4, v1, 15
; GFX1064-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX1064-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1064-NEXT:    v_readlane_b32 s5, v1, 31
; GFX1064-NEXT:    v_writelane_b32 v3, s4, 16
; GFX1064-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1064-NEXT:    v_readlane_b32 s7, v1, 63
; GFX1064-NEXT:    v_readlane_b32 s6, v1, 47
; GFX1064-NEXT:    v_writelane_b32 v3, s5, 32
; GFX1064-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX1064-NEXT:    v_writelane_b32 v3, s6, 48
; GFX1064-NEXT:    s_mov_b64 exec, s[4:5]
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    ; implicit-def: $vgpr0
; GFX1064-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB17_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064-NEXT:    v_mov_b32_e32 v4, s7
; GFX1064-NEXT:    s_mov_b32 s3, s7
; GFX1064-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1064-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1064-NEXT:    ds_max_rtn_i32 v0, v0, v4
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:  .LBB17_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1064-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1064-NEXT:    v_mov_b32_e32 v0, v3
; GFX1064-NEXT:    v_max_i32_e32 v0, s3, v0
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: max_i32_varying:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    v_mov_b32_e32 v1, v0
; GFX1032-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1032-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX1032-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1032-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032-NEXT:    v_max_i32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032-NEXT:    v_max_i32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1032-NEXT:    v_max_i32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1032-NEXT:    v_max_i32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1032-NEXT:    v_mov_b32_e32 v2, v1
; GFX1032-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1032-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX1032-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032-NEXT:    v_max_i32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1032-NEXT:    v_readlane_b32 s3, v1, 15
; GFX1032-NEXT:    v_readlane_b32 s4, v1, 31
; GFX1032-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032-NEXT:    v_writelane_b32 v3, s3, 16
; GFX1032-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    ; implicit-def: $vgpr0
; GFX1032-NEXT:    s_and_saveexec_b32 s3, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB17_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032-NEXT:    v_mov_b32_e32 v4, s4
; GFX1032-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1032-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1032-NEXT:    ds_max_rtn_i32 v0, v0, v4
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:  .LBB17_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GFX1032-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1032-NEXT:    v_mov_b32_e32 v0, v3
; GFX1032-NEXT:    v_max_i32_e32 v0, s3, v0
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: max_i32_varying:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    v_mov_b32_e32 v1, v0
; GFX1164-NEXT:    s_not_b64 exec, exec
; GFX1164-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX1164-NEXT:    s_not_b64 exec, exec
; GFX1164-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1164-NEXT:    v_max_i32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1164-NEXT:    v_max_i32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_max_i32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1164-NEXT:    v_max_i32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mov_b32_e32 v2, v1
; GFX1164-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_max_i32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1164-NEXT:    v_readlane_b32 s4, v1, 31
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mov_b32_e32 v2, s4
; GFX1164-NEXT:    v_max_i32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_readlane_b32 s4, v1, 15
; GFX1164-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1164-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX1164-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1164-NEXT:    v_readlane_b32 s5, v1, 31
; GFX1164-NEXT:    v_writelane_b32 v3, s4, 16
; GFX1164-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1164-NEXT:    v_readlane_b32 s7, v1, 63
; GFX1164-NEXT:    v_readlane_b32 s6, v1, 47
; GFX1164-NEXT:    v_writelane_b32 v3, s5, 32
; GFX1164-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX1164-NEXT:    v_writelane_b32 v3, s6, 48
; GFX1164-NEXT:    s_mov_b64 exec, s[4:5]
; GFX1164-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    ; implicit-def: $vgpr0
; GFX1164-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1164-NEXT:    s_cbranch_execz .LBB17_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164-NEXT:    v_mov_b32_e32 v4, s7
; GFX1164-NEXT:    s_mov_b32 s3, s7
; GFX1164-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1164-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1164-NEXT:    ds_max_rtn_i32 v0, v0, v4
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:  .LBB17_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1164-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1164-NEXT:    v_mov_b32_e32 v0, v3
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_max_i32_e32 v0, s3, v0
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1164-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: max_i32_varying:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    v_mov_b32_e32 v1, v0
; GFX1132-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1132-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX1132-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1132-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_max_i32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132-NEXT:    v_max_i32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_max_i32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1132-NEXT:    v_max_i32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_mov_b32_e32 v2, v1
; GFX1132-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1132-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX1132-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1132-NEXT:    v_max_i32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1132-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1132-NEXT:    v_readlane_b32 s3, v1, 15
; GFX1132-NEXT:    v_readlane_b32 s4, v1, 31
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1132-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132-NEXT:    v_writelane_b32 v3, s3, 16
; GFX1132-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1132-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    ; implicit-def: $vgpr0
; GFX1132-NEXT:    s_and_saveexec_b32 s3, vcc_lo
; GFX1132-NEXT:    s_cbranch_execz .LBB17_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    v_mov_b32_e32 v0, 0
; GFX1132-NEXT:    v_mov_b32_e32 v4, s4
; GFX1132-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1132-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1132-NEXT:    ds_max_rtn_i32 v0, v0, v4
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:  .LBB17_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GFX1132-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1132-NEXT:    v_mov_b32_e32 v0, v3
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_max_i32_e32 v0, s3, v0
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1132-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1132-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %old = atomicrmw max i32 addrspace(3)* @local_var32, i32 %lane acq_rel
  store i32 %old, i32 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @max_i64_constant(i64 addrspace(1)* %out) {
;
;
; GFX7LESS-LABEL: max_i64_constant:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB18_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, 0
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, 5
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    s_mov_b32 m0, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    ds_max_rtn_i64 v[0:1], v2, v[0:1]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:  .LBB18_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    v_readfirstlane_b32 s4, v0
; GFX7LESS-NEXT:    v_readfirstlane_b32 s5, v1
; GFX7LESS-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX7LESS-NEXT:    v_cndmask_b32_e64 v0, 5, 0, vcc
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, s5
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, s4
; GFX7LESS-NEXT:    v_cmp_gt_i64_e32 vcc, s[4:5], v[0:1]
; GFX7LESS-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX7LESS-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: max_i64_constant:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX8-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB18_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    v_mov_b32_e32 v0, 5
; GFX8-NEXT:    v_mov_b32_e32 v2, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    ds_max_rtn_i64 v[0:1], v2, v[0:1]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:  .LBB18_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_readfirstlane_b32 s2, v0
; GFX8-NEXT:    v_bfrev_b32_e32 v0, 1
; GFX8-NEXT:    v_readfirstlane_b32 s3, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v1, 0, v0, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v0, 5, 0, vcc
; GFX8-NEXT:    v_cmp_gt_i64_e32 vcc, s[2:3], v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v2, s3
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: max_i64_constant:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB18_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    v_mov_b32_e32 v0, 5
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    ds_max_rtn_i64 v[0:1], v2, v[0:1]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:  .LBB18_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_readfirstlane_b32 s2, v0
; GFX9-NEXT:    v_bfrev_b32_e32 v0, 1
; GFX9-NEXT:    v_readfirstlane_b32 s3, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, 0, v0, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v0, 5, 0, vcc
; GFX9-NEXT:    v_cmp_gt_i64_e32 vcc, s[2:3], v[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v2, s3
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX9-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: max_i64_constant:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1064-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB18_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    v_mov_b32_e32 v0, 5
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-NEXT:    v_mov_b32_e32 v2, 0
; GFX1064-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1064-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1064-NEXT:    ds_max_rtn_i64 v[0:1], v2, v[0:1]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:  .LBB18_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1064-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1064-NEXT:    v_cndmask_b32_e64 v1, 0, 0x80000000, vcc
; GFX1064-NEXT:    v_cndmask_b32_e64 v0, 5, 0, vcc
; GFX1064-NEXT:    v_cmp_gt_i64_e32 vcc, s[2:3], v[0:1]
; GFX1064-NEXT:    v_cndmask_b32_e64 v1, v1, s3, vcc
; GFX1064-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: max_i64_constant:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1032-NEXT:    s_and_saveexec_b32 s2, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB18_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    v_mov_b32_e32 v0, 5
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-NEXT:    v_mov_b32_e32 v2, 0
; GFX1032-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1032-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1032-NEXT:    ds_max_rtn_i64 v[0:1], v2, v[0:1]
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:  .LBB18_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s2
; GFX1032-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1032-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1032-NEXT:    v_cndmask_b32_e64 v1, 0, 0x80000000, vcc_lo
; GFX1032-NEXT:    v_cndmask_b32_e64 v0, 5, 0, vcc_lo
; GFX1032-NEXT:    v_cmp_gt_i64_e32 vcc_lo, s[2:3], v[0:1]
; GFX1032-NEXT:    v_cndmask_b32_e64 v1, v1, s3, vcc_lo
; GFX1032-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc_lo
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: max_i64_constant:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1164-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1164-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1164-NEXT:    s_cbranch_execz .LBB18_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    v_mov_b32_e32 v0, 5
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-NEXT:    v_mov_b32_e32 v2, 0
; GFX1164-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1164-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1164-NEXT:    ds_max_rtn_i64 v[0:1], v2, v[0:1]
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:  .LBB18_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1164-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1164-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1164-NEXT:    v_cndmask_b32_e64 v1, 0, 0x80000000, vcc
; GFX1164-NEXT:    v_cndmask_b32_e64 v0, 5, 0, vcc
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_cmp_gt_i64_e32 vcc, s[2:3], v[0:1]
; GFX1164-NEXT:    v_cndmask_b32_e64 v1, v1, s3, vcc
; GFX1164-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1164-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: max_i64_constant:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1132-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1132-NEXT:    s_and_saveexec_b32 s2, vcc_lo
; GFX1132-NEXT:    s_cbranch_execz .LBB18_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    v_mov_b32_e32 v0, 5
; GFX1132-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v2, 0
; GFX1132-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1132-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1132-NEXT:    ds_max_rtn_i64 v[0:1], v2, v[0:1]
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:  .LBB18_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s2
; GFX1132-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1132-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1132-NEXT:    v_cndmask_b32_e64 v1, 0, 0x80000000, vcc_lo
; GFX1132-NEXT:    v_cndmask_b32_e64 v0, 5, 0, vcc_lo
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmp_gt_i64_e32 vcc_lo, s[2:3], v[0:1]
; GFX1132-NEXT:    v_cndmask_b32_e64 v1, v1, s3, vcc_lo
; GFX1132-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc_lo
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1132-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1132-NEXT:    s_endpgm
entry:
  %old = atomicrmw max i64 addrspace(3)* @local_var64, i64 5 acq_rel
  store i64 %old, i64 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @min_i32_varying(i32 addrspace(1)* %out) {
;
;
; GFX7LESS-LABEL: min_i32_varying:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    s_mov_b32 m0, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    ds_min_rtn_i32 v0, v1, v0
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: min_i32_varying:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v3, exec_hi, v3
; GFX8-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX8-NEXT:    v_bfrev_b32_e32 v1, -2
; GFX8-NEXT:    s_mov_b64 exec, s[2:3]
; GFX8-NEXT:    v_mov_b32_e32 v2, v0
; GFX8-NEXT:    s_not_b64 exec, exec
; GFX8-NEXT:    v_bfrev_b32_e32 v2, -2
; GFX8-NEXT:    s_not_b64 exec, exec
; GFX8-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX8-NEXT:    v_min_i32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_min_i32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_min_i32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_min_i32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_min_i32_dpp v2, v2, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_min_i32_dpp v2, v2, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8-NEXT:    v_readlane_b32 s4, v2, 63
; GFX8-NEXT:    s_nop 0
; GFX8-NEXT:    v_mov_b32_dpp v1, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8-NEXT:    s_mov_b64 exec, s[2:3]
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX8-NEXT:    ; implicit-def: $vgpr0
; GFX8-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB19_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s4
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    ds_min_rtn_i32 v0, v0, v3
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:  .LBB19_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_readfirstlane_b32 s2, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, v1
; GFX8-NEXT:    v_min_i32_e32 v0, s2, v0
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    s_nop 0
; GFX8-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: min_i32_varying:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v3, exec_hi, v3
; GFX9-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX9-NEXT:    v_bfrev_b32_e32 v1, -2
; GFX9-NEXT:    s_mov_b64 exec, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    s_not_b64 exec, exec
; GFX9-NEXT:    v_bfrev_b32_e32 v2, -2
; GFX9-NEXT:    s_not_b64 exec, exec
; GFX9-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX9-NEXT:    v_min_i32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_min_i32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_min_i32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_min_i32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_min_i32_dpp v2, v2, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_min_i32_dpp v2, v2, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-NEXT:    v_readlane_b32 s4, v2, 63
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    v_mov_b32_dpp v1, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9-NEXT:    s_mov_b64 exec, s[2:3]
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX9-NEXT:    ; implicit-def: $vgpr0
; GFX9-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB19_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v3, s4
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    ds_min_rtn_i32 v0, v0, v3
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:  .LBB19_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_readfirstlane_b32 s2, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, v1
; GFX9-NEXT:    v_min_i32_e32 v0, s2, v0
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: min_i32_varying:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    v_mov_b32_e32 v1, v0
; GFX1064-NEXT:    s_not_b64 exec, exec
; GFX1064-NEXT:    v_bfrev_b32_e32 v1, -2
; GFX1064-NEXT:    s_not_b64 exec, exec
; GFX1064-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1064-NEXT:    v_min_i32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064-NEXT:    v_bfrev_b32_e32 v3, -2
; GFX1064-NEXT:    v_min_i32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1064-NEXT:    v_min_i32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1064-NEXT:    v_min_i32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1064-NEXT:    v_mov_b32_e32 v2, v1
; GFX1064-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1064-NEXT:    v_min_i32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064-NEXT:    v_readlane_b32 s4, v1, 31
; GFX1064-NEXT:    v_mov_b32_e32 v2, s4
; GFX1064-NEXT:    v_min_i32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064-NEXT:    v_readlane_b32 s4, v1, 15
; GFX1064-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX1064-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1064-NEXT:    v_readlane_b32 s5, v1, 31
; GFX1064-NEXT:    v_writelane_b32 v3, s4, 16
; GFX1064-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1064-NEXT:    v_readlane_b32 s7, v1, 63
; GFX1064-NEXT:    v_readlane_b32 s6, v1, 47
; GFX1064-NEXT:    v_writelane_b32 v3, s5, 32
; GFX1064-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX1064-NEXT:    v_writelane_b32 v3, s6, 48
; GFX1064-NEXT:    s_mov_b64 exec, s[4:5]
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    ; implicit-def: $vgpr0
; GFX1064-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB19_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064-NEXT:    v_mov_b32_e32 v4, s7
; GFX1064-NEXT:    s_mov_b32 s3, s7
; GFX1064-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1064-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1064-NEXT:    ds_min_rtn_i32 v0, v0, v4
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:  .LBB19_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1064-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1064-NEXT:    v_mov_b32_e32 v0, v3
; GFX1064-NEXT:    v_min_i32_e32 v0, s3, v0
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: min_i32_varying:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    v_mov_b32_e32 v1, v0
; GFX1032-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1032-NEXT:    v_bfrev_b32_e32 v1, -2
; GFX1032-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1032-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032-NEXT:    v_min_i32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032-NEXT:    v_min_i32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1032-NEXT:    v_min_i32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1032-NEXT:    v_min_i32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1032-NEXT:    v_mov_b32_e32 v2, v1
; GFX1032-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1032-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX1032-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032-NEXT:    v_min_i32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032-NEXT:    v_bfrev_b32_e32 v3, -2
; GFX1032-NEXT:    v_readlane_b32 s3, v1, 15
; GFX1032-NEXT:    v_readlane_b32 s4, v1, 31
; GFX1032-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032-NEXT:    v_writelane_b32 v3, s3, 16
; GFX1032-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    ; implicit-def: $vgpr0
; GFX1032-NEXT:    s_and_saveexec_b32 s3, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB19_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032-NEXT:    v_mov_b32_e32 v4, s4
; GFX1032-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1032-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1032-NEXT:    ds_min_rtn_i32 v0, v0, v4
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:  .LBB19_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GFX1032-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1032-NEXT:    v_mov_b32_e32 v0, v3
; GFX1032-NEXT:    v_min_i32_e32 v0, s3, v0
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: min_i32_varying:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    v_mov_b32_e32 v1, v0
; GFX1164-NEXT:    s_not_b64 exec, exec
; GFX1164-NEXT:    v_bfrev_b32_e32 v1, -2
; GFX1164-NEXT:    s_not_b64 exec, exec
; GFX1164-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1164-NEXT:    v_min_i32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164-NEXT:    v_bfrev_b32_e32 v3, -2
; GFX1164-NEXT:    v_min_i32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_min_i32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1164-NEXT:    v_min_i32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mov_b32_e32 v2, v1
; GFX1164-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_min_i32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1164-NEXT:    v_readlane_b32 s4, v1, 31
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mov_b32_e32 v2, s4
; GFX1164-NEXT:    v_min_i32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_readlane_b32 s4, v1, 15
; GFX1164-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1164-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX1164-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1164-NEXT:    v_readlane_b32 s5, v1, 31
; GFX1164-NEXT:    v_writelane_b32 v3, s4, 16
; GFX1164-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1164-NEXT:    v_readlane_b32 s7, v1, 63
; GFX1164-NEXT:    v_readlane_b32 s6, v1, 47
; GFX1164-NEXT:    v_writelane_b32 v3, s5, 32
; GFX1164-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX1164-NEXT:    v_writelane_b32 v3, s6, 48
; GFX1164-NEXT:    s_mov_b64 exec, s[4:5]
; GFX1164-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    ; implicit-def: $vgpr0
; GFX1164-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1164-NEXT:    s_cbranch_execz .LBB19_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164-NEXT:    v_mov_b32_e32 v4, s7
; GFX1164-NEXT:    s_mov_b32 s3, s7
; GFX1164-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1164-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1164-NEXT:    ds_min_rtn_i32 v0, v0, v4
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:  .LBB19_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1164-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1164-NEXT:    v_mov_b32_e32 v0, v3
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_min_i32_e32 v0, s3, v0
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1164-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: min_i32_varying:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    v_mov_b32_e32 v1, v0
; GFX1132-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1132-NEXT:    v_bfrev_b32_e32 v1, -2
; GFX1132-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1132-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_min_i32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132-NEXT:    v_min_i32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_min_i32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1132-NEXT:    v_min_i32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_mov_b32_e32 v2, v1
; GFX1132-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1132-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX1132-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1132-NEXT:    v_min_i32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1132-NEXT:    v_bfrev_b32_e32 v3, -2
; GFX1132-NEXT:    v_readlane_b32 s3, v1, 15
; GFX1132-NEXT:    v_readlane_b32 s4, v1, 31
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1132-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132-NEXT:    v_writelane_b32 v3, s3, 16
; GFX1132-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1132-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    ; implicit-def: $vgpr0
; GFX1132-NEXT:    s_and_saveexec_b32 s3, vcc_lo
; GFX1132-NEXT:    s_cbranch_execz .LBB19_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    v_mov_b32_e32 v0, 0
; GFX1132-NEXT:    v_mov_b32_e32 v4, s4
; GFX1132-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1132-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1132-NEXT:    ds_min_rtn_i32 v0, v0, v4
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:  .LBB19_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GFX1132-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1132-NEXT:    v_mov_b32_e32 v0, v3
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_min_i32_e32 v0, s3, v0
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1132-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1132-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %old = atomicrmw min i32 addrspace(3)* @local_var32, i32 %lane acq_rel
  store i32 %old, i32 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @min_i64_constant(i64 addrspace(1)* %out) {
;
;
; GFX7LESS-LABEL: min_i64_constant:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB20_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, 0
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, 5
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    s_mov_b32 m0, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    ds_min_rtn_i64 v[0:1], v2, v[0:1]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:  .LBB20_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    v_readfirstlane_b32 s4, v0
; GFX7LESS-NEXT:    v_readfirstlane_b32 s5, v1
; GFX7LESS-NEXT:    v_bfrev_b32_e32 v1, -2
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    v_cndmask_b32_e64 v0, 5, -1, vcc
; GFX7LESS-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, s5
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, s4
; GFX7LESS-NEXT:    v_cmp_lt_i64_e32 vcc, s[4:5], v[0:1]
; GFX7LESS-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX7LESS-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: min_i64_constant:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX8-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB20_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    v_mov_b32_e32 v0, 5
; GFX8-NEXT:    v_mov_b32_e32 v2, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    ds_min_rtn_i64 v[0:1], v2, v[0:1]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:  .LBB20_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_readfirstlane_b32 s4, v0
; GFX8-NEXT:    v_bfrev_b32_e32 v0, -2
; GFX8-NEXT:    v_readfirstlane_b32 s5, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v1, 0, v0, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v0, 5, -1, vcc
; GFX8-NEXT:    v_cmp_lt_i64_e32 vcc, s[4:5], v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v2, s5
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX8-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: min_i64_constant:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB20_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    v_mov_b32_e32 v0, 5
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    ds_min_rtn_i64 v[0:1], v2, v[0:1]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:  .LBB20_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_readfirstlane_b32 s4, v0
; GFX9-NEXT:    v_bfrev_b32_e32 v0, -2
; GFX9-NEXT:    v_readfirstlane_b32 s5, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, 0, v0, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v0, 5, -1, vcc
; GFX9-NEXT:    v_cmp_lt_i64_e32 vcc, s[4:5], v[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v2, s5
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX9-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: min_i64_constant:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1064-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB20_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    v_mov_b32_e32 v0, 5
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-NEXT:    v_mov_b32_e32 v2, 0
; GFX1064-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1064-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1064-NEXT:    ds_min_rtn_i64 v[0:1], v2, v[0:1]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:  .LBB20_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1064-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1064-NEXT:    v_cndmask_b32_e64 v1, 0, 0x7fffffff, vcc
; GFX1064-NEXT:    v_cndmask_b32_e64 v0, 5, -1, vcc
; GFX1064-NEXT:    v_cmp_lt_i64_e32 vcc, s[2:3], v[0:1]
; GFX1064-NEXT:    v_cndmask_b32_e64 v1, v1, s3, vcc
; GFX1064-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: min_i64_constant:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1032-NEXT:    s_and_saveexec_b32 s2, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB20_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    v_mov_b32_e32 v0, 5
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-NEXT:    v_mov_b32_e32 v2, 0
; GFX1032-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1032-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1032-NEXT:    ds_min_rtn_i64 v[0:1], v2, v[0:1]
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:  .LBB20_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s2
; GFX1032-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1032-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1032-NEXT:    v_cndmask_b32_e64 v1, 0, 0x7fffffff, vcc_lo
; GFX1032-NEXT:    v_cndmask_b32_e64 v0, 5, -1, vcc_lo
; GFX1032-NEXT:    v_cmp_lt_i64_e32 vcc_lo, s[2:3], v[0:1]
; GFX1032-NEXT:    v_cndmask_b32_e64 v1, v1, s3, vcc_lo
; GFX1032-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc_lo
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: min_i64_constant:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1164-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1164-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1164-NEXT:    s_cbranch_execz .LBB20_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    v_mov_b32_e32 v0, 5
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-NEXT:    v_mov_b32_e32 v2, 0
; GFX1164-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1164-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1164-NEXT:    ds_min_rtn_i64 v[0:1], v2, v[0:1]
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:  .LBB20_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1164-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1164-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1164-NEXT:    v_cndmask_b32_e64 v1, 0, 0x7fffffff, vcc
; GFX1164-NEXT:    v_cndmask_b32_e64 v0, 5, -1, vcc
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_cmp_lt_i64_e32 vcc, s[2:3], v[0:1]
; GFX1164-NEXT:    v_cndmask_b32_e64 v1, v1, s3, vcc
; GFX1164-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1164-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: min_i64_constant:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1132-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1132-NEXT:    s_and_saveexec_b32 s2, vcc_lo
; GFX1132-NEXT:    s_cbranch_execz .LBB20_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    v_mov_b32_e32 v0, 5
; GFX1132-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v2, 0
; GFX1132-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1132-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1132-NEXT:    ds_min_rtn_i64 v[0:1], v2, v[0:1]
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:  .LBB20_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s2
; GFX1132-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1132-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1132-NEXT:    v_cndmask_b32_e64 v1, 0, 0x7fffffff, vcc_lo
; GFX1132-NEXT:    v_cndmask_b32_e64 v0, 5, -1, vcc_lo
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmp_lt_i64_e32 vcc_lo, s[2:3], v[0:1]
; GFX1132-NEXT:    v_cndmask_b32_e64 v1, v1, s3, vcc_lo
; GFX1132-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc_lo
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1132-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1132-NEXT:    s_endpgm
entry:
  %old = atomicrmw min i64 addrspace(3)* @local_var64, i64 5 acq_rel
  store i64 %old, i64 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @umax_i32_varying(i32 addrspace(1)* %out) {
;
;
; GFX7LESS-LABEL: umax_i32_varying:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    s_mov_b32 m0, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    ds_max_rtn_u32 v0, v1, v0
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: umax_i32_varying:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX8-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    s_mov_b64 exec, s[2:3]
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v3, exec_hi, v3
; GFX8-NEXT:    v_mov_b32_e32 v2, v0
; GFX8-NEXT:    s_not_b64 exec, exec
; GFX8-NEXT:    v_mov_b32_e32 v2, 0
; GFX8-NEXT:    s_not_b64 exec, exec
; GFX8-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX8-NEXT:    v_max_u32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_max_u32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_max_u32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_max_u32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_max_u32_dpp v2, v2, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_max_u32_dpp v2, v2, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8-NEXT:    v_readlane_b32 s4, v2, 63
; GFX8-NEXT:    s_nop 0
; GFX8-NEXT:    v_mov_b32_dpp v1, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8-NEXT:    s_mov_b64 exec, s[2:3]
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX8-NEXT:    ; implicit-def: $vgpr0
; GFX8-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB21_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s4
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    ds_max_rtn_u32 v0, v0, v3
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:  .LBB21_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_readfirstlane_b32 s2, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, v1
; GFX8-NEXT:    v_max_u32_e32 v0, s2, v0
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    s_nop 0
; GFX8-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: umax_i32_varying:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_mov_b64 exec, s[2:3]
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v3, exec_hi, v3
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    s_not_b64 exec, exec
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_not_b64 exec, exec
; GFX9-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX9-NEXT:    v_max_u32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_max_u32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_max_u32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_max_u32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_max_u32_dpp v2, v2, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_max_u32_dpp v2, v2, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-NEXT:    v_readlane_b32 s4, v2, 63
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    v_mov_b32_dpp v1, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9-NEXT:    s_mov_b64 exec, s[2:3]
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX9-NEXT:    ; implicit-def: $vgpr0
; GFX9-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB21_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v3, s4
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    ds_max_rtn_u32 v0, v0, v3
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:  .LBB21_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_readfirstlane_b32 s2, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, v1
; GFX9-NEXT:    v_max_u32_e32 v0, s2, v0
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: umax_i32_varying:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    v_mov_b32_e32 v1, v0
; GFX1064-NEXT:    s_not_b64 exec, exec
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-NEXT:    s_not_b64 exec, exec
; GFX1064-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1064-NEXT:    v_max_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064-NEXT:    v_max_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064-NEXT:    v_max_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064-NEXT:    v_max_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064-NEXT:    v_mov_b32_e32 v2, v1
; GFX1064-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1064-NEXT:    v_max_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064-NEXT:    v_readlane_b32 s4, v1, 31
; GFX1064-NEXT:    v_mov_b32_e32 v2, s4
; GFX1064-NEXT:    v_max_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064-NEXT:    v_readlane_b32 s4, v1, 15
; GFX1064-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX1064-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1064-NEXT:    v_readlane_b32 s5, v1, 31
; GFX1064-NEXT:    v_writelane_b32 v3, s4, 16
; GFX1064-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1064-NEXT:    v_readlane_b32 s7, v1, 63
; GFX1064-NEXT:    v_readlane_b32 s6, v1, 47
; GFX1064-NEXT:    v_writelane_b32 v3, s5, 32
; GFX1064-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX1064-NEXT:    v_writelane_b32 v3, s6, 48
; GFX1064-NEXT:    s_mov_b64 exec, s[4:5]
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    ; implicit-def: $vgpr0
; GFX1064-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB21_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064-NEXT:    v_mov_b32_e32 v4, s7
; GFX1064-NEXT:    s_mov_b32 s3, s7
; GFX1064-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1064-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1064-NEXT:    ds_max_rtn_u32 v0, v0, v4
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:  .LBB21_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1064-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1064-NEXT:    v_mov_b32_e32 v0, v3
; GFX1064-NEXT:    v_max_u32_e32 v0, s3, v0
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: umax_i32_varying:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    v_mov_b32_e32 v1, v0
; GFX1032-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1032-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032-NEXT:    v_max_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032-NEXT:    v_max_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032-NEXT:    v_max_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032-NEXT:    v_max_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032-NEXT:    v_mov_b32_e32 v2, v1
; GFX1032-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1032-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX1032-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032-NEXT:    v_max_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032-NEXT:    v_readlane_b32 s3, v1, 15
; GFX1032-NEXT:    v_readlane_b32 s4, v1, 31
; GFX1032-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032-NEXT:    v_writelane_b32 v3, s3, 16
; GFX1032-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    ; implicit-def: $vgpr0
; GFX1032-NEXT:    s_and_saveexec_b32 s3, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB21_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032-NEXT:    v_mov_b32_e32 v4, s4
; GFX1032-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1032-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1032-NEXT:    ds_max_rtn_u32 v0, v0, v4
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:  .LBB21_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GFX1032-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1032-NEXT:    v_mov_b32_e32 v0, v3
; GFX1032-NEXT:    v_max_u32_e32 v0, s3, v0
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: umax_i32_varying:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    v_mov_b32_e32 v1, v0
; GFX1164-NEXT:    s_not_b64 exec, exec
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-NEXT:    s_not_b64 exec, exec
; GFX1164-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1164-NEXT:    v_max_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164-NEXT:    v_max_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_max_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164-NEXT:    v_max_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mov_b32_e32 v2, v1
; GFX1164-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_max_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1164-NEXT:    v_readlane_b32 s4, v1, 31
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mov_b32_e32 v2, s4
; GFX1164-NEXT:    v_max_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_readlane_b32 s4, v1, 15
; GFX1164-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1164-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX1164-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1164-NEXT:    v_readlane_b32 s5, v1, 31
; GFX1164-NEXT:    v_writelane_b32 v3, s4, 16
; GFX1164-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1164-NEXT:    v_readlane_b32 s7, v1, 63
; GFX1164-NEXT:    v_readlane_b32 s6, v1, 47
; GFX1164-NEXT:    v_writelane_b32 v3, s5, 32
; GFX1164-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX1164-NEXT:    v_writelane_b32 v3, s6, 48
; GFX1164-NEXT:    s_mov_b64 exec, s[4:5]
; GFX1164-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    ; implicit-def: $vgpr0
; GFX1164-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1164-NEXT:    s_cbranch_execz .LBB21_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164-NEXT:    v_mov_b32_e32 v4, s7
; GFX1164-NEXT:    s_mov_b32 s3, s7
; GFX1164-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1164-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1164-NEXT:    ds_max_rtn_u32 v0, v0, v4
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:  .LBB21_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1164-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1164-NEXT:    v_mov_b32_e32 v0, v3
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_max_u32_e32 v0, s3, v0
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1164-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: umax_i32_varying:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    v_mov_b32_e32 v1, v0
; GFX1132-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1132-NEXT:    v_mov_b32_e32 v1, 0
; GFX1132-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1132-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_max_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132-NEXT:    v_max_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_max_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132-NEXT:    v_max_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_mov_b32_e32 v2, v1
; GFX1132-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1132-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX1132-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1132-NEXT:    v_max_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1132-NEXT:    v_mov_b32_e32 v3, 0
; GFX1132-NEXT:    v_readlane_b32 s3, v1, 15
; GFX1132-NEXT:    v_readlane_b32 s4, v1, 31
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1132-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132-NEXT:    v_writelane_b32 v3, s3, 16
; GFX1132-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1132-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    ; implicit-def: $vgpr0
; GFX1132-NEXT:    s_and_saveexec_b32 s3, vcc_lo
; GFX1132-NEXT:    s_cbranch_execz .LBB21_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    v_mov_b32_e32 v0, 0
; GFX1132-NEXT:    v_mov_b32_e32 v4, s4
; GFX1132-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1132-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1132-NEXT:    ds_max_rtn_u32 v0, v0, v4
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:  .LBB21_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GFX1132-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1132-NEXT:    v_mov_b32_e32 v0, v3
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_max_u32_e32 v0, s3, v0
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1132-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1132-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %old = atomicrmw umax i32 addrspace(3)* @local_var32, i32 %lane acq_rel
  store i32 %old, i32 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @umax_i64_constant(i64 addrspace(1)* %out) {
;
;
; GFX7LESS-LABEL: umax_i64_constant:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB22_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, 0
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, 5
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    s_mov_b32 m0, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    ds_max_rtn_u64 v[0:1], v2, v[0:1]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:  .LBB22_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    v_readfirstlane_b32 s4, v0
; GFX7LESS-NEXT:    v_readfirstlane_b32 s5, v1
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    v_cndmask_b32_e64 v0, 5, 0, vcc
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, s4
; GFX7LESS-NEXT:    v_cmp_gt_u64_e32 vcc, s[4:5], v[0:1]
; GFX7LESS-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, s5
; GFX7LESS-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: umax_i64_constant:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX8-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB22_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    v_mov_b32_e32 v0, 5
; GFX8-NEXT:    v_mov_b32_e32 v2, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    ds_max_rtn_u64 v[0:1], v2, v[0:1]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:  .LBB22_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_readfirstlane_b32 s2, v0
; GFX8-NEXT:    v_readfirstlane_b32 s3, v1
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_cndmask_b32_e64 v0, 5, 0, vcc
; GFX8-NEXT:    v_cmp_gt_u64_e32 vcc, s[2:3], v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: umax_i64_constant:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB22_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    v_mov_b32_e32 v0, 5
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    ds_max_rtn_u64 v[0:1], v2, v[0:1]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:  .LBB22_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_readfirstlane_b32 s2, v0
; GFX9-NEXT:    v_readfirstlane_b32 s3, v1
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, 5, 0, vcc
; GFX9-NEXT:    v_cmp_gt_u64_e32 vcc, s[2:3], v[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: umax_i64_constant:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1064-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB22_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    v_mov_b32_e32 v0, 5
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-NEXT:    v_mov_b32_e32 v2, 0
; GFX1064-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1064-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1064-NEXT:    ds_max_rtn_u64 v[0:1], v2, v[0:1]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:  .LBB22_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1064-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-NEXT:    v_cndmask_b32_e64 v0, 5, 0, vcc
; GFX1064-NEXT:    v_cmp_gt_u64_e32 vcc, s[2:3], v[0:1]
; GFX1064-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc
; GFX1064-NEXT:    v_cndmask_b32_e64 v1, 0, s3, vcc
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: umax_i64_constant:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1032-NEXT:    s_and_saveexec_b32 s2, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB22_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    v_mov_b32_e32 v0, 5
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-NEXT:    v_mov_b32_e32 v2, 0
; GFX1032-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1032-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1032-NEXT:    ds_max_rtn_u64 v[0:1], v2, v[0:1]
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:  .LBB22_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s2
; GFX1032-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1032-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-NEXT:    v_cndmask_b32_e64 v0, 5, 0, vcc_lo
; GFX1032-NEXT:    v_cmp_gt_u64_e32 vcc_lo, s[2:3], v[0:1]
; GFX1032-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc_lo
; GFX1032-NEXT:    v_cndmask_b32_e64 v1, 0, s3, vcc_lo
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: umax_i64_constant:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1164-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1164-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1164-NEXT:    s_cbranch_execz .LBB22_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    v_mov_b32_e32 v0, 5
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-NEXT:    v_mov_b32_e32 v2, 0
; GFX1164-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1164-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1164-NEXT:    ds_max_rtn_u64 v[0:1], v2, v[0:1]
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:  .LBB22_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1164-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1164-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-NEXT:    v_cndmask_b32_e64 v0, 5, 0, vcc
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_cmp_gt_u64_e32 vcc, s[2:3], v[0:1]
; GFX1164-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc
; GFX1164-NEXT:    v_cndmask_b32_e64 v1, 0, s3, vcc
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1164-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: umax_i64_constant:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1132-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1132-NEXT:    s_and_saveexec_b32 s2, vcc_lo
; GFX1132-NEXT:    s_cbranch_execz .LBB22_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    v_mov_b32_e32 v0, 5
; GFX1132-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v2, 0
; GFX1132-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1132-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1132-NEXT:    ds_max_rtn_u64 v[0:1], v2, v[0:1]
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:  .LBB22_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s2
; GFX1132-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1132-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1132-NEXT:    v_mov_b32_e32 v1, 0
; GFX1132-NEXT:    v_cndmask_b32_e64 v0, 5, 0, vcc_lo
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmp_gt_u64_e32 vcc_lo, s[2:3], v[0:1]
; GFX1132-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc_lo
; GFX1132-NEXT:    v_cndmask_b32_e64 v1, 0, s3, vcc_lo
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1132-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1132-NEXT:    s_endpgm
entry:
  %old = atomicrmw umax i64 addrspace(3)* @local_var64, i64 5 acq_rel
  store i64 %old, i64 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @umin_i32_varying(i32 addrspace(1)* %out) {
;
;
; GFX7LESS-LABEL: umin_i32_varying:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    s_mov_b32 m0, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    ds_min_rtn_u32 v0, v1, v0
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: umin_i32_varying:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v3, exec_hi, v3
; GFX8-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX8-NEXT:    v_mov_b32_e32 v1, -1
; GFX8-NEXT:    s_mov_b64 exec, s[2:3]
; GFX8-NEXT:    v_mov_b32_e32 v2, v0
; GFX8-NEXT:    s_not_b64 exec, exec
; GFX8-NEXT:    v_mov_b32_e32 v2, -1
; GFX8-NEXT:    s_not_b64 exec, exec
; GFX8-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX8-NEXT:    v_min_u32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_min_u32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_min_u32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_min_u32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_min_u32_dpp v2, v2, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_min_u32_dpp v2, v2, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8-NEXT:    v_readlane_b32 s4, v2, 63
; GFX8-NEXT:    s_nop 0
; GFX8-NEXT:    v_mov_b32_dpp v1, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8-NEXT:    s_mov_b64 exec, s[2:3]
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX8-NEXT:    ; implicit-def: $vgpr0
; GFX8-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB23_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s4
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    ds_min_rtn_u32 v0, v0, v3
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:  .LBB23_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_readfirstlane_b32 s2, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, v1
; GFX8-NEXT:    v_min_u32_e32 v0, s2, v0
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    s_nop 0
; GFX8-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: umin_i32_varying:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v3, exec_hi, v3
; GFX9-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX9-NEXT:    v_mov_b32_e32 v1, -1
; GFX9-NEXT:    s_mov_b64 exec, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    s_not_b64 exec, exec
; GFX9-NEXT:    v_mov_b32_e32 v2, -1
; GFX9-NEXT:    s_not_b64 exec, exec
; GFX9-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX9-NEXT:    v_min_u32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_min_u32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_min_u32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_min_u32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_min_u32_dpp v2, v2, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_min_u32_dpp v2, v2, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-NEXT:    v_readlane_b32 s4, v2, 63
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    v_mov_b32_dpp v1, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9-NEXT:    s_mov_b64 exec, s[2:3]
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX9-NEXT:    ; implicit-def: $vgpr0
; GFX9-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB23_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v3, s4
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    ds_min_rtn_u32 v0, v0, v3
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:  .LBB23_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_readfirstlane_b32 s2, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, v1
; GFX9-NEXT:    v_min_u32_e32 v0, s2, v0
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: umin_i32_varying:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    v_mov_b32_e32 v1, v0
; GFX1064-NEXT:    s_not_b64 exec, exec
; GFX1064-NEXT:    v_mov_b32_e32 v1, -1
; GFX1064-NEXT:    s_not_b64 exec, exec
; GFX1064-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1064-NEXT:    v_min_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064-NEXT:    v_mov_b32_e32 v3, -1
; GFX1064-NEXT:    v_min_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1064-NEXT:    v_min_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1064-NEXT:    v_min_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1064-NEXT:    v_mov_b32_e32 v2, v1
; GFX1064-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1064-NEXT:    v_min_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064-NEXT:    v_readlane_b32 s4, v1, 31
; GFX1064-NEXT:    v_mov_b32_e32 v2, s4
; GFX1064-NEXT:    v_min_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064-NEXT:    v_readlane_b32 s4, v1, 15
; GFX1064-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX1064-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1064-NEXT:    v_readlane_b32 s5, v1, 31
; GFX1064-NEXT:    v_writelane_b32 v3, s4, 16
; GFX1064-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1064-NEXT:    v_readlane_b32 s7, v1, 63
; GFX1064-NEXT:    v_readlane_b32 s6, v1, 47
; GFX1064-NEXT:    v_writelane_b32 v3, s5, 32
; GFX1064-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX1064-NEXT:    v_writelane_b32 v3, s6, 48
; GFX1064-NEXT:    s_mov_b64 exec, s[4:5]
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    ; implicit-def: $vgpr0
; GFX1064-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB23_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064-NEXT:    v_mov_b32_e32 v4, s7
; GFX1064-NEXT:    s_mov_b32 s3, s7
; GFX1064-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1064-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1064-NEXT:    ds_min_rtn_u32 v0, v0, v4
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:  .LBB23_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1064-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1064-NEXT:    v_mov_b32_e32 v0, v3
; GFX1064-NEXT:    v_min_u32_e32 v0, s3, v0
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: umin_i32_varying:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    v_mov_b32_e32 v1, v0
; GFX1032-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1032-NEXT:    v_mov_b32_e32 v1, -1
; GFX1032-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1032-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032-NEXT:    v_min_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032-NEXT:    v_min_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1032-NEXT:    v_min_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1032-NEXT:    v_min_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1032-NEXT:    v_mov_b32_e32 v2, v1
; GFX1032-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1032-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX1032-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032-NEXT:    v_min_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032-NEXT:    v_mov_b32_e32 v3, -1
; GFX1032-NEXT:    v_readlane_b32 s3, v1, 15
; GFX1032-NEXT:    v_readlane_b32 s4, v1, 31
; GFX1032-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032-NEXT:    v_writelane_b32 v3, s3, 16
; GFX1032-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    ; implicit-def: $vgpr0
; GFX1032-NEXT:    s_and_saveexec_b32 s3, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB23_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032-NEXT:    v_mov_b32_e32 v4, s4
; GFX1032-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1032-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1032-NEXT:    ds_min_rtn_u32 v0, v0, v4
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:  .LBB23_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GFX1032-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1032-NEXT:    v_mov_b32_e32 v0, v3
; GFX1032-NEXT:    v_min_u32_e32 v0, s3, v0
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: umin_i32_varying:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    v_mov_b32_e32 v1, v0
; GFX1164-NEXT:    s_not_b64 exec, exec
; GFX1164-NEXT:    v_mov_b32_e32 v1, -1
; GFX1164-NEXT:    s_not_b64 exec, exec
; GFX1164-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1164-NEXT:    v_min_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164-NEXT:    v_mov_b32_e32 v3, -1
; GFX1164-NEXT:    v_min_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_min_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1164-NEXT:    v_min_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mov_b32_e32 v2, v1
; GFX1164-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_min_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1164-NEXT:    v_readlane_b32 s4, v1, 31
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mov_b32_e32 v2, s4
; GFX1164-NEXT:    v_min_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_readlane_b32 s4, v1, 15
; GFX1164-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1164-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX1164-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1164-NEXT:    v_readlane_b32 s5, v1, 31
; GFX1164-NEXT:    v_writelane_b32 v3, s4, 16
; GFX1164-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1164-NEXT:    v_readlane_b32 s7, v1, 63
; GFX1164-NEXT:    v_readlane_b32 s6, v1, 47
; GFX1164-NEXT:    v_writelane_b32 v3, s5, 32
; GFX1164-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX1164-NEXT:    v_writelane_b32 v3, s6, 48
; GFX1164-NEXT:    s_mov_b64 exec, s[4:5]
; GFX1164-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    ; implicit-def: $vgpr0
; GFX1164-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1164-NEXT:    s_cbranch_execz .LBB23_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164-NEXT:    v_mov_b32_e32 v4, s7
; GFX1164-NEXT:    s_mov_b32 s3, s7
; GFX1164-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1164-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1164-NEXT:    ds_min_rtn_u32 v0, v0, v4
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:  .LBB23_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1164-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1164-NEXT:    v_mov_b32_e32 v0, v3
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_min_u32_e32 v0, s3, v0
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1164-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: umin_i32_varying:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    v_mov_b32_e32 v1, v0
; GFX1132-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1132-NEXT:    v_mov_b32_e32 v1, -1
; GFX1132-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1132-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_min_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132-NEXT:    v_min_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_min_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1132-NEXT:    v_min_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_mov_b32_e32 v2, v1
; GFX1132-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1132-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX1132-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1132-NEXT:    v_min_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1132-NEXT:    v_mov_b32_e32 v3, -1
; GFX1132-NEXT:    v_readlane_b32 s3, v1, 15
; GFX1132-NEXT:    v_readlane_b32 s4, v1, 31
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1132-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132-NEXT:    v_writelane_b32 v3, s3, 16
; GFX1132-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1132-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    ; implicit-def: $vgpr0
; GFX1132-NEXT:    s_and_saveexec_b32 s3, vcc_lo
; GFX1132-NEXT:    s_cbranch_execz .LBB23_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    v_mov_b32_e32 v0, 0
; GFX1132-NEXT:    v_mov_b32_e32 v4, s4
; GFX1132-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1132-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1132-NEXT:    ds_min_rtn_u32 v0, v0, v4
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:  .LBB23_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GFX1132-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1132-NEXT:    v_mov_b32_e32 v0, v3
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_min_u32_e32 v0, s3, v0
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1132-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1132-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %old = atomicrmw umin i32 addrspace(3)* @local_var32, i32 %lane acq_rel
  store i32 %old, i32 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @umin_i64_constant(i64 addrspace(1)* %out) {
;
;
; GFX7LESS-LABEL: umin_i64_constant:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB24_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, 0
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, 5
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    s_mov_b32 m0, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    ds_min_rtn_u64 v[0:1], v2, v[0:1]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:  .LBB24_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    v_readfirstlane_b32 s4, v0
; GFX7LESS-NEXT:    v_readfirstlane_b32 s5, v1
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    v_cndmask_b32_e64 v1, 0, -1, vcc
; GFX7LESS-NEXT:    v_cndmask_b32_e64 v0, 5, -1, vcc
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, s5
; GFX7LESS-NEXT:    v_cmp_lt_u64_e32 vcc, s[4:5], v[0:1]
; GFX7LESS-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, s4
; GFX7LESS-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: umin_i64_constant:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX8-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB24_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    v_mov_b32_e32 v0, 5
; GFX8-NEXT:    v_mov_b32_e32 v2, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    ds_min_rtn_u64 v[0:1], v2, v[0:1]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:  .LBB24_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_readfirstlane_b32 s4, v0
; GFX8-NEXT:    v_readfirstlane_b32 s5, v1
; GFX8-NEXT:    v_cndmask_b32_e64 v1, 0, -1, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v0, 5, -1, vcc
; GFX8-NEXT:    v_cmp_lt_u64_e32 vcc, s[4:5], v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v2, s5
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX8-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: umin_i64_constant:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB24_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    v_mov_b32_e32 v0, 5
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    ds_min_rtn_u64 v[0:1], v2, v[0:1]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:  .LBB24_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_readfirstlane_b32 s4, v0
; GFX9-NEXT:    v_readfirstlane_b32 s5, v1
; GFX9-NEXT:    v_cndmask_b32_e64 v1, 0, -1, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v0, 5, -1, vcc
; GFX9-NEXT:    v_cmp_lt_u64_e32 vcc, s[4:5], v[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v2, s5
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX9-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: umin_i64_constant:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1064-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB24_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    v_mov_b32_e32 v0, 5
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-NEXT:    v_mov_b32_e32 v2, 0
; GFX1064-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1064-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1064-NEXT:    ds_min_rtn_u64 v[0:1], v2, v[0:1]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:  .LBB24_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1064-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1064-NEXT:    v_cndmask_b32_e64 v1, 0, -1, vcc
; GFX1064-NEXT:    v_cndmask_b32_e64 v0, 5, -1, vcc
; GFX1064-NEXT:    v_cmp_lt_u64_e32 vcc, s[2:3], v[0:1]
; GFX1064-NEXT:    v_cndmask_b32_e64 v1, v1, s3, vcc
; GFX1064-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: umin_i64_constant:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1032-NEXT:    s_and_saveexec_b32 s2, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB24_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    v_mov_b32_e32 v0, 5
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-NEXT:    v_mov_b32_e32 v2, 0
; GFX1032-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1032-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1032-NEXT:    ds_min_rtn_u64 v[0:1], v2, v[0:1]
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:  .LBB24_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s2
; GFX1032-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1032-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1032-NEXT:    v_cndmask_b32_e64 v1, 0, -1, vcc_lo
; GFX1032-NEXT:    v_cndmask_b32_e64 v0, 5, -1, vcc_lo
; GFX1032-NEXT:    v_cmp_lt_u64_e32 vcc_lo, s[2:3], v[0:1]
; GFX1032-NEXT:    v_cndmask_b32_e64 v1, v1, s3, vcc_lo
; GFX1032-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc_lo
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: umin_i64_constant:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1164-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1164-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1164-NEXT:    s_cbranch_execz .LBB24_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    v_mov_b32_e32 v0, 5
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-NEXT:    v_mov_b32_e32 v2, 0
; GFX1164-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1164-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1164-NEXT:    ds_min_rtn_u64 v[0:1], v2, v[0:1]
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:  .LBB24_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1164-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1164-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1164-NEXT:    v_cndmask_b32_e64 v1, 0, -1, vcc
; GFX1164-NEXT:    v_cndmask_b32_e64 v0, 5, -1, vcc
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_cmp_lt_u64_e32 vcc, s[2:3], v[0:1]
; GFX1164-NEXT:    v_cndmask_b32_e64 v1, v1, s3, vcc
; GFX1164-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1164-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: umin_i64_constant:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1132-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1132-NEXT:    s_and_saveexec_b32 s2, vcc_lo
; GFX1132-NEXT:    s_cbranch_execz .LBB24_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    v_mov_b32_e32 v0, 5
; GFX1132-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v2, 0
; GFX1132-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1132-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1132-NEXT:    ds_min_rtn_u64 v[0:1], v2, v[0:1]
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:  .LBB24_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s2
; GFX1132-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1132-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1132-NEXT:    v_cndmask_b32_e64 v1, 0, -1, vcc_lo
; GFX1132-NEXT:    v_cndmask_b32_e64 v0, 5, -1, vcc_lo
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmp_lt_u64_e32 vcc_lo, s[2:3], v[0:1]
; GFX1132-NEXT:    v_cndmask_b32_e64 v1, v1, s3, vcc_lo
; GFX1132-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc_lo
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1132-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1132-NEXT:    s_endpgm
entry:
  %old = atomicrmw umin i64 addrspace(3)* @local_var64, i64 5 acq_rel
  store i64 %old, i64 addrspace(1)* %out
  ret void
}
