#ifndef _LINUX_BH_H
#define _LINUX_BH_H

#include <linux/preempt.h>
#include <linux/preempt_mask.h>

#ifdef CONFIG_TRACE_IRQFLAGS
extern void __local_bh_disable_ip(unsigned long ip, unsigned int cnt);
#else
static __always_inline void __local_bh_disable_ip(unsigned long ip, unsigned int cnt)
{
	add_preempt_count(cnt);
	barrier();
}
#endif

extern void local_bh_disable(void);
extern void _local_bh_enable(void);
extern void local_bh_enable(void);
extern void local_bh_enable_ip(unsigned long ip);
extern void __local_bh_enable_ip(unsigned long ip, unsigned int cnt);

#endif /* _LINUX_BH_H */
