"""Generated message classes for baremetalsolution version v2.

Provides ways to manage Bare Metal Solution hardware installed in a regional
extension located near a Google Cloud data center.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'baremetalsolution'


class BaremetalsolutionProjectsLocationsGetRequest(_messages.Message):
  r"""A BaremetalsolutionProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class BaremetalsolutionProjectsLocationsInstancesGetRequest(_messages.Message):
  r"""A BaremetalsolutionProjectsLocationsInstancesGetRequest object.

  Fields:
    name: Required. Name of the resource.
  """

  name = _messages.StringField(1, required=True)


class BaremetalsolutionProjectsLocationsInstancesListRequest(_messages.Message):
  r"""A BaremetalsolutionProjectsLocationsInstancesListRequest object.

  Fields:
    filter: Filtering results.
    orderBy: Hint for how to order the results.
    pageSize: Requested page size. Server may return fewer items than
      requested. If unspecified, the server will pick an appropriate default.
    pageToken: A token identifying a page of results from the server.
    parent: Required. Parent value for ListInstancesRequest.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class BaremetalsolutionProjectsLocationsListRequest(_messages.Message):
  r"""A BaremetalsolutionProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like "displayName=tokyo", and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class Instance(_messages.Message):
  r"""A server.

  Enums:
    StateValueValuesEnum: The state of the server.

  Messages:
    LabelsValue: Labels as key value pairs.

  Fields:
    createTime: Output only. Create a time stamp.
    hyperthreadingEnabled: True if you enable hyperthreading for the server,
      otherwise false. The default value is false.
    interactiveSerialConsoleEnabled: True if the interactive serial console
      feature is enabled for the instance, false otherwise. The default value
      is false.
    labels: Labels as key value pairs.
    luns: List of LUNs associated with this server.
    machineType: The server type. [Available server
      types](https://cloud.google.com/bare-metal/docs/bms-
      planning#server_configurations)
    name: Output only. The resource name of this `Instance`. Resource names
      are schemeless URIs that follow the conventions in
      https://cloud.google.com/apis/design/resource_names. Format:
      `projects/{project}/locations/{location}/instances/{instance}`
    networks: List of networks associated with this server.
    state: The state of the server.
    updateTime: Output only. Update a time stamp.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The state of the server.

    Values:
      STATE_UNSPECIFIED: The server is in an unknown state.
      PROVISIONING: The server is being provisioned.
      RUNNING: The server is running.
      DELETED: The server has been deleted.
    """
    STATE_UNSPECIFIED = 0
    PROVISIONING = 1
    RUNNING = 2
    DELETED = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels as key value pairs.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  hyperthreadingEnabled = _messages.BooleanField(2)
  interactiveSerialConsoleEnabled = _messages.BooleanField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  luns = _messages.MessageField('Lun', 5, repeated=True)
  machineType = _messages.StringField(6)
  name = _messages.StringField(7)
  networks = _messages.MessageField('Network', 8, repeated=True)
  state = _messages.EnumField('StateValueValuesEnum', 9)
  updateTime = _messages.StringField(10)


class ListInstancesResponse(_messages.Message):
  r"""Response message for the list of servers.

  Fields:
    instances: The list of servers.
    nextPageToken: A token identifying a page of results from the server.
    unreachable: Locations that could not be reached.
  """

  instances = _messages.MessageField('Instance', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class Location(_messages.Message):
  r"""A resource that represents Google Cloud Platform location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class Lun(_messages.Message):
  r"""A storage volume logical unit number (LUN).

  Enums:
    MultiprotocolTypeValueValuesEnum: The LUN multiprotocol type ensures the
      characteristics of the LUN are optimized for each operating system.
    StateValueValuesEnum: The state of this storage volume.
    StorageTypeValueValuesEnum: The storage type for this LUN.

  Fields:
    bootLun: Display if this LUN is a boot LUN.
    multiprotocolType: The LUN multiprotocol type ensures the characteristics
      of the LUN are optimized for each operating system.
    name: Output only. The name of the LUN.
    shareable: Display if this LUN can be shared between multiple physical
      servers.
    sizeGb: The size of this LUN, in gigabytes.
    state: The state of this storage volume.
    storageType: The storage type for this LUN.
    storageVolume: Display the storage volume for this LUN.
  """

  class MultiprotocolTypeValueValuesEnum(_messages.Enum):
    r"""The LUN multiprotocol type ensures the characteristics of the LUN are
    optimized for each operating system.

    Values:
      MULTIPROTOCOL_TYPE_UNSPECIFIED: Server has no OS specified.
      LINUX: Server with Linux OS.
    """
    MULTIPROTOCOL_TYPE_UNSPECIFIED = 0
    LINUX = 1

  class StateValueValuesEnum(_messages.Enum):
    r"""The state of this storage volume.

    Values:
      STATE_UNSPECIFIED: The LUN is in an unknown state.
      CREATING: The LUN is being created.
      UPDATING: The LUN is being updated.
      READY: The LUN is ready for use.
      DELETING: The LUN has been requested to be deleted.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    UPDATING = 2
    READY = 3
    DELETING = 4

  class StorageTypeValueValuesEnum(_messages.Enum):
    r"""The storage type for this LUN.

    Values:
      STORAGE_TYPE_UNSPECIFIED: The storage type for this LUN is unknown.
      SSD: This storage type for this LUN is SSD.
      HDD: This storage type for this LUN is HDD.
    """
    STORAGE_TYPE_UNSPECIFIED = 0
    SSD = 1
    HDD = 2

  bootLun = _messages.BooleanField(1)
  multiprotocolType = _messages.EnumField('MultiprotocolTypeValueValuesEnum', 2)
  name = _messages.StringField(3)
  shareable = _messages.BooleanField(4)
  sizeGb = _messages.IntegerField(5)
  state = _messages.EnumField('StateValueValuesEnum', 6)
  storageType = _messages.EnumField('StorageTypeValueValuesEnum', 7)
  storageVolume = _messages.StringField(8)


class Network(_messages.Message):
  r"""A network.

  Enums:
    TypeValueValuesEnum: The type of this network.

  Fields:
    ipAddress: IP address configured.
    macAddress: List of physical interfaces.
    name: Output only. The resource name of this `Network`. Resource names are
      schemeless URIs that follow the conventions in
      https://cloud.google.com/apis/design/resource_names. Format:
      `projects/{project}/locations/{location}/networks/{network}` This field
      will contain the same value as field "network", which will soon be
      deprecated. Please use this field to reference the name of the network
      resource.
    network: Name of the network.
    type: The type of this network.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of this network.

    Values:
      TYPE_UNSPECIFIED: Unspecified value.
      CLIENT: Client network, a network peered to a Google Cloud VPC.
      PRIVATE: Private network, a network local to the Bare Metal Solution
        environment.
    """
    TYPE_UNSPECIFIED = 0
    CLIENT = 1
    PRIVATE = 2

  ipAddress = _messages.StringField(1)
  macAddress = _messages.StringField(2, repeated=True)
  name = _messages.StringField(3)
  network = _messages.StringField(4)
  type = _messages.EnumField('TypeValueValuesEnum', 5)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
