; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --check-globals --version 2
; RUN: opt < %s -passes='simplifycfg<sink-common-insts;no-hoist-common-insts>' -simplifycfg-require-and-preserve-domtree=1 -S | FileCheck %s --check-prefix=SINK


; Test case based on the following C++ code with manualy annotated !prof metadata.
; This is to test that when calls to 'func1' from 'if.then' and 'if.else' are
; sinked, the branch weights are merged and attached to sinked call.
;
; int func1(int a, int b) ;
; int func2(int a, int b) ;

; int func(int a, int b, bool c) {
;    int sum = 0;
;    if (c) {
;        sum += func1(a,b);
;    } else {
;        b -= func2(a,b);
;        sum += func1(a,b);
;    }
;    return sum;
; }

define i32 @_Z4funciib(i32 %a, i32 %b, i1 %c) {
; SINK-LABEL: define i32 @_Z4funciib
; SINK-SAME: (i32 [[A:%.*]], i32 [[B:%.*]], i1 [[C:%.*]]) {
; SINK-NEXT:  entry:
; SINK-NEXT:    br i1 [[C]], label [[IF_END:%.*]], label [[IF_ELSE:%.*]]
; SINK:       if.else:
; SINK-NEXT:    [[CALL1:%.*]] = tail call i32 @_Z5func2ii(i32 [[A]], i32 [[B]])
; SINK-NEXT:    [[SUB:%.*]] = sub i32 [[B]], [[CALL1]]
; SINK-NEXT:    br label [[IF_END]]
; SINK:       if.end:
; SINK-NEXT:    [[SUB_SINK:%.*]] = phi i32 [ [[SUB]], [[IF_ELSE]] ], [ [[B]], [[ENTRY:%.*]] ]
; SINK-NEXT:    [[CALL2:%.*]] = tail call i32 @_Z5func1ii(i32 [[A]], i32 [[SUB_SINK]]), !prof [[PROF0:![0-9]+]]
; SINK-NEXT:    ret i32 [[CALL2]]
;
entry:
  br i1 %c, label %if.then, label %if.else

if.then:                                          ; preds = %entry
  %call = tail call i32 @_Z5func1ii(i32 %a, i32 %b), !prof !0
  br label %if.end

if.else:                                          ; preds = %entry
  %call1 = tail call i32 @_Z5func2ii(i32 %a, i32 %b)
  %sub = sub i32 %b, %call1
  %call2 = tail call i32 @_Z5func1ii(i32 %a, i32 %sub), !prof !1
  br label %if.end

if.end:                                           ; preds = %if.else, %if.then
  %sum.0 = phi i32 [ %call, %if.then ], [ %call2, %if.else ]
  ret i32 %sum.0
}

declare i32 @_Z5func1ii(i32, i32)

declare i32 @_Z5func2ii(i32, i32)

!0 = !{!"branch_weights", i32 10}
!1 = !{!"branch_weights", i32 90}
;.
; SINK: [[PROF0]] = !{!"branch_weights", i64 100}
;.
