; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mattr=+sve -force-streaming-compatible-sve  < %s | FileCheck %s

target triple = "aarch64-unknown-linux-gnu"

define <4 x i32> @test(ptr %arg1, ptr %arg2) {
; CHECK-LABEL: test:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ldp q2, q1, [x0, #32]
; CHECK-NEXT:    add z2.s, z2.s, z2.s
; CHECK-NEXT:    ldp q3, q4, [x0]
; CHECK-NEXT:    mov z0.s, z1.s[2]
; CHECK-NEXT:    add z1.s, z1.s, z1.s
; CHECK-NEXT:    stp q2, q1, [x0, #32]
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    add z2.s, z3.s, z3.s
; CHECK-NEXT:    add z1.s, z4.s, z4.s
; CHECK-NEXT:    stp q2, q1, [x0]
; CHECK-NEXT:    ret
entry:
  %0 = load <16 x i32>, ptr %arg1, align 256
  %1 = load <16 x i32>, ptr %arg2, align 256
  %shvec = shufflevector <16 x i32> %0, <16 x i32> %1, <4 x i32> <i32 14, i32 14, i32 14, i32 14>
  %2 = add <16 x i32> %0, %0
  store <16 x i32> %2, ptr %arg1, align 256
  ret <4 x i32> %shvec
}

define <2 x i32> @test2(ptr %arg1, ptr %arg2) {
; CHECK-LABEL: test2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ldp q1, q0, [x0, #32]
; CHECK-NEXT:    add z1.s, z1.s, z1.s
; CHECK-NEXT:    ldp q2, q3, [x0]
; CHECK-NEXT:    add z4.s, z0.s, z0.s
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    mov z0.s, s0
; CHECK-NEXT:    stp q1, q4, [x0, #32]
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    add z1.s, z2.s, z2.s
; CHECK-NEXT:    add z2.s, z3.s, z3.s
; CHECK-NEXT:    stp q1, q2, [x0]
; CHECK-NEXT:    ret
entry:
  %0 = load <16 x i32>, ptr %arg1, align 256
  %1 = load <16 x i32>, ptr %arg2, align 256
  %shvec = shufflevector <16 x i32> %0, <16 x i32> %1, <2 x i32> <i32 14, i32 14>
  %2 = add <16 x i32> %0, %0
  store <16 x i32> %2, ptr %arg1, align 256
  ret <2 x i32> %shvec
}
