; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=avr | FileCheck %s

define void @add_r_i8(i8 signext %0, i8 signext %1) {
; CHECK-LABEL: add_r_i8:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    mov r20, r22
; CHECK-NEXT:    mov r22, r24
; CHECK-NEXT:    ;APP
; CHECK-NEXT:    mov r24, r22
; CHECK-NEXT:    add r24, r20
; CHECK-NEXT:    ;NO_APP
; CHECK-NEXT:    rcall foo8
; CHECK-NEXT:    ret
  %3 = tail call i8 asm sideeffect "mov $0, $1\0Aadd $0, $2", "=r,r,r"(i8 %0, i8 %1)
  tail call void @foo8(i8 signext %3, i8 signext %0, i8 signext %1)
  ret void
}

declare void @foo8(i8 signext, i8 signext, i8 signext)

define void @add_r_i16(i16 signext %0, i16 signext %1) {
; CHECK-LABEL: add_r_i16:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    mov r20, r22
; CHECK-NEXT:    mov r21, r23
; CHECK-NEXT:    mov r22, r24
; CHECK-NEXT:    mov r23, r25
; CHECK-NEXT:    ;APP
; CHECK-NEXT:    mov r24, r22
; CHECK-NEXT:    mov r25, r23
; CHECK-NEXT:    add r24, r20
; CHECK-NEXT:    adc r25, r21
; CHECK-NEXT:    ;NO_APP
; CHECK-NEXT:    rcall foo16
; CHECK-NEXT:    ret
  %3 = tail call i16 asm sideeffect "mov ${0:A}, ${1:A}\0Amov ${0:B}, ${1:B}\0Aadd ${0:A}, ${2:A}\0Aadc ${0:B}, ${2:B}", "=r,r,r"(i16 %0, i16 %1)
  tail call void @foo16(i16 signext %3, i16 signext %0, i16 signext %1)
  ret void
}

declare void @foo16(i16 signext, i16 signext, i16 signext)

define void @add_a_i8(i8 signext %0, i8 signext %1) {
; CHECK-LABEL: add_a_i8:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    mov r20, r22
; CHECK-NEXT:    mov r22, r24
; CHECK-NEXT:    ;APP
; CHECK-NEXT:    mov r23, r22
; CHECK-NEXT:    add r23, r20
; CHECK-NEXT:    ;NO_APP
; CHECK-NEXT:    mov r24, r23
; CHECK-NEXT:    rcall foo8
; CHECK-NEXT:    ret
  %3 = tail call i8 asm sideeffect "mov $0, $1\0Aadd $0, $2", "=a,a,a"(i8 %0, i8 %1)
  tail call void @foo8(i8 signext %3, i8 signext %0, i8 signext %1)
  ret void
}

define void @add_a_i16(i16 signext %0, i16 signext %1) {
; CHECK-LABEL: add_a_i16:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    mov r20, r22
; CHECK-NEXT:    mov r21, r23
; CHECK-NEXT:    mov r22, r24
; CHECK-NEXT:    mov r23, r25
; CHECK-NEXT:    ;APP
; CHECK-NEXT:    mov r18, r22
; CHECK-NEXT:    mov r19, r23
; CHECK-NEXT:    add r18, r20
; CHECK-NEXT:    adc r19, r21
; CHECK-NEXT:    ;NO_APP
; CHECK-NEXT:    mov r24, r18
; CHECK-NEXT:    mov r25, r19
; CHECK-NEXT:    rcall foo16
; CHECK-NEXT:    ret
  %3 = tail call i16 asm sideeffect "mov ${0:A}, ${1:A}\0Amov ${0:B}, ${1:B}\0Aadd ${0:A}, ${2:A}\0Aadc ${0:B}, ${2:B}", "=a,a,a"(i16 %0, i16 %1)
  tail call void @foo16(i16 signext %3, i16 signext %0, i16 signext %1)
  ret void
}

define void @add_d_i8(i8 signext %0, i8 signext %1) {
; CHECK-LABEL: add_d_i8:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    mov r20, r22
; CHECK-NEXT:    mov r22, r24
; CHECK-NEXT:    ;APP
; CHECK-NEXT:    mov r24, r22
; CHECK-NEXT:    add r24, r20
; CHECK-NEXT:    ;NO_APP
; CHECK-NEXT:    rcall foo8
; CHECK-NEXT:    ret
  %3 = tail call i8 asm sideeffect "mov $0, $1\0Aadd $0, $2", "=d,d,d"(i8 %0, i8 %1)
  tail call void @foo8(i8 signext %3, i8 signext %0, i8 signext %1)
  ret void
}

define void @add_d_i16(i16 signext %0, i16 signext %1) {
; CHECK-LABEL: add_d_i16:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    mov r20, r22
; CHECK-NEXT:    mov r21, r23
; CHECK-NEXT:    mov r22, r24
; CHECK-NEXT:    mov r23, r25
; CHECK-NEXT:    ;APP
; CHECK-NEXT:    mov r24, r22
; CHECK-NEXT:    mov r25, r23
; CHECK-NEXT:    add r24, r20
; CHECK-NEXT:    adc r25, r21
; CHECK-NEXT:    ;NO_APP
; CHECK-NEXT:    rcall foo16
; CHECK-NEXT:    ret
  %3 = tail call i16 asm sideeffect "mov ${0:A}, ${1:A}\0Amov ${0:B}, ${1:B}\0Aadd ${0:A}, ${2:A}\0Aadc ${0:B}, ${2:B}", "=d,d,d"(i16 %0, i16 %1)
  tail call void @foo16(i16 signext %3, i16 signext %0, i16 signext %1)
  ret void
}

define void @add_l_i8(i8 signext %0, i8 signext %1) {
; CHECK-LABEL: add_l_i8:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    push r13
; CHECK-NEXT:    push r14
; CHECK-NEXT:    push r15
; CHECK-NEXT:    mov r15, r22
; CHECK-NEXT:    mov r14, r24
; CHECK-NEXT:    ;APP
; CHECK-NEXT:    mov r13, r14
; CHECK-NEXT:    add r13, r15
; CHECK-NEXT:    ;NO_APP
; CHECK-NEXT:    mov r24, r13
; CHECK-NEXT:    mov r22, r14
; CHECK-NEXT:    mov r20, r15
; CHECK-NEXT:    rcall foo8
; CHECK-NEXT:    pop r15
; CHECK-NEXT:    pop r14
; CHECK-NEXT:    pop r13
; CHECK-NEXT:    ret
  %3 = tail call i8 asm sideeffect "mov $0, $1\0Aadd $0, $2", "=l,l,l"(i8 %0, i8 %1)
  tail call void @foo8(i8 signext %3, i8 signext %0, i8 signext %1)
  ret void
}

define void @add_l_i16(i16 signext %0, i16 signext %1) {
; CHECK-LABEL: add_l_i16:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    push r10
; CHECK-NEXT:    push r11
; CHECK-NEXT:    push r12
; CHECK-NEXT:    push r13
; CHECK-NEXT:    push r14
; CHECK-NEXT:    push r15
; CHECK-NEXT:    mov r14, r22
; CHECK-NEXT:    mov r15, r23
; CHECK-NEXT:    mov r12, r24
; CHECK-NEXT:    mov r13, r25
; CHECK-NEXT:    ;APP
; CHECK-NEXT:    mov r10, r12
; CHECK-NEXT:    mov r11, r13
; CHECK-NEXT:    add r10, r14
; CHECK-NEXT:    adc r11, r15
; CHECK-NEXT:    ;NO_APP
; CHECK-NEXT:    mov r24, r10
; CHECK-NEXT:    mov r25, r11
; CHECK-NEXT:    mov r22, r12
; CHECK-NEXT:    mov r23, r13
; CHECK-NEXT:    mov r20, r14
; CHECK-NEXT:    mov r21, r15
; CHECK-NEXT:    rcall foo16
; CHECK-NEXT:    pop r15
; CHECK-NEXT:    pop r14
; CHECK-NEXT:    pop r13
; CHECK-NEXT:    pop r12
; CHECK-NEXT:    pop r11
; CHECK-NEXT:    pop r10
; CHECK-NEXT:    ret
  %3 = tail call i16 asm sideeffect "mov ${0:A}, ${1:A}\0Amov ${0:B}, ${1:B}\0Aadd ${0:A}, ${2:A}\0Aadc ${0:B}, ${2:B}", "=l,l,l"(i16 %0, i16 %1)
  tail call void @foo16(i16 signext %3, i16 signext %0, i16 signext %1)
  ret void
}

define void @add_b_i8(i8 signext %0, i8 signext %1) {
; CHECK-LABEL: add_b_i8:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    mov r20, r22
; CHECK-NEXT:    mov r22, r24
; CHECK-NEXT:    mov r30, r22
; CHECK-NEXT:    ;APP
; CHECK-NEXT:    mov r30, r30
; CHECK-NEXT:    add r30, r20
; CHECK-NEXT:    ;NO_APP
; CHECK-NEXT:    mov r24, r30
; CHECK-NEXT:    rcall foo8
; CHECK-NEXT:    ret
  %3 = tail call i8 asm sideeffect "mov $0, $1\0Aadd $0, $2", "=b,b,r"(i8 %0, i8 %1)
  tail call void @foo8(i8 signext %3, i8 signext %0, i8 signext %1)
  ret void
}

define void @add_b_i16(i16 signext %0, i16 signext %1) {
; CHECK-LABEL: add_b_i16:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    mov r20, r22
; CHECK-NEXT:    mov r21, r23
; CHECK-NEXT:    mov r22, r24
; CHECK-NEXT:    mov r23, r25
; CHECK-NEXT:    mov r30, r22
; CHECK-NEXT:    mov r31, r23
; CHECK-NEXT:    ;APP
; CHECK-NEXT:    mov r30, r30
; CHECK-NEXT:    mov r31, r31
; CHECK-NEXT:    add r30, r20
; CHECK-NEXT:    adc r31, r21
; CHECK-NEXT:    ;NO_APP
; CHECK-NEXT:    mov r24, r30
; CHECK-NEXT:    mov r25, r31
; CHECK-NEXT:    rcall foo16
; CHECK-NEXT:    ret
  %3 = tail call i16 asm sideeffect "mov ${0:A}, ${1:A}\0Amov ${0:B}, ${1:B}\0Aadd ${0:A}, ${2:A}\0Aadc ${0:B}, ${2:B}", "=b,b,r"(i16 %0, i16 %1)
  tail call void @foo16(i16 signext %3, i16 signext %0, i16 signext %1)
  ret void
}

define void @add_e_i8(i8 signext %0, i8 signext %1) {
; CHECK-LABEL: add_e_i8:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    mov r30, r22
; CHECK-NEXT:    mov r22, r24
; CHECK-NEXT:    mov r26, r22
; CHECK-NEXT:    ;APP
; CHECK-NEXT:    mov r26, r26
; CHECK-NEXT:    add r26, r30
; CHECK-NEXT:    ;NO_APP
; CHECK-NEXT:    mov r20, r30
; CHECK-NEXT:    mov r24, r26
; CHECK-NEXT:    rcall foo8
; CHECK-NEXT:    ret
  %3 = tail call i8 asm sideeffect "mov $0, $1\0Aadd $0, $2", "=e,e,e"(i8 %0, i8 %1)
  tail call void @foo8(i8 signext %3, i8 signext %0, i8 signext %1)
  ret void
}

define void @add_e_i16(i16 signext %0, i16 signext %1) {
; CHECK-LABEL: add_e_i16:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    mov r30, r22
; CHECK-NEXT:    mov r31, r23
; CHECK-NEXT:    mov r22, r24
; CHECK-NEXT:    mov r23, r25
; CHECK-NEXT:    mov r26, r22
; CHECK-NEXT:    mov r27, r23
; CHECK-NEXT:    ;APP
; CHECK-NEXT:    mov r26, r26
; CHECK-NEXT:    mov r27, r27
; CHECK-NEXT:    add r26, r30
; CHECK-NEXT:    adc r27, r31
; CHECK-NEXT:    ;NO_APP
; CHECK-NEXT:    mov r24, r26
; CHECK-NEXT:    mov r25, r27
; CHECK-NEXT:    mov r20, r30
; CHECK-NEXT:    mov r21, r31
; CHECK-NEXT:    rcall foo16
; CHECK-NEXT:    ret
  %3 = tail call i16 asm sideeffect "mov ${0:A}, ${1:A}\0Amov ${0:B}, ${1:B}\0Aadd ${0:A}, ${2:A}\0Aadc ${0:B}, ${2:B}", "=e,e,e"(i16 %0, i16 %1)
  tail call void @foo16(i16 signext %3, i16 signext %0, i16 signext %1)
  ret void
}

define void @add_t_i8(i8 signext %0, i8 signext %1) {
; CHECK-LABEL: add_t_i8:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    mov r20, r22
; CHECK-NEXT:    mov r22, r24
; CHECK-NEXT:    ;APP
; CHECK-NEXT:    mov r0, r22
; CHECK-NEXT:    add r0, r20
; CHECK-NEXT:    ;NO_APP
; CHECK-NEXT:    mov r24, r0
; CHECK-NEXT:    rcall foo8
; CHECK-NEXT:    ret
  %3 = tail call i8 asm sideeffect "mov $0, $1\0Aadd $0, $2", "=t,r,r"(i8 %0, i8 %1)
  tail call void @foo8(i8 signext %3, i8 signext %0, i8 signext %1)
  ret void
}

define void @add_w_i8(i8 signext %0, i8 signext %1) {
; CHECK-LABEL: add_w_i8:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    mov r26, r22
; CHECK-NEXT:    mov r30, r24
; CHECK-NEXT:    ;APP
; CHECK-NEXT:    mov r24, r30
; CHECK-NEXT:    add r24, r26
; CHECK-NEXT:    ;NO_APP
; CHECK-NEXT:    mov r22, r30
; CHECK-NEXT:    mov r20, r26
; CHECK-NEXT:    rcall foo8
; CHECK-NEXT:    ret
  %3 = tail call i8 asm sideeffect "mov $0, $1\0Aadd $0, $2", "=w,w,w"(i8 %0, i8 %1)
  tail call void @foo8(i8 signext %3, i8 signext %0, i8 signext %1)
  ret void
}

define void @add_w_i16(i16 signext %0, i16 signext %1) {
; CHECK-LABEL: add_w_i16:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    mov r26, r22
; CHECK-NEXT:    mov r27, r23
; CHECK-NEXT:    mov r30, r24
; CHECK-NEXT:    mov r31, r25
; CHECK-NEXT:    ;APP
; CHECK-NEXT:    mov r24, r30
; CHECK-NEXT:    mov r25, r31
; CHECK-NEXT:    add r24, r26
; CHECK-NEXT:    adc r25, r27
; CHECK-NEXT:    ;NO_APP
; CHECK-NEXT:    mov r22, r30
; CHECK-NEXT:    mov r23, r31
; CHECK-NEXT:    mov r20, r26
; CHECK-NEXT:    mov r21, r27
; CHECK-NEXT:    rcall foo16
; CHECK-NEXT:    ret
  %3 = tail call i16 asm sideeffect "mov ${0:A}, ${1:A}\0Amov ${0:B}, ${1:B}\0Aadd ${0:A}, ${2:A}\0Aadc ${0:B}, ${2:B}", "=w,w,w"(i16 %0, i16 %1)
  tail call void @foo16(i16 signext %3, i16 signext %0, i16 signext %1)
  ret void
}

define void @add_xyz_i8(i8 signext %0, i8 signext %1) {
; CHECK-LABEL: add_xyz_i8:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    push r28
; CHECK-NEXT:    push r29
; CHECK-NEXT:    mov r20, r22
; CHECK-NEXT:    mov r22, r24
; CHECK-NEXT:    mov r28, r22
; CHECK-NEXT:    mov r29, r23
; CHECK-NEXT:    mov r26, r20
; CHECK-NEXT:    mov r27, r21
; CHECK-NEXT:    ;APP
; CHECK-NEXT:    mov r30, r28
; CHECK-NEXT:    add r30, r26
; CHECK-NEXT:    ;NO_APP
; CHECK-NEXT:    mov r24, r30
; CHECK-NEXT:    mov r25, r31
; CHECK-NEXT:    rcall foo8
; CHECK-NEXT:    pop r29
; CHECK-NEXT:    pop r28
; CHECK-NEXT:    ret
  %3 = tail call i8 asm sideeffect "mov $0, $1\0Aadd $0, $2", "=z,y,x"(i8 %0, i8 %1)
  tail call void @foo8(i8 signext %3, i8 signext %0, i8 signext %1)
  ret void
}

define void @add_xyz_i16(i16 signext %0, i16 signext %1) {
; CHECK-LABEL: add_xyz_i16:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    push r28
; CHECK-NEXT:    push r29
; CHECK-NEXT:    mov r20, r22
; CHECK-NEXT:    mov r21, r23
; CHECK-NEXT:    mov r22, r24
; CHECK-NEXT:    mov r23, r25
; CHECK-NEXT:    mov r28, r22
; CHECK-NEXT:    mov r29, r23
; CHECK-NEXT:    mov r26, r20
; CHECK-NEXT:    mov r27, r21
; CHECK-NEXT:    ;APP
; CHECK-NEXT:    mov r30, r28
; CHECK-NEXT:    mov r31, r29
; CHECK-NEXT:    add r30, r26
; CHECK-NEXT:    adc r31, r27
; CHECK-NEXT:    ;NO_APP
; CHECK-NEXT:    mov r24, r30
; CHECK-NEXT:    mov r25, r31
; CHECK-NEXT:    rcall foo16
; CHECK-NEXT:    pop r29
; CHECK-NEXT:    pop r28
; CHECK-NEXT:    ret
  %3 = tail call i16 asm sideeffect "mov ${0:A}, ${1:A}\0Amov ${0:B}, ${1:B}\0Aadd ${0:A}, ${2:A}\0Aadc ${0:B}, ${2:B}", "=z,y,x"(i16 %0, i16 %1)
  tail call void @foo16(i16 signext %3, i16 signext %0, i16 signext %1)
  ret void
}

@gvar = global i16 0

define i16* @ldi_dreg_symbol() {
; CHECK-LABEL: ldi_dreg_symbol:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    ;APP
; CHECK-NEXT:    ldi r25, hi8(gvar)
; CHECK-NEXT:    ldi r24, lo8(gvar)
; CHECK-NEXT:    ;NO_APP
; CHECK-NEXT:    ret
  %1 = tail call i16* asm sideeffect "ldi ${0:B}, hi8($1)\0A\09ldi ${0:A}, lo8($1)", "=d,i"(i16* @gvar)
  ret i16* %1
}

define i16* @ldi_dreg_imm() {
; CHECK-LABEL: ldi_dreg_imm:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    ;APP
; CHECK-NEXT:    ldi r25, hi8(2345)
; CHECK-NEXT:    ldi r24, lo8(2345)
; CHECK-NEXT:    ;NO_APP
; CHECK-NEXT:    ret
  %1 = tail call i16* asm sideeffect "ldi ${0:B}, hi8($1)\0A\09ldi ${0:A}, lo8($1)", "=d,i"(i16 2345)
  ret i16* %1
}
