; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -march=amdgcn -mcpu=gfx900 --verify-machineinstrs < %s | FileCheck --check-prefixes=GCN,GFX9 %s
; RUN: llc -march=amdgcn -mcpu=gfx1030 --verify-machineinstrs < %s | FileCheck --check-prefixes=GCN,GFX10 %s
; RUN: llc -march=amdgcn -mcpu=gfx1100 -amdgpu-enable-vopd=0 -amdgpu-enable-delay-alu=0 --verify-machineinstrs < %s | FileCheck --check-prefixes=GCN,GFX11 %s
; RUN: llc -march=amdgcn -mcpu=gfx1030 -mattr=+wavefrontsize64 --verify-machineinstrs < %s | FileCheck --check-prefixes=GCN,GFX10 %s
; RUN: llc -march=amdgcn -mcpu=gfx1100 -amdgpu-enable-delay-alu=0 -mattr=+wavefrontsize64 --verify-machineinstrs < %s | FileCheck --check-prefixes=GCN,GFX11 %s

define amdgpu_ps float @mad_i32_vvv(i32 %a, i32 %b, i32 %c) {
; GFX9-LABEL: mad_i32_vvv:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mad_u64_u32 v[0:1], s[0:1], v0, v1, v[2:3]
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: mad_i32_vvv:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_mad_u64_u32 v[0:1], null, v0, v1, v[2:3]
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: mad_i32_vvv:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_mov_b32_e32 v3, v1
; GFX11-NEXT:    v_mov_b32_e32 v4, v0
; GFX11-NEXT:    v_mad_u64_u32 v[0:1], null, v4, v3, v[2:3]
; GFX11-NEXT:    ; return to shader part epilog
  %mul = mul i32 %a, %b
  %add = add i32 %mul, %c
  %cast = bitcast i32 %add to float
  ret float %cast
}

define amdgpu_ps float @mad_i32_sss(i32 inreg %a, i32 inreg %b, i32 inreg %c) {
; GCN-LABEL: mad_i32_sss:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_mul_i32 s0, s0, s1
; GCN-NEXT:    s_add_i32 s0, s0, s2
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    ; return to shader part epilog
  %mul = mul i32 %a, %b
  %add = add i32 %mul, %c
  %cast = bitcast i32 %add to float
  ret float %cast
}

define amdgpu_ps float @mad_i32_vvc(i32 %a, i32 %b) {
; GFX9-LABEL: mad_i32_vvc:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mad_u64_u32 v[0:1], s[0:1], v0, v1, 42
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: mad_i32_vvc:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_mad_u64_u32 v[0:1], null, v0, v1, 42
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: mad_i32_vvc:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_mov_b32_e32 v2, v1
; GFX11-NEXT:    v_mov_b32_e32 v3, v0
; GFX11-NEXT:    v_mad_u64_u32 v[0:1], null, v3, v2, 42
; GFX11-NEXT:    ; return to shader part epilog
  %mul = mul i32 %a, %b
  %add = add i32 %mul, 42
  %cast = bitcast i32 %add to float
  ret float %cast
}

define amdgpu_ps float @mad_i32_vvi(i32 %a, i32 %b) {
; GFX9-LABEL: mad_i32_vvi:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v2, 0x12d687
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    v_mad_u64_u32 v[0:1], s[0:1], v0, v1, v[2:3]
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: mad_i32_vvi:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_mad_u64_u32 v[0:1], null, v0, v1, 0x12d687
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: mad_i32_vvi:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_mov_b32_e32 v2, v1
; GFX11-NEXT:    v_mov_b32_e32 v3, v0
; GFX11-NEXT:    v_mad_u64_u32 v[0:1], null, v3, v2, 0x12d687
; GFX11-NEXT:    ; return to shader part epilog
  %mul = mul i32 %a, %b
  %add = add i32 %mul, 1234567
  %cast = bitcast i32 %add to float
  ret float %cast
}

define amdgpu_ps float @mad_i32_vvi_neg(i32 %a, i32 %b) {
; GFX9-LABEL: mad_i32_vvi_neg:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v2, 0xffed2979
; GFX9-NEXT:    v_mov_b32_e32 v3, -1
; GFX9-NEXT:    v_mad_u64_u32 v[0:1], s[0:1], v0, v1, v[2:3]
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: mad_i32_vvi_neg:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_mad_u64_u32 v[0:1], null, v0, v1, 0xffffffffffed2979
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: mad_i32_vvi_neg:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_mov_b32_e32 v2, v1
; GFX11-NEXT:    v_mov_b32_e32 v3, v0
; GFX11-NEXT:    v_mad_u64_u32 v[0:1], null, v3, v2, 0xffffffffffed2979
; GFX11-NEXT:    ; return to shader part epilog
  %mul = mul i32 %a, %b
  %add = add i32 %mul, -1234567
  %cast = bitcast i32 %add to float
  ret float %cast
}

define amdgpu_ps float @mad_i32_vcv(i32 %a, i32 %c) {
; GFX9-LABEL: mad_i32_vcv:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mad_u64_u32 v[0:1], s[0:1], v0, 42, v[1:2]
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: mad_i32_vcv:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_mad_u64_u32 v[0:1], null, v0, 42, v[1:2]
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: mad_i32_vcv:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_mad_u64_u32 v[2:3], null, v0, 42, v[1:2]
; GFX11-NEXT:    v_mov_b32_e32 v0, v2
; GFX11-NEXT:    ; return to shader part epilog
  %mul = mul i32 %a, 42
  %add = add i32 %mul, %c
  %cast = bitcast i32 %add to float
  ret float %cast
}

define amdgpu_ps float @mad_i32_vcc(i32 %a) {
; GFX9-LABEL: mad_i32_vcc:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mad_u64_u32 v[0:1], s[0:1], v0, 42, 43
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: mad_i32_vcc:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_mad_u64_u32 v[0:1], null, v0, 42, 43
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: mad_i32_vcc:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_mov_b32_e32 v2, v0
; GFX11-NEXT:    v_mad_u64_u32 v[0:1], null, v2, 42, 43
; GFX11-NEXT:    ; return to shader part epilog
  %mul = mul i32 %a, 42
  %add = add i32 %mul, 43
  %cast = bitcast i32 %add to float
  ret float %cast
}

define amdgpu_ps float @mad_i32_vvs(i32 %a, i32 %b, i32 inreg %c) {
; GFX9-LABEL: mad_i32_vvs:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mad_u64_u32 v[0:1], s[0:1], v0, v1, s[0:1]
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: mad_i32_vvs:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_mad_u64_u32 v[0:1], null, v0, v1, s[0:1]
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: mad_i32_vvs:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_mov_b32_e32 v2, v1
; GFX11-NEXT:    v_mov_b32_e32 v3, v0
; GFX11-NEXT:    v_mad_u64_u32 v[0:1], null, v3, v2, s[0:1]
; GFX11-NEXT:    ; return to shader part epilog
  %mul = mul i32 %a, %b
  %add = add i32 %mul, %c
  %cast = bitcast i32 %add to float
  ret float %cast
}

define amdgpu_ps float @mad_i32_vsv(i32 %a, i32 inreg %b, i32 %c) {
; GFX9-LABEL: mad_i32_vsv:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mad_u64_u32 v[0:1], s[0:1], v0, s0, v[1:2]
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: mad_i32_vsv:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_mad_u64_u32 v[0:1], null, v0, s0, v[1:2]
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: mad_i32_vsv:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_mad_u64_u32 v[2:3], null, v0, s0, v[1:2]
; GFX11-NEXT:    v_mov_b32_e32 v0, v2
; GFX11-NEXT:    ; return to shader part epilog
  %mul = mul i32 %a, %b
  %add = add i32 %mul, %c
  %cast = bitcast i32 %add to float
  ret float %cast
}

define amdgpu_ps float @mad_i32_svv(i32 inreg %a, i32 %b, i32 %c) {
; GFX9-LABEL: mad_i32_svv:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mad_u64_u32 v[0:1], s[0:1], s0, v0, v[1:2]
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: mad_i32_svv:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_mad_u64_u32 v[0:1], null, s0, v0, v[1:2]
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: mad_i32_svv:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_mad_u64_u32 v[2:3], null, s0, v0, v[1:2]
; GFX11-NEXT:    v_mov_b32_e32 v0, v2
; GFX11-NEXT:    ; return to shader part epilog
  %mul = mul i32 %a, %b
  %add = add i32 %mul, %c
  %cast = bitcast i32 %add to float
  ret float %cast
}

define amdgpu_ps float @mad_i32_vss(i32 %a, i32 inreg %b, i32 inreg %c) {
; GFX9-LABEL: mad_i32_vss:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mul_lo_u32 v0, v0, s0
; GFX9-NEXT:    v_add_u32_e32 v0, s1, v0
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: mad_i32_vss:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_mov_b32 s2, s1
; GFX10-NEXT:    v_mad_u64_u32 v[0:1], null, v0, s0, s[2:3]
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: mad_i32_vss:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_mov_b32_e32 v2, v0
; GFX11-NEXT:    s_mov_b32 s2, s1
; GFX11-NEXT:    v_mad_u64_u32 v[0:1], null, v2, s0, s[2:3]
; GFX11-NEXT:    ; return to shader part epilog
  %mul = mul i32 %a, %b
  %add = add i32 %mul, %c
  %cast = bitcast i32 %add to float
  ret float %cast
}

define amdgpu_ps float @mad_i32_svs(i32 inreg %a, i32 %b, i32 inreg %c) {
; GFX9-LABEL: mad_i32_svs:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mul_lo_u32 v0, s0, v0
; GFX9-NEXT:    v_add_u32_e32 v0, s1, v0
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: mad_i32_svs:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_mov_b32 s2, s1
; GFX10-NEXT:    v_mad_u64_u32 v[0:1], null, s0, v0, s[2:3]
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: mad_i32_svs:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_mov_b32_e32 v2, v0
; GFX11-NEXT:    s_mov_b32 s2, s1
; GFX11-NEXT:    v_mad_u64_u32 v[0:1], null, s0, v2, s[2:3]
; GFX11-NEXT:    ; return to shader part epilog
  %mul = mul i32 %a, %b
  %add = add i32 %mul, %c
  %cast = bitcast i32 %add to float
  ret float %cast
}

define amdgpu_ps float @mad_i32_ssv(i32 inreg %a, i32 inreg %b, i32 %c) {
; GFX9-LABEL: mad_i32_ssv:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_mul_i32 s0, s0, s1
; GFX9-NEXT:    v_add_u32_e32 v0, s0, v0
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: mad_i32_ssv:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_mad_u64_u32 v[0:1], null, s0, s1, v[0:1]
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: mad_i32_ssv:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_mad_u64_u32 v[1:2], null, s0, s1, v[0:1]
; GFX11-NEXT:    v_mov_b32_e32 v0, v1
; GFX11-NEXT:    ; return to shader part epilog
  %mul = mul i32 %a, %b
  %add = add i32 %mul, %c
  %cast = bitcast i32 %add to float
  ret float %cast
}

define amdgpu_ps float @mad_i32_vvv_multiuse(i32 %a, i32 %b, i32 %c) {
; GFX9-LABEL: mad_i32_vvv_multiuse:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mul_lo_u32 v1, v0, v1
; GFX9-NEXT:    v_add_u32_e32 v0, v1, v2
; GFX9-NEXT:    flat_store_dword v[0:1], v1
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: mad_i32_vvv_multiuse:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_mul_lo_u32 v1, v0, v1
; GFX10-NEXT:    v_add_nc_u32_e32 v0, v1, v2
; GFX10-NEXT:    flat_store_dword v[0:1], v1
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: mad_i32_vvv_multiuse:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_mul_lo_u32 v1, v0, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, v1, v2
; GFX11-NEXT:    flat_store_b32 v[0:1], v1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    ; return to shader part epilog
  %mul = mul i32 %a, %b
  %add = add i32 %mul, %c
  store i32 %mul, ptr undef
  %cast = bitcast i32 %add to float
  ret float %cast
}
