; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes='gvn' -S %s | FileCheck %s

define i32 @load_of_ptr_select_can_be_replaced_by_value_select(ptr %ptr, ptr %end) {
; CHECK-LABEL: @load_of_ptr_select_can_be_replaced_by_value_select(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_PTR:%.*]] = getelementptr inbounds i32, ptr [[PTR:%.*]], i64 1
; CHECK-NEXT:    [[L_2_PRE:%.*]] = load i32, ptr [[PTR]], align 4
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[L_2:%.*]] = phi i32 [ [[L_2_PRE]], [[ENTRY:%.*]] ], [ [[MIN_VAL:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START_PTR]], [[ENTRY]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[MIN_PTR:%.*]] = phi ptr [ [[PTR]], [[ENTRY]] ], [ [[MIN_SELECT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[PTR_IV]], align 4
; CHECK-NEXT:    [[CMP_1:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_VAL]] = select i1 [[CMP_1]], i32 [[L_1]], i32 [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT]] = select i1 [[CMP_1]], ptr [[PTR_IV]], ptr [[MIN_PTR]]
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i64 1
; CHECK-NEXT:    [[EC:%.*]] = icmp eq ptr [[PTR_IV_NEXT]], [[END:%.*]]
; CHECK-NEXT:    br i1 [[EC]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    [[RES:%.*]] = load i32, ptr [[MIN_SELECT]], align 4
; CHECK-NEXT:    ret i32 [[RES]]
;
entry:
  %start.ptr = getelementptr inbounds i32, ptr %ptr, i64 1
  %l.2.pre = load i32, ptr %ptr, align 4
  br label %loop

loop:
  %l.2 = phi i32 [ %l.2.pre, %entry ], [ %min.val, %loop ]
  %ptr.iv = phi ptr [ %start.ptr, %entry ], [ %ptr.iv.next, %loop ]
  %min.ptr = phi ptr [ %ptr, %entry ], [ %min.select, %loop ]
  %l.1 = load i32, ptr %ptr.iv, align 4
  %cmp.1 = icmp ult i32 %l.1, %l.2
  %min.val = select i1 %cmp.1, i32 %l.1, i32 %l.2
  %min.select = select i1 %cmp.1, ptr %ptr.iv, ptr %min.ptr
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i64 1
  %ec = icmp eq ptr %ptr.iv.next, %end
  br i1 %ec, label %exit, label %loop

exit:
  %res = load i32, ptr %min.select, align 4
  ret i32 %res
}

define i32 @different_phis_1(ptr %ptr, ptr %end) {
; CHECK-LABEL: @different_phis_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_PTR:%.*]] = getelementptr inbounds i32, ptr [[PTR:%.*]], i64 1
; CHECK-NEXT:    [[L_2_PRE:%.*]] = load i32, ptr [[PTR]], align 4
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[L_2:%.*]] = phi i32 [ [[L_2_PRE]], [[ENTRY:%.*]] ], [ [[MIN_VAL:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START_PTR]], [[ENTRY]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[MIN_PTR:%.*]] = phi ptr [ null, [[ENTRY]] ], [ [[MIN_SELECT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[PTR_IV]], align 4
; CHECK-NEXT:    [[CMP_1:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_VAL]] = select i1 [[CMP_1]], i32 [[L_1]], i32 [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT]] = select i1 [[CMP_1]], ptr [[PTR_IV]], ptr [[MIN_PTR]]
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i64 1
; CHECK-NEXT:    [[EC:%.*]] = icmp eq ptr [[PTR_IV_NEXT]], [[END:%.*]]
; CHECK-NEXT:    br i1 [[EC]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    [[RES:%.*]] = load i32, ptr [[MIN_SELECT]], align 4
; CHECK-NEXT:    ret i32 [[RES]]
;
entry:
  %start.ptr = getelementptr inbounds i32, ptr %ptr, i64 1
  %l.2.pre = load i32, ptr %ptr, align 4
  br label %loop

loop:
  %l.2 = phi i32 [ %l.2.pre, %entry ], [ %min.val, %loop ]
  %ptr.iv = phi ptr [ %start.ptr, %entry ], [ %ptr.iv.next, %loop ]
  %min.ptr = phi ptr [ null, %entry ], [ %min.select, %loop ]
  %l.1 = load i32, ptr %ptr.iv, align 4
  %cmp.1 = icmp ult i32 %l.1, %l.2
  %min.val = select i1 %cmp.1, i32 %l.1, i32 %l.2
  %min.select = select i1 %cmp.1, ptr %ptr.iv, ptr %min.ptr
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i64 1
  %ec = icmp eq ptr %ptr.iv.next, %end
  br i1 %ec, label %exit, label %loop

exit:
  %res = load i32, ptr %min.select, align 4
  ret i32 %res
}

define i32 @different_phi_2(ptr %ptr, ptr %end) {
; CHECK-LABEL: @different_phi_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_PTR:%.*]] = getelementptr inbounds i32, ptr [[PTR:%.*]], i64 1
; CHECK-NEXT:    [[L_2_PRE:%.*]] = load i32, ptr [[PTR]], align 4
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[L_2:%.*]] = phi i32 [ [[L_2_PRE]], [[ENTRY:%.*]] ], [ [[MIN_VAL:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START_PTR]], [[ENTRY]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[MIN_PTR:%.*]] = phi ptr [ [[PTR]], [[ENTRY]] ], [ [[START_PTR]], [[LOOP]] ]
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[PTR_IV]], align 4
; CHECK-NEXT:    [[CMP_1:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_VAL]] = select i1 [[CMP_1]], i32 [[L_1]], i32 [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_1]], ptr [[PTR_IV]], ptr [[MIN_PTR]]
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i64 1
; CHECK-NEXT:    [[EC:%.*]] = icmp eq ptr [[PTR_IV_NEXT]], [[END:%.*]]
; CHECK-NEXT:    br i1 [[EC]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    [[RES:%.*]] = load i32, ptr [[MIN_SELECT]], align 4
; CHECK-NEXT:    ret i32 [[RES]]
;
entry:
  %start.ptr = getelementptr inbounds i32, ptr %ptr, i64 1
  %l.2.pre = load i32, ptr %ptr, align 4
  br label %loop

loop:
  %l.2 = phi i32 [ %l.2.pre, %entry ], [ %min.val, %loop ]
  %ptr.iv = phi ptr [ %start.ptr, %entry ], [ %ptr.iv.next, %loop ]
  %min.ptr = phi ptr [ %ptr, %entry ], [ %start.ptr, %loop ]
  %l.1 = load i32, ptr %ptr.iv, align 4
  %cmp.1 = icmp ult i32 %l.1, %l.2
  %min.val = select i1 %cmp.1, i32 %l.1, i32 %l.2
  %min.select = select i1 %cmp.1, ptr %ptr.iv, ptr %min.ptr
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i64 1
  %ec = icmp eq ptr %ptr.iv.next, %end
  br i1 %ec, label %exit, label %loop

exit:
  %res = load i32, ptr %min.select, align 4
  ret i32 %res
}

define i32 @different_phis_3(ptr %ptr, ptr %end) {
; CHECK-LABEL: @different_phis_3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_PTR:%.*]] = getelementptr inbounds i32, ptr [[PTR:%.*]], i64 1
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[L_2:%.*]] = phi i32 [ 19, [[ENTRY:%.*]] ], [ [[MIN_VAL:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START_PTR]], [[ENTRY]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[MIN_PTR:%.*]] = phi ptr [ [[PTR]], [[ENTRY]] ], [ [[MIN_SELECT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[PTR_IV]], align 4
; CHECK-NEXT:    [[CMP_1:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_VAL]] = select i1 [[CMP_1]], i32 [[L_1]], i32 [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT]] = select i1 [[CMP_1]], ptr [[PTR_IV]], ptr [[MIN_PTR]]
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i64 1
; CHECK-NEXT:    [[EC:%.*]] = icmp eq ptr [[PTR_IV_NEXT]], [[END:%.*]]
; CHECK-NEXT:    br i1 [[EC]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    [[RES:%.*]] = load i32, ptr [[MIN_SELECT]], align 4
; CHECK-NEXT:    ret i32 [[RES]]
;
entry:
  %start.ptr = getelementptr inbounds i32, ptr %ptr, i64 1
  br label %loop

loop:
  %l.2 = phi i32 [ 19, %entry ], [ %min.val, %loop ]
  %ptr.iv = phi ptr [ %start.ptr, %entry ], [ %ptr.iv.next, %loop ]
  %min.ptr = phi ptr [ %ptr, %entry ], [ %min.select, %loop ]
  %l.1 = load i32, ptr %ptr.iv, align 4
  %cmp.1 = icmp ult i32 %l.1, %l.2
  %min.val = select i1 %cmp.1, i32 %l.1, i32 %l.2
  %min.select = select i1 %cmp.1, ptr %ptr.iv, ptr %min.ptr
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i64 1
  %ec = icmp eq ptr %ptr.iv.next, %end
  br i1 %ec, label %exit, label %loop

exit:
  %res = load i32, ptr %min.select, align 4
  ret i32 %res
}

define i32 @different_phis_4(ptr %ptr, ptr %end) {
; CHECK-LABEL: @different_phis_4(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_PTR:%.*]] = getelementptr inbounds i32, ptr [[PTR:%.*]], i64 1
; CHECK-NEXT:    [[L_2_PRE:%.*]] = load i32, ptr [[PTR]], align 4
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[L_2:%.*]] = phi i32 [ [[L_2_PRE]], [[ENTRY:%.*]] ], [ 10, [[LOOP]] ]
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START_PTR]], [[ENTRY]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[MIN_PTR:%.*]] = phi ptr [ [[PTR]], [[ENTRY]] ], [ [[MIN_SELECT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[PTR_IV]], align 4
; CHECK-NEXT:    [[CMP_1:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_VAL:%.*]] = select i1 [[CMP_1]], i32 [[L_1]], i32 [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT]] = select i1 [[CMP_1]], ptr [[PTR_IV]], ptr [[MIN_PTR]]
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i64 1
; CHECK-NEXT:    [[EC:%.*]] = icmp eq ptr [[PTR_IV_NEXT]], [[END:%.*]]
; CHECK-NEXT:    br i1 [[EC]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    [[RES:%.*]] = load i32, ptr [[MIN_SELECT]], align 4
; CHECK-NEXT:    ret i32 [[RES]]
;
entry:
  %start.ptr = getelementptr inbounds i32, ptr %ptr, i64 1
  %l.2.pre = load i32, ptr %ptr, align 4
  br label %loop

loop:
  %l.2 = phi i32 [ %l.2.pre, %entry ], [ 10, %loop ]
  %ptr.iv = phi ptr [ %start.ptr, %entry ], [ %ptr.iv.next, %loop ]
  %min.ptr = phi ptr [ %ptr, %entry ], [ %min.select, %loop ]
  %l.1 = load i32, ptr %ptr.iv, align 4
  %cmp.1 = icmp ult i32 %l.1, %l.2
  %min.val = select i1 %cmp.1, i32 %l.1, i32 %l.2
  %min.select = select i1 %cmp.1, ptr %ptr.iv, ptr %min.ptr
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i64 1
  %ec = icmp eq ptr %ptr.iv.next, %end
  br i1 %ec, label %exit, label %loop

exit:
  %res = load i32, ptr %min.select, align 4
  ret i32 %res
}

define i32 @load_before_loop_in_different_block(ptr %ptr, ptr %end, i1 %c) {
; CHECK-LABEL: @load_before_loop_in_different_block(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_PTR:%.*]] = getelementptr inbounds i32, ptr [[PTR:%.*]], i64 1
; CHECK-NEXT:    [[L_2_PRE:%.*]] = load i32, ptr [[PTR]], align 4
; CHECK-NEXT:    br i1 [[C:%.*]], label [[PH:%.*]], label [[EXIT_2:%.*]]
; CHECK:       ph:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[L_2:%.*]] = phi i32 [ [[L_2_PRE]], [[PH]] ], [ [[MIN_VAL:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START_PTR]], [[PH]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[MIN_PTR:%.*]] = phi ptr [ [[PTR]], [[PH]] ], [ [[MIN_SELECT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[PTR_IV]], align 4
; CHECK-NEXT:    [[CMP_1:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_VAL]] = select i1 [[CMP_1]], i32 [[L_1]], i32 [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT]] = select i1 [[CMP_1]], ptr [[PTR_IV]], ptr [[MIN_PTR]]
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i64 1
; CHECK-NEXT:    [[EC:%.*]] = icmp eq ptr [[PTR_IV_NEXT]], [[END:%.*]]
; CHECK-NEXT:    br i1 [[EC]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    [[RES:%.*]] = load i32, ptr [[MIN_SELECT]], align 4
; CHECK-NEXT:    ret i32 [[RES]]
; CHECK:       exit.2:
; CHECK-NEXT:    ret i32 0
;
entry:
  %start.ptr = getelementptr inbounds i32, ptr %ptr, i64 1
  %l.2.pre = load i32, ptr %ptr, align 4
  br i1 %c, label %ph, label %exit.2

ph:
  br label %loop

loop:
  %l.2 = phi i32 [ %l.2.pre, %ph ], [ %min.val, %loop ]
  %ptr.iv = phi ptr [ %start.ptr, %ph ], [ %ptr.iv.next, %loop ]
  %min.ptr = phi ptr [ %ptr, %ph ], [ %min.select, %loop ]
  %l.1 = load i32, ptr %ptr.iv, align 4
  %cmp.1 = icmp ult i32 %l.1, %l.2
  %min.val = select i1 %cmp.1, i32 %l.1, i32 %l.2
  %min.select = select i1 %cmp.1, ptr %ptr.iv, ptr %min.ptr
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i64 1
  %ec = icmp eq ptr %ptr.iv.next, %end
  br i1 %ec, label %exit, label %loop

exit:
  %res = load i32, ptr %min.select, align 4
  ret i32 %res

exit.2:
  ret i32 0
}

define i32 @selects_use_different_compares(ptr %ptr, ptr %end) {
; CHECK-LABEL: @selects_use_different_compares(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_PTR:%.*]] = getelementptr inbounds i32, ptr [[PTR:%.*]], i64 1
; CHECK-NEXT:    [[L_2_PRE:%.*]] = load i32, ptr [[PTR]], align 4
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[L_2:%.*]] = phi i32 [ [[L_2_PRE]], [[ENTRY:%.*]] ], [ [[MIN_VAL:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START_PTR]], [[ENTRY]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[MIN_PTR:%.*]] = phi ptr [ [[PTR]], [[ENTRY]] ], [ [[MIN_SELECT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[PTR_IV]], align 4
; CHECK-NEXT:    [[CMP_1:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[CMP_2:%.*]] = icmp ult i32 [[L_1]], 10
; CHECK-NEXT:    [[MIN_VAL]] = select i1 [[CMP_2]], i32 [[L_1]], i32 [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT]] = select i1 [[CMP_1]], ptr [[PTR_IV]], ptr [[MIN_PTR]]
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i64 1
; CHECK-NEXT:    [[EC:%.*]] = icmp eq ptr [[PTR_IV_NEXT]], [[END:%.*]]
; CHECK-NEXT:    br i1 [[EC]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    [[RES:%.*]] = load i32, ptr [[MIN_SELECT]], align 4
; CHECK-NEXT:    ret i32 [[RES]]
;
entry:
  %start.ptr = getelementptr inbounds i32, ptr %ptr, i64 1
  %l.2.pre = load i32, ptr %ptr, align 4
  br label %loop

loop:
  %l.2 = phi i32 [ %l.2.pre, %entry ], [ %min.val, %loop ]
  %ptr.iv = phi ptr [ %start.ptr, %entry ], [ %ptr.iv.next, %loop ]
  %min.ptr = phi ptr [ %ptr, %entry ], [ %min.select, %loop ]
  %l.1 = load i32, ptr %ptr.iv, align 4
  %cmp.1 = icmp ult i32 %l.1, %l.2
  %cmp.2 = icmp ult i32 %l.1, 10
  %min.val = select i1 %cmp.2, i32 %l.1, i32 %l.2
  %min.select = select i1 %cmp.1, ptr %ptr.iv, ptr %min.ptr
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i64 1
  %ec = icmp eq ptr %ptr.iv.next, %end
  br i1 %ec, label %exit, label %loop

exit:
  %res = load i32, ptr %min.select, align 4
  ret i32 %res
}


define i32 @value_select_different_value_1(ptr %ptr, ptr %end) {
; CHECK-LABEL: @value_select_different_value_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_PTR:%.*]] = getelementptr inbounds i32, ptr [[PTR:%.*]], i64 1
; CHECK-NEXT:    [[L_2_PRE:%.*]] = load i32, ptr [[PTR]], align 4
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[L_2:%.*]] = phi i32 [ [[L_2_PRE]], [[ENTRY:%.*]] ], [ [[MIN_VAL:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START_PTR]], [[ENTRY]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[MIN_PTR:%.*]] = phi ptr [ [[PTR]], [[ENTRY]] ], [ [[MIN_SELECT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[PTR_IV]], align 4
; CHECK-NEXT:    [[CMP_1:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_VAL]] = select i1 [[CMP_1]], i32 [[L_1]], i32 10
; CHECK-NEXT:    [[MIN_SELECT]] = select i1 [[CMP_1]], ptr [[PTR_IV]], ptr [[MIN_PTR]]
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i64 1
; CHECK-NEXT:    [[EC:%.*]] = icmp eq ptr [[PTR_IV_NEXT]], [[END:%.*]]
; CHECK-NEXT:    br i1 [[EC]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    [[RES:%.*]] = load i32, ptr [[MIN_SELECT]], align 4
; CHECK-NEXT:    ret i32 [[RES]]
;
entry:
  %start.ptr = getelementptr inbounds i32, ptr %ptr, i64 1
  %l.2.pre = load i32, ptr %ptr, align 4
  br label %loop

loop:
  %l.2 = phi i32 [ %l.2.pre, %entry ], [ %min.val, %loop ]
  %ptr.iv = phi ptr [ %start.ptr, %entry ], [ %ptr.iv.next, %loop ]
  %min.ptr = phi ptr [ %ptr, %entry ], [ %min.select, %loop ]
  %l.1 = load i32, ptr %ptr.iv, align 4
  %cmp.1 = icmp ult i32 %l.1, %l.2
  %min.val = select i1 %cmp.1, i32 %l.1, i32 10
  %min.select = select i1 %cmp.1, ptr %ptr.iv, ptr %min.ptr
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i64 1
  %ec = icmp eq ptr %ptr.iv.next, %end
  br i1 %ec, label %exit, label %loop

exit:
  %res = load i32, ptr %min.select, align 4
  ret i32 %res
}

define i32 @value_select_different_value_2(ptr %ptr, ptr %end, ptr %ptr.2) {
; CHECK-LABEL: @value_select_different_value_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_PTR:%.*]] = getelementptr inbounds i32, ptr [[PTR:%.*]], i64 1
; CHECK-NEXT:    [[L_2_PRE:%.*]] = load i32, ptr [[PTR]], align 4
; CHECK-NEXT:    [[L_1_PRE:%.*]] = load i32, ptr [[PTR_2:%.*]], align 4
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[L_2:%.*]] = phi i32 [ [[L_2_PRE]], [[ENTRY:%.*]] ], [ [[MIN_VAL:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START_PTR]], [[ENTRY]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[MIN_PTR:%.*]] = phi ptr [ [[PTR]], [[ENTRY]] ], [ [[MIN_SELECT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[CMP_1:%.*]] = icmp ult i32 [[L_1_PRE]], [[L_2]]
; CHECK-NEXT:    [[MIN_VAL]] = select i1 [[CMP_1]], i32 [[L_1_PRE]], i32 [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT]] = select i1 [[CMP_1]], ptr [[PTR_IV]], ptr [[MIN_PTR]]
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i64 1
; CHECK-NEXT:    [[EC:%.*]] = icmp eq ptr [[PTR_IV_NEXT]], [[END:%.*]]
; CHECK-NEXT:    br i1 [[EC]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    [[RES:%.*]] = load i32, ptr [[MIN_SELECT]], align 4
; CHECK-NEXT:    ret i32 [[RES]]
;
entry:
  %start.ptr = getelementptr inbounds i32, ptr %ptr, i64 1
  %l.2.pre = load i32, ptr %ptr, align 4
  br label %loop

loop:
  %l.2 = phi i32 [ %l.2.pre, %entry ], [ %min.val, %loop ]
  %ptr.iv = phi ptr [ %start.ptr, %entry ], [ %ptr.iv.next, %loop ]
  %min.ptr = phi ptr [ %ptr, %entry ], [ %min.select, %loop ]
  %l.1 = load i32, ptr %ptr.2, align 4
  %cmp.1 = icmp ult i32 %l.1, %l.2
  %min.val = select i1 %cmp.1, i32 %l.1, i32 %l.2
  %min.select = select i1 %cmp.1, ptr %ptr.iv, ptr %min.ptr
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i64 1
  %ec = icmp eq ptr %ptr.iv.next, %end
  br i1 %ec, label %exit, label %loop

exit:
  %res = load i32, ptr %min.select, align 4
  ret i32 %res
}

define i32 @pointer_select_clobbered_1(ptr %ptr, ptr %end) {
; CHECK-LABEL: @pointer_select_clobbered_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_PTR:%.*]] = getelementptr inbounds i32, ptr [[PTR:%.*]], i64 1
; CHECK-NEXT:    [[L_2_PRE:%.*]] = load i32, ptr [[PTR]], align 4
; CHECK-NEXT:    store i32 99, ptr [[PTR]], align 4
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[L_2:%.*]] = phi i32 [ [[L_2_PRE]], [[ENTRY:%.*]] ], [ [[MIN_VAL:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START_PTR]], [[ENTRY]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[MIN_PTR:%.*]] = phi ptr [ [[PTR]], [[ENTRY]] ], [ [[MIN_SELECT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[PTR_IV]], align 4
; CHECK-NEXT:    [[CMP_1:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_VAL]] = select i1 [[CMP_1]], i32 [[L_1]], i32 [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT]] = select i1 [[CMP_1]], ptr [[PTR_IV]], ptr [[MIN_PTR]]
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i64 1
; CHECK-NEXT:    [[EC:%.*]] = icmp eq ptr [[PTR_IV_NEXT]], [[END:%.*]]
; CHECK-NEXT:    br i1 [[EC]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    [[RES:%.*]] = load i32, ptr [[MIN_SELECT]], align 4
; CHECK-NEXT:    ret i32 [[RES]]
;
entry:
  %start.ptr = getelementptr inbounds i32, ptr %ptr, i64 1
  %l.2.pre = load i32, ptr %ptr, align 4
  store i32 99, ptr %ptr
  br label %loop

loop:
  %l.2 = phi i32 [ %l.2.pre, %entry ], [ %min.val, %loop ]
  %ptr.iv = phi ptr [ %start.ptr, %entry ], [ %ptr.iv.next, %loop ]
  %min.ptr = phi ptr [ %ptr, %entry ], [ %min.select, %loop ]
  %l.1 = load i32, ptr %ptr.iv, align 4
  %cmp.1 = icmp ult i32 %l.1, %l.2
  %min.val = select i1 %cmp.1, i32 %l.1, i32 %l.2
  %min.select = select i1 %cmp.1, ptr %ptr.iv, ptr %min.ptr
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i64 1
  %ec = icmp eq ptr %ptr.iv.next, %end
  br i1 %ec, label %exit, label %loop

exit:
  %res = load i32, ptr %min.select, align 4
  ret i32 %res
}

define i32 @pointer_select_clobbered_in_loop(ptr %ptr, ptr %end) {
; CHECK-LABEL: @pointer_select_clobbered_in_loop(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_PTR:%.*]] = getelementptr inbounds i32, ptr [[PTR:%.*]], i64 1
; CHECK-NEXT:    [[L_2_PRE:%.*]] = load i32, ptr [[PTR]], align 4
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[L_2:%.*]] = phi i32 [ [[L_2_PRE]], [[ENTRY:%.*]] ], [ [[MIN_VAL:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START_PTR]], [[ENTRY]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[MIN_PTR:%.*]] = phi ptr [ [[PTR]], [[ENTRY]] ], [ [[MIN_SELECT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    store i32 99, ptr [[PTR]], align 4
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[PTR_IV]], align 4
; CHECK-NEXT:    [[CMP_1:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_VAL]] = select i1 [[CMP_1]], i32 [[L_1]], i32 [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT]] = select i1 [[CMP_1]], ptr [[PTR_IV]], ptr [[MIN_PTR]]
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i64 1
; CHECK-NEXT:    [[EC:%.*]] = icmp eq ptr [[PTR_IV_NEXT]], [[END:%.*]]
; CHECK-NEXT:    br i1 [[EC]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    [[RES:%.*]] = load i32, ptr [[MIN_SELECT]], align 4
; CHECK-NEXT:    ret i32 [[RES]]
;
entry:
  %start.ptr = getelementptr inbounds i32, ptr %ptr, i64 1
  %l.2.pre = load i32, ptr %ptr, align 4
  br label %loop

loop:
  %l.2 = phi i32 [ %l.2.pre, %entry ], [ %min.val, %loop ]
  %ptr.iv = phi ptr [ %start.ptr, %entry ], [ %ptr.iv.next, %loop ]
  %min.ptr = phi ptr [ %ptr, %entry ], [ %min.select, %loop ]
  store i32 99, ptr %ptr
  %l.1 = load i32, ptr %ptr.iv, align 4
  %cmp.1 = icmp ult i32 %l.1, %l.2
  %min.val = select i1 %cmp.1, i32 %l.1, i32 %l.2
  %min.select = select i1 %cmp.1, ptr %ptr.iv, ptr %min.ptr
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i64 1
  %ec = icmp eq ptr %ptr.iv.next, %end
  br i1 %ec, label %exit, label %loop

exit:
  %res = load i32, ptr %min.select, align 4
  ret i32 %res
}

define i32 @pointer_select_clobbered_in_loop_2(ptr %ptr, ptr %end) {
; CHECK-LABEL: @pointer_select_clobbered_in_loop_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_PTR:%.*]] = getelementptr inbounds i32, ptr [[PTR:%.*]], i64 1
; CHECK-NEXT:    [[L_2_PRE:%.*]] = load i32, ptr [[PTR]], align 4
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[L_2:%.*]] = phi i32 [ [[L_2_PRE]], [[ENTRY:%.*]] ], [ [[MIN_VAL:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START_PTR]], [[ENTRY]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[MIN_PTR:%.*]] = phi ptr [ [[PTR]], [[ENTRY]] ], [ [[MIN_SELECT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[PTR_IV]], align 4
; CHECK-NEXT:    store i32 99, ptr [[PTR]], align 4
; CHECK-NEXT:    [[CMP_1:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_VAL]] = select i1 [[CMP_1]], i32 [[L_1]], i32 [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT]] = select i1 [[CMP_1]], ptr [[PTR_IV]], ptr [[MIN_PTR]]
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i64 1
; CHECK-NEXT:    [[EC:%.*]] = icmp eq ptr [[PTR_IV_NEXT]], [[END:%.*]]
; CHECK-NEXT:    br i1 [[EC]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    [[RES:%.*]] = load i32, ptr [[MIN_SELECT]], align 4
; CHECK-NEXT:    ret i32 [[RES]]
;
entry:
  %start.ptr = getelementptr inbounds i32, ptr %ptr, i64 1
  %l.2.pre = load i32, ptr %ptr, align 4
  br label %loop

loop:
  %l.2 = phi i32 [ %l.2.pre, %entry ], [ %min.val, %loop ]
  %ptr.iv = phi ptr [ %start.ptr, %entry ], [ %ptr.iv.next, %loop ]
  %min.ptr = phi ptr [ %ptr, %entry ], [ %min.select, %loop ]
  %l.1 = load i32, ptr %ptr.iv, align 4
  store i32 99, ptr %ptr
  %cmp.1 = icmp ult i32 %l.1, %l.2
  %min.val = select i1 %cmp.1, i32 %l.1, i32 %l.2
  %min.select = select i1 %cmp.1, ptr %ptr.iv, ptr %min.ptr
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i64 1
  %ec = icmp eq ptr %ptr.iv.next, %end
  br i1 %ec, label %exit, label %loop

exit:
  %res = load i32, ptr %min.select, align 4
  ret i32 %res
}

define i32 @pointer_select_clobbered_in_loop_3(ptr %ptr, ptr %end) {
; CHECK-LABEL: @pointer_select_clobbered_in_loop_3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_PTR:%.*]] = getelementptr inbounds i32, ptr [[PTR:%.*]], i64 1
; CHECK-NEXT:    [[L_2_PRE:%.*]] = load i32, ptr [[PTR]], align 4
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[L_2:%.*]] = phi i32 [ [[L_2_PRE]], [[ENTRY:%.*]] ], [ [[MIN_VAL:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START_PTR]], [[ENTRY]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[MIN_PTR:%.*]] = phi ptr [ [[PTR]], [[ENTRY]] ], [ [[MIN_SELECT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[PTR_IV]], align 4
; CHECK-NEXT:    store i32 99, ptr [[PTR_IV]], align 4
; CHECK-NEXT:    [[CMP_1:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_VAL]] = select i1 [[CMP_1]], i32 [[L_1]], i32 [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT]] = select i1 [[CMP_1]], ptr [[PTR_IV]], ptr [[MIN_PTR]]
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i64 1
; CHECK-NEXT:    [[EC:%.*]] = icmp eq ptr [[PTR_IV_NEXT]], [[END:%.*]]
; CHECK-NEXT:    br i1 [[EC]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    [[RES:%.*]] = load i32, ptr [[MIN_SELECT]], align 4
; CHECK-NEXT:    ret i32 [[RES]]
;
entry:
  %start.ptr = getelementptr inbounds i32, ptr %ptr, i64 1
  %l.2.pre = load i32, ptr %ptr, align 4
  br label %loop

loop:
  %l.2 = phi i32 [ %l.2.pre, %entry ], [ %min.val, %loop ]
  %ptr.iv = phi ptr [ %start.ptr, %entry ], [ %ptr.iv.next, %loop ]
  %min.ptr = phi ptr [ %ptr, %entry ], [ %min.select, %loop ]
  %l.1 = load i32, ptr %ptr.iv, align 4
  store i32 99, ptr %ptr.iv
  %cmp.1 = icmp ult i32 %l.1, %l.2
  %min.val = select i1 %cmp.1, i32 %l.1, i32 %l.2
  %min.select = select i1 %cmp.1, ptr %ptr.iv, ptr %min.ptr
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i64 1
  %ec = icmp eq ptr %ptr.iv.next, %end
  br i1 %ec, label %exit, label %loop

exit:
  %res = load i32, ptr %min.select, align 4
  ret i32 %res
}

define i32 @pointer_select_clobbered_in_loop_4(ptr %ptr, ptr %end, ptr %ptr.2) {
; CHECK-LABEL: @pointer_select_clobbered_in_loop_4(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_PTR:%.*]] = getelementptr inbounds i32, ptr [[PTR:%.*]], i64 1
; CHECK-NEXT:    [[L_2_PRE:%.*]] = load i32, ptr [[PTR]], align 4
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[L_2:%.*]] = phi i32 [ [[L_2_PRE]], [[ENTRY:%.*]] ], [ [[MIN_VAL:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START_PTR]], [[ENTRY]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[MIN_PTR:%.*]] = phi ptr [ [[PTR]], [[ENTRY]] ], [ [[MIN_SELECT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    store i32 99, ptr [[PTR_2:%.*]], align 4
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[PTR_IV]], align 4
; CHECK-NEXT:    [[CMP_1:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_VAL]] = select i1 [[CMP_1]], i32 [[L_1]], i32 [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT]] = select i1 [[CMP_1]], ptr [[PTR_IV]], ptr [[MIN_PTR]]
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i64 1
; CHECK-NEXT:    [[EC:%.*]] = icmp eq ptr [[PTR_IV_NEXT]], [[END:%.*]]
; CHECK-NEXT:    br i1 [[EC]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    [[RES:%.*]] = load i32, ptr [[MIN_SELECT]], align 4
; CHECK-NEXT:    ret i32 [[RES]]
;
entry:
  %start.ptr = getelementptr inbounds i32, ptr %ptr, i64 1
  %l.2.pre = load i32, ptr %ptr, align 4
  br label %loop

loop:
  %l.2 = phi i32 [ %l.2.pre, %entry ], [ %min.val, %loop ]
  %ptr.iv = phi ptr [ %start.ptr, %entry ], [ %ptr.iv.next, %loop ]
  %min.ptr = phi ptr [ %ptr, %entry ], [ %min.select, %loop ]
  store i32 99, ptr %ptr.2
  %l.1 = load i32, ptr %ptr.iv, align 4
  %cmp.1 = icmp ult i32 %l.1, %l.2
  %min.val = select i1 %cmp.1, i32 %l.1, i32 %l.2
  %min.select = select i1 %cmp.1, ptr %ptr.iv, ptr %min.ptr
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i64 1
  %ec = icmp eq ptr %ptr.iv.next, %end
  br i1 %ec, label %exit, label %loop

exit:
  %res = load i32, ptr %min.select, align 4
  ret i32 %res
}

declare void @may_write()

define i32 @pointer_select_clobbered_by_call_before_loop(ptr %ptr, ptr %end, ptr %ptr.2) {
; CHECK-LABEL: @pointer_select_clobbered_by_call_before_loop(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_PTR:%.*]] = getelementptr inbounds i32, ptr [[PTR:%.*]], i64 1
; CHECK-NEXT:    [[L_2_PRE:%.*]] = load i32, ptr [[PTR]], align 4
; CHECK-NEXT:    call void @may_write()
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[L_2:%.*]] = phi i32 [ [[L_2_PRE]], [[ENTRY:%.*]] ], [ [[MIN_VAL:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START_PTR]], [[ENTRY]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[MIN_PTR:%.*]] = phi ptr [ [[PTR]], [[ENTRY]] ], [ [[MIN_SELECT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[PTR_IV]], align 4
; CHECK-NEXT:    [[CMP_1:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_VAL]] = select i1 [[CMP_1]], i32 [[L_1]], i32 [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT]] = select i1 [[CMP_1]], ptr [[PTR_IV]], ptr [[MIN_PTR]]
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i64 1
; CHECK-NEXT:    [[EC:%.*]] = icmp eq ptr [[PTR_IV_NEXT]], [[END:%.*]]
; CHECK-NEXT:    br i1 [[EC]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    [[RES:%.*]] = load i32, ptr [[MIN_SELECT]], align 4
; CHECK-NEXT:    ret i32 [[RES]]
;
entry:
  %start.ptr = getelementptr inbounds i32, ptr %ptr, i64 1
  %l.2.pre = load i32, ptr %ptr, align 4
  call void @may_write()
  br label %loop

loop:
  %l.2 = phi i32 [ %l.2.pre, %entry ], [ %min.val, %loop ]
  %ptr.iv = phi ptr [ %start.ptr, %entry ], [ %ptr.iv.next, %loop ]
  %min.ptr = phi ptr [ %ptr, %entry ], [ %min.select, %loop ]
  %l.1 = load i32, ptr %ptr.iv, align 4
  %cmp.1 = icmp ult i32 %l.1, %l.2
  %min.val = select i1 %cmp.1, i32 %l.1, i32 %l.2
  %min.select = select i1 %cmp.1, ptr %ptr.iv, ptr %min.ptr
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i64 1
  %ec = icmp eq ptr %ptr.iv.next, %end
  br i1 %ec, label %exit, label %loop

exit:
  %res = load i32, ptr %min.select, align 4
  ret i32 %res
}

define i32 @pointer_select_clobbered_by_call_in_loop(ptr %ptr, ptr %end, ptr %ptr.2) {
; CHECK-LABEL: @pointer_select_clobbered_by_call_in_loop(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_PTR:%.*]] = getelementptr inbounds i32, ptr [[PTR:%.*]], i64 1
; CHECK-NEXT:    [[L_2_PRE:%.*]] = load i32, ptr [[PTR]], align 4
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[L_2:%.*]] = phi i32 [ [[L_2_PRE]], [[ENTRY:%.*]] ], [ [[MIN_VAL:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START_PTR]], [[ENTRY]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[MIN_PTR:%.*]] = phi ptr [ [[PTR]], [[ENTRY]] ], [ [[MIN_SELECT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    call void @may_write()
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[PTR_IV]], align 4
; CHECK-NEXT:    [[CMP_1:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_VAL]] = select i1 [[CMP_1]], i32 [[L_1]], i32 [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT]] = select i1 [[CMP_1]], ptr [[PTR_IV]], ptr [[MIN_PTR]]
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i64 1
; CHECK-NEXT:    [[EC:%.*]] = icmp eq ptr [[PTR_IV_NEXT]], [[END:%.*]]
; CHECK-NEXT:    br i1 [[EC]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    [[RES:%.*]] = load i32, ptr [[MIN_SELECT]], align 4
; CHECK-NEXT:    ret i32 [[RES]]
;
entry:
  %start.ptr = getelementptr inbounds i32, ptr %ptr, i64 1
  %l.2.pre = load i32, ptr %ptr, align 4
  br label %loop

loop:
  %l.2 = phi i32 [ %l.2.pre, %entry ], [ %min.val, %loop ]
  %ptr.iv = phi ptr [ %start.ptr, %entry ], [ %ptr.iv.next, %loop ]
  %min.ptr = phi ptr [ %ptr, %entry ], [ %min.select, %loop ]
  call void @may_write()
  %l.1 = load i32, ptr %ptr.iv, align 4
  %cmp.1 = icmp ult i32 %l.1, %l.2
  %min.val = select i1 %cmp.1, i32 %l.1, i32 %l.2
  %min.select = select i1 %cmp.1, ptr %ptr.iv, ptr %min.ptr
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i64 1
  %ec = icmp eq ptr %ptr.iv.next, %end
  br i1 %ec, label %exit, label %loop

exit:
  %res = load i32, ptr %min.select, align 4
  ret i32 %res
}

define i32 @pointer_select_clobbered_by_call_after_loop(ptr %ptr, ptr %end, ptr %ptr.2) {
; CHECK-LABEL: @pointer_select_clobbered_by_call_after_loop(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_PTR:%.*]] = getelementptr inbounds i32, ptr [[PTR:%.*]], i64 1
; CHECK-NEXT:    [[L_2_PRE:%.*]] = load i32, ptr [[PTR]], align 4
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[L_2:%.*]] = phi i32 [ [[L_2_PRE]], [[ENTRY:%.*]] ], [ [[MIN_VAL:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START_PTR]], [[ENTRY]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[MIN_PTR:%.*]] = phi ptr [ [[PTR]], [[ENTRY]] ], [ [[MIN_SELECT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[PTR_IV]], align 4
; CHECK-NEXT:    [[CMP_1:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_VAL]] = select i1 [[CMP_1]], i32 [[L_1]], i32 [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT]] = select i1 [[CMP_1]], ptr [[PTR_IV]], ptr [[MIN_PTR]]
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i64 1
; CHECK-NEXT:    [[EC:%.*]] = icmp eq ptr [[PTR_IV_NEXT]], [[END:%.*]]
; CHECK-NEXT:    br i1 [[EC]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    call void @may_write()
; CHECK-NEXT:    [[RES:%.*]] = load i32, ptr [[MIN_SELECT]], align 4
; CHECK-NEXT:    ret i32 [[RES]]
;
entry:
  %start.ptr = getelementptr inbounds i32, ptr %ptr, i64 1
  %l.2.pre = load i32, ptr %ptr, align 4
  br label %loop

loop:
  %l.2 = phi i32 [ %l.2.pre, %entry ], [ %min.val, %loop ]
  %ptr.iv = phi ptr [ %start.ptr, %entry ], [ %ptr.iv.next, %loop ]
  %min.ptr = phi ptr [ %ptr, %entry ], [ %min.select, %loop ]
  %l.1 = load i32, ptr %ptr.iv, align 4
  %cmp.1 = icmp ult i32 %l.1, %l.2
  %min.val = select i1 %cmp.1, i32 %l.1, i32 %l.2
  %min.select = select i1 %cmp.1, ptr %ptr.iv, ptr %min.ptr
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i64 1
  %ec = icmp eq ptr %ptr.iv.next, %end
  br i1 %ec, label %exit, label %loop

exit:
  call void @may_write()
  %res = load i32, ptr %min.select, align 4
  ret i32 %res
}

define i32 @pointer_select_clobbered_after_loop(ptr %ptr, ptr %end) {
; CHECK-LABEL: @pointer_select_clobbered_after_loop(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_PTR:%.*]] = getelementptr inbounds i32, ptr [[PTR:%.*]], i64 1
; CHECK-NEXT:    [[L_2_PRE:%.*]] = load i32, ptr [[PTR]], align 4
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[L_2:%.*]] = phi i32 [ [[L_2_PRE]], [[ENTRY:%.*]] ], [ [[MIN_VAL:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START_PTR]], [[ENTRY]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[MIN_PTR:%.*]] = phi ptr [ [[PTR]], [[ENTRY]] ], [ [[MIN_SELECT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[PTR_IV]], align 4
; CHECK-NEXT:    [[CMP_1:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_VAL]] = select i1 [[CMP_1]], i32 [[L_1]], i32 [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT]] = select i1 [[CMP_1]], ptr [[PTR_IV]], ptr [[MIN_PTR]]
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i64 1
; CHECK-NEXT:    [[EC:%.*]] = icmp eq ptr [[PTR_IV_NEXT]], [[END:%.*]]
; CHECK-NEXT:    br i1 [[EC]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    store i32 99, ptr [[PTR]], align 4
; CHECK-NEXT:    [[RES:%.*]] = load i32, ptr [[MIN_SELECT]], align 4
; CHECK-NEXT:    ret i32 [[RES]]
;
entry:
  %start.ptr = getelementptr inbounds i32, ptr %ptr, i64 1
  %l.2.pre = load i32, ptr %ptr, align 4
  br label %loop

loop:
  %l.2 = phi i32 [ %l.2.pre, %entry ], [ %min.val, %loop ]
  %ptr.iv = phi ptr [ %start.ptr, %entry ], [ %ptr.iv.next, %loop ]
  %min.ptr = phi ptr [ %ptr, %entry ], [ %min.select, %loop ]
  %l.1 = load i32, ptr %ptr.iv, align 4
  %cmp.1 = icmp ult i32 %l.1, %l.2
  %min.val = select i1 %cmp.1, i32 %l.1, i32 %l.2
  %min.select = select i1 %cmp.1, ptr %ptr.iv, ptr %min.ptr
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i64 1
  %ec = icmp eq ptr %ptr.iv.next, %end
  br i1 %ec, label %exit, label %loop

exit:
  store i32 99, ptr %ptr
  %res = load i32, ptr %min.select, align 4
  ret i32 %res
}

declare void @may_throw() readonly

define i32 @pointer_select_may_throw_before_loop(ptr %ptr, ptr %end) {
; CHECK-LABEL: @pointer_select_may_throw_before_loop(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_PTR:%.*]] = getelementptr inbounds i32, ptr [[PTR:%.*]], i64 1
; CHECK-NEXT:    [[L_2_PRE:%.*]] = load i32, ptr [[PTR]], align 4
; CHECK-NEXT:    call void @may_throw()
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[L_2:%.*]] = phi i32 [ [[L_2_PRE]], [[ENTRY:%.*]] ], [ [[MIN_VAL:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START_PTR]], [[ENTRY]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[MIN_PTR:%.*]] = phi ptr [ [[PTR]], [[ENTRY]] ], [ [[MIN_SELECT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[PTR_IV]], align 4
; CHECK-NEXT:    [[CMP_1:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_VAL]] = select i1 [[CMP_1]], i32 [[L_1]], i32 [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT]] = select i1 [[CMP_1]], ptr [[PTR_IV]], ptr [[MIN_PTR]]
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i64 1
; CHECK-NEXT:    [[EC:%.*]] = icmp eq ptr [[PTR_IV_NEXT]], [[END:%.*]]
; CHECK-NEXT:    br i1 [[EC]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    [[RES:%.*]] = load i32, ptr [[MIN_SELECT]], align 4
; CHECK-NEXT:    ret i32 [[RES]]
;
entry:
  %start.ptr = getelementptr inbounds i32, ptr %ptr, i64 1
  %l.2.pre = load i32, ptr %ptr, align 4
  call void @may_throw()
  br label %loop

loop:
  %l.2 = phi i32 [ %l.2.pre, %entry ], [ %min.val, %loop ]
  %ptr.iv = phi ptr [ %start.ptr, %entry ], [ %ptr.iv.next, %loop ]
  %min.ptr = phi ptr [ %ptr, %entry ], [ %min.select, %loop ]
  %l.1 = load i32, ptr %ptr.iv, align 4
  %cmp.1 = icmp ult i32 %l.1, %l.2
  %min.val = select i1 %cmp.1, i32 %l.1, i32 %l.2
  %min.select = select i1 %cmp.1, ptr %ptr.iv, ptr %min.ptr
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i64 1
  %ec = icmp eq ptr %ptr.iv.next, %end
  br i1 %ec, label %exit, label %loop

exit:
  %res = load i32, ptr %min.select, align 4
  ret i32 %res
}

define i32 @pointer_select_may_throw_in_loop(ptr %ptr, ptr %end) {
; CHECK-LABEL: @pointer_select_may_throw_in_loop(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_PTR:%.*]] = getelementptr inbounds i32, ptr [[PTR:%.*]], i64 1
; CHECK-NEXT:    [[L_2_PRE:%.*]] = load i32, ptr [[PTR]], align 4
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[L_2:%.*]] = phi i32 [ [[L_2_PRE]], [[ENTRY:%.*]] ], [ [[MIN_VAL:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START_PTR]], [[ENTRY]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[MIN_PTR:%.*]] = phi ptr [ [[PTR]], [[ENTRY]] ], [ [[MIN_SELECT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[PTR_IV]], align 4
; CHECK-NEXT:    call void @may_throw()
; CHECK-NEXT:    [[CMP_1:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_VAL]] = select i1 [[CMP_1]], i32 [[L_1]], i32 [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT]] = select i1 [[CMP_1]], ptr [[PTR_IV]], ptr [[MIN_PTR]]
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i64 1
; CHECK-NEXT:    [[EC:%.*]] = icmp eq ptr [[PTR_IV_NEXT]], [[END:%.*]]
; CHECK-NEXT:    br i1 [[EC]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    [[RES:%.*]] = load i32, ptr [[MIN_SELECT]], align 4
; CHECK-NEXT:    ret i32 [[RES]]
;
entry:
  %start.ptr = getelementptr inbounds i32, ptr %ptr, i64 1
  %l.2.pre = load i32, ptr %ptr, align 4
  br label %loop

loop:
  %l.2 = phi i32 [ %l.2.pre, %entry ], [ %min.val, %loop ]
  %ptr.iv = phi ptr [ %start.ptr, %entry ], [ %ptr.iv.next, %loop ]
  %min.ptr = phi ptr [ %ptr, %entry ], [ %min.select, %loop ]
  %l.1 = load i32, ptr %ptr.iv, align 4
  call void @may_throw()
  %cmp.1 = icmp ult i32 %l.1, %l.2
  %min.val = select i1 %cmp.1, i32 %l.1, i32 %l.2
  %min.select = select i1 %cmp.1, ptr %ptr.iv, ptr %min.ptr
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i64 1
  %ec = icmp eq ptr %ptr.iv.next, %end
  br i1 %ec, label %exit, label %loop

exit:
  %res = load i32, ptr %min.select, align 4
  ret i32 %res
}

define i32 @pointer_select_may_throw_after_loop(ptr %ptr, ptr %end) {
; CHECK-LABEL: @pointer_select_may_throw_after_loop(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_PTR:%.*]] = getelementptr inbounds i32, ptr [[PTR:%.*]], i64 1
; CHECK-NEXT:    [[L_2_PRE:%.*]] = load i32, ptr [[PTR]], align 4
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[L_2:%.*]] = phi i32 [ [[L_2_PRE]], [[ENTRY:%.*]] ], [ [[MIN_VAL:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START_PTR]], [[ENTRY]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[MIN_PTR:%.*]] = phi ptr [ [[PTR]], [[ENTRY]] ], [ [[MIN_SELECT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[PTR_IV]], align 4
; CHECK-NEXT:    [[CMP_1:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_VAL]] = select i1 [[CMP_1]], i32 [[L_1]], i32 [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT]] = select i1 [[CMP_1]], ptr [[PTR_IV]], ptr [[MIN_PTR]]
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i64 1
; CHECK-NEXT:    [[EC:%.*]] = icmp eq ptr [[PTR_IV_NEXT]], [[END:%.*]]
; CHECK-NEXT:    br i1 [[EC]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    call void @may_throw()
; CHECK-NEXT:    [[RES:%.*]] = load i32, ptr [[MIN_SELECT]], align 4
; CHECK-NEXT:    ret i32 [[RES]]
;
entry:
  %start.ptr = getelementptr inbounds i32, ptr %ptr, i64 1
  %l.2.pre = load i32, ptr %ptr, align 4
  br label %loop

loop:
  %l.2 = phi i32 [ %l.2.pre, %entry ], [ %min.val, %loop ]
  %ptr.iv = phi ptr [ %start.ptr, %entry ], [ %ptr.iv.next, %loop ]
  %min.ptr = phi ptr [ %ptr, %entry ], [ %min.select, %loop ]
  %l.1 = load i32, ptr %ptr.iv, align 4
  %cmp.1 = icmp ult i32 %l.1, %l.2
  %min.val = select i1 %cmp.1, i32 %l.1, i32 %l.2
  %min.select = select i1 %cmp.1, ptr %ptr.iv, ptr %min.ptr
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i64 1
  %ec = icmp eq ptr %ptr.iv.next, %end
  br i1 %ec, label %exit, label %loop

exit:
  call void @may_throw()
  %res = load i32, ptr %min.select, align 4
  ret i32 %res
}
