// Generated by CoffeeScript 2.5.1
var Block, Layout, SpecialString, cloneAndMergeDeep, i, len, prop, ref, terminalWidth;

Block = require('./layout/Block');

({cloneAndMergeDeep} = require('./tools'));

SpecialString = require('./layout/SpecialString');

terminalWidth = require('./tools').getCols();

module.exports = Layout = (function() {
  var self;

  class Layout {
    constructor(config = {}, rootBlockConfig = {}) {
      var rootConfig;
      this._written = [];
      this._activeBlock = null;
      this._config = cloneAndMergeDeep(self._defaultConfig, config);
      // Every layout has a root block
      rootConfig = cloneAndMergeDeep(self._rootBlockDefaultConfig, rootBlockConfig);
      this._root = new Block(this, null, rootConfig, '__root');
      this._root._open();
    }

    getRootBlock() {
      return this._root;
    }

    _append(text) {
      return this._written.push(text);
    }

    _appendLine(text) {
      var s;
      this._append(text);
      s = new SpecialString(text);
      if (s.length < this._config.terminalWidth) {
        this._append('<none>\n</none>');
      }
      return this;
    }

    get() {
      this._ensureClosed();
      if (this._written[this._written.length - 1] === '<none>\n</none>') {
        this._written.pop();
      }
      return this._written.join("");
    }

    _ensureClosed() {
      if (this._activeBlock !== this._root) {
        throw Error("Not all the blocks have been closed. Please call block.close() on all open blocks.");
      }
      if (this._root.isOpen()) {
        this._root.close();
      }
    }

  };

  self = Layout;

  Layout._rootBlockDefaultConfig = {
    linePrependor: {
      options: {
        amount: 0
      }
    },
    lineAppendor: {
      options: {
        amount: 0
      }
    },
    blockPrependor: {
      options: {
        amount: 0
      }
    },
    blockAppendor: {
      options: {
        amount: 0
      }
    }
  };

  Layout._defaultConfig = {
    terminalWidth: terminalWidth
  };

  return Layout;

}).call(this);

ref = ['openBlock', 'write'];
for (i = 0, len = ref.length; i < len; i++) {
  prop = ref[i];
  (function() {
    var method;
    method = prop;
    return Layout.prototype[method] = function() {
      return this._root[method].apply(this._root, arguments);
    };
  })();
}
